/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.util.Log;
import androidx.annotation.Nullable;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.LayoutState;
import com.facebook.litho.config.ComponentsConfiguration;

public class AnimationsDebug {
    public static final boolean ENABLED = ComponentsConfiguration.isEndToEndTestRun;
    static final String TAG = "LithoAnimationDebug";

    static void debugPrintLayoutState(LayoutState layoutState) {
        if (!ENABLED) {
            return;
        }
        Log.d((String)TAG, (String)layoutState.dumpAsString());
    }

    static void debugPrintAnimationLockedIndices(LayoutState layoutState, int[] animationLockedIndices) {
        if (!ENABLED) {
            return;
        }
        if (animationLockedIndices != null) {
            for (int i = 0; i < animationLockedIndices.length; ++i) {
                LayoutOutput output = LayoutOutput.getLayoutOutput(layoutState.getMountableOutputAt(i));
                Log.d((String)TAG, (String)("" + i + " [" + output.getId() + "] (" + output.getTransitionId() + ") host => (" + output.getHostMarker() + "), locked ref count: " + animationLockedIndices[i]));
            }
        }
    }

    static boolean areTransitionsEnabled(@Nullable Context context) {
        if (ComponentsConfiguration.isAnimationDisabled) {
            return false;
        }
        if (!ComponentsConfiguration.isEndToEndTestRun) {
            return true;
        }
        if (!ComponentsConfiguration.CAN_CHECK_GLOBAL_ANIMATOR_SETTINGS) {
            return false;
        }
        if (context == null) {
            return false;
        }
        float animatorDurationScale = Settings.Global.getFloat((ContentResolver)context.getContentResolver(), (String)"animator_duration_scale", (float)1.0f);
        return ComponentsConfiguration.forceEnableTransitionsForInstrumentationTests || animatorDurationScale != 0.0f;
    }
}

