/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.animation.Interpolator;
import androidx.annotation.Nullable;
import com.facebook.litho.DerivedDynamicValue;
import com.facebook.litho.DynamicValue;
import com.facebook.litho.StateValue;
import java.util.concurrent.atomic.AtomicReference;

public class Animations {
    public static DynamicValueBindingBuilder bind(DynamicValue<Float> in) {
        return new DynamicValueBindingBuilder(in);
    }

    public static DynamicValueBindingBuilder bind(StateValue<DynamicValue<Float>> in) {
        DynamicValue dynamicValue = (DynamicValue)in.get();
        if (dynamicValue == null) {
            throw new IllegalArgumentException("The input must not be null.");
        }
        return Animations.bind(dynamicValue);
    }

    public static AnimationBuilder animate(DynamicValue<Float> in) {
        return new AnimationBuilder(in);
    }

    public static class AnimationBuilder {
        private final DynamicValue<Float> mValueToAnimate;
        private long mDuration = -1L;
        private float mFrom;
        private float mTo = 0.0f;
        @Nullable
        private Interpolator mInterpolator;

        private AnimationBuilder(DynamicValue<Float> valueToAnimate) {
            this.mValueToAnimate = valueToAnimate;
            this.mFrom = valueToAnimate.get().floatValue();
        }

        public AnimationBuilder to(float to) {
            this.mTo = to;
            return this;
        }

        public AnimationBuilder from(float from) {
            this.mFrom = from;
            return this;
        }

        public AnimationBuilder duration(long duration) {
            this.mDuration = duration;
            return this;
        }

        public AnimationBuilder interpolator(Interpolator interpolator) {
            this.mInterpolator = interpolator;
            return this;
        }

        public Animator start() {
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{this.mFrom, this.mTo});
            if (this.mDuration > -1L) {
                animator.setDuration(this.mDuration);
            }
            if (this.mInterpolator != null) {
                animator.setInterpolator((TimeInterpolator)this.mInterpolator);
            }
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float animatedValue = ((Float)animation.getAnimatedValue()).floatValue();
                    AnimationBuilder.this.mValueToAnimate.set(Float.valueOf(animatedValue));
                }
            });
            animator.start();
            return animator;
        }

        public void startAndCancelPrevious(AtomicReference<Animator> animatorRef) {
            Animator oldAnimator = animatorRef.get();
            if (oldAnimator != null) {
                oldAnimator.cancel();
            }
            Animator newAnimator = this.start();
            animatorRef.set(newAnimator);
        }
    }

    public static class DynamicValueBindingBuilder {
        private final DynamicValue<Float> mSource;
        private boolean hasInputRange = false;
        private float inputRangeStart = 0.0f;
        private float inputRangeEnd = 1.0f;
        private boolean hasOutputRange = false;
        private float outputRangeStart = 0.0f;
        private float outputRangeEnd = 1.0f;
        @Nullable
        private Interpolator mInterpolator;

        private DynamicValueBindingBuilder(DynamicValue<Float> source) {
            this.mSource = source;
        }

        public DynamicValueBindingBuilder inputRange(float start, float end) {
            this.inputRangeStart = start;
            this.inputRangeEnd = end;
            this.hasInputRange = true;
            return this;
        }

        public DynamicValueBindingBuilder outputRange(float start, float end) {
            this.outputRangeStart = start;
            this.outputRangeEnd = end;
            this.hasOutputRange = true;
            return this;
        }

        public DynamicValueBindingBuilder with(Interpolator interpolator) {
            this.mInterpolator = interpolator;
            return this;
        }

        public void to(StateValue<DynamicValue<Float>> dynamicValueState) {
            DynamicValue<Float> dynamicValue = this.create();
            dynamicValueState.set(dynamicValue);
        }

        public void toInteger(StateValue<DynamicValue<Integer>> dynamicValueState) {
            DynamicValue<Integer> dynamicValue = this.createInteger();
            dynamicValueState.set(dynamicValue);
        }

        private float modify(float in) {
            float result = in;
            if (this.hasInputRange) {
                result = (result - this.inputRangeStart) / (this.inputRangeEnd - this.inputRangeStart);
                result = Math.min(result, 1.0f);
                result = Math.max(result, 0.0f);
            }
            if (this.mInterpolator != null) {
                result = this.mInterpolator.getInterpolation(result);
            }
            if (this.hasOutputRange) {
                float range = this.outputRangeEnd - this.outputRangeStart;
                result = this.outputRangeStart + result * range;
            }
            return result;
        }

        public DynamicValue<Float> create() {
            DerivedDynamicValue.Modifier<Float, Float> modifier = new DerivedDynamicValue.Modifier<Float, Float>(){

                @Override
                public Float modify(Float in) {
                    return Float.valueOf(DynamicValueBindingBuilder.this.modify(in.floatValue()));
                }
            };
            return new DerivedDynamicValue<Float, Float>(this.mSource, modifier);
        }

        public DynamicValue<Integer> createInteger() {
            DerivedDynamicValue.Modifier<Float, Integer> modifier = new DerivedDynamicValue.Modifier<Float, Integer>(){

                @Override
                public Integer modify(Float in) {
                    return (int)DynamicValueBindingBuilder.this.modify(in.floatValue());
                }
            };
            return new DerivedDynamicValue<Float, Integer>(this.mSource, modifier);
        }
    }
}

