/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.Context;
import android.view.accessibility.AccessibilityManager;
import androidx.core.accessibilityservice.AccessibilityServiceInfoCompat;
import java.util.List;

public class AccessibilityUtils {
    private static volatile boolean isCachedIsAccessibilityEnabledSet = false;
    private static volatile boolean cachedIsAccessibilityEnabled;

    public static boolean isAccessibilityEnabled(Context context) {
        if (!isCachedIsAccessibilityEnabledSet) {
            AccessibilityManager manager = (AccessibilityManager)context.getSystemService("accessibility");
            AccessibilityUtils.updateCachedIsAccessibilityEnabled(manager);
        }
        return cachedIsAccessibilityEnabled;
    }

    public static boolean isAccessibilityEnabled(AccessibilityManager manager) {
        if (!isCachedIsAccessibilityEnabledSet) {
            AccessibilityUtils.updateCachedIsAccessibilityEnabled(manager);
        }
        return cachedIsAccessibilityEnabled;
    }

    private static synchronized void updateCachedIsAccessibilityEnabled(AccessibilityManager manager) {
        cachedIsAccessibilityEnabled = Boolean.getBoolean("is_accessibility_enabled") || AccessibilityUtils.isRunningApplicableAccessibilityService(manager);
        isCachedIsAccessibilityEnabledSet = true;
    }

    public static synchronized void invalidateCachedIsAccessibilityEnabled() {
        isCachedIsAccessibilityEnabledSet = false;
    }

    public static boolean isRunningApplicableAccessibilityService(AccessibilityManager manager) {
        if (manager == null || !manager.isEnabled()) {
            return false;
        }
        return manager.isTouchExplorationEnabled() || AccessibilityUtils.enabledServiceCanFocusAndRetrieveWindowContent(manager);
    }

    public static boolean enabledServiceCanFocusAndRetrieveWindowContent(AccessibilityManager manager) {
        List enabledServices = manager.getEnabledAccessibilityServiceList(-1);
        if (enabledServices == null) {
            return false;
        }
        for (AccessibilityServiceInfo serviceInfo : enabledServices) {
            int capabilities;
            int eventTypes = serviceInfo.eventTypes;
            if ((eventTypes & 0x800) != 2048 || ((capabilities = AccessibilityServiceInfoCompat.getCapabilities((AccessibilityServiceInfo)serviceInfo)) & 1) != 1) continue;
            return true;
        }
        return false;
    }
}

