/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.utils;

import android.view.View;
import com.facebook.litho.Size;
import com.facebook.litho.SizeSpec;

public final class MeasureUtils {
    private static final String TAG = "MeasureUtils";

    public static int getViewMeasureSpec(int sizeSpec) {
        switch (SizeSpec.getMode(sizeSpec)) {
            case 0x40000000: {
                return View.MeasureSpec.makeMeasureSpec((int)SizeSpec.getSize(sizeSpec), (int)0x40000000);
            }
            case -2147483648: {
                return View.MeasureSpec.makeMeasureSpec((int)SizeSpec.getSize(sizeSpec), (int)Integer.MIN_VALUE);
            }
            case 0: {
                return View.MeasureSpec.makeMeasureSpec((int)SizeSpec.getSize(sizeSpec), (int)0);
            }
        }
        throw new IllegalStateException("Unexpected size spec mode");
    }

    public static void measureWithDesiredPx(int widthSpec, int heightSpec, int desiredWidthPx, int desiredHeightPx, Size outputSize) {
        outputSize.width = MeasureUtils.getResultSizePxWithSpecAndDesiredPx(widthSpec, desiredWidthPx);
        outputSize.height = MeasureUtils.getResultSizePxWithSpecAndDesiredPx(heightSpec, desiredHeightPx);
    }

    private static int getResultSizePxWithSpecAndDesiredPx(int spec, int desiredSize) {
        int mode = SizeSpec.getMode(spec);
        switch (mode) {
            case 0: {
                return desiredSize;
            }
            case -2147483648: {
                return Math.min(SizeSpec.getSize(spec), desiredSize);
            }
            case 0x40000000: {
                return SizeSpec.getSize(spec);
            }
        }
        throw new IllegalStateException("Unexpected size spec mode");
    }

    public static void measureWithEqualDimens(int widthSpec, int heightSpec, Size outputSize) {
        int widthMode = SizeSpec.getMode(widthSpec);
        int widthSize = SizeSpec.getSize(widthSpec);
        int heightMode = SizeSpec.getMode(heightSpec);
        int heightSize = SizeSpec.getSize(heightSpec);
        if (widthMode == 0 && heightMode == 0) {
            outputSize.width = 0;
            outputSize.height = 0;
            return;
        }
        if (widthMode == 0x40000000) {
            outputSize.width = widthSize;
            switch (heightMode) {
                case 0x40000000: {
                    outputSize.height = heightSize;
                    return;
                }
                case -2147483648: {
                    outputSize.height = Math.min(widthSize, heightSize);
                    return;
                }
                case 0: {
                    outputSize.height = widthSize;
                    return;
                }
            }
        } else if (widthMode == Integer.MIN_VALUE) {
            switch (heightMode) {
                case 0x40000000: {
                    outputSize.height = heightSize;
                    outputSize.width = Math.min(widthSize, heightSize);
                    return;
                }
                case -2147483648: {
                    int chosenSize;
                    outputSize.width = chosenSize = Math.min(widthSize, heightSize);
                    outputSize.height = chosenSize;
                    return;
                }
                case 0: {
                    outputSize.width = widthSize;
                    outputSize.height = widthSize;
                    return;
                }
            }
        }
        outputSize.height = heightSize;
        outputSize.width = heightSize;
    }

    public static void measureWithAspectRatio(int widthSpec, int heightSpec, int intrinsicWidth, int intrinsicHeight, float aspectRatio, Size outputSize) {
        if (SizeSpec.getMode(widthSpec) == Integer.MIN_VALUE && SizeSpec.getSize(widthSpec) > intrinsicWidth) {
            widthSpec = SizeSpec.makeSizeSpec(intrinsicWidth, Integer.MIN_VALUE);
        }
        if (SizeSpec.getMode(heightSpec) == Integer.MIN_VALUE && SizeSpec.getSize(heightSpec) > intrinsicHeight) {
            heightSpec = SizeSpec.makeSizeSpec(intrinsicHeight, Integer.MIN_VALUE);
        }
        MeasureUtils.measureWithAspectRatio(widthSpec, heightSpec, aspectRatio, outputSize);
    }

    public static void measureWithAspectRatio(int widthSpec, int heightSpec, float aspectRatio, Size outputSize) {
        int widthMode = SizeSpec.getMode(widthSpec);
        int widthSize = SizeSpec.getSize(widthSpec);
        int heightMode = SizeSpec.getMode(heightSpec);
        int heightSize = SizeSpec.getSize(heightSpec);
        int widthBasedHeight = (int)Math.ceil((float)widthSize / aspectRatio);
        int heightBasedWidth = (int)Math.ceil((float)heightSize * aspectRatio);
        if (widthMode == 0 && heightMode == 0) {
            outputSize.width = 0;
            outputSize.height = 0;
            return;
        }
        if (widthMode == Integer.MIN_VALUE && heightMode == Integer.MIN_VALUE) {
            if (widthBasedHeight > heightSize) {
                outputSize.width = heightBasedWidth;
                outputSize.height = heightSize;
            } else {
                outputSize.width = widthSize;
                outputSize.height = widthBasedHeight;
            }
        } else if (widthMode == 0x40000000) {
            outputSize.width = widthSize;
            outputSize.height = heightMode == 0 || widthBasedHeight <= heightSize ? widthBasedHeight : heightSize;
        } else if (heightMode == 0x40000000) {
            outputSize.height = heightSize;
            outputSize.width = widthMode == 0 || heightBasedWidth <= widthSize ? heightBasedWidth : widthSize;
        } else if (widthMode == Integer.MIN_VALUE) {
            outputSize.width = widthSize;
            outputSize.height = widthBasedHeight;
        } else if (heightMode == Integer.MIN_VALUE) {
            outputSize.width = heightBasedWidth;
            outputSize.height = heightSize;
        }
    }
}

