/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.drawable;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import com.facebook.litho.drawable.ComparableDrawable;
import com.facebook.litho.drawable.ComparableDrawableWrapper;

public class ComparableResDrawable
extends ComparableDrawableWrapper {
    @DrawableRes
    private final int mResId;
    private final Configuration mConfig;

    private ComparableResDrawable(@DrawableRes int resId, Configuration config, Drawable drawable) {
        super(drawable);
        this.mResId = resId;
        this.mConfig = config;
    }

    @Override
    public boolean isEquivalentTo(ComparableDrawable other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ComparableResDrawable)) {
            return false;
        }
        return this.mResId == ((ComparableResDrawable)other).mResId && this.mConfig.equals(((ComparableResDrawable)other).mConfig);
    }

    public static ComparableResDrawable create(Context context, @DrawableRes int resId) {
        Configuration config = new Configuration(context.getResources().getConfiguration());
        Drawable drawable = ContextCompat.getDrawable((Context)context, (int)resId);
        return new ComparableResDrawable(resId, config, drawable);
    }
}

