/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.drawable;

import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import androidx.annotation.ColorInt;
import androidx.annotation.RequiresApi;
import com.facebook.litho.CommonUtils;
import com.facebook.litho.drawable.ComparableDrawable;
import com.facebook.litho.drawable.ComparableDrawableWrapper;
import java.util.Arrays;

public class ComparableGradientDrawable
extends ComparableDrawableWrapper {
    protected GradientDrawable.Orientation orientation;
    protected int color;
    protected ColorStateList colorStateList;
    protected int[] colors;
    protected float cornerRadius;
    protected float[] cornerRadii;
    protected int gradientType = 0;
    protected int gradientRadius;
    protected int shape = 0;
    protected int width = -1;
    protected int height = -1;
    protected int strokeWidth = -1;
    protected float strokeDashWidth = 0.0f;
    protected float strokeDashGap = 0.0f;
    protected int strokeColor;
    protected ColorStateList strokeColorStateList;

    public ComparableGradientDrawable() {
        super((Drawable)new GradientDrawable());
    }

    public ComparableGradientDrawable(GradientDrawable.Orientation orientation, int[] colors) {
        super((Drawable)new GradientDrawable(orientation, colors));
        this.orientation = orientation;
        this.colors = colors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComparableGradientDrawable)) {
            return false;
        }
        ComparableGradientDrawable that = (ComparableGradientDrawable)((Object)o);
        return this.color == that.color && CommonUtils.equals(this.colorStateList, that.colorStateList) && this.cornerRadius == that.cornerRadius && this.gradientType == that.gradientType && this.gradientRadius == that.gradientRadius && this.shape == that.shape && this.width == that.width && this.height == that.height && this.strokeWidth == that.strokeWidth && this.strokeDashWidth == that.strokeDashWidth && this.strokeDashGap == that.strokeDashGap && this.strokeColor == that.strokeColor && this.orientation == that.orientation && Arrays.equals(this.colors, that.colors) && Arrays.equals(this.cornerRadii, that.cornerRadii) && CommonUtils.equals(this.strokeColorStateList, that.strokeColorStateList);
    }

    public int hashCode() {
        int result = Arrays.hashCode(new Object[]{this.orientation, this.color, this.colorStateList, Float.valueOf(this.cornerRadius), this.gradientType, this.gradientRadius, this.shape, this.width, this.height, this.strokeWidth, Float.valueOf(this.strokeDashWidth), Float.valueOf(this.strokeDashGap), this.strokeColor, this.strokeColorStateList});
        result = 31 * result + Arrays.hashCode(this.colors);
        result = 31 * result + Arrays.hashCode(this.cornerRadii);
        return result;
    }

    @Override
    public boolean isEquivalentTo(ComparableDrawable other) {
        return this.equals((Object)other);
    }

    public GradientDrawable getGradientDrawable() {
        return (GradientDrawable)super.getWrappedDrawable();
    }

    @RequiresApi(api=16)
    public void setOrientation(GradientDrawable.Orientation orientation) {
        this.orientation = orientation;
        this.getGradientDrawable().setOrientation(orientation);
    }

    public void setColor(int color) {
        this.color = color;
        this.getGradientDrawable().setColor(color);
    }

    @RequiresApi(api=21)
    public void setColor(ColorStateList color) {
        this.colorStateList = color;
        this.getGradientDrawable().setColor(color);
    }

    public void setColors(int[] colors) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.colors = colors;
            this.getGradientDrawable().setColors(colors);
        }
    }

    public void setCornerRadius(float cornerRadius) {
        this.cornerRadius = cornerRadius;
        this.getGradientDrawable().setCornerRadius(cornerRadius);
    }

    public void setCornerRadii(float[] cornerRadii) {
        this.cornerRadii = cornerRadii;
        this.getGradientDrawable().setCornerRadii(cornerRadii);
    }

    public void setGradientType(int gradientType) {
        this.gradientType = gradientType;
        this.getGradientDrawable().setGradientType(gradientType);
    }

    public void setGradientRadius(int gradientRadius) {
        this.gradientRadius = gradientRadius;
        this.getGradientDrawable().setGradientRadius((float)gradientRadius);
    }

    public void setShape(int shape) {
        this.shape = shape;
        this.getGradientDrawable().setShape(shape);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.getGradientDrawable().setSize(width, height);
    }

    public void setStroke(int width, @ColorInt int color) {
        this.setStroke(width, color, 0.0f, 0.0f);
    }

    @RequiresApi(api=21)
    public void setStroke(int width, ColorStateList colorStateList) {
        this.setStroke(width, colorStateList, 0.0f, 0.0f);
    }

    public void setStroke(int width, @ColorInt int color, float dashWidth, float dashGap) {
        this.strokeWidth = width;
        this.strokeDashWidth = dashWidth;
        this.strokeDashGap = dashGap;
        this.strokeColor = color;
        this.getGradientDrawable().setStroke(width, color, dashWidth, dashGap);
    }

    @RequiresApi(api=21)
    public void setStroke(int width, ColorStateList colorStateList, float dashWidth, float dashGap) {
        this.strokeWidth = width;
        this.strokeDashWidth = dashWidth;
        this.strokeDashGap = dashGap;
        this.strokeColorStateList = colorStateList;
        this.getGradientDrawable().setStroke(width, colorStateList, dashWidth, dashGap);
    }
}

