/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.drawable;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.DrawableCompat;
import com.facebook.litho.drawable.ComparableDrawable;

public abstract class ComparableDrawableWrapper
extends ComparableDrawable
implements Drawable.Callback {
    private Drawable mDrawable;

    protected ComparableDrawableWrapper(Drawable drawable) {
        this.setWrappedDrawable(drawable);
    }

    protected void onBoundsChange(Rect bounds) {
        this.mDrawable.setBounds(bounds);
    }

    public int getChangingConfigurations() {
        return this.mDrawable.getChangingConfigurations();
    }

    public void setChangingConfigurations(int configs) {
        this.mDrawable.setChangingConfigurations(configs);
    }

    public void setDither(boolean dither) {
        this.mDrawable.setDither(dither);
    }

    public void setFilterBitmap(boolean filter) {
        this.mDrawable.setFilterBitmap(filter);
    }

    public boolean isStateful() {
        return this.mDrawable.isStateful();
    }

    public boolean setState(int[] state) {
        return this.mDrawable.setState(state);
    }

    public int[] getState() {
        return this.mDrawable.getState();
    }

    public void jumpToCurrentState() {
        this.mDrawable.jumpToCurrentState();
    }

    public Drawable getCurrent() {
        return this.mDrawable.getCurrent();
    }

    public boolean setVisible(boolean visible, boolean restart) {
        return super.setVisible(visible, restart) || this.mDrawable.setVisible(visible, restart);
    }

    public Region getTransparentRegion() {
        return this.mDrawable.getTransparentRegion();
    }

    public int getIntrinsicWidth() {
        return this.mDrawable.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.mDrawable.getIntrinsicHeight();
    }

    public int getMinimumWidth() {
        return this.mDrawable.getMinimumWidth();
    }

    public int getMinimumHeight() {
        return this.mDrawable.getMinimumHeight();
    }

    public boolean getPadding(Rect padding) {
        return this.mDrawable.getPadding(padding);
    }

    protected boolean onLevelChange(int level) {
        return this.mDrawable.setLevel(level);
    }

    public boolean isAutoMirrored() {
        return DrawableCompat.isAutoMirrored((Drawable)this.mDrawable);
    }

    public void setAutoMirrored(boolean mirrored) {
        DrawableCompat.setAutoMirrored((Drawable)this.mDrawable, (boolean)mirrored);
    }

    public void setTint(int tint) {
        DrawableCompat.setTint((Drawable)this.mDrawable, (int)tint);
    }

    public void setTintList(ColorStateList tint) {
        DrawableCompat.setTintList((Drawable)this.mDrawable, (ColorStateList)tint);
    }

    public void setTintMode(PorterDuff.Mode mode) {
        DrawableCompat.setTintMode((Drawable)this.mDrawable, (PorterDuff.Mode)mode);
    }

    public void setHotspot(float x, float y) {
        DrawableCompat.setHotspot((Drawable)this.mDrawable, (float)x, (float)y);
    }

    public void setHotspotBounds(int left, int top, int right, int bottom) {
        DrawableCompat.setHotspotBounds((Drawable)this.mDrawable, (int)left, (int)top, (int)right, (int)bottom);
    }

    public void draw(Canvas canvas) {
        this.mDrawable.draw(canvas);
    }

    public void setAlpha(int alpha) {
        this.mDrawable.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter filter) {
        this.mDrawable.setColorFilter(filter);
    }

    public int getOpacity() {
        return this.mDrawable.getOpacity();
    }

    public void invalidateDrawable(Drawable drawable) {
        this.invalidateSelf();
    }

    public void scheduleDrawable(Drawable drawable, Runnable runnable, long l) {
        this.scheduleSelf(runnable, l);
    }

    public void unscheduleDrawable(Drawable drawable, Runnable runnable) {
        this.unscheduleSelf(runnable);
    }

    public Drawable getWrappedDrawable() {
        return this.mDrawable;
    }

    public void setWrappedDrawable(Drawable drawable) {
        if (drawable instanceof ComparableDrawable) {
            throw new IllegalArgumentException("drawable is already a ComparableDrawable");
        }
        if (this.mDrawable != null) {
            this.mDrawable.setCallback(null);
        }
        this.mDrawable = drawable;
        if (drawable != null) {
            drawable.setCallback((Drawable.Callback)this);
        }
    }
}

