/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.drawable;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.RectF;
import androidx.annotation.ColorInt;
import androidx.annotation.Px;
import com.facebook.litho.CommonUtils;
import com.facebook.litho.drawable.ComparableDrawable;
import java.util.Arrays;
import javax.annotation.Nullable;

public class BorderColorDrawable
extends ComparableDrawable {
    private static final int QUICK_REJECT_COLOR = 0;
    private static final float CLIP_ANGLE = 45.0f;
    private static final RectF sClipBounds = new RectF();
    private static final RectF sDrawBounds = new RectF();
    private static final RectF sInnerDrawBounds = new RectF();
    private final State mState;
    private Paint mPaint;
    private Path mPath;
    private Path mClipPath;
    private boolean mDrawBorderWithPath;

    private BorderColorDrawable(State state) {
        this.mState = state;
    }

    private static void drawBorder(Canvas canvas, RectF bounds, Path path, float[] radii, Paint paint) {
        float maxRadii = Math.min(bounds.width(), bounds.height()) / 2.0f;
        if (path == null) {
            float radius = Math.min(maxRadii, radii[0]);
            canvas.drawRoundRect(bounds, radius, radius, paint);
        } else {
            if (path.isEmpty()) {
                path.addRoundRect(bounds, radii, Path.Direction.CW);
            }
            canvas.drawPath(path, paint);
        }
    }

    public void init() {
        this.mPaint = new Paint();
        this.mPath = new Path();
        this.mClipPath = new Path();
        boolean hasRadius = false;
        float lastRadius = 0.0f;
        for (int i = 0; i < this.mState.mBorderRadius.length; ++i) {
            float radius = this.mState.mBorderRadius[i];
            if (radius > 0.0f) {
                hasRadius = true;
            }
            if (i == 0) {
                lastRadius = radius;
                continue;
            }
            if (lastRadius == radius) continue;
            this.mDrawBorderWithPath = true;
            break;
        }
        if (this.mDrawBorderWithPath && this.mState.mBorderRadius.length != 8) {
            float[] radii = new float[8];
            for (int i = 0; i < 4; ++i) {
                radii[i * 2] = this.mState.mBorderRadius[i];
                radii[i * 2 + 1] = this.mState.mBorderRadius[i];
            }
            this.mState.mBorderRadius = radii;
        }
        this.mPaint.setPathEffect(this.mState.mPathEffect);
        this.mPaint.setAntiAlias(this.mState.mPathEffect != null || hasRadius);
        this.mPaint.setStyle(Paint.Style.STROKE);
    }

    public void draw(Canvas canvas) {
        boolean equalBorderWidths;
        if (this.mPaint == null || this.mPath == null) {
            this.init();
        }
        boolean equalBorderColors = this.mState.mBorderLeftColor == this.mState.mBorderTopColor && this.mState.mBorderTopColor == this.mState.mBorderRightColor && this.mState.mBorderRightColor == this.mState.mBorderBottomColor;
        boolean bl = equalBorderWidths = this.mState.mBorderLeftWidth == this.mState.mBorderTopWidth && this.mState.mBorderTopWidth == this.mState.mBorderRightWidth && this.mState.mBorderRightWidth == this.mState.mBorderBottomWidth;
        if (equalBorderWidths && this.mState.mBorderLeftWidth == 0.0f) {
            return;
        }
        if (equalBorderWidths && equalBorderColors) {
            this.drawAllBorders(canvas, this.mState.mBorderLeftWidth, this.mState.mBorderLeftColor);
        } else if (equalBorderWidths) {
            this.drawMultiColoredBorders(canvas);
        } else {
            this.drawIndividualBorders(canvas);
        }
    }

    private void drawAllBorders(Canvas canvas, float strokeWidth, @ColorInt int color) {
        float inset = strokeWidth / 2.0f;
        sDrawBounds.set(this.getBounds());
        sDrawBounds.inset(inset, inset);
        this.mPaint.setStrokeWidth(strokeWidth);
        this.mPaint.setColor(color);
        BorderColorDrawable.drawBorder(canvas, sDrawBounds, this.path(), this.mState.mBorderRadius, this.mPaint);
    }

    private void drawMultiColoredBorders(Canvas canvas) {
        int saveCount;
        this.mPaint.setStrokeWidth(this.mState.mBorderLeftWidth);
        float inset = this.mState.mBorderLeftWidth / 2.0f;
        sDrawBounds.set(this.getBounds());
        int translateSaveCount = canvas.save();
        canvas.translate(BorderColorDrawable.sDrawBounds.left, BorderColorDrawable.sDrawBounds.top);
        sDrawBounds.offsetTo(0.0f, 0.0f);
        sDrawBounds.inset(inset, inset);
        sInnerDrawBounds.set(sDrawBounds);
        float third = Math.min(sDrawBounds.width(), sDrawBounds.height()) / 3.0f;
        sInnerDrawBounds.inset(third, third);
        int color = this.mState.mBorderLeftColor;
        if (color != 0) {
            saveCount = canvas.save();
            this.mPaint.setColor(color);
            this.mClipPath.reset();
            this.mClipPath.moveTo(BorderColorDrawable.sDrawBounds.left - inset, BorderColorDrawable.sDrawBounds.top - inset);
            this.mClipPath.lineTo(BorderColorDrawable.sInnerDrawBounds.left, BorderColorDrawable.sInnerDrawBounds.top);
            this.mClipPath.lineTo(BorderColorDrawable.sInnerDrawBounds.left, BorderColorDrawable.sInnerDrawBounds.bottom);
            this.mClipPath.lineTo(BorderColorDrawable.sDrawBounds.left - inset, BorderColorDrawable.sDrawBounds.bottom + inset);
            this.mClipPath.close();
            canvas.clipPath(this.mClipPath);
            BorderColorDrawable.drawBorder(canvas, sDrawBounds, this.path(), this.mState.mBorderRadius, this.mPaint);
            canvas.restoreToCount(saveCount);
        }
        if ((color = this.mState.mBorderTopColor) != 0) {
            saveCount = canvas.save();
            this.mPaint.setColor(color);
            this.mClipPath.reset();
            this.mClipPath.moveTo(BorderColorDrawable.sDrawBounds.left - inset, BorderColorDrawable.sDrawBounds.top - inset);
            this.mClipPath.lineTo(BorderColorDrawable.sInnerDrawBounds.left, BorderColorDrawable.sInnerDrawBounds.top);
            this.mClipPath.lineTo(BorderColorDrawable.sInnerDrawBounds.right, BorderColorDrawable.sInnerDrawBounds.top);
            this.mClipPath.lineTo(BorderColorDrawable.sDrawBounds.right + inset, BorderColorDrawable.sDrawBounds.top - inset);
            this.mClipPath.close();
            canvas.clipPath(this.mClipPath);
            BorderColorDrawable.drawBorder(canvas, sDrawBounds, this.path(), this.mState.mBorderRadius, this.mPaint);
            canvas.restoreToCount(saveCount);
        }
        if ((color = this.mState.mBorderRightColor) != 0) {
            saveCount = canvas.save();
            this.mPaint.setColor(color);
            this.mClipPath.reset();
            this.mClipPath.moveTo(BorderColorDrawable.sDrawBounds.right + inset, BorderColorDrawable.sDrawBounds.top - inset);
            this.mClipPath.lineTo(BorderColorDrawable.sInnerDrawBounds.right, BorderColorDrawable.sInnerDrawBounds.top);
            this.mClipPath.lineTo(BorderColorDrawable.sInnerDrawBounds.right, BorderColorDrawable.sInnerDrawBounds.bottom);
            this.mClipPath.lineTo(BorderColorDrawable.sDrawBounds.right + inset, BorderColorDrawable.sDrawBounds.bottom + inset);
            this.mClipPath.close();
            canvas.clipPath(this.mClipPath);
            BorderColorDrawable.drawBorder(canvas, sDrawBounds, this.path(), this.mState.mBorderRadius, this.mPaint);
            canvas.restoreToCount(saveCount);
        }
        if ((color = this.mState.mBorderBottomColor) != 0) {
            saveCount = canvas.save();
            this.mPaint.setColor(color);
            this.mClipPath.reset();
            this.mClipPath.moveTo(BorderColorDrawable.sDrawBounds.left - inset, BorderColorDrawable.sDrawBounds.bottom + inset);
            this.mClipPath.lineTo(BorderColorDrawable.sInnerDrawBounds.left, BorderColorDrawable.sInnerDrawBounds.bottom);
            this.mClipPath.lineTo(BorderColorDrawable.sInnerDrawBounds.right, BorderColorDrawable.sInnerDrawBounds.bottom);
            this.mClipPath.lineTo(BorderColorDrawable.sDrawBounds.right + inset, BorderColorDrawable.sDrawBounds.bottom + inset);
            this.mClipPath.close();
            canvas.clipPath(this.mClipPath);
            BorderColorDrawable.drawBorder(canvas, sDrawBounds, this.path(), this.mState.mBorderRadius, this.mPaint);
            canvas.restoreToCount(saveCount);
        }
        canvas.restoreToCount(translateSaveCount);
    }

    private void drawIndividualBorders(Canvas canvas) {
        Rect bounds = this.getBounds();
        if (this.mState.mBorderLeftWidth > 0.0f && this.mState.mBorderLeftColor != 0) {
            this.drawBorder(canvas, this.mState.mBorderLeftColor, this.mState.mBorderLeftWidth, bounds.left, bounds.top, Math.min((float)bounds.left + this.mState.mBorderLeftWidth, (float)bounds.right), bounds.bottom, true);
        }
        if (this.mState.mBorderRightWidth > 0.0f && this.mState.mBorderRightColor != 0) {
            this.drawBorder(canvas, this.mState.mBorderRightColor, this.mState.mBorderRightWidth, Math.max((float)bounds.right - this.mState.mBorderRightWidth, (float)bounds.left), bounds.top, bounds.right, bounds.bottom, true);
        }
        if (this.mState.mBorderTopWidth > 0.0f && this.mState.mBorderTopColor != 0) {
            this.drawBorder(canvas, this.mState.mBorderTopColor, this.mState.mBorderTopWidth, bounds.left, bounds.top, bounds.right, Math.min((float)bounds.top + this.mState.mBorderTopWidth, (float)bounds.bottom), false);
        }
        if (this.mState.mBorderBottomWidth > 0.0f && this.mState.mBorderBottomColor != 0) {
            this.drawBorder(canvas, this.mState.mBorderBottomColor, this.mState.mBorderBottomWidth, bounds.left, Math.max((float)bounds.bottom - this.mState.mBorderBottomWidth, (float)bounds.top), bounds.right, bounds.bottom, false);
        }
    }

    private void drawBorder(Canvas canvas, @ColorInt int color, float strokeWidth, float left, float top, float right, float bottom, boolean insetHorizontal) {
        this.mPaint.setStrokeWidth(strokeWidth);
        this.mPaint.setColor(color);
        sClipBounds.set(left, top, right, bottom);
        sDrawBounds.set(this.getBounds());
        if (insetHorizontal) {
            sDrawBounds.inset(sClipBounds.centerX() - BorderColorDrawable.sClipBounds.left, 0.0f);
        } else {
            sDrawBounds.inset(0.0f, sClipBounds.centerY() - BorderColorDrawable.sClipBounds.top);
        }
        int saveCount = canvas.save();
        canvas.clipRect(sClipBounds);
        BorderColorDrawable.drawBorder(canvas, sDrawBounds, this.path(), this.mState.mBorderRadius, this.mPaint);
        canvas.restoreToCount(saveCount);
    }

    @Nullable
    private Path path() {
        return this.mDrawBorderWithPath ? this.mPath : null;
    }

    public void setAlpha(int alpha) {
        if (this.mPaint != null) {
            this.mPaint.setAlpha(alpha);
        }
    }

    public void setColorFilter(ColorFilter colorFilter) {
        if (this.mPaint != null) {
            this.mPaint.setColorFilter(colorFilter);
        }
    }

    public int getOpacity() {
        return -1;
    }

    @Override
    public boolean isEquivalentTo(ComparableDrawable other) {
        return this.equals((Object)other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BorderColorDrawable)) {
            return false;
        }
        BorderColorDrawable that = (BorderColorDrawable)((Object)o);
        return CommonUtils.equals(this.mState, that.mState);
    }

    public int hashCode() {
        return this.mState.hashCode();
    }

    public static class Builder {
        private State mState = new State();

        public Builder pathEffect(@Nullable PathEffect pathEffect) {
            this.mState.mPathEffect = pathEffect;
            return this;
        }

        public Builder borderColor(@ColorInt int color) {
            this.mState.mBorderLeftColor = color;
            this.mState.mBorderTopColor = color;
            this.mState.mBorderRightColor = color;
            this.mState.mBorderBottomColor = color;
            return this;
        }

        public Builder borderLeftColor(@ColorInt int color) {
            this.mState.mBorderLeftColor = color;
            return this;
        }

        public Builder borderTopColor(@ColorInt int color) {
            this.mState.mBorderTopColor = color;
            return this;
        }

        public Builder borderRightColor(@ColorInt int color) {
            this.mState.mBorderRightColor = color;
            return this;
        }

        public Builder borderBottomColor(@ColorInt int color) {
            this.mState.mBorderBottomColor = color;
            return this;
        }

        public Builder borderWidth(@Px int border) {
            this.mState.mBorderLeftWidth = border;
            this.mState.mBorderTopWidth = border;
            this.mState.mBorderRightWidth = border;
            this.mState.mBorderBottomWidth = border;
            return this;
        }

        public Builder borderLeftWidth(@Px int borderLeft) {
            this.mState.mBorderLeftWidth = borderLeft;
            return this;
        }

        public Builder borderTopWidth(@Px int borderTop) {
            this.mState.mBorderTopWidth = borderTop;
            return this;
        }

        public Builder borderRightWidth(@Px int borderRight) {
            this.mState.mBorderRightWidth = borderRight;
            return this;
        }

        public Builder borderBottomWidth(@Px int borderBottom) {
            this.mState.mBorderBottomWidth = borderBottom;
            return this;
        }

        public Builder borderRadius(float[] radius) {
            this.mState.mBorderRadius = Arrays.copyOf(radius, radius.length);
            return this;
        }

        public BorderColorDrawable build() {
            return new BorderColorDrawable(this.mState);
        }
    }

    static class State {
        float mBorderLeftWidth;
        float mBorderTopWidth;
        float mBorderRightWidth;
        float mBorderBottomWidth;
        @ColorInt
        int mBorderLeftColor;
        @ColorInt
        int mBorderTopColor;
        @ColorInt
        int mBorderRightColor;
        @ColorInt
        int mBorderBottomColor;
        @Nullable
        PathEffect mPathEffect;
        float[] mBorderRadius;

        State() {
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (int)this.mBorderLeftWidth;
            result = 31 * result + (int)this.mBorderTopWidth;
            result = 31 * result + (int)this.mBorderRightWidth;
            result = 31 * result + (int)this.mBorderBottomWidth;
            result = 31 * result + this.mBorderLeftColor;
            result = 31 * result + this.mBorderTopColor;
            result = 31 * result + this.mBorderRightColor;
            result = 31 * result + this.mBorderBottomColor;
            result = 31 * result + (this.mPathEffect != null ? this.mPathEffect.hashCode() : 0);
            result = 31 * result + Arrays.hashCode(this.mBorderRadius);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return state.mBorderLeftWidth == this.mBorderLeftWidth && state.mBorderTopWidth == this.mBorderTopWidth && state.mBorderRightWidth == this.mBorderRightWidth && state.mBorderBottomWidth == this.mBorderBottomWidth && this.mBorderLeftColor == state.mBorderLeftColor && this.mBorderTopColor == state.mBorderTopColor && this.mBorderRightColor == state.mBorderRightColor && this.mBorderBottomColor == state.mBorderBottomColor && CommonUtils.equals(this.mPathEffect, state.mPathEffect) && Arrays.equals(this.mBorderRadius, state.mBorderRadius);
        }
    }
}

