/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.dataflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class ValueNode {
    public static final String DEFAULT_INPUT = "default_input";
    private Map<String, ValueNode> mInputs = null;
    private ArrayList<ValueNode> mOutputs = null;
    private float mValue;
    private long mTimeNs = 0L;

    public float getValue() {
        return this.mValue;
    }

    public void setValue(float value) {
        this.mValue = value;
    }

    protected abstract float calculateValue(long var1);

    protected ValueNode getInput(String name) {
        ValueNode input = this.getInputUnsafe(name);
        if (input == null) {
            throw new RuntimeException("Tried to get non-existent input '" + name + "'. Node only has these inputs: " + this.buildDebugInputsString());
        }
        return input;
    }

    protected ValueNode getInput() {
        if (this.getInputCount() > 1) {
            throw new RuntimeException("Trying to get single input of node with multiple inputs!");
        }
        return this.getInput(DEFAULT_INPUT);
    }

    protected boolean hasInput(String name) {
        if (this.mInputs == null) {
            return false;
        }
        return this.mInputs.containsKey(name);
    }

    protected boolean hasInput() {
        if (this.getInputCount() > 1) {
            throw new RuntimeException("Trying to check for single input of node with multiple inputs!");
        }
        return this.hasInput(DEFAULT_INPUT);
    }

    private String buildDebugInputsString() {
        if (this.mInputs == null) {
            return "[]";
        }
        String inputNames = "";
        Iterator<String> inputIterator = this.mInputs.keySet().iterator();
        while (inputIterator.hasNext()) {
            inputNames = inputNames + "'" + inputIterator.next() + "'";
            if (inputIterator.hasNext()) continue;
            inputNames = inputNames + ", ";
        }
        return "[" + inputNames + "]";
    }

    @Nullable
    ValueNode getInputUnsafe(String name) {
        if (this.mInputs == null) {
            return null;
        }
        return this.mInputs.get(name);
    }

    final void doCalculateValue(long frameTimeNanos) {
        float value = this.calculateValue(frameTimeNanos);
        if (frameTimeNanos == this.mTimeNs) {
            throw new RuntimeException("Got a calculate value call multiple times in the same frame. This isn't expected.");
        }
        this.mTimeNs = frameTimeNanos;
        this.mValue = value;
    }

    void addOutput(ValueNode node) {
        if (this.mOutputs == null) {
            this.mOutputs = new ArrayList();
        }
        this.mOutputs.add(node);
    }

    int getOutputCount() {
        return this.mOutputs == null ? 0 : this.mOutputs.size();
    }

    ValueNode getOutputAt(int i) {
        return this.mOutputs.get(i);
    }

    ValueNode getOutput() {
        if (this.getOutputCount() != 1) {
            throw new RuntimeException("Node does not have inputs of size 1: " + this.getOutputCount());
        }
        return this.getOutputAt(0);
    }

    void removeOutput(ValueNode output) {
        if (!this.mOutputs.remove(output)) {
            throw new RuntimeException("Tried to remove non-existent input!");
        }
    }

    int getInputCount() {
        return this.mInputs == null ? 0 : this.mInputs.size();
    }

    Collection<ValueNode> getAllInputs() {
        if (this.mInputs == null) {
            return Collections.emptySet();
        }
        return this.mInputs.values();
    }

    void setInput(String name, ValueNode input) {
        if (this.mInputs == null) {
            this.mInputs = new LinkedHashMap<String, ValueNode>();
        }
        this.mInputs.put(name, input);
    }

    void removeInput(String name) {
        if (this.mInputs == null || this.mInputs.remove(name) == null) {
            throw new RuntimeException("Tried to remove non-existent input with name: " + name);
        }
    }
}

