/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.dataflow;

import com.facebook.litho.dataflow.NodeCanFinish;
import com.facebook.litho.dataflow.ValueNode;

public class TimingNode
extends ValueNode
implements NodeCanFinish {
    private static final int MS_IN_NANOS = 1000000;
    private static final float INITIAL_VALUE = 0.0f;
    private static final float END_VALUE = 1.0f;
    private final long mDurationMs;
    private long mStartTimeNs = Long.MIN_VALUE;
    private long mExpectedEndTimeNs = Long.MIN_VALUE;
    private long mLastValueTimeNs = Long.MIN_VALUE;

    public TimingNode(int durationMs) {
        this.mDurationMs = durationMs;
    }

    @Override
    public float calculateValue(long frameTimeNanos) {
        if (this.mLastValueTimeNs == Long.MIN_VALUE) {
            this.mStartTimeNs = frameTimeNanos;
            this.mLastValueTimeNs = frameTimeNanos;
            this.mExpectedEndTimeNs = this.mStartTimeNs + this.mDurationMs * 1000000L;
            return 0.0f;
        }
        if (frameTimeNanos >= this.mExpectedEndTimeNs) {
            this.mLastValueTimeNs = frameTimeNanos;
            return 1.0f;
        }
        this.mLastValueTimeNs = frameTimeNanos;
        return (float)(frameTimeNanos - this.mStartTimeNs) / (float)(this.mExpectedEndTimeNs - this.mStartTimeNs);
    }

    @Override
    public boolean isFinished() {
        return this.mLastValueTimeNs >= this.mExpectedEndTimeNs;
    }
}

