/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.dataflow;

import com.facebook.litho.choreographercompat.ChoreographerCompat;
import com.facebook.litho.choreographercompat.ChoreographerCompatImpl;
import com.facebook.litho.dataflow.DataFlowGraph;
import com.facebook.litho.dataflow.TimingSource;

public class ChoreographerTimingSource
implements TimingSource {
    private final ChoreographerCompat mChoreographerCompat;
    private final ChoreographerCompat.FrameCallback mFrameCallback;
    private DataFlowGraph mDataFlowGraph;
    private boolean mIsRunning = false;
    private boolean mHasPostedFrameCallback = false;
    private long mLastFrameTime = Long.MIN_VALUE;

    public ChoreographerTimingSource() {
        this.mChoreographerCompat = ChoreographerCompatImpl.getInstance();
        this.mFrameCallback = new ChoreographerCompat.FrameCallback(){

            @Override
            public void doFrame(long frameTimeNanos) {
                ChoreographerTimingSource.this.doFrame(frameTimeNanos);
            }
        };
    }

    @Override
    public void setDataFlowGraph(DataFlowGraph dataFlowGraph) {
        this.mDataFlowGraph = dataFlowGraph;
    }

    @Override
    public void start() {
        if (this.mDataFlowGraph == null) {
            throw new RuntimeException("Must set a binding graph first.");
        }
        if (this.mIsRunning) {
            throw new RuntimeException("Tried to start but was already running.");
        }
        this.mIsRunning = true;
        this.postFrameCallback();
    }

    @Override
    public void stop() {
        if (!this.mIsRunning) {
            throw new RuntimeException("Tried to stop but wasn't running.");
        }
        this.mIsRunning = false;
        this.stopFrameCallback();
    }

    private void postFrameCallback() {
        if (this.mHasPostedFrameCallback) {
            return;
        }
        this.mChoreographerCompat.postFrameCallback(this.mFrameCallback);
        this.mHasPostedFrameCallback = true;
    }

    private void stopFrameCallback() {
        this.mChoreographerCompat.removeFrameCallback(this.mFrameCallback);
        this.mHasPostedFrameCallback = false;
    }

    private void doFrame(long frameTimeNanos) {
        this.mHasPostedFrameCallback = false;
        if (!this.mIsRunning) {
            return;
        }
        if (this.mLastFrameTime != frameTimeNanos) {
            this.mDataFlowGraph.doFrame(frameTimeNanos);
            this.mLastFrameTime = frameTimeNanos;
        }
        if (this.mIsRunning) {
            this.postFrameCallback();
        }
    }
}

