/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.choreographercompat;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.Choreographer;
import androidx.annotation.VisibleForTesting;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.choreographercompat.ChoreographerCompat;
import javax.annotation.Nullable;

public class ChoreographerCompatImpl
implements ChoreographerCompat {
    private static final long ONE_FRAME_MILLIS = 17L;
    private static final boolean IS_JELLYBEAN_OR_HIGHER = Build.VERSION.SDK_INT >= 16;
    private static ChoreographerCompat sInstance = new ChoreographerCompatImpl();
    @Nullable
    private final Handler mHandler;
    private Choreographer mChoreographer;

    public static ChoreographerCompat getInstance() {
        return sInstance;
    }

    @VisibleForTesting
    public static void setInstance(ChoreographerCompat choreographerCompat) {
        sInstance = choreographerCompat;
    }

    @VisibleForTesting
    ChoreographerCompatImpl() {
        if (IS_JELLYBEAN_OR_HIGHER) {
            if (ThreadUtils.isMainThread()) {
                this.mChoreographer = this.getChoreographer();
                this.mHandler = null;
            } else {
                this.mHandler = new Handler(Looper.getMainLooper());
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ChoreographerCompatImpl.this.mChoreographer = ChoreographerCompatImpl.this.getChoreographer();
                    }
                });
            }
        } else {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
    }

    @Override
    public void postFrameCallback(ChoreographerCompat.FrameCallback callbackWrapper) {
        if (IS_JELLYBEAN_OR_HIGHER && this.mChoreographer != null) {
            this.choreographerPostFrameCallback(callbackWrapper.getFrameCallback());
        } else {
            this.mHandler.postDelayed(callbackWrapper.getRunnable(), 0L);
        }
    }

    @Override
    public void postFrameCallbackDelayed(ChoreographerCompat.FrameCallback callbackWrapper, long delayMillis) {
        if (IS_JELLYBEAN_OR_HIGHER && this.mChoreographer != null) {
            this.choreographerPostFrameCallbackDelayed(callbackWrapper.getFrameCallback(), delayMillis);
        } else {
            this.mHandler.postDelayed(callbackWrapper.getRunnable(), delayMillis + 17L);
        }
    }

    @Override
    public void removeFrameCallback(ChoreographerCompat.FrameCallback callbackWrapper) {
        if (IS_JELLYBEAN_OR_HIGHER && this.mChoreographer != null) {
            this.choreographerRemoveFrameCallback(callbackWrapper.getFrameCallback());
        } else {
            this.mHandler.removeCallbacks(callbackWrapper.getRunnable());
        }
    }

    @TargetApi(value=16)
    private Choreographer getChoreographer() {
        return Choreographer.getInstance();
    }

    @TargetApi(value=16)
    private void choreographerPostFrameCallback(Choreographer.FrameCallback frameCallback) {
        this.mChoreographer.postFrameCallback(frameCallback);
    }

    @TargetApi(value=16)
    private void choreographerPostFrameCallbackDelayed(Choreographer.FrameCallback frameCallback, long delayMillis) {
        this.mChoreographer.postFrameCallbackDelayed(frameCallback, delayMillis);
    }

    @TargetApi(value=16)
    private void choreographerRemoveFrameCallback(Choreographer.FrameCallback frameCallback) {
        this.mChoreographer.removeFrameCallback(frameCallback);
    }

    @VisibleForTesting
    boolean isUsingChoreographer() {
        return this.mChoreographer != null;
    }
}

