/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.util.Log;
import android.util.Property;
import android.view.View;
import com.facebook.litho.AnimationsDebug;
import com.facebook.litho.animation.AnimatedProperties;
import com.facebook.litho.animation.AnimatedProperty;
import com.facebook.litho.animation.AnimatedPropertyNode;
import com.facebook.litho.animation.PropertyAnimation;
import com.facebook.litho.animation.PropertyHandle;
import com.facebook.litho.animation.Resolver;
import com.facebook.litho.animation.TransitionAnimationBinding;
import com.facebook.litho.dataflow.ConstantNode;
import com.facebook.litho.dataflow.InterpolatorNode;
import com.facebook.litho.dataflow.MappingNode;
import com.facebook.litho.dataflow.TimingNode;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class RenderThreadTransition
extends TransitionAnimationBinding {
    private static final String TAG = "RenderThreadTransition";
    private final int mDurationMs;
    private final PropertyAnimation mPropertyAnimation;
    @Nullable
    private final TimeInterpolator mInterpolator;
    private AnimatedPropertyNode mAnimatedPropertyNode;
    @Nullable
    private Animator mRunningAnimator;

    public RenderThreadTransition(PropertyAnimation propertyAnimation, int delayMs, int durationMs, TimeInterpolator interpolator) {
        if (delayMs < 0) {
            throw new IllegalArgumentException("Delay value should be non-negative, provided=" + delayMs);
        }
        if (durationMs <= 0) {
            throw new IllegalArgumentException("Duration value should be positive, provided=" + durationMs);
        }
        if (interpolator == null) {
            throw new IllegalArgumentException("Interpolator should not be null");
        }
        if (delayMs > 0) {
            this.mDurationMs = delayMs + durationMs;
            this.mInterpolator = new DelayInterpolator(interpolator, durationMs, delayMs);
        } else {
            this.mDurationMs = durationMs;
            this.mInterpolator = interpolator;
        }
        this.mPropertyAnimation = propertyAnimation;
    }

    @Override
    public void collectTransitioningProperties(ArrayList<PropertyAnimation> outList) {
        outList.add(this.mPropertyAnimation);
    }

    @Override
    protected void setupBinding(Resolver resolver) {
        PropertyHandle propertyHandle = this.mPropertyAnimation.getPropertyHandle();
        this.mAnimatedPropertyNode = resolver.getAnimatedPropertyNode(propertyHandle);
        this.mAnimatedPropertyNode.setUsingRenderThread(true);
        TimingNode timingNode = new TimingNode(this.mDurationMs);
        ConstantNode initial = new ConstantNode(resolver.getCurrentState(propertyHandle));
        ConstantNode end = new ConstantNode(this.mPropertyAnimation.getTargetValue());
        MappingNode mappingNode = new MappingNode();
        InterpolatorNode interpolatorNode = new InterpolatorNode(this.mInterpolator);
        this.addBinding(timingNode, interpolatorNode);
        this.addBinding(interpolatorNode, mappingNode);
        this.addBinding(initial, mappingNode, "initial");
        this.addBinding(end, mappingNode, "end");
        this.addBinding(mappingNode, this.mAnimatedPropertyNode);
    }

    @Override
    public void start(Resolver resolver) {
        super.start(resolver);
        View target = resolver.getAnimatedPropertyNode(this.mPropertyAnimation.getPropertyHandle()).getSingleTargetView();
        float finalValue = this.mPropertyAnimation.getTargetValue();
        if (AnimationsDebug.ENABLED) {
            Log.d((String)TAG, (String)("Trying to start, target=" + target + ", finalValue=" + finalValue));
        }
        if (target == null) {
            Log.e((String)TAG, (String)"Couldn't resolve target for RT animation. Most possible reasons:\n\t1) the components is not wrapped in view, please consider calling .wrapInView()\n\t2) incremental mount is enabled and the view is out of screen at this moment");
            return;
        }
        this.mRunningAnimator = RenderThreadTransition.createAnimator(target, this.mPropertyAnimation.getProperty(), finalValue);
        this.mRunningAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                RenderThreadTransition.this.mRunningAnimator = null;
            }
        });
        this.mRunningAnimator.setInterpolator(this.mInterpolator);
        this.mRunningAnimator.setDuration((long)this.mDurationMs);
        this.mRunningAnimator.start();
    }

    @Override
    public void stop() {
        super.stop();
        if (this.mRunningAnimator != null) {
            this.mRunningAnimator.cancel();
            this.mRunningAnimator = null;
        }
        this.mAnimatedPropertyNode.setUsingRenderThread(false);
    }

    private static Animator createAnimator(View target, AnimatedProperty animatedProperty, float finalValue) {
        Property viewAnimatorProperty = RenderThreadTransition.getViewAnimatorProperty(animatedProperty);
        return ObjectAnimator.ofFloat((Object)target, (Property)viewAnimatorProperty, (float[])new float[]{finalValue});
    }

    private static Property getViewAnimatorProperty(AnimatedProperty animatedProperty) {
        if (animatedProperty == AnimatedProperties.ALPHA) {
            return View.ALPHA;
        }
        if (animatedProperty == AnimatedProperties.X) {
            return View.X;
        }
        if (animatedProperty == AnimatedProperties.Y) {
            return View.Y;
        }
        if (animatedProperty == AnimatedProperties.ROTATION) {
            return View.ROTATION;
        }
        throw new IllegalArgumentException("Cannot animate " + animatedProperty.getName() + " on RenderThread");
    }

    private static class DelayInterpolator
    implements TimeInterpolator {
        final TimeInterpolator mOriginal;
        final float mDelayFraction;

        DelayInterpolator(TimeInterpolator original, int duration, int delay) {
            this.mOriginal = original;
            this.mDelayFraction = (float)delay / (float)(delay + duration);
        }

        public float getInterpolation(float input) {
            if (input <= this.mDelayFraction) {
                return 0.0f;
            }
            float adjustedInput = (input - this.mDelayFraction) / (1.0f - this.mDelayFraction);
            return this.mOriginal.getInterpolation(adjustedInput);
        }
    }
}

