/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.animation;

import com.facebook.litho.animation.AnimationBinding;
import com.facebook.litho.animation.AnimationBindingListener;
import com.facebook.litho.animation.BaseAnimationBinding;
import com.facebook.litho.animation.PropertyAnimation;
import com.facebook.litho.animation.Resolver;
import com.facebook.litho.choreographercompat.ChoreographerCompat;
import com.facebook.litho.choreographercompat.ChoreographerCompatImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ParallelBinding
extends BaseAnimationBinding {
    private final List<AnimationBinding> mBindings;
    private final AnimationBindingListener mChildListener;
    private final HashSet<AnimationBinding> mBindingsFinished = new HashSet();
    private final ChoreographerCompat.FrameCallback mStaggerCallback;
    private final int mStaggerMs;
    private int mNextIndexToStart = 0;
    private int mChildrenFinished = 0;
    private boolean mHasStarted = false;
    private boolean mIsActive = false;
    private Resolver mResolver;

    public ParallelBinding(int staggerMs, List<AnimationBinding> bindings) {
        this.mStaggerMs = staggerMs;
        this.mBindings = bindings;
        if (this.mBindings.isEmpty()) {
            throw new IllegalArgumentException("Empty binding parallel");
        }
        this.mChildListener = new AnimationBindingListener(){

            @Override
            public void onScheduledToStartLater(AnimationBinding binding) {
            }

            @Override
            public void onWillStart(AnimationBinding binding) {
            }

            @Override
            public void onFinish(AnimationBinding binding) {
                ParallelBinding.this.onBindingFinished(binding);
            }

            @Override
            public void onCanceledBeforeStart(AnimationBinding binding) {
                ParallelBinding.this.onBindingFinished(binding);
            }

            @Override
            public boolean shouldStart(AnimationBinding binding) {
                return true;
            }
        };
        this.mStaggerCallback = this.mStaggerMs == 0 ? null : new ChoreographerCompat.FrameCallback(){

            @Override
            public void doFrame(long frameTimeNanos) {
                if (!ParallelBinding.this.mIsActive) {
                    return;
                }
                ParallelBinding.this.startNextBindingForStagger();
            }
        };
    }

    private void onBindingFinished(AnimationBinding binding) {
        if (this.mBindingsFinished.contains(binding)) {
            throw new RuntimeException("Binding unexpectedly completed twice");
        }
        this.mBindingsFinished.add(binding);
        ++this.mChildrenFinished;
        binding.removeListener(this.mChildListener);
        if (this.mChildrenFinished >= this.mBindings.size()) {
            this.finish();
        }
    }

    private void finish() {
        this.mIsActive = false;
        this.notifyFinished();
    }

    @Override
    public void start(Resolver resolver) {
        if (this.mHasStarted) {
            throw new RuntimeException("Starting binding multiple times");
        }
        this.mHasStarted = true;
        this.mResolver = resolver;
        if (!this.shouldStart()) {
            this.notifyCanceledBeforeStart();
            return;
        }
        this.notifyWillStart();
        this.mIsActive = true;
        for (AnimationBinding binding : this.mBindings) {
            binding.addListener(this.mChildListener);
        }
        if (this.mStaggerMs == 0) {
            int size = this.mBindings.size();
            for (int i = 0; i < size; ++i) {
                AnimationBinding binding = this.mBindings.get(i);
                binding.start(this.mResolver);
            }
            this.mNextIndexToStart = this.mBindings.size();
        } else {
            int size = this.mBindings.size();
            for (int i = 1; i < size; ++i) {
                AnimationBinding binding = this.mBindings.get(i);
                binding.prepareToStartLater();
            }
            this.startNextBindingForStagger();
        }
    }

    private void startNextBindingForStagger() {
        this.mBindings.get(this.mNextIndexToStart).start(this.mResolver);
        ++this.mNextIndexToStart;
        if (this.mNextIndexToStart < this.mBindings.size()) {
            ChoreographerCompatImpl.getInstance().postFrameCallbackDelayed(this.mStaggerCallback, this.mStaggerMs);
        }
    }

    @Override
    public void stop() {
        if (!this.mIsActive) {
            return;
        }
        this.mIsActive = false;
        this.mResolver = null;
        int size = this.mBindings.size();
        for (int i = 0; i < size; ++i) {
            AnimationBinding childBinding = this.mBindings.get(i);
            if (!childBinding.isActive()) continue;
            childBinding.stop();
        }
    }

    @Override
    public boolean isActive() {
        return this.mIsActive;
    }

    @Override
    public void collectTransitioningProperties(ArrayList<PropertyAnimation> outList) {
        int size = this.mBindings.size();
        for (int i = 0; i < size; ++i) {
            this.mBindings.get(i).collectTransitioningProperties(outList);
        }
    }

    @Override
    public void prepareToStartLater() {
        this.notifyScheduledToStartLater();
        int size = this.mBindings.size();
        for (int i = 0; i < size; ++i) {
            AnimationBinding binding = this.mBindings.get(i);
            binding.prepareToStartLater();
        }
    }
}

