/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.animation;

import android.graphics.drawable.Drawable;
import android.view.View;
import com.facebook.litho.OutputUnitsAffinityGroup;
import com.facebook.litho.animation.AnimatedProperty;
import com.facebook.litho.dataflow.ValueNode;
import java.lang.ref.WeakReference;
import javax.annotation.Nullable;

public class AnimatedPropertyNode
extends ValueNode {
    private final AnimatedProperty mAnimatedProperty;
    private final OutputUnitsAffinityGroup<WeakReference<Object>> mMountContentGroup = new OutputUnitsAffinityGroup();
    private boolean mUsingRenderThread;

    public AnimatedPropertyNode(OutputUnitsAffinityGroup<Object> mountContentGroup, AnimatedProperty animatedProperty) {
        this.setMountContentGroupInner(mountContentGroup);
        this.mAnimatedProperty = animatedProperty;
    }

    public void setMountContentGroup(OutputUnitsAffinityGroup<Object> mountContentGroup) {
        this.setMountContentGroupInner(mountContentGroup);
        this.setValueInner(this.getValue());
    }

    @Override
    public void setValue(float value) {
        super.setValue(value);
        this.setValueInner(value);
    }

    @Override
    public float calculateValue(long frameTimeNanos) {
        boolean hasInput = this.hasInput();
        Object mountContent = AnimatedPropertyNode.resolveReference(this.mMountContentGroup.getMostSignificantUnit());
        if (mountContent == null) {
            if (hasInput) {
                return this.getInput().getValue();
            }
            return this.getValue();
        }
        if (!hasInput) {
            return this.mAnimatedProperty.get(mountContent);
        }
        float value = this.getInput().getValue();
        this.setValueInner(value);
        return value;
    }

    void setUsingRenderThread(boolean usingRenderThread) {
        this.mUsingRenderThread = usingRenderThread;
    }

    @Nullable
    View getSingleTargetView() {
        View view = null;
        int size = this.mMountContentGroup.size();
        for (int i = 0; i < size; ++i) {
            Object mountContent = AnimatedPropertyNode.resolveReference(this.mMountContentGroup.getAt(i));
            if (mountContent == null) continue;
            if (view != null || !(mountContent instanceof View)) {
                return null;
            }
            view = (View)mountContent;
        }
        return view;
    }

    private void setMountContentGroupInner(OutputUnitsAffinityGroup<Object> mountContentGroup) {
        this.mMountContentGroup.clean();
        if (mountContentGroup == null) {
            return;
        }
        int size = mountContentGroup.size();
        for (int i = 0; i < size; ++i) {
            WeakReference<Object> mountContentRef = new WeakReference<Object>(mountContentGroup.getAt(i));
            this.mMountContentGroup.add(mountContentGroup.typeAt(i), mountContentRef);
        }
    }

    private void setValueInner(float value) {
        if (this.mUsingRenderThread) {
            return;
        }
        int size = this.mMountContentGroup.size();
        for (int i = 0; i < size; ++i) {
            Object mountContent = AnimatedPropertyNode.resolveReference(this.mMountContentGroup.getAt(i));
            if (mountContent == null) continue;
            this.mAnimatedProperty.set(mountContent, value);
        }
    }

    @Nullable
    private static Object resolveReference(WeakReference<Object> mountContentRef) {
        Object mountContent;
        Object v0 = mountContent = mountContentRef != null ? mountContentRef.get() : null;
        if (mountContent == null) {
            return null;
        }
        if (mountContent instanceof Drawable && ((Drawable)mountContent).getCallback() == null) {
            mountContentRef.clear();
            return null;
        }
        return mountContent;
    }
}

