/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.animation;

import android.graphics.drawable.Drawable;
import android.view.View;
import com.facebook.litho.AnimatableItem;
import com.facebook.litho.BoundsHelper;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.LithoView;
import com.facebook.litho.animation.AnimatedProperty;
import java.util.List;
import javax.annotation.Nullable;

public final class AnimatedProperties {
    public static final AnimatedProperty X = new XAnimatedProperty();
    public static final AnimatedProperty Y = new YAnimatedProperty();
    public static final AnimatedProperty WIDTH = new WidthAnimatedProperty();
    public static final AnimatedProperty HEIGHT = new HeightAnimatedProperty();
    public static final AnimatedProperty ALPHA = new AlphaAnimatedProperty();
    public static final AnimatedProperty SCALE = new ScaleAnimatedProperty();
    public static final AnimatedProperty SCALE_X = new ScaleXAnimatedProperty();
    public static final AnimatedProperty SCALE_Y = new ScaleYAnimatedProperty();
    public static final AnimatedProperty ROTATION = new RotationAnimatedProperty();
    public static final AnimatedProperty[] AUTO_LAYOUT_PROPERTIES = new AnimatedProperty[]{X, Y, WIDTH, HEIGHT};

    private AnimatedProperties() {
    }

    private static View assertIsView(Object mountContent, AnimatedProperty property) {
        if (!(mountContent instanceof View)) {
            throw new RuntimeException("Animating '" + property.getName() + "' is only supported on Views (got " + mountContent + ")");
        }
        return (View)mountContent;
    }

    private static float getPositionRelativeToLithoView(View mountContent, boolean getX) {
        float pos = 0.0f;
        View currentView = mountContent;
        while (true) {
            if (currentView == null) {
                throw new RuntimeException("Got unexpected null parent");
            }
            if (currentView instanceof LithoView) {
                return pos;
            }
            pos += getX ? currentView.getX() : currentView.getY();
            if (!(currentView.getParent() instanceof View)) {
                throw new RuntimeException("Expected parent to be View, was " + currentView.getParent());
            }
            currentView = (View)currentView.getParent();
        }
    }

    @Nullable
    private static View getHostView(Drawable drawable) {
        Drawable.Callback callback;
        while ((callback = drawable.getCallback()) instanceof Drawable) {
            drawable = (Drawable)callback;
        }
        if (callback instanceof View) {
            return (View)callback;
        }
        return null;
    }

    private static class RotationAnimatedProperty
    implements AnimatedProperty {
        private RotationAnimatedProperty() {
        }

        @Override
        public String getName() {
            return "rotation";
        }

        @Override
        public float get(Object mountContent) {
            return AnimatedProperties.assertIsView(mountContent, this).getRotation();
        }

        @Override
        public float get(AnimatableItem animatableItem) {
            return animatableItem.isRotationSet() ? animatableItem.getRotation() : 0.0f;
        }

        @Override
        public void set(Object mountContent, float value) {
            AnimatedProperties.assertIsView(mountContent, this).setRotation(value);
        }

        @Override
        public void reset(Object mountContent) {
            AnimatedProperties.assertIsView(mountContent, this).setRotation(0.0f);
        }
    }

    private static class ScaleYAnimatedProperty
    implements AnimatedProperty {
        private ScaleYAnimatedProperty() {
        }

        @Override
        public String getName() {
            return "scale_y";
        }

        @Override
        public float get(Object mountContent) {
            return AnimatedProperties.assertIsView(mountContent, this).getScaleY();
        }

        @Override
        public float get(AnimatableItem animatableItem) {
            return 1.0f;
        }

        @Override
        public void set(Object mountContent, float value) {
            AnimatedProperties.assertIsView(mountContent, this).setScaleY(value);
        }

        @Override
        public void reset(Object mountContent) {
            AnimatedProperties.assertIsView(mountContent, this).setScaleY(1.0f);
        }
    }

    private static class ScaleXAnimatedProperty
    implements AnimatedProperty {
        private ScaleXAnimatedProperty() {
        }

        @Override
        public String getName() {
            return "scale_x";
        }

        @Override
        public float get(Object mountContent) {
            return AnimatedProperties.assertIsView(mountContent, this).getScaleX();
        }

        @Override
        public float get(AnimatableItem animatableItem) {
            return 1.0f;
        }

        @Override
        public void set(Object mountContent, float value) {
            AnimatedProperties.assertIsView(mountContent, this).setScaleX(value);
        }

        @Override
        public void reset(Object mountContent) {
            AnimatedProperties.assertIsView(mountContent, this).setScaleX(1.0f);
        }
    }

    private static class ScaleAnimatedProperty
    implements AnimatedProperty {
        private ScaleAnimatedProperty() {
        }

        @Override
        public String getName() {
            return "scale";
        }

        @Override
        public float get(Object mountContent) {
            View asView = AnimatedProperties.assertIsView(mountContent, this);
            float scale = asView.getScaleX();
            if (scale != asView.getScaleY()) {
                throw new RuntimeException("Tried to get scale of view, but scaleX and scaleY are different");
            }
            return scale;
        }

        @Override
        public float get(AnimatableItem animatableItem) {
            return animatableItem.isScaleSet() ? animatableItem.getScale() : 1.0f;
        }

        @Override
        public void set(Object mountContent, float value) {
            View asView = AnimatedProperties.assertIsView(mountContent, this);
            asView.setScaleX(value);
            asView.setScaleY(value);
        }

        @Override
        public void reset(Object mountContent) {
            View asView = AnimatedProperties.assertIsView(mountContent, this);
            asView.setScaleX(1.0f);
            asView.setScaleY(1.0f);
        }
    }

    private static class AlphaAnimatedProperty
    implements AnimatedProperty {
        private AlphaAnimatedProperty() {
        }

        @Override
        public String getName() {
            return "alpha";
        }

        @Override
        public float get(Object mountContent) {
            if (mountContent instanceof View) {
                return ((View)mountContent).getAlpha();
            }
            throw new UnsupportedOperationException("Tried to get alpha of unsupported mount content: " + mountContent);
        }

        @Override
        public float get(AnimatableItem animatableItem) {
            return animatableItem.isAlphaSet() ? animatableItem.getAlpha() : 1.0f;
        }

        @Override
        public void set(Object mountContent, float value) {
            if (!(mountContent instanceof View)) {
                throw new UnsupportedOperationException("Setting alpha on unsupported mount content: " + mountContent);
            }
            ((View)mountContent).setAlpha(value);
        }

        @Override
        public void reset(Object mountContent) {
            this.set(mountContent, 1.0f);
        }
    }

    private static class HeightAnimatedProperty
    implements AnimatedProperty {
        private HeightAnimatedProperty() {
        }

        @Override
        public String getName() {
            return "height";
        }

        @Override
        public float get(Object mountContent) {
            if (mountContent instanceof View) {
                return ((View)mountContent).getHeight();
            }
            if (mountContent instanceof Drawable) {
                return ((Drawable)mountContent).getBounds().height();
            }
            throw new UnsupportedOperationException("Getting height from unsupported mount content: " + mountContent);
        }

        @Override
        public float get(AnimatableItem animatableItem) {
            return animatableItem.getBounds().height();
        }

        @Override
        public void set(Object mountContent, float value) {
            if (mountContent instanceof ComponentHost) {
                ComponentHost view = (ComponentHost)((Object)mountContent);
                if (view instanceof LithoView) {
                    ((LithoView)view).setAnimatedHeight((int)value);
                } else {
                    int top = view.getTop();
                    BoundsHelper.applyBoundsToView((View)view, view.getLeft(), top, view.getRight(), (int)((float)top + value), false);
                }
                List<Drawable> animatingDrawables = view.getLinkedDrawablesForAnimation();
                if (animatingDrawables != null) {
                    int width = view.getWidth();
                    int height = (int)value;
                    for (int index = 0; index < animatingDrawables.size(); ++index) {
                        BoundsHelper.applySizeToDrawableForAnimation(animatingDrawables.get(index), width, height);
                    }
                }
            } else if (mountContent instanceof View) {
                View view = (View)mountContent;
                int top = view.getTop();
                int bottom = (int)((float)top + value);
                BoundsHelper.applyBoundsToView(view, view.getLeft(), top, view.getRight(), bottom, false);
            } else if (mountContent instanceof Drawable) {
                Drawable drawable = (Drawable)mountContent;
                int width = drawable.getBounds().width();
                int height = (int)value;
                BoundsHelper.applySizeToDrawableForAnimation(drawable, width, height);
            } else {
                throw new UnsupportedOperationException("Setting height on unsupported mount content: " + mountContent);
            }
        }

        @Override
        public void reset(Object mountContent) {
        }
    }

    private static class WidthAnimatedProperty
    implements AnimatedProperty {
        private WidthAnimatedProperty() {
        }

        @Override
        public String getName() {
            return "width";
        }

        @Override
        public float get(Object mountContent) {
            if (mountContent instanceof View) {
                return ((View)mountContent).getWidth();
            }
            if (mountContent instanceof Drawable) {
                return ((Drawable)mountContent).getBounds().width();
            }
            throw new UnsupportedOperationException("Getting width from unsupported mount content: " + mountContent);
        }

        @Override
        public float get(AnimatableItem animatableItem) {
            return animatableItem.getBounds().width();
        }

        @Override
        public void set(Object mountContent, float value) {
            if (mountContent instanceof ComponentHost) {
                ComponentHost view = (ComponentHost)((Object)mountContent);
                if (view instanceof LithoView) {
                    ((LithoView)view).setAnimatedWidth((int)value);
                } else {
                    int left = view.getLeft();
                    BoundsHelper.applyBoundsToView((View)view, left, view.getTop(), (int)((float)left + value), view.getBottom(), false);
                }
                List<Drawable> animatingDrawables = view.getLinkedDrawablesForAnimation();
                if (animatingDrawables != null) {
                    int width = (int)value;
                    int height = view.getHeight();
                    for (int index = 0; index < animatingDrawables.size(); ++index) {
                        BoundsHelper.applySizeToDrawableForAnimation(animatingDrawables.get(index), width, height);
                    }
                }
            } else if (mountContent instanceof View) {
                View view = (View)mountContent;
                int left = view.getLeft();
                int right = (int)((float)left + value);
                BoundsHelper.applyBoundsToView(view, left, view.getTop(), right, view.getBottom(), false);
            } else if (mountContent instanceof Drawable) {
                Drawable drawable = (Drawable)mountContent;
                int width = (int)value;
                int height = drawable.getBounds().height();
                BoundsHelper.applySizeToDrawableForAnimation(drawable, width, height);
            } else {
                throw new UnsupportedOperationException("Setting width on unsupported mount content: " + mountContent);
            }
        }

        @Override
        public void reset(Object mountContent) {
        }
    }

    private static class YAnimatedProperty
    implements AnimatedProperty {
        private YAnimatedProperty() {
        }

        @Override
        public String getName() {
            return "y";
        }

        @Override
        public float get(Object mountContent) {
            if (mountContent instanceof LithoView) {
                return ((LithoView)((Object)mountContent)).getY();
            }
            if (mountContent instanceof View) {
                return AnimatedProperties.getPositionRelativeToLithoView((View)mountContent, false);
            }
            if (mountContent instanceof Drawable) {
                Drawable drawable = (Drawable)mountContent;
                float parentY = AnimatedProperties.getPositionRelativeToLithoView(AnimatedProperties.getHostView(drawable), false);
                return parentY + (float)drawable.getBounds().top;
            }
            throw new UnsupportedOperationException("Getting Y from unsupported mount content: " + mountContent);
        }

        @Override
        public float get(AnimatableItem animatableItem) {
            return animatableItem.getBounds().top;
        }

        @Override
        public void set(Object mountContent, float value) {
            if (mountContent instanceof LithoView) {
                ((View)mountContent).setY(value);
            } else if (mountContent instanceof View) {
                View view = (View)mountContent;
                float parentY = AnimatedProperties.getPositionRelativeToLithoView((View)view.getParent(), false);
                view.setY(value - parentY);
            } else if (mountContent instanceof Drawable) {
                Drawable drawable = (Drawable)mountContent;
                float parentY = AnimatedProperties.getPositionRelativeToLithoView(AnimatedProperties.getHostView(drawable), false);
                BoundsHelper.applyXYToDrawableForAnimation(drawable, drawable.getBounds().left, (int)(value - parentY));
            } else {
                throw new UnsupportedOperationException("Setting Y on unsupported mount content: " + mountContent);
            }
        }

        @Override
        public void reset(Object mountContent) {
            if (mountContent instanceof View) {
                View view = (View)mountContent;
                view.setTranslationY(0.0f);
            } else if (mountContent instanceof Drawable) {
                // empty if block
            }
        }
    }

    private static class XAnimatedProperty
    implements AnimatedProperty {
        private XAnimatedProperty() {
        }

        @Override
        public String getName() {
            return "x";
        }

        @Override
        public float get(Object mountContent) {
            if (mountContent instanceof LithoView) {
                return ((LithoView)((Object)mountContent)).getX();
            }
            if (mountContent instanceof View) {
                return AnimatedProperties.getPositionRelativeToLithoView((View)mountContent, true);
            }
            if (mountContent instanceof Drawable) {
                Drawable drawable = (Drawable)mountContent;
                float parentX = AnimatedProperties.getPositionRelativeToLithoView(AnimatedProperties.getHostView(drawable), true);
                return parentX + (float)drawable.getBounds().left;
            }
            throw new UnsupportedOperationException("Getting X from unsupported mount content: " + mountContent);
        }

        @Override
        public float get(AnimatableItem animatableItem) {
            return animatableItem.getBounds().left;
        }

        @Override
        public void set(Object mountContent, float value) {
            if (mountContent instanceof LithoView) {
                ((View)mountContent).setX(value);
            } else if (mountContent instanceof View) {
                View view = (View)mountContent;
                float parentX = AnimatedProperties.getPositionRelativeToLithoView((View)view.getParent(), true);
                view.setX(value - parentX);
            } else if (mountContent instanceof Drawable) {
                Drawable drawable = (Drawable)mountContent;
                float parentX = AnimatedProperties.getPositionRelativeToLithoView(AnimatedProperties.getHostView(drawable), true);
                BoundsHelper.applyXYToDrawableForAnimation(drawable, (int)(value - parentX), drawable.getBounds().top);
            } else {
                throw new UnsupportedOperationException("Setting X on unsupported mount content: " + mountContent);
            }
        }

        @Override
        public void reset(Object mountContent) {
            if (mountContent instanceof View) {
                View view = (View)mountContent;
                view.setTranslationX(0.0f);
            } else if (mountContent instanceof Drawable) {
                // empty if block
            }
        }
    }
}

