/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.VisibleForTesting;
import com.facebook.litho.Component;
import java.util.HashMap;
import java.util.Map;

public class WorkingRangeStatusHandler {
    static final int STATUS_UNINITIALIZED = 0;
    static final int STATUS_IN_RANGE = 1;
    static final int STATUS_OUT_OF_RANGE = 2;
    private final Map<String, Integer> mStatus = new HashMap<String, Integer>();

    boolean isInRange(String name, Component component) {
        return this.getStatus(name, component) == 1;
    }

    @WorkingRangeStatus
    private int getStatus(String name, Component component) {
        String key = WorkingRangeStatusHandler.generateKey(name, component.getGlobalKey());
        if (this.mStatus.containsKey(key)) {
            return this.mStatus.get(key);
        }
        return 0;
    }

    void setEnteredRangeStatus(String name, Component component) {
        this.setStatus(name, component, 1);
    }

    void setExitedRangeStatus(String name, Component component) {
        this.setStatus(name, component, 2);
    }

    void clear() {
        this.mStatus.clear();
    }

    @VisibleForTesting
    Map<String, Integer> getStatus() {
        return this.mStatus;
    }

    @VisibleForTesting
    void setStatus(String name, Component component, @WorkingRangeStatus int status) {
        String globalKey = component.getGlobalKey();
        this.mStatus.put(WorkingRangeStatusHandler.generateKey(name, globalKey), status);
    }

    private static String generateKey(String name, String globalKey) {
        return name + "_" + globalKey;
    }

    public static @interface WorkingRangeStatus {
    }
}

