/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.VisibleForTesting;
import com.facebook.litho.Component;
import com.facebook.litho.WorkingRange;
import com.facebook.litho.WorkingRangeStatusHandler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class WorkingRangeContainer {
    @Nullable
    private Map<String, RangeTuple> mWorkingRanges;

    WorkingRangeContainer() {
    }

    void registerWorkingRange(String name, WorkingRange workingRange, Component component) {
        String key;
        RangeTuple rangeTuple;
        if (this.mWorkingRanges == null) {
            this.mWorkingRanges = new LinkedHashMap<String, RangeTuple>();
        }
        if ((rangeTuple = this.mWorkingRanges.get(key = name + "_" + workingRange.hashCode())) == null) {
            this.mWorkingRanges.put(key, new RangeTuple(name, workingRange, component));
        } else {
            rangeTuple.addComponent(component);
        }
    }

    void checkWorkingRangeAndDispatch(int position, int firstVisibleIndex, int lastVisibleIndex, int firstFullyVisibleIndex, int lastFullyVisibleIndex, WorkingRangeStatusHandler statusHandler) {
        if (this.mWorkingRanges == null) {
            return;
        }
        for (String key : this.mWorkingRanges.keySet()) {
            RangeTuple rangeTuple = this.mWorkingRanges.get(key);
            for (Component component : rangeTuple.mComponents) {
                if (!statusHandler.isInRange(rangeTuple.mName, component) && WorkingRangeContainer.isEnteringRange(rangeTuple.mWorkingRange, position, firstVisibleIndex, lastVisibleIndex, firstFullyVisibleIndex, lastFullyVisibleIndex)) {
                    component.dispatchOnEnteredRange(rangeTuple.mName);
                    statusHandler.setEnteredRangeStatus(rangeTuple.mName, component);
                    continue;
                }
                if (!statusHandler.isInRange(rangeTuple.mName, component) || !WorkingRangeContainer.isExitingRange(rangeTuple.mWorkingRange, position, firstVisibleIndex, lastVisibleIndex, firstFullyVisibleIndex, lastFullyVisibleIndex)) continue;
                component.dispatchOnExitedRange(rangeTuple.mName);
                statusHandler.setExitedRangeStatus(rangeTuple.mName, component);
            }
        }
    }

    void dispatchOnExitedRangeIfNeeded(WorkingRangeStatusHandler statusHandler) {
        if (this.mWorkingRanges == null) {
            return;
        }
        for (String key : this.mWorkingRanges.keySet()) {
            RangeTuple rangeTuple = this.mWorkingRanges.get(key);
            for (Component component : rangeTuple.mComponents) {
                if (!statusHandler.isInRange(rangeTuple.mName, component)) continue;
                component.dispatchOnExitedRange(rangeTuple.mName);
            }
        }
    }

    static boolean isEnteringRange(WorkingRange workingRange, int position, int firstVisibleIndex, int lastVisibleIndex, int firstFullyVisibleIndex, int lastFullyVisibleIndex) {
        return workingRange.shouldEnterRange(position, firstVisibleIndex, lastVisibleIndex, firstFullyVisibleIndex, lastFullyVisibleIndex);
    }

    static boolean isExitingRange(WorkingRange workingRange, int position, int firstVisibleIndex, int lastVisibleIndex, int firstFullyVisibleIndex, int lastFullyVisibleIndex) {
        return workingRange.shouldExitRange(position, firstVisibleIndex, lastVisibleIndex, firstFullyVisibleIndex, lastFullyVisibleIndex);
    }

    @VisibleForTesting
    Map<String, RangeTuple> getWorkingRangesForTestOnly() {
        return this.mWorkingRanges != null ? this.mWorkingRanges : new LinkedHashMap<String, RangeTuple>();
    }

    static class Registration {
        final String mName;
        final WorkingRange mWorkingRange;
        final Component mComponent;

        Registration(String name, WorkingRange workingRange, Component component) {
            this.mName = name;
            this.mWorkingRange = workingRange;
            this.mComponent = component;
        }
    }

    @VisibleForTesting
    static class RangeTuple {
        final String mName;
        final WorkingRange mWorkingRange;
        final List<Component> mComponents;

        RangeTuple(String name, WorkingRange workingRange, Component component) {
            this.mName = name;
            this.mWorkingRange = workingRange;
            this.mComponents = new ArrayList<Component>();
            this.mComponents.add(component);
        }

        void addComponent(Component component) {
            this.mComponents.add(component);
        }
    }
}

