/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.animation.StateListAnimator;
import android.graphics.Rect;
import androidx.annotation.DrawableRes;
import com.facebook.litho.CommonUtils;
import com.facebook.litho.InternalNode;
import com.facebook.litho.drawable.ComparableDrawable;
import com.facebook.yoga.YogaDirection;
import javax.annotation.Nullable;

class ViewNodeInfo {
    private ComparableDrawable mBackground;
    private ComparableDrawable mForeground;
    private Rect mPadding;
    private Rect mExpandedTouchBounds;
    private YogaDirection mLayoutDirection;
    @Nullable
    private StateListAnimator mStateListAnimator;
    @DrawableRes
    private int mStateListAnimatorRes;

    ViewNodeInfo() {
    }

    void setBackground(ComparableDrawable background) {
        this.mBackground = background;
    }

    ComparableDrawable getBackground() {
        return this.mBackground;
    }

    void setForeground(ComparableDrawable foreground) {
        this.mForeground = foreground;
    }

    ComparableDrawable getForeground() {
        return this.mForeground;
    }

    int getPaddingLeft() {
        return this.mPadding != null ? this.mPadding.left : 0;
    }

    int getPaddingTop() {
        return this.mPadding != null ? this.mPadding.top : 0;
    }

    int getPaddingRight() {
        return this.mPadding != null ? this.mPadding.right : 0;
    }

    int getPaddingBottom() {
        return this.mPadding != null ? this.mPadding.bottom : 0;
    }

    void setPadding(int l, int t, int r, int b) {
        if (this.mPadding != null) {
            throw new IllegalStateException("Padding already initialized for this ViewNodeInfo.");
        }
        this.mPadding = new Rect();
        this.mPadding.set(l, t, r, b);
    }

    boolean hasPadding() {
        return this.mPadding != null;
    }

    void setLayoutDirection(YogaDirection layoutDirection) {
        this.mLayoutDirection = layoutDirection;
    }

    YogaDirection getLayoutDirection() {
        return this.mLayoutDirection;
    }

    void setExpandedTouchBounds(InternalNode node, int l, int t, int r, int b) {
        if (!node.hasTouchExpansion()) {
            return;
        }
        int touchExpansionLeft = node.getTouchExpansionLeft();
        int touchExpansionTop = node.getTouchExpansionTop();
        int touchExpansionRight = node.getTouchExpansionRight();
        int touchExpansionBottom = node.getTouchExpansionBottom();
        if (touchExpansionLeft == 0 && touchExpansionTop == 0 && touchExpansionRight == 0 && touchExpansionBottom == 0) {
            return;
        }
        if (this.mExpandedTouchBounds != null) {
            throw new IllegalStateException("ExpandedTouchBounds already initialized for this ViewNodeInfo.");
        }
        this.mExpandedTouchBounds = new Rect();
        this.mExpandedTouchBounds.set(l - touchExpansionLeft, t - touchExpansionTop, r + touchExpansionRight, b + touchExpansionBottom);
    }

    @Nullable
    Rect getExpandedTouchBounds() {
        if (this.mExpandedTouchBounds == null || this.mExpandedTouchBounds.isEmpty()) {
            return null;
        }
        return this.mExpandedTouchBounds;
    }

    @Nullable
    StateListAnimator getStateListAnimator() {
        return this.mStateListAnimator;
    }

    void setStateListAnimator(StateListAnimator stateListAnimator) {
        this.mStateListAnimator = stateListAnimator;
    }

    @DrawableRes
    int getStateListAnimatorRes() {
        return this.mStateListAnimatorRes;
    }

    void setStateListAnimatorRes(@DrawableRes int resId) {
        this.mStateListAnimatorRes = resId;
    }

    public boolean isEquivalentTo(ViewNodeInfo other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!ComparableDrawable.isEquivalentTo(this.mBackground, other.mBackground)) {
            return false;
        }
        if (!ComparableDrawable.isEquivalentTo(this.mForeground, other.mForeground)) {
            return false;
        }
        if (!CommonUtils.equals(this.mPadding, other.mPadding)) {
            return false;
        }
        if (!CommonUtils.equals(this.mExpandedTouchBounds, other.mExpandedTouchBounds)) {
            return false;
        }
        if (!CommonUtils.equals(this.mLayoutDirection, other.mLayoutDirection)) {
            return false;
        }
        if (this.mStateListAnimatorRes != other.mStateListAnimatorRes) {
            return false;
        }
        return CommonUtils.equals(this.mStateListAnimator, other.mStateListAnimator);
    }
}

