/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import androidx.annotation.Nullable;
import com.facebook.litho.Transition;
import com.facebook.litho.TransitionId;
import com.facebook.litho.TransitionSet;
import com.facebook.litho.animation.AnimatedProperty;
import com.facebook.litho.config.ComponentsConfiguration;
import java.util.ArrayList;
import java.util.List;

class TransitionUtils {
    TransitionUtils() {
    }

    static void collectRootBoundsTransitions(TransitionId rootTransitionId, Transition transition, AnimatedProperty property, Transition.RootBoundsTransition outRootBoundsTransition) {
        if (transition instanceof TransitionSet) {
            ArrayList<Transition> children = ((TransitionSet)transition).getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                TransitionUtils.collectRootBoundsTransitions(rootTransitionId, children.get(i), property, outRootBoundsTransition);
            }
        } else if (transition instanceof Transition.TransitionUnit) {
            Transition.TransitionUnit transitionUnit = (Transition.TransitionUnit)transition;
            if (transitionUnit.targets(rootTransitionId) && transitionUnit.targetsProperty(property)) {
                outRootBoundsTransition.hasTransition = true;
                if (transitionUnit.hasAppearAnimation()) {
                    outRootBoundsTransition.appearTransition = transitionUnit;
                }
            }
        } else if (transition instanceof Transition.BaseTransitionUnitsBuilder) {
            Transition.BaseTransitionUnitsBuilder builder = (Transition.BaseTransitionUnitsBuilder)transition;
            ArrayList<Transition.TransitionUnit> units = builder.getTransitionUnits();
            int size = units.size();
            for (int i = 0; i < size; ++i) {
                TransitionUtils.collectRootBoundsTransitions(rootTransitionId, units.get(i), property, outRootBoundsTransition);
            }
        } else {
            throw new RuntimeException("Unhandled transition type: " + transition);
        }
    }

    static boolean areTransitionsEnabled(Context context) {
        if (!ComponentsConfiguration.ARE_TRANSITIONS_SUPPORTED) {
            return false;
        }
        if (!ComponentsConfiguration.isEndToEndTestRun) {
            return true;
        }
        if (!ComponentsConfiguration.CAN_CHECK_GLOBAL_ANIMATOR_SETTINGS) {
            return false;
        }
        float animatorDurationScale = Settings.Global.getFloat((ContentResolver)context.getContentResolver(), (String)"animator_duration_scale", (float)1.0f);
        return ComponentsConfiguration.forceEnableTransitionsForInstrumentationTests || animatorDurationScale != 0.0f;
    }

    static void addTransitions(Transition transition, List<Transition> outList, @Nullable String logContext) {
        if (transition instanceof Transition.BaseTransitionUnitsBuilder) {
            outList.addAll(((Transition.BaseTransitionUnitsBuilder)transition).getTransitionUnits());
        } else if (transition != null) {
            outList.add(transition);
        } else {
            throw new IllegalStateException("[" + logContext + "] Adding null to transition list is not allowed.");
        }
    }

    static void setOwnerKey(Transition transition, @Nullable String ownerKey) {
        if (transition instanceof Transition.TransitionUnit) {
            ((Transition.TransitionUnit)transition).setOwnerKey(ownerKey);
        } else if (transition instanceof TransitionSet) {
            ArrayList<Transition> children = ((TransitionSet)transition).getChildren();
            for (int index = children.size() - 1; index >= 0; --index) {
                TransitionUtils.setOwnerKey(children.get(index), ownerKey);
            }
        } else if (transition instanceof Transition.BaseTransitionUnitsBuilder) {
            ArrayList<Transition.TransitionUnit> units = ((Transition.BaseTransitionUnitsBuilder)transition).getTransitionUnits();
            for (int index = units.size() - 1; index >= 0; --index) {
                units.get(index).setOwnerKey(ownerKey);
            }
        } else {
            throw new RuntimeException("Unhandled transition type: " + transition);
        }
    }

    static boolean targetsAllLayout(@Nullable Transition transition) {
        if (transition == null) {
            return false;
        }
        if (transition instanceof TransitionSet) {
            ArrayList<Transition> children = ((TransitionSet)transition).getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                if (!TransitionUtils.targetsAllLayout(children.get(i))) continue;
                return true;
            }
        } else if (transition instanceof Transition.TransitionUnit) {
            Transition.TransitionUnit unit = (Transition.TransitionUnit)transition;
            Transition.ComponentTargetType targetType = unit.getAnimationTarget().componentTarget.componentTargetType;
            if (targetType == Transition.ComponentTargetType.ALL || targetType == Transition.ComponentTargetType.AUTO_LAYOUT) {
                return true;
            }
        } else if (transition instanceof Transition.BaseTransitionUnitsBuilder) {
            Transition.BaseTransitionUnitsBuilder builder = (Transition.BaseTransitionUnitsBuilder)transition;
            ArrayList<Transition.TransitionUnit> units = builder.getTransitionUnits();
            int size = units.size();
            for (int i = 0; i < size; ++i) {
                if (!TransitionUtils.targetsAllLayout((Transition)units.get(i))) continue;
                return true;
            }
        } else {
            throw new RuntimeException("Unhandled transition type: " + transition);
        }
        return false;
    }
}

