/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.TransitionId;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class TransitionIdMap<V> {
    private final Map<String, TransitionId> mGlobalIds = new LinkedHashMap<String, TransitionId>();
    private final Map<String, Map<String, TransitionId>> mScopedIdsByOwner = new LinkedHashMap<String, Map<String, TransitionId>>();
    private final Map<String, TransitionId> mAutogeneratedIds = new LinkedHashMap<String, TransitionId>();
    private final Map<TransitionId, V> mIds = new HashMap<TransitionId, V>();

    TransitionIdMap() {
    }

    boolean contains(TransitionId id2) {
        return this.mIds.containsKey(id2);
    }

    void put(TransitionId id2, V value) {
        if (this.mIds.put(id2, value) == null) {
            switch (id2.mType) {
                case 1: {
                    this.mGlobalIds.put(id2.mReference, id2);
                    break;
                }
                case 2: {
                    String owner = id2.mExtraData;
                    Map<String, TransitionId> siblingsIds = this.mScopedIdsByOwner.get(owner);
                    if (siblingsIds == null) {
                        siblingsIds = new LinkedHashMap<String, TransitionId>();
                        this.mScopedIdsByOwner.put(owner, siblingsIds);
                    }
                    siblingsIds.put(id2.mReference, id2);
                    break;
                }
                case 3: {
                    this.mAutogeneratedIds.put(id2.mReference, id2);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown TransitionId type " + id2.mType);
                }
            }
        }
    }

    @Nullable
    V get(TransitionId id2) {
        return this.mIds.get(id2);
    }

    void remove(TransitionId id2) {
        if (this.mIds.remove(id2) == null) {
            return;
        }
        switch (id2.mType) {
            case 1: {
                this.mGlobalIds.remove(id2.mReference);
                break;
            }
            case 2: {
                String owner = id2.mExtraData;
                Map<String, TransitionId> siblingsIds = this.mScopedIdsByOwner.get(owner);
                siblingsIds.remove(id2.mReference);
                if (!siblingsIds.isEmpty()) break;
                this.mScopedIdsByOwner.remove(owner);
                break;
            }
            case 3: {
                this.mAutogeneratedIds.remove(id2.mReference);
            }
        }
    }

    @Nullable
    TransitionId getGlobalId(String reference) {
        return this.mGlobalIds.get(reference);
    }

    @Nullable
    TransitionId getScopedId(String owner, String reference) {
        Map<String, TransitionId> siblingsIds = this.mScopedIdsByOwner.get(owner);
        return siblingsIds != null ? siblingsIds.get(reference) : null;
    }

    Set<TransitionId> ids() {
        return this.mIds.keySet();
    }

    Collection<V> values() {
        return this.mIds.values();
    }

    void clear() {
        this.mGlobalIds.clear();
        this.mScopedIdsByOwner.clear();
        this.mAutogeneratedIds.clear();
        this.mIds.clear();
    }
}

