/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

public class TransitionId {
    final int mType;
    final String mReference;
    final String mExtraData;
    private final int mHashCode;

    TransitionId(int type, String reference, String extraData) {
        if (reference == null) {
            throw new IllegalArgumentException("reference can't be null");
        }
        this.mType = type;
        this.mReference = reference;
        this.mExtraData = extraData;
        this.mHashCode = reference.hashCode() * 31 * 31 + (extraData == null ? 0 : extraData.hashCode()) * 31 + this.mType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransitionId that = (TransitionId)o;
        return this.mType == that.mType && (this.mReference == that.mReference || this.mReference != null && this.mReference.equals(that.mReference)) && (this.mExtraData == that.mExtraData || this.mExtraData != null && this.mExtraData.equals(that.mExtraData));
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TransitionId{");
        sb.append("\"").append(this.mReference).append("\", ");
        switch (this.mType) {
            case 1: {
                sb.append("GLOBAL");
                break;
            }
            case 2: {
                sb.append("SCOPED(").append(this.mExtraData).append(")");
                break;
            }
            case 3: {
                sb.append("AUTOGENERATED");
            }
        }
        sb.append("}");
        return sb.toString();
    }
}

