/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.animation.TimeInterpolator;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.CommonUtils;
import com.facebook.litho.DelayTransitionSet;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.LayoutState;
import com.facebook.litho.ParallelTransitionSet;
import com.facebook.litho.SequenceTransitionSet;
import com.facebook.litho.TransitionId;
import com.facebook.litho.TransitionSet;
import com.facebook.litho.animation.AnimatedProperties;
import com.facebook.litho.animation.AnimatedProperty;
import com.facebook.litho.animation.AnimatedPropertyNode;
import com.facebook.litho.animation.AnimationBinding;
import com.facebook.litho.animation.FloatValue;
import com.facebook.litho.animation.PropertyAnimation;
import com.facebook.litho.animation.PropertyHandle;
import com.facebook.litho.animation.RenderThreadTransition;
import com.facebook.litho.animation.Resolver;
import com.facebook.litho.animation.RuntimeValue;
import com.facebook.litho.animation.SpringTransition;
import com.facebook.litho.animation.TimingTransition;
import com.facebook.litho.animation.TransitionAnimationBinding;
import com.facebook.litho.dataflow.springs.SpringConfig;
import java.util.ArrayList;
import javax.annotation.Nullable;

public abstract class Transition {
    public static final TransitionAnimator SPRING_WITH_OVERSHOOT = new SpringTransitionAnimator(SpringConfig.defaultConfig);
    public static final TransitionAnimator SPRING_WITHOUT_OVERSHOOT = new SpringTransitionAnimator(SpringConfig.noOvershootConfig);
    static final TransitionKeyType DEFAULT_TRANSITION_KEY_TYPE = TransitionKeyType.LOCAL;
    private static final TransitionAnimator DEFAULT_ANIMATOR = SPRING_WITH_OVERSHOOT;
    private static final Interpolator DEFAULT_INTERPOLATOR = new AccelerateDecelerateInterpolator();
    private static final int DEFAULT_DURATION = 300;

    public static TransitionUnitsBuilder create(String key) {
        return Transition.create(DEFAULT_TRANSITION_KEY_TYPE, key);
    }

    public static TransitionUnitsBuilder create(String ... keys) {
        return Transition.create(DEFAULT_TRANSITION_KEY_TYPE, keys);
    }

    public static TransitionUnitsBuilder create(TransitionKeyType type, String key) {
        return new TransitionUnitsBuilder(Transition.getComponentTargetTypeForTransitionKeyType(type, true), key);
    }

    public static TransitionUnitsBuilder create(TransitionKeyType type, String ... keys) {
        return new TransitionUnitsBuilder(Transition.getComponentTargetTypeForTransitionKeyType(type, false), keys);
    }

    private static ComponentTargetType getComponentTargetTypeForTransitionKeyType(TransitionKeyType transitionKeyType, boolean isSingleKey) {
        if (transitionKeyType == TransitionKeyType.GLOBAL) {
            return isSingleKey ? ComponentTargetType.GLOBAL_KEY : ComponentTargetType.GLOBAL_KEY_SET;
        }
        if (transitionKeyType == TransitionKeyType.LOCAL) {
            return isSingleKey ? ComponentTargetType.LOCAL_KEY : ComponentTargetType.LOCAL_KEY_SET;
        }
        throw new RuntimeException("Unhandled TransitionKeyType " + (Object)((Object)transitionKeyType));
    }

    public static TransitionUnitsBuilder create(ComponentTarget target) {
        return new TransitionUnitsBuilder(target.componentTargetType, target.componentTargetExtraData);
    }

    public static AutoBoundsTransitionBuilder allLayout() {
        return new AutoBoundsTransitionBuilder();
    }

    @ThreadSafe(enableChecks=false)
    public static <T extends Transition> TransitionSet parallel(T ... transitions) {
        return new ParallelTransitionSet(transitions);
    }

    public static <T extends Transition> TransitionSet stagger(int staggerMs, T ... transitions) {
        return new ParallelTransitionSet(staggerMs, transitions);
    }

    public static <T extends Transition> TransitionSet sequence(T ... transitions) {
        return new SequenceTransitionSet(transitions);
    }

    public static <T extends Transition> Transition delay(int delayMs, T transition) {
        return new DelayTransitionSet(delayMs, transition);
    }

    public static TransitionAnimator springWithConfig(double tension, double friction) {
        return new SpringTransitionAnimator(tension, friction);
    }

    public static TransitionAnimator timing(int durationMs) {
        return new TimingTransitionAnimator(durationMs);
    }

    public static TransitionAnimator timing(int durationMs, Interpolator interpolator) {
        return new TimingTransitionAnimator(durationMs, interpolator);
    }

    public static TransitionAnimator renderThread() {
        return new RenderThreadAnimator(0, 300, (TimeInterpolator)DEFAULT_INTERPOLATOR);
    }

    public static TransitionAnimator renderThread(int delayMs, int durationMs) {
        return new RenderThreadAnimator(delayMs, durationMs, (TimeInterpolator)DEFAULT_INTERPOLATOR);
    }

    public static TransitionAnimator renderThread(int durationMs) {
        return new RenderThreadAnimator(0, durationMs, (TimeInterpolator)DEFAULT_INTERPOLATOR);
    }

    public static TransitionAnimator renderThread(int durationMs, TimeInterpolator interpolator) {
        return new RenderThreadAnimator(0, durationMs, interpolator);
    }

    public static TransitionAnimator renderThread(int delayMs, int durationMs, Interpolator interpolator) {
        return new RenderThreadAnimator(delayMs, durationMs, (TimeInterpolator)interpolator);
    }

    private static <T> boolean arrayContains(T[] array, T value) {
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    static float getRootAppearFromValue(TransitionUnit transition, LayoutState layoutState, AnimatedProperty property) {
        RootItemResolver resolver = new RootItemResolver(layoutState, property);
        TransitionId rootTransitionId = layoutState.getRootTransitionId();
        return transition.getAppearFrom().resolve(resolver, new PropertyHandle(rootTransitionId, property));
    }

    static class RootBoundsTransition {
        boolean hasTransition;
        TransitionUnit appearTransition;

        RootBoundsTransition() {
        }
    }

    private static class RootItemResolver
    implements Resolver {
        private final LayoutState mLayoutState;
        private final AnimatedProperty mAnimatedProperty;

        private RootItemResolver(LayoutState layoutState, AnimatedProperty animatedProperty) {
            this.mLayoutState = layoutState;
            this.mAnimatedProperty = animatedProperty;
        }

        @Override
        public float getCurrentState(PropertyHandle propertyHandle) {
            LayoutOutput root = this.mLayoutState.getMountableOutputAt(0);
            return this.mAnimatedProperty.get(root);
        }

        @Override
        public AnimatedPropertyNode getAnimatedPropertyNode(PropertyHandle propertyHandle) {
            throw new UnsupportedOperationException();
        }
    }

    private static class RenderThreadAnimator
    implements TransitionAnimator {
        final int mDelayMs;
        final int mDurationMs;
        final TimeInterpolator mInterpolator;

        RenderThreadAnimator(int mDelayMs, int mDurationMs, TimeInterpolator mInterpolator) {
            this.mDelayMs = mDelayMs;
            this.mDurationMs = mDurationMs;
            this.mInterpolator = mInterpolator;
        }

        @Override
        public TransitionAnimationBinding createAnimation(PropertyAnimation propertyAnimation) {
            return new RenderThreadTransition(propertyAnimation, this.mDelayMs, this.mDurationMs, this.mInterpolator);
        }
    }

    public static class TimingTransitionAnimator
    implements TransitionAnimator {
        final int mDurationMs;
        final Interpolator mInterpolator;

        public TimingTransitionAnimator(int durationMs) {
            this(durationMs, DEFAULT_INTERPOLATOR);
        }

        public TimingTransitionAnimator(int durationMs, Interpolator interpolator) {
            this.mDurationMs = durationMs;
            this.mInterpolator = interpolator;
        }

        @Override
        public TransitionAnimationBinding createAnimation(PropertyAnimation propertyAnimation) {
            return new TimingTransition(this.mDurationMs, propertyAnimation, this.mInterpolator);
        }
    }

    public static class SpringTransitionAnimator
    implements TransitionAnimator {
        final SpringConfig mSpringConfig;

        public SpringTransitionAnimator(double tension, double friction) {
            this.mSpringConfig = new SpringConfig(tension, friction);
        }

        public SpringTransitionAnimator(SpringConfig springConfig) {
            this.mSpringConfig = springConfig;
        }

        @Override
        public TransitionAnimationBinding createAnimation(PropertyAnimation propertyAnimation) {
            return new SpringTransition(propertyAnimation, this.mSpringConfig);
        }
    }

    public static abstract class BaseTransitionUnitsBuilder
    extends Transition {
        ArrayList<TransitionUnit> mBuiltTransitions = new ArrayList();
        ComponentTarget mComponentTarget;
        PropertyTarget mPropertyTarget;
        TransitionAnimator mTransitionAnimator = Transition.access$100();
        RuntimeValue mAppearFrom;
        RuntimeValue mDisappearTo;
        String mTraceName;

        void maybeCommitCurrentBuilder() {
            if (this.mPropertyTarget == null) {
                return;
            }
            this.mBuiltTransitions.add(new TransitionUnit(new AnimationTarget(this.mComponentTarget, this.mPropertyTarget), this.mTransitionAnimator, this.mAppearFrom, this.mDisappearTo, this.mTraceName));
            this.mPropertyTarget = null;
            this.mTransitionAnimator = DEFAULT_ANIMATOR;
            this.mAppearFrom = null;
            this.mDisappearTo = null;
            this.mTraceName = null;
        }

        ArrayList<TransitionUnit> getTransitionUnits() {
            this.maybeCommitCurrentBuilder();
            return this.mBuiltTransitions;
        }
    }

    public static class AutoBoundsTransitionBuilder
    extends BaseTransitionUnitsBuilder {
        AutoBoundsTransitionBuilder() {
            this.mComponentTarget = new ComponentTarget(ComponentTargetType.AUTO_LAYOUT, null);
            this.mPropertyTarget = new PropertyTarget(PropertyTargetType.AUTO_LAYOUT, null);
        }

        public AutoBoundsTransitionBuilder animator(TransitionAnimator animator) {
            this.mTransitionAnimator = animator;
            return this;
        }
    }

    public static class TransitionUnitsBuilder
    extends BaseTransitionUnitsBuilder {
        TransitionUnitsBuilder(ComponentTarget componentTarget) {
            this.mComponentTarget = componentTarget;
        }

        TransitionUnitsBuilder(ComponentTargetType componentTargetType, Object componentTargetExtraData) {
            this.mComponentTarget = new ComponentTarget(componentTargetType, componentTargetExtraData);
        }

        public TransitionUnitsBuilder animate(AnimatedProperty property) {
            this.maybeCommitCurrentBuilder();
            this.mPropertyTarget = new PropertyTarget(PropertyTargetType.SINGLE, property);
            return this;
        }

        public TransitionUnitsBuilder animate(AnimatedProperty ... properties) {
            this.maybeCommitCurrentBuilder();
            this.mPropertyTarget = new PropertyTarget(PropertyTargetType.SET, properties);
            return this;
        }

        public TransitionUnitsBuilder animate(PropertyTarget propertyTarget) {
            this.maybeCommitCurrentBuilder();
            this.mPropertyTarget = propertyTarget;
            return this;
        }

        public TransitionUnitsBuilder animator(TransitionAnimator animator) {
            this.mTransitionAnimator = animator;
            return this;
        }

        public TransitionUnitsBuilder appearFrom(RuntimeValue value) {
            if (this.mPropertyTarget == null || this.mPropertyTarget.propertyTargetType != PropertyTargetType.SINGLE) {
                throw new RuntimeException("Must specify a single property using #animate() before specifying an appearFrom value!");
            }
            this.mAppearFrom = value;
            return this;
        }

        public TransitionUnitsBuilder traceName(String name) {
            this.mTraceName = name;
            return this;
        }

        public TransitionUnitsBuilder disappearTo(RuntimeValue value) {
            if (this.mPropertyTarget == null || this.mPropertyTarget.propertyTargetType != PropertyTargetType.SINGLE) {
                throw new RuntimeException("Must specify a single property using #animate() before specifying an disappearTo value!");
            }
            this.mDisappearTo = value;
            return this;
        }

        public TransitionUnitsBuilder appearFrom(float value) {
            return this.appearFrom(new FloatValue(value));
        }

        public TransitionUnitsBuilder disappearTo(float value) {
            return this.disappearTo(new FloatValue(value));
        }
    }

    public static class TransitionUnit
    extends Transition {
        private final AnimationTarget mAnimationTarget;
        private final TransitionAnimator mTransitionAnimator;
        private final RuntimeValue mAppearFrom;
        private final RuntimeValue mDisappearTo;
        @Nullable
        private final String mTraceName;
        @Nullable
        private String mOwnerKey;

        TransitionUnit(AnimationTarget animationTarget, TransitionAnimator transitionAnimator, RuntimeValue appearFrom, RuntimeValue disappearTo, @Nullable String traceName) {
            this.mAnimationTarget = animationTarget;
            this.mTransitionAnimator = transitionAnimator;
            this.mAppearFrom = appearFrom;
            this.mDisappearTo = disappearTo;
            this.mTraceName = traceName;
        }

        AnimationTarget getAnimationTarget() {
            return this.mAnimationTarget;
        }

        boolean hasAppearAnimation() {
            return this.mAppearFrom != null;
        }

        boolean hasDisappearAnimation() {
            return this.mDisappearTo != null;
        }

        RuntimeValue getAppearFrom() {
            return this.mAppearFrom;
        }

        RuntimeValue getDisappearTo() {
            return this.mDisappearTo;
        }

        AnimationBinding createAnimation(PropertyHandle propertyHandle, float targetValue) {
            PropertyAnimation propertyAnimation = new PropertyAnimation(propertyHandle, targetValue);
            return this.mTransitionAnimator.createAnimation(propertyAnimation);
        }

        @Nullable
        String getTraceName() {
            return this.mTraceName;
        }

        void setOwnerKey(@Nullable String ownerKey) {
            this.mOwnerKey = ownerKey;
        }

        @Nullable
        String getOwnerKey() {
            return this.mOwnerKey;
        }

        boolean targets(TransitionId transitionId) {
            switch (this.mAnimationTarget.componentTarget.componentTargetType) {
                case ALL: 
                case AUTO_LAYOUT: {
                    return true;
                }
                case LOCAL_KEY: {
                    if (!CommonUtils.equals(this.mOwnerKey, transitionId.mExtraData)) {
                        return false;
                    }
                }
                case GLOBAL_KEY: {
                    return transitionId.mReference.equals(this.mAnimationTarget.componentTarget.componentTargetExtraData);
                }
                case LOCAL_KEY_SET: {
                    if (!CommonUtils.equals(this.mOwnerKey, transitionId.mExtraData)) {
                        return false;
                    }
                }
                case GLOBAL_KEY_SET: {
                    return Transition.arrayContains((String[])this.mAnimationTarget.componentTarget.componentTargetExtraData, transitionId.mReference);
                }
            }
            throw new RuntimeException("Didn't handle type: " + (Object)((Object)this.mAnimationTarget.componentTarget.componentTargetType));
        }

        boolean targetsProperty(AnimatedProperty property) {
            switch (this.mAnimationTarget.propertyTarget.propertyTargetType) {
                case AUTO_LAYOUT: {
                    return Transition.arrayContains(AnimatedProperties.AUTO_LAYOUT_PROPERTIES, property);
                }
                case SET: {
                    return Transition.arrayContains((AnimatedProperty[])this.mAnimationTarget.propertyTarget.propertyTargetExtraData, property);
                }
                case SINGLE: {
                    return property.equals(this.mAnimationTarget.propertyTarget.propertyTargetExtraData);
                }
            }
            throw new RuntimeException("Didn't handle type: " + this.mAnimationTarget.propertyTarget.propertyTargetExtraData);
        }
    }

    public static interface TransitionAnimator {
        public TransitionAnimationBinding createAnimation(PropertyAnimation var1);
    }

    public static class PropertyTarget {
        public final PropertyTargetType propertyTargetType;
        public final Object propertyTargetExtraData;

        PropertyTarget(PropertyTargetType propertyTargetType, Object propertyTargetExtraData) {
            this.propertyTargetType = propertyTargetType;
            this.propertyTargetExtraData = propertyTargetExtraData;
        }
    }

    public static class ComponentTarget {
        public final ComponentTargetType componentTargetType;
        public final Object componentTargetExtraData;

        ComponentTarget(ComponentTargetType componentTargetType, Object componentTargetExtraData) {
            this.componentTargetType = componentTargetType;
            this.componentTargetExtraData = componentTargetExtraData;
        }
    }

    public static class AnimationTarget {
        public final ComponentTarget componentTarget;
        public final PropertyTarget propertyTarget;

        AnimationTarget(ComponentTarget componentTarget, PropertyTarget propertyTarget) {
            this.componentTarget = componentTarget;
            this.propertyTarget = propertyTarget;
        }
    }

    static enum PropertyTargetType {
        SET,
        SINGLE,
        AUTO_LAYOUT;

    }

    static enum ComponentTargetType {
        ALL,
        LOCAL_KEY,
        LOCAL_KEY_SET,
        GLOBAL_KEY,
        GLOBAL_KEY_SET,
        AUTO_LAYOUT;

    }

    public static enum TransitionKeyType {
        GLOBAL,
        LOCAL;

    }
}

