/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.os.Looper;
import android.os.Process;
import androidx.annotation.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ThreadUtils {
    public static final int OVERRIDE_DISABLED = 0;
    public static final int OVERRIDE_MAIN_THREAD_TRUE = 1;
    public static final int OVERRIDE_MAIN_THREAD_FALSE = 2;
    private static int sMainThreadOverride = 0;

    private ThreadUtils() {
    }

    @VisibleForTesting
    public static void setMainThreadOverride(int override) {
        sMainThreadOverride = override;
    }

    public static boolean isMainThread() {
        switch (sMainThreadOverride) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    public static void assertMainThread() {
    }

    public static void assertHoldsLock(Object lock) {
    }

    public static void assertDoesntHoldLock(Object lock) {
    }

    public static int tryInheritThreadPriorityFromCurrentThread(int threadId) {
        return ThreadUtils.tryRaiseThreadPriority(threadId, Process.getThreadPriority((int)Process.myTid()));
    }

    public static int tryRaiseThreadPriority(int threadId, int targetThreadPriority) {
        int originalThreadPriority = Process.getThreadPriority((int)threadId);
        boolean success = false;
        while (!success && targetThreadPriority < originalThreadPriority) {
            try {
                Process.setThreadPriority((int)threadId, (int)targetThreadPriority);
                success = true;
            }
            catch (SecurityException e) {
                ++targetThreadPriority;
            }
        }
        return originalThreadPriority;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MainThreadOverride {
    }
}

