/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.util.Log;
import com.facebook.litho.config.ComponentsConfiguration;

public abstract class ThreadTracingRunnable
implements Runnable {
    private static final String MESSAGE_PART_1 = "Runnable instantiated on thread id: ";
    private static final String MESSAGE_PART_2 = ", name: ";
    private final Throwable mTracingThrowable;

    public ThreadTracingRunnable() {
        Thread thread = Thread.currentThread();
        this.mTracingThrowable = new Throwable(MESSAGE_PART_1 + thread.getId() + MESSAGE_PART_2 + thread.getName());
    }

    public ThreadTracingRunnable(Throwable prevTracingThrowable) {
        this();
        this.mTracingThrowable.initCause(prevTracingThrowable);
    }

    public abstract void tracedRun(Throwable var1);

    public void resetTrace() {
        this.mTracingThrowable.fillInStackTrace();
    }

    @Override
    public final void run() {
        try {
            this.tracedRun(this.mTracingThrowable);
        }
        catch (Throwable t) {
            if (ComponentsConfiguration.enableThreadTracingStacktrace) {
                Log.w((String)"LithoThreadTracing", (String)"--- start debug trace");
                Log.w((String)"LithoThreadTracing", (String)"Thread tracing stacktrace", (Throwable)this.mTracingThrowable);
                Log.w((String)"LithoThreadTracing", (String)"--- end debug trace");
            }
            throw t;
        }
    }
}

