/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.LayoutThreadPoolExecutor;
import com.facebook.litho.LithoHandler;
import com.facebook.litho.config.LayoutThreadPoolConfiguration;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;

public class ThreadPoolLayoutHandler
implements LithoHandler {
    private static ThreadPoolExecutor sLayoutThreadPoolExecutor;

    public ThreadPoolLayoutHandler(LayoutThreadPoolConfiguration configuration) {
        if (sLayoutThreadPoolExecutor == null) {
            sLayoutThreadPoolExecutor = new LayoutThreadPoolExecutor(configuration.getCorePoolSize(), configuration.getMaxPoolSize(), configuration.getThreadPriority());
        }
    }

    @Override
    public boolean isTracing() {
        return false;
    }

    @Override
    public void post(Runnable runnable, String tag) {
        try {
            sLayoutThreadPoolExecutor.execute(runnable);
        }
        catch (RejectedExecutionException e) {
            throw new RuntimeException("Cannot execute layout calculation task; " + e);
        }
    }

    @Override
    public void remove(Runnable runnable) {
        sLayoutThreadPoolExecutor.remove(runnable);
    }
}

