/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.StateContainer;
import com.facebook.litho.Transition;
import com.facebook.litho.TransitionUtils;
import com.facebook.litho.stats.LithoStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;

public class StateHandler {
    private static final int INITIAL_STATE_UPDATE_LIST_CAPACITY = 4;
    private static final int INITIAL_MAP_CAPACITY = 4;
    @GuardedBy(value="this")
    private Map<String, List<StateContainer.StateUpdate>> mPendingStateUpdates;
    @GuardedBy(value="this")
    @Nullable
    private Map<String, List<StateContainer.StateUpdate>> mPendingLazyStateUpdates;
    @GuardedBy(value="this")
    @Nullable
    private Map<String, List<Transition>> mPendingStateUpdateTransitions;
    @GuardedBy(value="this")
    private Map<String, List<StateContainer.StateUpdate>> mAppliedStateUpdates;
    @GuardedBy(value="this")
    public Map<String, StateContainer> mStateContainers;
    @GuardedBy(value="this")
    public HashSet<String> mNeededStateContainers;
    @GuardedBy(value="this")
    @Nullable
    private Map<Object, Object> mCachedValues;
    private Map<String, Object> mCreateInitialStateLock;

    public StateHandler() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateHandler(@Nullable StateHandler stateHandler) {
        if (stateHandler == null) {
            return;
        }
        StateHandler stateHandler2 = this;
        synchronized (stateHandler2) {
            this.copyStateUpdatesMap(stateHandler.getPendingStateUpdates(), stateHandler.getPendingLazyStateUpdates(), stateHandler.getAppliedStateUpdates());
            this.copyCurrentStateContainers(stateHandler.getStateContainers());
            this.copyPendingStateTransitions(stateHandler.getPendingStateUpdateTransitions());
        }
    }

    public static StateHandler createNewInstance(@Nullable StateHandler stateHandler) {
        return new StateHandler(stateHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StateHandler createShallowCopyForLazyStateUpdates(StateHandler stateHandler) {
        StateHandler copy = new StateHandler();
        StateHandler stateHandler2 = stateHandler;
        synchronized (stateHandler2) {
            copy.copyPendingLazyStateUpdates(stateHandler.mPendingLazyStateUpdates);
        }
        return copy;
    }

    public synchronized boolean isEmpty() {
        return this.mStateContainers == null || this.mStateContainers.isEmpty();
    }

    synchronized boolean hasPendingUpdates() {
        if (this.mPendingStateUpdates != null && !this.mPendingStateUpdates.isEmpty()) {
            for (List<StateContainer.StateUpdate> entry : this.mPendingStateUpdates.values()) {
                if (entry.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    synchronized void queueStateUpdate(String key, StateContainer.StateUpdate stateUpdate, boolean isLazyStateUpdate) {
        this.maybeInitStateUpdatesMap();
        StateHandler.addStateUpdateForKey(key, stateUpdate, this.mPendingStateUpdates);
        if (isLazyStateUpdate) {
            this.maybeInitLazyStateUpdatesMap();
            StateHandler.addStateUpdateForKey(key, stateUpdate, this.mPendingLazyStateUpdates);
        }
    }

    private static void addStateUpdateForKey(String key, StateContainer.StateUpdate stateUpdate, Map<String, List<StateContainer.StateUpdate>> map) {
        List<StateContainer.StateUpdate> pendingStateUpdatesForKey = map.get(key);
        if (pendingStateUpdatesForKey == null) {
            pendingStateUpdatesForKey = StateHandler.createStateUpdatesList();
            map.put(key, pendingStateUpdatesForKey);
        }
        pendingStateUpdatesForKey.add(stateUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe(enableChecks=false)
    void applyStateUpdatesForComponent(Component component) {
        List<StateContainer.StateUpdate> stateUpdatesForKey;
        StateContainer currentStateContainer;
        this.maybeInitStateContainers();
        this.maybeInitNeededStateContainers();
        if (!component.hasState()) {
            return;
        }
        String key = component.getGlobalKey();
        StateHandler stateHandler = this;
        synchronized (stateHandler) {
            currentStateContainer = this.mStateContainers.get(key);
            this.mNeededStateContainers.add(key);
        }
        if (currentStateContainer != null) {
            component.transferState(currentStateContainer, component.getStateContainer());
        } else {
            ComponentTree componentTree = component.getScopedContext().getComponentTree();
            if (componentTree == null || !componentTree.shouldCreateInitialStateOncePerThread()) {
                component.createInitialState(component.getScopedContext());
            } else {
                StateHandler.maybeCreateInitialStateAndCommitResult(component, componentTree);
            }
        }
        Object object = this;
        synchronized (object) {
            stateUpdatesForKey = this.mPendingStateUpdates == null ? null : this.mPendingStateUpdates.get(key);
        }
        if (stateUpdatesForKey != null) {
            for (StateContainer.StateUpdate update : stateUpdatesForKey) {
                component.getStateContainer().applyStateUpdate(update);
            }
            LithoStats.incStateUpdate(stateUpdatesForKey.size());
            if (component.getScopedContext().isNestedTreeResolutionExperimentEnabled()) {
                object = this;
                synchronized (object) {
                    this.mPendingStateUpdates.remove(key);
                    if (this.mPendingLazyStateUpdates != null) {
                        this.mPendingLazyStateUpdates.remove(key);
                    }
                    this.mAppliedStateUpdates.put(key, stateUpdatesForKey);
                }
            }
        }
        object = this;
        synchronized (object) {
            List<Transition> transitions;
            StateContainer stateContainer = component.getStateContainer();
            this.mStateContainers.put(key, stateContainer);
            if (stateContainer instanceof ComponentLifecycle.TransitionContainer && !(transitions = ((ComponentLifecycle.TransitionContainer)((Object)stateContainer)).consumeTransitions()).isEmpty()) {
                this.maybeInitPendingStateUpdateTransitions();
                this.mPendingStateUpdateTransitions.put(key, transitions);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void maybeCreateInitialStateAndCommitResult(Component component, ComponentTree componentTree) {
        Object initLock;
        StateHandler stateHandler = componentTree.getStateHandler();
        if (stateHandler == null) {
            return;
        }
        String key = component.getGlobalKey();
        Object object = initLock = new Object();
        synchronized (object) {
            Object lock;
            Object object2 = lock = stateHandler.getCreateInitialStateLock(key, initLock);
            synchronized (object2) {
                if (initLock == lock) {
                    component.createInitialState(component.getScopedContext());
                    stateHandler.maybeInitStateContainers();
                    stateHandler.mStateContainers.put(key, component.getStateContainer());
                } else {
                    component.transferState(stateHandler.mStateContainers.get(key), component.getStateContainer());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getCreateInitialStateLock(String globalKey, Object lock) {
        Object object = this;
        synchronized (object) {
            if (this.mCreateInitialStateLock == null) {
                this.mCreateInitialStateLock = new HashMap<String, Object>();
            }
        }
        object = this.mCreateInitialStateLock;
        synchronized (object) {
            Object existingLock = this.mCreateInitialStateLock.get(globalKey);
            if (existingLock != null) {
                return existingLock;
            }
            this.mCreateInitialStateLock.put(globalKey, lock);
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyLazyStateUpdatesForContainer(String componentKey, StateContainer container) {
        List<StateContainer.StateUpdate> stateUpdatesForKey;
        StateHandler stateHandler = this;
        synchronized (stateHandler) {
            stateUpdatesForKey = this.mPendingLazyStateUpdates == null ? null : this.mPendingLazyStateUpdates.get(componentKey);
        }
        if (stateUpdatesForKey != null) {
            for (StateContainer.StateUpdate update : stateUpdatesForKey) {
                container.applyStateUpdate(update);
            }
        }
    }

    void commit(StateHandler stateHandler, boolean isNestedTreeResolutionExperimentEnabled) {
        this.clearStateUpdates(isNestedTreeResolutionExperimentEnabled ? stateHandler.getAppliedStateUpdates() : stateHandler.getPendingStateUpdates());
        StateHandler.clearUnusedStateContainers(this, stateHandler);
        this.copyCurrentStateContainers(stateHandler.getStateContainers());
        this.copyPendingStateTransitions(stateHandler.getPendingStateUpdateTransitions());
    }

    synchronized Set<String> getKeysForPendingUpdates() {
        HashSet<String> keys = new HashSet<String>();
        if (this.mAppliedStateUpdates != null) {
            keys.addAll(this.mAppliedStateUpdates.keySet());
        }
        if (this.mPendingStateUpdates != null) {
            keys.addAll(this.mPendingStateUpdates.keySet());
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearStateUpdates(@Nullable Map<String, List<StateContainer.StateUpdate>> appliedStateUpdates) {
        StateHandler stateHandler = this;
        synchronized (stateHandler) {
            if (appliedStateUpdates == null || this.mPendingStateUpdates == null || this.mPendingStateUpdates.isEmpty()) {
                return;
            }
        }
        for (String key : appliedStateUpdates.keySet()) {
            List<StateContainer.StateUpdate> pendingLazyStateUpdatesForKey;
            List<StateContainer.StateUpdate> pendingStateUpdatesForKey;
            StateHandler stateHandler2 = this;
            synchronized (stateHandler2) {
                pendingStateUpdatesForKey = this.mPendingStateUpdates.get(key);
                pendingLazyStateUpdatesForKey = this.mPendingLazyStateUpdates == null ? null : this.mPendingLazyStateUpdates.get(key);
            }
            if (pendingStateUpdatesForKey == null) continue;
            List<StateContainer.StateUpdate> appliedStateUpdatesForKey = appliedStateUpdates.get(key);
            if (pendingStateUpdatesForKey.size() == appliedStateUpdatesForKey.size()) {
                StateHandler stateHandler3 = this;
                synchronized (stateHandler3) {
                    this.mPendingStateUpdates.remove(key);
                    if (this.mPendingLazyStateUpdates != null) {
                        this.mPendingLazyStateUpdates.remove(key);
                    }
                    continue;
                }
            }
            pendingStateUpdatesForKey.removeAll(appliedStateUpdatesForKey);
            if (pendingLazyStateUpdatesForKey == null) continue;
            pendingLazyStateUpdatesForKey.removeAll(appliedStateUpdatesForKey);
        }
    }

    private static List<StateContainer.StateUpdate> createStateUpdatesList() {
        return StateHandler.createStateUpdatesList(null);
    }

    private static List<StateContainer.StateUpdate> createStateUpdatesList(@Nullable List<StateContainer.StateUpdate> copyFrom) {
        ArrayList<StateContainer.StateUpdate> list = new ArrayList<StateContainer.StateUpdate>(copyFrom == null ? 4 : copyFrom.size());
        if (copyFrom != null) {
            list.addAll(copyFrom);
        }
        return list;
    }

    synchronized Map<String, StateContainer> getStateContainers() {
        return this.mStateContainers;
    }

    @Nullable
    synchronized Map<String, List<StateContainer.StateUpdate>> getPendingStateUpdates() {
        return this.mPendingStateUpdates;
    }

    @Nullable
    synchronized Map<String, List<StateContainer.StateUpdate>> getPendingLazyStateUpdates() {
        return this.mPendingLazyStateUpdates;
    }

    @Nullable
    synchronized Map<String, List<Transition>> getPendingStateUpdateTransitions() {
        return this.mPendingStateUpdateTransitions;
    }

    @VisibleForTesting
    synchronized Map<String, List<StateContainer.StateUpdate>> getAppliedStateUpdates() {
        return this.mAppliedStateUpdates;
    }

    synchronized void consumePendingStateUpdateTransitions(List<Transition> outList, @Nullable String logContext) {
        if (this.mPendingStateUpdateTransitions == null) {
            return;
        }
        for (List<Transition> pendingTransitions : this.mPendingStateUpdateTransitions.values()) {
            int size = pendingTransitions.size();
            for (int i = 0; i < size; ++i) {
                TransitionUtils.addTransitions(pendingTransitions.get(i), outList, logContext);
            }
        }
        this.mPendingStateUpdateTransitions = null;
    }

    @Nullable
    synchronized Object getCachedValue(Object cachedValueInputs) {
        if (this.mCachedValues == null) {
            this.mCachedValues = new HashMap<Object, Object>();
        }
        return this.mCachedValues.get(cachedValueInputs);
    }

    synchronized void putCachedValue(Object cachedValueInputs, Object cachedValue) {
        if (this.mCachedValues == null) {
            this.mCachedValues = new HashMap<Object, Object>();
        }
        this.mCachedValues.put(cachedValueInputs, cachedValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStateUpdatesMap(@Nullable Map<String, List<StateContainer.StateUpdate>> pendingStateUpdates, @Nullable Map<String, List<StateContainer.StateUpdate>> pendingLazyStateUpdates, @Nullable Map<String, List<StateContainer.StateUpdate>> appliedStateUpdates) {
        if ((pendingStateUpdates == null || pendingStateUpdates.isEmpty()) && (appliedStateUpdates == null || appliedStateUpdates.isEmpty())) {
            return;
        }
        this.maybeInitStateUpdatesMap();
        StateHandler stateHandler = this;
        synchronized (stateHandler) {
            if (pendingStateUpdates != null) {
                for (String key : pendingStateUpdates.keySet()) {
                    this.mPendingStateUpdates.put(key, StateHandler.createStateUpdatesList(pendingStateUpdates.get(key)));
                }
            }
            this.copyPendingLazyStateUpdates(pendingLazyStateUpdates);
            if (appliedStateUpdates != null) {
                for (String key : appliedStateUpdates.keySet()) {
                    this.mAppliedStateUpdates.put(key, StateHandler.createStateUpdatesList(appliedStateUpdates.get(key)));
                }
            }
        }
    }

    private void copyPendingLazyStateUpdates(@Nullable Map<String, List<StateContainer.StateUpdate>> pendingLazyStateUpdates) {
        if (pendingLazyStateUpdates == null || pendingLazyStateUpdates.isEmpty()) {
            return;
        }
        this.maybeInitLazyStateUpdatesMap();
        for (String key : pendingLazyStateUpdates.keySet()) {
            this.mPendingLazyStateUpdates.put(key, StateHandler.createStateUpdatesList(pendingLazyStateUpdates.get(key)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCurrentStateContainers(Map<String, StateContainer> stateContainers) {
        if (stateContainers == null || stateContainers.isEmpty()) {
            return;
        }
        StateHandler stateHandler = this;
        synchronized (stateHandler) {
            this.maybeInitStateContainers();
            this.mStateContainers.clear();
            this.mStateContainers.putAll(stateContainers);
        }
    }

    private static void clearUnusedStateContainers(StateHandler createInitialStateLockingStateHandler, StateHandler currentStateHandler) {
        HashSet<String> neededStateContainers = currentStateHandler.mNeededStateContainers;
        ArrayList<String> stateContainerKeys = new ArrayList<String>();
        if (neededStateContainers == null || currentStateHandler.mStateContainers == null) {
            return;
        }
        boolean shouldCleanLocks = createInitialStateLockingStateHandler.mCreateInitialStateLock != null && !createInitialStateLockingStateHandler.mCreateInitialStateLock.isEmpty();
        stateContainerKeys.addAll(currentStateHandler.mStateContainers.keySet());
        for (String key : stateContainerKeys) {
            if (neededStateContainers.contains(key)) continue;
            currentStateHandler.mStateContainers.remove(key);
            if (!shouldCleanLocks) continue;
            createInitialStateLockingStateHandler.mCreateInitialStateLock.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPendingStateTransitions(@Nullable Map<String, List<Transition>> pendingStateUpdateTransitions) {
        if (pendingStateUpdateTransitions == null || pendingStateUpdateTransitions.isEmpty()) {
            return;
        }
        StateHandler stateHandler = this;
        synchronized (stateHandler) {
            this.maybeInitPendingStateUpdateTransitions();
            this.mPendingStateUpdateTransitions.putAll(pendingStateUpdateTransitions);
        }
    }

    private synchronized void maybeInitStateContainers() {
        if (this.mStateContainers == null) {
            this.mStateContainers = new HashMap<String, StateContainer>(4);
        }
    }

    private synchronized void maybeInitNeededStateContainers() {
        if (this.mNeededStateContainers == null) {
            this.mNeededStateContainers = new HashSet();
        }
    }

    private synchronized void maybeInitPendingStateUpdateTransitions() {
        if (this.mPendingStateUpdateTransitions == null) {
            this.mPendingStateUpdateTransitions = new HashMap<String, List<Transition>>();
        }
    }

    private synchronized void maybeInitStateUpdatesMap() {
        if (this.mPendingStateUpdates == null) {
            this.mPendingStateUpdates = new HashMap<String, List<StateContainer.StateUpdate>>(4);
        }
        if (this.mAppliedStateUpdates == null) {
            this.mAppliedStateUpdates = new HashMap<String, List<StateContainer.StateUpdate>>(4);
        }
    }

    private synchronized void maybeInitLazyStateUpdatesMap() {
        if (this.mPendingLazyStateUpdates == null) {
            this.mPendingLazyStateUpdates = new HashMap<String, List<StateContainer.StateUpdate>>(4);
        }
    }
}

