/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.util.SparseArray;
import android.view.ViewOutlineProvider;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.litho.ClickEvent;
import com.facebook.litho.DispatchPopulateAccessibilityEventEvent;
import com.facebook.litho.EventHandler;
import com.facebook.litho.FocusChangedEvent;
import com.facebook.litho.InterceptTouchEvent;
import com.facebook.litho.LongClickEvent;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.NodeInfoUtils;
import com.facebook.litho.OnInitializeAccessibilityEventEvent;
import com.facebook.litho.OnInitializeAccessibilityNodeInfoEvent;
import com.facebook.litho.OnPopulateAccessibilityEventEvent;
import com.facebook.litho.OnRequestSendAccessibilityEventEvent;
import com.facebook.litho.PerformAccessibilityActionEvent;
import com.facebook.litho.SendAccessibilityEventEvent;
import com.facebook.litho.SendAccessibilityEventUncheckedEvent;
import com.facebook.litho.TouchEvent;

@ThreadConfined(value="ANY")
class SparseNodeInfo
implements NodeInfo {
    private static final int PFLAG_CONTENT_DESCRIPTION_IS_SET = 1;
    private static final int PFLAG_VIEW_TAG_IS_SET = 2;
    private static final int PFLAG_VIEW_TAGS_IS_SET = 4;
    private static final int PFLAG_CLICK_HANDLER_IS_SET = 8;
    private static final int PFLAG_LONG_CLICK_HANDLER_IS_SET = 16;
    private static final int PFLAG_TOUCH_HANDLER_IS_SET = 32;
    private static final int PFLAG_DISPATCH_POPULATE_ACCESSIBILITY_EVENT_HANDLER_IS_SET = 64;
    private static final int PFLAG_ON_INITIALIZE_ACCESSIBILITY_EVENT_HANDLER_IS_SET = 128;
    private static final int PFLAG_ON_INITIALIZE_ACCESSIBILITY_NODE_INFO_HANDLER_IS_SET = 256;
    private static final int PFLAG_ON_POPULATE_ACCESSIBILITY_EVENT_HANDLER_IS_SET = 512;
    private static final int PFLAG_ON_REQUEST_SEND_ACCESSIBILITY_EVENT_HANDLER_IS_SET = 1024;
    private static final int PFLAG_PERFORM_ACCESSIBILITY_ACTION_HANDLER_IS_SET = 2048;
    private static final int PFLAG_SEND_ACCESSIBILITY_EVENT_HANDLER_IS_SET = 4096;
    private static final int PFLAG_SEND_ACCESSIBILITY_EVENT_UNCHECKED_HANDLER_IS_SET = 8192;
    private static final int PFLAG_SHADOW_ELEVATION_IS_SET = 16384;
    private static final int PFLAG_OUTINE_PROVIDER_IS_SET = 32768;
    private static final int PFLAG_CLIP_TO_OUTLINE_IS_SET = 65536;
    private static final int PFLAG_FOCUS_CHANGE_HANDLER_IS_SET = 131072;
    private static final int PFLAG_INTERCEPT_TOUCH_HANDLER_IS_SET = 262144;
    private static final int PFLAG_SCALE_IS_SET = 524288;
    private static final int PFLAG_ALPHA_IS_SET = 0x100000;
    private static final int PFLAG_ROTATION_IS_SET = 0x200000;
    private static final int PFLAG_ACCESSIBILITY_ROLE_IS_SET = 0x400000;
    private static final int PFLAG_CLIP_CHILDREN_IS_SET = 0x800000;
    private static final int PFLAG_ACCESSIBILITY_ROLE_DESCRIPTION_IS_SET = 0x1000000;
    private static final int PFLAG_ROTATION_X_IS_SET = 0x2000000;
    private static final int PFLAG_ROTATION_Y_IS_SET = 0x4000000;
    private static final int OFLAG_HAS_FOCUS_CHANGE_HANDLER = 1;
    private static final int OFLAG_HAS_CLICK_HANDLER = 2;
    private static final int OFLAG_HAS_LONG_CLICK_HANDLER = 4;
    private static final int OFLAG_HAS_TOUCH_HANDLER = 8;
    private static final int OFLAG_HAS_INTERCEPT_TOUCH_HANDLER = 16;
    private static final int OFLAG_HAS_ON_INITIALIZE_ACCESSIBILITY_EVENT_HANDLER = 32;
    private static final int OFLAG_HAS_ON_INITIALIZE_ACCESSIBILITY_NODE_INFO_HANDLER = 64;
    private static final int OFLAG_HAS_ON_POPULATE_ACCESSIBILITY_EVENT_HANDLER = 128;
    private static final int OFLAG_HAS_ON_REQUEST_SEND_ACCESSIBILITY_EVENT_HANDLER = 256;
    private static final int OFLAG_HAS_PERFORM_ACCESSIBILITY_ACTION_HANDLER = 512;
    private static final int OFLAG_HAS_DISPATCH_POPULATE_ACCESSIBILITY_EVENT_HANDLER = 1024;
    private static final int OFLAG_HAS_SEND_ACCESSIBILITY_EVENT_HANDLER = 2048;
    private static final int OFLAG_HAS_SEND_ACCESSIBILITY_EVENT_UNCHECKED_HANDLER = 4096;
    private static final int OFLAG_HAS_ACCESSIBILITY_ROLE = 8192;
    private static final int OFLAG_HAS_ACCESSIBILITY_ROLE_DESCRIPTION = 16384;
    private static final int INDEX_ViewTag = 0;
    private static final int INDEX_ViewTags = 1;
    private static final int INDEX_OutlineProvider = 2;
    private static final int INDEX_ContentDescription = 3;
    private static final int INDEX_AccessibilityRoleDescription = 4;
    private static final int INDEX_AccessibilityRole = 5;
    private static final int INDEX_ClickHandler = 6;
    private static final int INDEX_FocusChangeHandler = 7;
    private static final int INDEX_LongClickHandler = 8;
    private static final int INDEX_TouchHandler = 9;
    private static final int INDEX_InterceptTouchHandler = 10;
    private static final int INDEX_DispatchPopulateAccessibilityEventHandler = 11;
    private static final int INDEX_OnInitializeAccessibilityEventHandler = 12;
    private static final int INDEX_OnPopulateAccessibilityEventHandler = 13;
    private static final int INDEX_OnInitializeAccessibilityNodeInfoHandler = 14;
    private static final int INDEX_OnRequestSendAccessibilityEventHandler = 15;
    private static final int INDEX_PerformAccessibilityActionHandler = 16;
    private static final int INDEX_SendAccessibilityEventHandler = 17;
    private static final int INDEX_SendAccessibilityEventUncheckedHandler = 18;
    @Nullable
    private SparseArray<Object> mObjectProps;
    private float mScale = 1.0f;
    private float mAlpha = 1.0f;
    private float mRotation = 0.0f;
    private float mRotationX = 0.0f;
    private float mRotationY = 0.0f;
    private float mShadowElevation = 0.0f;
    private int mFocusState = 0;
    private int mClickableState = 0;
    private int mEnabledState = 0;
    private int mSelectedState = 0;
    private boolean mClipToOutline;
    private boolean mClipChildren = true;
    private int mPrivateFlags;
    private int mOtherFlags;

    SparseNodeInfo() {
    }

    @Override
    public void setContentDescription(@Nullable CharSequence contentDescription) {
        this.mPrivateFlags |= 1;
        this.getOrCreateObjectProps().append(3, (Object)contentDescription);
    }

    @Override
    @Nullable
    public CharSequence getContentDescription() {
        return (this.mPrivateFlags & 1) != 0 ? (CharSequence)this.getOrCreateObjectProps().get(3) : null;
    }

    @Override
    public void setViewTag(@Nullable Object viewTag) {
        this.mPrivateFlags |= 2;
        this.getOrCreateObjectProps().append(0, viewTag);
    }

    @Override
    @Nullable
    public Object getViewTag() {
        return (this.mPrivateFlags & 2) != 0 ? this.getOrCreateObjectProps().get(0) : null;
    }

    @Override
    public void setViewTags(@Nullable SparseArray<Object> viewTags) {
        this.mPrivateFlags |= 4;
        this.getOrCreateObjectProps().append(1, viewTags);
    }

    @Override
    @Nullable
    public SparseArray<Object> getViewTags() {
        return (this.mPrivateFlags & 4) != 0 ? (SparseArray)this.getOrCreateObjectProps().get(1) : null;
    }

    @Override
    public void setShadowElevation(float shadowElevation) {
        this.mPrivateFlags |= 0x4000;
        this.mShadowElevation = shadowElevation;
    }

    @Override
    public float getShadowElevation() {
        return this.mShadowElevation;
    }

    @Override
    public void setOutlineProvider(@Nullable ViewOutlineProvider outlineProvider) {
        this.mPrivateFlags |= 0x8000;
        this.getOrCreateObjectProps().append(2, (Object)outlineProvider);
    }

    @Override
    @Nullable
    public ViewOutlineProvider getOutlineProvider() {
        return (this.mPrivateFlags & 0x8000) != 0 ? (ViewOutlineProvider)this.getOrCreateObjectProps().get(2) : null;
    }

    @Override
    public void setClipToOutline(boolean clipToOutline) {
        this.mPrivateFlags |= 0x10000;
        this.mClipToOutline = clipToOutline;
    }

    @Override
    public boolean getClipToOutline() {
        return this.mClipToOutline;
    }

    @Override
    public void setClipChildren(boolean clipChildren) {
        this.mPrivateFlags |= 0x800000;
        this.mClipChildren = clipChildren;
    }

    @Override
    public boolean getClipChildren() {
        return this.mClipChildren;
    }

    @Override
    public boolean isClipChildrenSet() {
        return (this.mPrivateFlags & 0x800000) != 0;
    }

    @Override
    public void setClickHandler(@Nullable EventHandler<ClickEvent> clickHandler) {
        this.mPrivateFlags |= 8;
        this.mOtherFlags = clickHandler == null ? (this.mOtherFlags &= 0xFFFFFFFD) : (this.mOtherFlags |= 2);
        this.getOrCreateObjectProps().append(6, clickHandler);
    }

    @Override
    @Nullable
    public EventHandler<ClickEvent> getClickHandler() {
        return (this.mOtherFlags & 2) != 0 ? (EventHandler)this.getOrCreateObjectProps().get(6) : null;
    }

    @Override
    public void setLongClickHandler(@Nullable EventHandler<LongClickEvent> longClickHandler) {
        this.mPrivateFlags |= 0x10;
        this.mOtherFlags = longClickHandler == null ? (this.mOtherFlags &= 0xFFFFFFFB) : (this.mOtherFlags |= 4);
        this.getOrCreateObjectProps().append(8, longClickHandler);
    }

    @Override
    @Nullable
    public EventHandler<LongClickEvent> getLongClickHandler() {
        return (this.mOtherFlags & 4) != 0 ? (EventHandler)this.getOrCreateObjectProps().get(8) : null;
    }

    @Override
    public void setFocusChangeHandler(@Nullable EventHandler<FocusChangedEvent> focusChangedHandler) {
        this.mPrivateFlags |= 0x20000;
        this.mOtherFlags = focusChangedHandler == null ? (this.mOtherFlags &= 0xFFFFFFFE) : (this.mOtherFlags |= 1);
        this.getOrCreateObjectProps().append(7, focusChangedHandler);
    }

    @Override
    @Nullable
    public EventHandler<FocusChangedEvent> getFocusChangeHandler() {
        return this.hasFocusChangeHandler() ? (EventHandler)this.getOrCreateObjectProps().get(7) : null;
    }

    @Override
    public boolean hasFocusChangeHandler() {
        return (this.mOtherFlags & 1) != 0;
    }

    @Override
    public void setTouchHandler(@Nullable EventHandler<TouchEvent> touchHandler) {
        this.mPrivateFlags |= 0x20;
        this.mOtherFlags = touchHandler == null ? (this.mOtherFlags &= 0xFFFFFFF7) : (this.mOtherFlags |= 8);
        this.getOrCreateObjectProps().append(9, touchHandler);
    }

    @Override
    @Nullable
    public EventHandler<TouchEvent> getTouchHandler() {
        return (this.mOtherFlags & 8) != 0 ? (EventHandler)this.getOrCreateObjectProps().get(9) : null;
    }

    @Override
    public void setInterceptTouchHandler(@Nullable EventHandler<InterceptTouchEvent> interceptTouchHandler) {
        this.mPrivateFlags |= 0x40000;
        this.mOtherFlags = interceptTouchHandler == null ? (this.mOtherFlags &= 0xFFFFFFEF) : (this.mOtherFlags |= 0x10);
        this.getOrCreateObjectProps().append(10, interceptTouchHandler);
    }

    @Override
    @Nullable
    public EventHandler<InterceptTouchEvent> getInterceptTouchHandler() {
        return (this.mOtherFlags & 0x10) != 0 ? (EventHandler)this.getOrCreateObjectProps().get(10) : null;
    }

    @Override
    public boolean hasTouchEventHandlers() {
        return (this.mOtherFlags & 0x1E) != 0;
    }

    @Override
    public void setAccessibilityRole(@Nullable String role) {
        this.mPrivateFlags |= 0x400000;
        this.mOtherFlags = role == null ? (this.mOtherFlags &= 0xFFFFDFFF) : (this.mOtherFlags |= 0x2000);
        this.getOrCreateObjectProps().append(5, (Object)role);
    }

    @Override
    @Nullable
    public String getAccessibilityRole() {
        return (this.mOtherFlags & 0x2000) != 0 ? (String)this.getOrCreateObjectProps().get(5) : null;
    }

    @Override
    public void setAccessibilityRoleDescription(@Nullable CharSequence roleDescription) {
        this.mPrivateFlags |= 0x1000000;
        this.mOtherFlags = roleDescription == null ? (this.mOtherFlags &= 0xFFFFBFFF) : (this.mOtherFlags |= 0x4000);
        this.getOrCreateObjectProps().append(4, (Object)roleDescription);
    }

    @Override
    @Nullable
    public CharSequence getAccessibilityRoleDescription() {
        return (this.mOtherFlags & 0x4000) != 0 ? (CharSequence)this.getOrCreateObjectProps().get(4) : null;
    }

    @Override
    public void setDispatchPopulateAccessibilityEventHandler(@Nullable EventHandler<DispatchPopulateAccessibilityEventEvent> dispatchPopulateAccessibilityEventHandler) {
        this.mPrivateFlags |= 0x40;
        this.mOtherFlags = dispatchPopulateAccessibilityEventHandler == null ? (this.mOtherFlags &= 0xFFFFFBFF) : (this.mOtherFlags |= 0x400);
        this.getOrCreateObjectProps().append(11, dispatchPopulateAccessibilityEventHandler);
    }

    @Override
    @Nullable
    public EventHandler<DispatchPopulateAccessibilityEventEvent> getDispatchPopulateAccessibilityEventHandler() {
        return (this.mOtherFlags & 0x400) != 0 ? (EventHandler)this.getOrCreateObjectProps().get(11) : null;
    }

    @Override
    public void setOnInitializeAccessibilityEventHandler(@Nullable EventHandler<OnInitializeAccessibilityEventEvent> onInitializeAccessibilityEventHandler) {
        this.mPrivateFlags |= 0x80;
        this.mOtherFlags = onInitializeAccessibilityEventHandler == null ? (this.mOtherFlags &= 0xFFFFFFDF) : (this.mOtherFlags |= 0x20);
        this.getOrCreateObjectProps().append(12, onInitializeAccessibilityEventHandler);
    }

    @Override
    @Nullable
    public EventHandler<OnInitializeAccessibilityEventEvent> getOnInitializeAccessibilityEventHandler() {
        return (this.mOtherFlags & 0x20) != 0 ? (EventHandler)this.getOrCreateObjectProps().get(12) : null;
    }

    @Override
    public void setOnInitializeAccessibilityNodeInfoHandler(@Nullable EventHandler<OnInitializeAccessibilityNodeInfoEvent> onInitializeAccessibilityNodeInfoHandler) {
        this.mPrivateFlags |= 0x100;
        this.mOtherFlags = onInitializeAccessibilityNodeInfoHandler == null ? (this.mOtherFlags &= 0xFFFFFFBF) : (this.mOtherFlags |= 0x40);
        this.getOrCreateObjectProps().append(14, onInitializeAccessibilityNodeInfoHandler);
    }

    @Override
    @Nullable
    public EventHandler<OnInitializeAccessibilityNodeInfoEvent> getOnInitializeAccessibilityNodeInfoHandler() {
        return (this.mOtherFlags & 0x40) != 0 ? (EventHandler)this.getOrCreateObjectProps().get(14) : null;
    }

    @Override
    public void setOnPopulateAccessibilityEventHandler(@Nullable EventHandler<OnPopulateAccessibilityEventEvent> onPopulateAccessibilityEventHandler) {
        this.mPrivateFlags |= 0x200;
        this.mOtherFlags = onPopulateAccessibilityEventHandler == null ? (this.mOtherFlags &= 0xFFFFFF7F) : (this.mOtherFlags |= 0x80);
        this.getOrCreateObjectProps().append(13, onPopulateAccessibilityEventHandler);
    }

    @Override
    @Nullable
    public EventHandler<OnPopulateAccessibilityEventEvent> getOnPopulateAccessibilityEventHandler() {
        return (this.mOtherFlags & 0x80) != 0 ? (EventHandler)this.getOrCreateObjectProps().get(13) : null;
    }

    @Override
    public void setOnRequestSendAccessibilityEventHandler(@Nullable EventHandler<OnRequestSendAccessibilityEventEvent> onRequestSendAccessibilityEventHandler) {
        this.mPrivateFlags |= 0x400;
        this.mOtherFlags = onRequestSendAccessibilityEventHandler == null ? (this.mOtherFlags &= 0xFFFFFEFF) : (this.mOtherFlags |= 0x100);
        this.getOrCreateObjectProps().append(15, onRequestSendAccessibilityEventHandler);
    }

    @Override
    @Nullable
    public EventHandler<OnRequestSendAccessibilityEventEvent> getOnRequestSendAccessibilityEventHandler() {
        return (this.mOtherFlags & 0x100) != 0 ? (EventHandler)this.getOrCreateObjectProps().get(15) : null;
    }

    @Override
    public void setPerformAccessibilityActionHandler(@Nullable EventHandler<PerformAccessibilityActionEvent> performAccessibilityActionHandler) {
        this.mPrivateFlags |= 0x800;
        this.mOtherFlags = performAccessibilityActionHandler == null ? (this.mOtherFlags &= 0xFFFFFDFF) : (this.mOtherFlags |= 0x200);
        this.getOrCreateObjectProps().append(16, performAccessibilityActionHandler);
    }

    @Override
    @Nullable
    public EventHandler<PerformAccessibilityActionEvent> getPerformAccessibilityActionHandler() {
        return (this.mOtherFlags & 0x200) != 0 ? (EventHandler)this.getOrCreateObjectProps().get(16) : null;
    }

    @Override
    public void setSendAccessibilityEventHandler(@Nullable EventHandler<SendAccessibilityEventEvent> sendAccessibilityEventHandler) {
        this.mPrivateFlags |= 0x1000;
        this.mOtherFlags = sendAccessibilityEventHandler == null ? (this.mOtherFlags &= 0xFFFFF7FF) : (this.mOtherFlags |= 0x800);
        this.getOrCreateObjectProps().append(17, sendAccessibilityEventHandler);
    }

    @Override
    @Nullable
    public EventHandler<SendAccessibilityEventEvent> getSendAccessibilityEventHandler() {
        return (this.mOtherFlags & 0x800) != 0 ? (EventHandler)this.getOrCreateObjectProps().get(17) : null;
    }

    @Override
    public void setSendAccessibilityEventUncheckedHandler(@Nullable EventHandler<SendAccessibilityEventUncheckedEvent> sendAccessibilityEventUncheckedHandler) {
        this.mPrivateFlags |= 0x2000;
        this.mOtherFlags = sendAccessibilityEventUncheckedHandler == null ? (this.mOtherFlags &= 0xFFFFEFFF) : (this.mOtherFlags |= 0x1000);
        this.getOrCreateObjectProps().append(18, sendAccessibilityEventUncheckedHandler);
    }

    @Override
    @Nullable
    public EventHandler<SendAccessibilityEventUncheckedEvent> getSendAccessibilityEventUncheckedHandler() {
        return (this.mOtherFlags & 0x1000) != 0 ? (EventHandler)this.getOrCreateObjectProps().get(18) : null;
    }

    @Override
    public boolean needsAccessibilityDelegate() {
        return (this.mOtherFlags & 0x7FE0) != 0;
    }

    @Override
    public void setFocusable(boolean isFocusable) {
        this.mFocusState = isFocusable ? 1 : 2;
    }

    @Override
    public int getFocusState() {
        return this.mFocusState;
    }

    @Override
    public void setClickable(boolean isClickable) {
        this.mClickableState = isClickable ? 1 : 2;
    }

    @Override
    public int getClickableState() {
        return this.mClickableState;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.mEnabledState = isEnabled ? 1 : 2;
    }

    @Override
    public int getEnabledState() {
        return this.mEnabledState;
    }

    @Override
    public void setSelected(boolean isSelected) {
        this.mSelectedState = isSelected ? 1 : 2;
    }

    @Override
    public int getSelectedState() {
        return this.mSelectedState;
    }

    @Override
    public float getScale() {
        return this.mScale;
    }

    @Override
    public void setScale(float scale) {
        this.mScale = scale;
        this.mPrivateFlags |= 0x80000;
    }

    @Override
    public boolean isScaleSet() {
        return (this.mPrivateFlags & 0x80000) != 0;
    }

    @Override
    public float getAlpha() {
        return this.mAlpha;
    }

    @Override
    public void setAlpha(float alpha) {
        this.mAlpha = alpha;
        this.mPrivateFlags |= 0x100000;
    }

    @Override
    public boolean isAlphaSet() {
        return (this.mPrivateFlags & 0x100000) != 0;
    }

    @Override
    public float getRotation() {
        return this.mRotation;
    }

    @Override
    public void setRotation(float rotation) {
        this.mRotation = rotation;
        this.mPrivateFlags |= 0x200000;
    }

    @Override
    public boolean isRotationSet() {
        return (this.mPrivateFlags & 0x200000) != 0;
    }

    @Override
    public float getRotationX() {
        return this.mRotationX;
    }

    @Override
    public void setRotationX(float rotationX) {
        this.mRotationX = rotationX;
        this.mPrivateFlags |= 0x2000000;
    }

    @Override
    public boolean isRotationXSet() {
        return (this.mPrivateFlags & 0x2000000) != 0;
    }

    @Override
    public float getRotationY() {
        return this.mRotationY;
    }

    @Override
    public void setRotationY(float rotationY) {
        this.mRotationY = rotationY;
        this.mPrivateFlags |= 0x4000000;
    }

    @Override
    public boolean isRotationYSet() {
        return (this.mPrivateFlags & 0x4000000) != 0;
    }

    @Override
    public boolean isEquivalentTo(@Nullable NodeInfo other) {
        return NodeInfoUtils.isEquivalentTo(this, other);
    }

    @Override
    public void copyInto(NodeInfo target) {
        if ((this.mPrivateFlags & 8) != 0) {
            target.setClickHandler(this.getClickHandler());
        }
        if ((this.mPrivateFlags & 0x10) != 0) {
            target.setLongClickHandler(this.getLongClickHandler());
        }
        if ((this.mPrivateFlags & 0x20000) != 0) {
            target.setFocusChangeHandler(this.getFocusChangeHandler());
        }
        if ((this.mPrivateFlags & 0x20) != 0) {
            target.setTouchHandler(this.getTouchHandler());
        }
        if ((this.mPrivateFlags & 0x40000) != 0) {
            target.setInterceptTouchHandler(this.getInterceptTouchHandler());
        }
        if ((this.mPrivateFlags & 0x400000) != 0) {
            target.setAccessibilityRole(this.getAccessibilityRole());
        }
        if ((this.mPrivateFlags & 0x1000000) != 0) {
            target.setAccessibilityRoleDescription(this.getAccessibilityRoleDescription());
        }
        if ((this.mPrivateFlags & 0x40) != 0) {
            target.setDispatchPopulateAccessibilityEventHandler(this.getDispatchPopulateAccessibilityEventHandler());
        }
        if ((this.mPrivateFlags & 0x80) != 0) {
            target.setOnInitializeAccessibilityEventHandler(this.getOnInitializeAccessibilityEventHandler());
        }
        if ((this.mPrivateFlags & 0x100) != 0) {
            target.setOnInitializeAccessibilityNodeInfoHandler(this.getOnInitializeAccessibilityNodeInfoHandler());
        }
        if ((this.mPrivateFlags & 0x200) != 0) {
            target.setOnPopulateAccessibilityEventHandler(this.getOnPopulateAccessibilityEventHandler());
        }
        if ((this.mPrivateFlags & 0x400) != 0) {
            target.setOnRequestSendAccessibilityEventHandler(this.getOnRequestSendAccessibilityEventHandler());
        }
        if ((this.mPrivateFlags & 0x800) != 0) {
            target.setPerformAccessibilityActionHandler(this.getPerformAccessibilityActionHandler());
        }
        if ((this.mPrivateFlags & 0x1000) != 0) {
            target.setSendAccessibilityEventHandler(this.getSendAccessibilityEventHandler());
        }
        if ((this.mPrivateFlags & 0x2000) != 0) {
            target.setSendAccessibilityEventUncheckedHandler(this.getSendAccessibilityEventUncheckedHandler());
        }
        if ((this.mPrivateFlags & 1) != 0) {
            target.setContentDescription(this.getContentDescription());
        }
        if ((this.mPrivateFlags & 0x4000) != 0) {
            target.setShadowElevation(this.mShadowElevation);
        }
        if ((this.mPrivateFlags & 0x8000) != 0) {
            target.setOutlineProvider(this.getOutlineProvider());
        }
        if ((this.mPrivateFlags & 0x10000) != 0) {
            target.setClipToOutline(this.mClipToOutline);
        }
        if ((this.mPrivateFlags & 0x800000) != 0) {
            target.setClipChildren(this.mClipChildren);
        }
        if ((this.mPrivateFlags & 2) != 0) {
            target.setViewTag(this.getViewTag());
        }
        if ((this.mPrivateFlags & 4) != 0) {
            target.setViewTags(this.getViewTags());
        }
        if (this.getFocusState() != 0) {
            target.setFocusable(this.getFocusState() == 1);
        }
        if (this.getEnabledState() != 0) {
            target.setEnabled(this.getEnabledState() == 1);
        }
        if (this.getSelectedState() != 0) {
            target.setSelected(this.getSelectedState() == 1);
        }
        if ((this.mPrivateFlags & 0x80000) != 0) {
            target.setScale(this.mScale);
        }
        if ((this.mPrivateFlags & 0x100000) != 0) {
            target.setAlpha(this.mAlpha);
        }
        if ((this.mPrivateFlags & 0x200000) != 0) {
            target.setRotation(this.mRotation);
        }
        if ((this.mPrivateFlags & 0x2000000) != 0) {
            target.setRotationX(this.mRotationX);
        }
        if ((this.mPrivateFlags & 0x4000000) != 0) {
            target.setRotationY(this.mRotationY);
        }
    }

    @Override
    public int getFlags() {
        return this.mPrivateFlags;
    }

    private SparseArray<Object> getOrCreateObjectProps() {
        if (this.mObjectProps == null) {
            this.mObjectProps = new SparseArray(2);
        }
        return this.mObjectProps;
    }
}

