/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.animation.StateListAnimator;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.ViewOutlineProvider;
import androidx.annotation.AttrRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.StyleRes;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.litho.Border;
import com.facebook.litho.ClickEvent;
import com.facebook.litho.CommonProps;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.DefaultNodeInfo;
import com.facebook.litho.DispatchPopulateAccessibilityEventEvent;
import com.facebook.litho.Edges;
import com.facebook.litho.EventHandler;
import com.facebook.litho.FocusChangedEvent;
import com.facebook.litho.FocusedVisibleEvent;
import com.facebook.litho.FullImpressionVisibleEvent;
import com.facebook.litho.InterceptTouchEvent;
import com.facebook.litho.InternalNode;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.LongClickEvent;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.OnInitializeAccessibilityEventEvent;
import com.facebook.litho.OnInitializeAccessibilityNodeInfoEvent;
import com.facebook.litho.OnPopulateAccessibilityEventEvent;
import com.facebook.litho.OnRequestSendAccessibilityEventEvent;
import com.facebook.litho.PerformAccessibilityActionEvent;
import com.facebook.litho.SendAccessibilityEventEvent;
import com.facebook.litho.SendAccessibilityEventUncheckedEvent;
import com.facebook.litho.SparseNodeInfo;
import com.facebook.litho.TouchEvent;
import com.facebook.litho.Transition;
import com.facebook.litho.UnfocusedVisibleEvent;
import com.facebook.litho.VisibilityChangedEvent;
import com.facebook.litho.VisibleEvent;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.drawable.ComparableDrawable;
import com.facebook.litho.internal.SparseFloatArray;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaConstants;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaPositionType;
import java.util.ArrayList;
import java.util.List;

@ThreadConfined(value="ANY")
class SparseCommonPropsHolder
implements CommonProps {
    private static final long PFLAG_LAYOUT_DIRECTION_IS_SET = 1L;
    private static final long PFLAG_ALIGN_SELF_IS_SET = 2L;
    private static final long PFLAG_FLEX_IS_SET = 4L;
    private static final long PFLAG_FLEX_GROW_IS_SET = 8L;
    private static final long PFLAG_FLEX_SHRINK_IS_SET = 16L;
    private static final long PFLAG_FLEX_BASIS_IS_SET = 32L;
    private static final long PFLAG_IMPORTANT_FOR_ACCESSIBILITY_IS_SET = 64L;
    private static final long PFLAG_DUPLICATE_PARENT_STATE_IS_SET = 128L;
    private static final long PFLAG_MARGIN_IS_SET = 256L;
    private static final long PFLAG_PADDING_IS_SET = 512L;
    private static final long PFLAG_POSITION_PERCENT_IS_SET = 1024L;
    private static final long PFLAG_MIN_WIDTH_IS_SET = 2048L;
    private static final long PFLAG_MAX_WIDTH_IS_SET = 4096L;
    private static final long PFLAG_MIN_HEIGHT_IS_SET = 8192L;
    private static final long PFLAG_MAX_HEIGHT_IS_SET = 16384L;
    private static final long PFLAG_FOREGROUND_IS_SET = 32768L;
    private static final long PFLAG_VISIBLE_HANDLER_IS_SET = 65536L;
    private static final long PFLAG_FOCUSED_HANDLER_IS_SET = 131072L;
    private static final long PFLAG_FULL_IMPRESSION_HANDLER_IS_SET = 262144L;
    private static final long PFLAG_INVISIBLE_HANDLER_IS_SET = 524288L;
    private static final long PFLAG_UNFOCUSED_HANDLER_IS_SET = 0x100000L;
    private static final long PFLAG_TOUCH_EXPANSION_IS_SET = 0x200000L;
    private static final long PFLAG_ASPECT_RATIO_IS_SET = 0x400000L;
    private static final long PFLAG_TRANSITION_KEY_IS_SET = 0x800000L;
    private static final long PFLAG_WRAP_IN_VIEW_IS_SET = 0x1000000L;
    private static final long PFLAG_VISIBLE_HEIGHT_RATIO_IS_SET = 0x2000000L;
    private static final long PFLAG_VISIBLE_WIDTH_RATIO_IS_SET = 0x4000000L;
    private static final long PFLAG_FLEX_BASIS_PERCENT_IS_SET = 0x8000000L;
    private static final long PFLAG_MARGIN_PERCENT_IS_SET = 0x10000000L;
    private static final long PFLAG_MARGIN_AUTO_IS_SET = 0x20000000L;
    private static final long PFLAG_PADDING_PERCENT_IS_SET = 0x40000000L;
    private static final long PFLAG_WIDTH_PERCENT_IS_SET = 0x80000000L;
    private static final long PFLAG_MIN_WIDTH_PERCENT_IS_SET = 0x100000000L;
    private static final long PFLAG_MAX_WIDTH_PERCENT_IS_SET = 0x200000000L;
    private static final long PFLAG_HEIGHT_PERCENT_IS_SET = 0x400000000L;
    private static final long PFLAG_MIN_HEIGHT_PERCENT_IS_SET = 0x800000000L;
    private static final long PFLAG_MAX_HEIGHT_PERCENT_IS_SET = 0x1000000000L;
    private static final long PFLAG_BORDER_IS_SET = 0x2000000000L;
    private static final long PFLAG_STATE_LIST_ANIMATOR_IS_SET = 0x4000000000L;
    private static final long PFLAG_STATE_LIST_ANIMATOR_RES_IS_SET = 0x8000000000L;
    private static final long PFLAG_VISIBILITY_CHANGED_HANDLER_IS_SET = 0x10000000000L;
    private static final long PFLAG_TRANSITION_KEY_TYPE_IS_SET = 0x20000000000L;
    private static final long PFLAG_USE_HEIGHT_AS_BASELINE_IS_SET = 0x40000000000L;
    private static final long PFLAG_IS_REFERENCE_BASELINE_IS_SET = 0x80000000000L;
    private static final long PFLAG_POSITION_TYPE_IS_SET = 0x100000000000L;
    private static final long PFLAG_POSITION_IS_SET = 0x200000000000L;
    private static final long PFLAG_WIDTH_IS_SET = 0x400000000000L;
    private static final long PFLAG_HEIGHT_IS_SET = 0x800000000000L;
    private static final long PFLAG_BACKGROUND_IS_SET = 0x1000000000000L;
    private static final long PFLAG_TEST_KEY_IS_SET = 0x2000000000000L;
    private static final int INDEX_VisibleHandler = 0;
    private static final int INDEX_FocusedHandler = 1;
    private static final int INDEX_UnfocusedHandler = 2;
    private static final int INDEX_FullImpressionHandler = 3;
    private static final int INDEX_InvisibleHandler = 4;
    private static final int INDEX_VisibilityChangedHandler = 5;
    private static final int INDEX_LayoutDirection = 6;
    private static final int INDEX_AlignSelf = 7;
    private static final int INDEX_Margins = 8;
    private static final int INDEX_MarginPercents = 9;
    private static final int INDEX_MarginAutos = 10;
    private static final int INDEX_Paddings = 11;
    private static final int INDEX_PaddingPercents = 12;
    private static final int INDEX_PositionPercents = 13;
    private static final int INDEX_TouchExpansions = 14;
    private static final int INDEX_Foreground = 15;
    private static final int INDEX_TransitionKey = 16;
    private static final int INDEX_TransitionKeyType = 17;
    private static final int INDEX_Border = 18;
    private static final int INDEX_StateListAnimator = 19;
    private static final int INDEX_PositionType = 20;
    private static final int INDEX_Positions = 21;
    private static final int INDEX_Background = 22;
    private static final int INDEX_TestKey = 23;
    private static final int INDEX_WidthPx = 0;
    private static final int INDEX_HeightPx = 1;
    private static final int INDEX_ImportantForAccessibility = 2;
    private static final int INDEX_FlexBasisPx = 3;
    private static final int INDEX_MinWidthPx = 4;
    private static final int INDEX_MaxWidthPx = 5;
    private static final int INDEX_MinHeightPx = 6;
    private static final int INDEX_MaxHeightPx = 7;
    private static final int INDEX_DefStyleAttr = 8;
    private static final int INDEX_DefStyleRes = 9;
    private static final int INDEX_StateListAnimatorRes = 10;
    private static final int INDEX_VisibleHeightRatio = 0;
    private static final int INDEX_VisibleWidthRatio = 1;
    private static final int INDEX_Flex = 2;
    private static final int INDEX_FlexGrow = 3;
    private static final int INDEX_FlexShrink = 4;
    private static final int INDEX_FlexBasisPercent = 5;
    private static final int INDEX_WidthPercent = 6;
    private static final int INDEX_MinWidthPercent = 7;
    private static final int INDEX_MaxWidthPercent = 8;
    private static final int INDEX_HeightPercentage = 9;
    private static final int INDEX_MinHeightPercent = 10;
    private static final int INDEX_MaxHeightPercent = 11;
    private static final int INDEX_AspectRatio = 12;
    private long mPrivateFlags;
    @Nullable
    private NodeInfo mNodeInfo;
    @Nullable
    SparseArray<Object> mObjectProps;
    @Nullable
    SparseIntArray mIntProps;
    @Nullable
    SparseFloatArray mFloatProps;
    private boolean mDuplicateParentState;
    private boolean mIsReferenceBaseline;
    private boolean mUseHeightAsBaseline;

    SparseCommonPropsHolder() {
    }

    @Override
    public void layoutDirection(@Nullable YogaDirection direction) {
        this.mPrivateFlags |= 1L;
        this.getOrCreateObjectProps().append(6, (Object)direction);
    }

    @Override
    public void alignSelf(@Nullable YogaAlign alignSelf) {
        this.mPrivateFlags |= 2L;
        this.getOrCreateObjectProps().append(7, (Object)alignSelf);
    }

    @Override
    public void flex(float flex) {
        this.mPrivateFlags |= 4L;
        this.getOrCreateFloatProps().append(2, flex);
    }

    @Override
    public void flexGrow(float flexGrow) {
        this.mPrivateFlags |= 8L;
        this.getOrCreateFloatProps().append(3, flexGrow);
    }

    @Override
    public void flexShrink(float flexShrink) {
        this.mPrivateFlags |= 0x10L;
        this.getOrCreateFloatProps().append(4, flexShrink);
    }

    @Override
    public void flexBasisPx(@Px int flexBasis) {
        this.mPrivateFlags |= 0x20L;
        this.getOrCreateIntProps().append(3, flexBasis);
    }

    @Override
    public void flexBasisPercent(float percent) {
        this.mPrivateFlags |= 0x8000000L;
        this.getOrCreateFloatProps().append(5, percent);
    }

    @Override
    public void importantForAccessibility(int importantForAccessibility) {
        this.mPrivateFlags |= 0x40L;
        this.getOrCreateIntProps().append(2, importantForAccessibility);
    }

    @Override
    public void duplicateParentState(boolean duplicateParentState) {
        this.mPrivateFlags |= 0x80L;
        this.mDuplicateParentState = duplicateParentState;
    }

    @Override
    public void marginPx(YogaEdge edge, @Px int margin) {
        this.mPrivateFlags |= 0x100L;
        Edges mMargins = (Edges)this.getOrCreateObjectProps().get(8);
        if (mMargins == null) {
            mMargins = new Edges();
            this.getOrCreateObjectProps().append(8, (Object)mMargins);
        }
        mMargins.set(edge, margin);
    }

    @Override
    public void marginPercent(YogaEdge edge, float percent) {
        this.mPrivateFlags |= 0x10000000L;
        Edges mMarginPercents = (Edges)this.getOrCreateObjectProps().get(9);
        if (mMarginPercents == null) {
            mMarginPercents = new Edges();
            this.getOrCreateObjectProps().append(9, (Object)mMarginPercents);
        }
        mMarginPercents.set(edge, percent);
    }

    @Override
    public void marginAuto(YogaEdge edge) {
        this.mPrivateFlags |= 0x20000000L;
        ArrayList<YogaEdge> mMarginAutos = (ArrayList<YogaEdge>)this.getOrCreateObjectProps().get(10);
        if (mMarginAutos == null) {
            mMarginAutos = new ArrayList<YogaEdge>(2);
            this.getOrCreateObjectProps().append(10, mMarginAutos);
        }
        mMarginAutos.add(edge);
    }

    @Override
    public void paddingPx(YogaEdge edge, @Px int padding) {
        this.mPrivateFlags |= 0x200L;
        Edges mPaddings = (Edges)this.getOrCreateObjectProps().get(11);
        if (mPaddings == null) {
            mPaddings = new Edges();
            this.getOrCreateObjectProps().append(11, (Object)mPaddings);
        }
        mPaddings.set(edge, padding);
    }

    @Override
    public void paddingPercent(YogaEdge edge, float percent) {
        this.mPrivateFlags |= 0x40000000L;
        Edges mPaddingPercents = (Edges)this.getOrCreateObjectProps().get(12);
        if (mPaddingPercents == null) {
            mPaddingPercents = new Edges();
            this.getOrCreateObjectProps().append(12, (Object)mPaddingPercents);
        }
        mPaddingPercents.set(edge, percent);
    }

    @Override
    public void border(@Nullable Border border) {
        if (border != null) {
            this.mPrivateFlags |= 0x2000000000L;
            this.getOrCreateObjectProps().append(18, (Object)border);
        }
    }

    @Override
    public void positionPercent(YogaEdge edge, float percent) {
        this.mPrivateFlags |= 0x400L;
        Edges mPositionPercents = (Edges)this.getOrCreateObjectProps().get(13);
        if (mPositionPercents == null) {
            mPositionPercents = new Edges();
            this.getOrCreateObjectProps().append(13, (Object)mPositionPercents);
        }
        mPositionPercents.set(edge, percent);
    }

    @Override
    public void widthPercent(float percent) {
        this.mPrivateFlags |= 0x80000000L;
        this.getOrCreateFloatProps().append(6, percent);
    }

    @Override
    public void minWidthPx(@Px int minWidth) {
        this.mPrivateFlags |= 0x800L;
        this.getOrCreateIntProps().append(4, minWidth);
    }

    @Override
    public void minWidthPercent(float percent) {
        this.mPrivateFlags |= 0x100000000L;
        this.getOrCreateFloatProps().append(7, percent);
    }

    @Override
    public void maxWidthPx(@Px int maxWidth) {
        this.mPrivateFlags |= 0x1000L;
        this.getOrCreateIntProps().append(5, maxWidth);
    }

    @Override
    public void maxWidthPercent(float percent) {
        this.mPrivateFlags |= 0x200000000L;
        this.getOrCreateFloatProps().append(8, percent);
    }

    @Override
    public void heightPercent(float percent) {
        this.mPrivateFlags |= 0x400000000L;
        this.getOrCreateFloatProps().append(9, percent);
    }

    @Override
    public void minHeightPx(@Px int minHeight) {
        this.mPrivateFlags |= 0x2000L;
        this.getOrCreateIntProps().append(6, minHeight);
    }

    @Override
    public void minHeightPercent(float percent) {
        this.mPrivateFlags |= 0x800000000L;
        this.getOrCreateFloatProps().append(10, percent);
    }

    @Override
    public void maxHeightPx(@Px int maxHeight) {
        this.mPrivateFlags |= 0x4000L;
        this.getOrCreateIntProps().append(7, maxHeight);
    }

    @Override
    public void maxHeightPercent(float percent) {
        this.mPrivateFlags |= 0x1000000000L;
        this.getOrCreateFloatProps().append(11, percent);
    }

    @Override
    public void aspectRatio(float aspectRatio) {
        this.mPrivateFlags |= 0x400000L;
        this.getOrCreateFloatProps().append(12, aspectRatio);
    }

    @Override
    public void isReferenceBaseline(boolean isReferenceBaseline) {
        this.mPrivateFlags |= 0x80000000000L;
        this.mIsReferenceBaseline = isReferenceBaseline;
    }

    @Override
    public void touchExpansionPx(YogaEdge edge, @Px int touchExpansion) {
        this.mPrivateFlags |= 0x200000L;
        Edges mTouchExpansions = (Edges)this.getOrCreateObjectProps().get(14);
        if (mTouchExpansions == null) {
            mTouchExpansions = new Edges();
            this.getOrCreateObjectProps().append(14, (Object)mTouchExpansions);
        }
        mTouchExpansions.set(edge, touchExpansion);
    }

    @Override
    public void foreground(@Nullable ComparableDrawable foreground) {
        this.mPrivateFlags |= 0x8000L;
        this.getOrCreateObjectProps().append(15, (Object)foreground);
    }

    @Override
    public void visibleHeightRatio(float visibleHeightRatio) {
        this.mPrivateFlags |= 0x2000000L;
        this.getOrCreateFloatProps().append(0, visibleHeightRatio);
    }

    @Override
    public void visibleWidthRatio(float visibleWidthRatio) {
        this.mPrivateFlags |= 0x4000000L;
        this.getOrCreateFloatProps().append(1, visibleWidthRatio);
    }

    @Override
    public void visibleHandler(@Nullable EventHandler<VisibleEvent> visibleHandler) {
        this.mPrivateFlags |= 0x10000L;
        this.getOrCreateObjectProps().append(0, visibleHandler);
    }

    @Override
    public void focusedHandler(@Nullable EventHandler<FocusedVisibleEvent> focusedHandler) {
        this.mPrivateFlags |= 0x20000L;
        this.getOrCreateObjectProps().append(1, focusedHandler);
    }

    @Override
    public void unfocusedHandler(@Nullable EventHandler<UnfocusedVisibleEvent> unfocusedHandler) {
        this.mPrivateFlags |= 0x100000L;
        this.getOrCreateObjectProps().append(2, unfocusedHandler);
    }

    @Override
    public void fullImpressionHandler(@Nullable EventHandler<FullImpressionVisibleEvent> fullImpressionHandler) {
        this.mPrivateFlags |= 0x40000L;
        this.getOrCreateObjectProps().append(3, fullImpressionHandler);
    }

    @Override
    public void invisibleHandler(@Nullable EventHandler<InvisibleEvent> invisibleHandler) {
        this.mPrivateFlags |= 0x80000L;
        this.getOrCreateObjectProps().append(4, invisibleHandler);
    }

    @Override
    public void visibilityChangedHandler(@Nullable EventHandler<VisibilityChangedEvent> visibilityChangedHandler) {
        this.mPrivateFlags |= 0x10000000000L;
        this.getOrCreateObjectProps().append(5, visibilityChangedHandler);
    }

    @Override
    public void transitionKey(@Nullable String key) {
        this.mPrivateFlags |= 0x800000L;
        this.getOrCreateObjectProps().append(16, (Object)key);
    }

    @Override
    public void transitionKeyType(@Nullable Transition.TransitionKeyType type) {
        this.mPrivateFlags |= 0x20000000000L;
        this.getOrCreateObjectProps().append(17, (Object)type);
    }

    @Override
    @Nullable
    public Transition.TransitionKeyType getTransitionKeyType() {
        return this.mObjectProps != null ? (Transition.TransitionKeyType)((Object)this.mObjectProps.get(17)) : null;
    }

    @Override
    public void stateListAnimator(@Nullable StateListAnimator stateListAnimator) {
        this.mPrivateFlags |= 0x4000000000L;
        this.getOrCreateObjectProps().append(19, (Object)stateListAnimator);
    }

    @Override
    public void stateListAnimatorRes(@DrawableRes int resId) {
        this.mPrivateFlags |= 0x8000000000L;
        this.getOrCreateIntProps().append(10, resId);
    }

    @Override
    public void useHeightAsBaseline(boolean useHeightAsBaseline) {
        this.mPrivateFlags |= 0x40000000000L;
        this.mUseHeightAsBaseline = useHeightAsBaseline;
    }

    @Override
    public void setStyle(@AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        this.getOrCreateIntProps().append(8, defStyleAttr);
        this.getOrCreateIntProps().append(9, defStyleRes);
    }

    @Override
    public void positionType(@Nullable YogaPositionType positionType) {
        this.mPrivateFlags |= 0x100000000000L;
        this.getOrCreateObjectProps().append(20, (Object)positionType);
    }

    @Override
    public void positionPx(YogaEdge edge, @Px int position) {
        this.mPrivateFlags |= 0x200000000000L;
        Edges mPositions = (Edges)this.getOrCreateObjectProps().get(21);
        if (mPositions == null) {
            mPositions = new Edges();
            this.getOrCreateObjectProps().append(21, (Object)mPositions);
        }
        mPositions.set(edge, position);
    }

    @Override
    public void widthPx(@Px int width) {
        this.mPrivateFlags |= 0x400000000000L;
        this.getOrCreateIntProps().append(0, width);
    }

    @Override
    public void heightPx(@Px int height) {
        this.mPrivateFlags |= 0x800000000000L;
        this.getOrCreateIntProps().append(1, height);
    }

    @Override
    public void background(ComparableDrawable background) {
        this.mPrivateFlags |= 0x1000000000000L;
        this.getOrCreateObjectProps().append(22, (Object)background);
    }

    @Override
    public void testKey(String testKey) {
        this.mPrivateFlags |= 0x2000000000000L;
        this.getOrCreateObjectProps().append(23, (Object)testKey);
    }

    @Override
    public void wrapInView() {
        this.mPrivateFlags |= 0x1000000L;
    }

    @Override
    @Nullable
    public ComparableDrawable getBackground() {
        return (ComparableDrawable)((Object)this.getOrCreateObjectProps().get(22));
    }

    @Override
    public void clickHandler(EventHandler<ClickEvent> clickHandler) {
        this.getOrCreateNodeInfo().setClickHandler(clickHandler);
    }

    @Override
    @Nullable
    public EventHandler<ClickEvent> getClickHandler() {
        return this.getOrCreateNodeInfo().getClickHandler();
    }

    @Override
    public void longClickHandler(EventHandler<LongClickEvent> longClickHandler) {
        this.getOrCreateNodeInfo().setLongClickHandler(longClickHandler);
    }

    @Override
    @Nullable
    public EventHandler<LongClickEvent> getLongClickHandler() {
        return this.getOrCreateNodeInfo().getLongClickHandler();
    }

    @Override
    public void focusChangeHandler(EventHandler<FocusChangedEvent> focusChangeHandler) {
        this.getOrCreateNodeInfo().setFocusChangeHandler(focusChangeHandler);
    }

    @Override
    @Nullable
    public EventHandler<FocusChangedEvent> getFocusChangeHandler() {
        return this.getOrCreateNodeInfo().getFocusChangeHandler();
    }

    @Override
    public void touchHandler(EventHandler<TouchEvent> touchHandler) {
        this.getOrCreateNodeInfo().setTouchHandler(touchHandler);
    }

    @Override
    @Nullable
    public EventHandler<TouchEvent> getTouchHandler() {
        return this.getOrCreateNodeInfo().getTouchHandler();
    }

    @Override
    public void interceptTouchHandler(EventHandler<InterceptTouchEvent> interceptTouchHandler) {
        this.getOrCreateNodeInfo().setInterceptTouchHandler(interceptTouchHandler);
    }

    @Override
    @Nullable
    public EventHandler<InterceptTouchEvent> getInterceptTouchHandler() {
        return this.getOrCreateNodeInfo().getInterceptTouchHandler();
    }

    @Override
    public void focusable(boolean isFocusable) {
        this.getOrCreateNodeInfo().setFocusable(isFocusable);
    }

    @Override
    public boolean getFocusable() {
        return this.getOrCreateNodeInfo().getFocusState() == 1;
    }

    @Override
    public void clickable(boolean isClickable) {
        this.getOrCreateNodeInfo().setClickable(isClickable);
    }

    @Override
    @Nullable
    public String getTransitionKey() {
        return this.mObjectProps != null ? (String)this.mObjectProps.get(16) : null;
    }

    @Override
    public void enabled(boolean isEnabled) {
        this.getOrCreateNodeInfo().setEnabled(isEnabled);
    }

    @Override
    public void selected(boolean isSelected) {
        this.getOrCreateNodeInfo().setSelected(isSelected);
    }

    @Override
    public void contentDescription(@Nullable CharSequence contentDescription) {
        this.getOrCreateNodeInfo().setContentDescription(contentDescription);
    }

    @Override
    public void viewTag(@Nullable Object viewTag) {
        this.getOrCreateNodeInfo().setViewTag(viewTag);
    }

    @Override
    public void viewTags(@Nullable SparseArray<Object> viewTags) {
        this.getOrCreateNodeInfo().setViewTags(viewTags);
    }

    @Override
    public void shadowElevationPx(float shadowElevation) {
        this.getOrCreateNodeInfo().setShadowElevation(shadowElevation);
    }

    @Override
    public void outlineProvider(@Nullable ViewOutlineProvider outlineProvider) {
        this.getOrCreateNodeInfo().setOutlineProvider(outlineProvider);
    }

    @Override
    public void clipToOutline(boolean clipToOutline) {
        this.getOrCreateNodeInfo().setClipToOutline(clipToOutline);
    }

    @Override
    public void clipChildren(boolean clipChildren) {
        this.getOrCreateNodeInfo().setClipChildren(clipChildren);
    }

    @Override
    public void accessibilityRole(@Nullable String role) {
        this.getOrCreateNodeInfo().setAccessibilityRole(role);
    }

    @Override
    public void accessibilityRoleDescription(@Nullable CharSequence roleDescription) {
        this.getOrCreateNodeInfo().setAccessibilityRoleDescription(roleDescription);
    }

    @Override
    public void dispatchPopulateAccessibilityEventHandler(@Nullable EventHandler<DispatchPopulateAccessibilityEventEvent> dispatchPopulateAccessibilityEventHandler) {
        this.getOrCreateNodeInfo().setDispatchPopulateAccessibilityEventHandler(dispatchPopulateAccessibilityEventHandler);
    }

    @Override
    public void onInitializeAccessibilityEventHandler(@Nullable EventHandler<OnInitializeAccessibilityEventEvent> onInitializeAccessibilityEventHandler) {
        this.getOrCreateNodeInfo().setOnInitializeAccessibilityEventHandler(onInitializeAccessibilityEventHandler);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoHandler(@Nullable EventHandler<OnInitializeAccessibilityNodeInfoEvent> onInitializeAccessibilityNodeInfoHandler) {
        this.getOrCreateNodeInfo().setOnInitializeAccessibilityNodeInfoHandler(onInitializeAccessibilityNodeInfoHandler);
    }

    @Override
    public void onPopulateAccessibilityEventHandler(@Nullable EventHandler<OnPopulateAccessibilityEventEvent> onPopulateAccessibilityEventHandler) {
        this.getOrCreateNodeInfo().setOnPopulateAccessibilityEventHandler(onPopulateAccessibilityEventHandler);
    }

    @Override
    public void onRequestSendAccessibilityEventHandler(@Nullable EventHandler<OnRequestSendAccessibilityEventEvent> onRequestSendAccessibilityEventHandler) {
        this.getOrCreateNodeInfo().setOnRequestSendAccessibilityEventHandler(onRequestSendAccessibilityEventHandler);
    }

    @Override
    public void performAccessibilityActionHandler(@Nullable EventHandler<PerformAccessibilityActionEvent> performAccessibilityActionHandler) {
        this.getOrCreateNodeInfo().setPerformAccessibilityActionHandler(performAccessibilityActionHandler);
    }

    @Override
    public void sendAccessibilityEventHandler(@Nullable EventHandler<SendAccessibilityEventEvent> sendAccessibilityEventHandler) {
        this.getOrCreateNodeInfo().setSendAccessibilityEventHandler(sendAccessibilityEventHandler);
    }

    @Override
    public void sendAccessibilityEventUncheckedHandler(@Nullable EventHandler<SendAccessibilityEventUncheckedEvent> sendAccessibilityEventUncheckedHandler) {
        this.getOrCreateNodeInfo().setSendAccessibilityEventUncheckedHandler(sendAccessibilityEventUncheckedHandler);
    }

    @Override
    public void scale(float scale) {
        this.getOrCreateNodeInfo().setScale(scale);
        this.wrapInView();
    }

    @Override
    public void alpha(float alpha) {
        this.getOrCreateNodeInfo().setAlpha(alpha);
        this.wrapInView();
    }

    @Override
    public void rotation(float rotation) {
        this.getOrCreateNodeInfo().setRotation(rotation);
        this.wrapInView();
    }

    @Override
    public void rotationX(float rotationX) {
        this.getOrCreateNodeInfo().setRotationX(rotationX);
        this.wrapInView();
    }

    @Override
    public void rotationY(float rotationY) {
        this.getOrCreateNodeInfo().setRotationY(rotationY);
        this.wrapInView();
    }

    @Override
    @Nullable
    public NodeInfo getNullableNodeInfo() {
        return this.mNodeInfo;
    }

    @Override
    public NodeInfo getOrCreateNodeInfo() {
        if (this.mNodeInfo == null) {
            this.mNodeInfo = ComponentsConfiguration.isSparseNodeInfoIsEnabled ? new SparseNodeInfo() : new DefaultNodeInfo();
        }
        return this.mNodeInfo;
    }

    @Override
    public void copyInto(ComponentContext c, InternalNode node) {
        float value;
        YogaEdge edge;
        int i;
        int length;
        if (node == ComponentContext.NULL_LAYOUT) {
            return;
        }
        if (this.mIntProps != null) {
            c.applyStyle(node, this.mIntProps.get(8), this.mIntProps.get(9));
        }
        if (this.mNodeInfo != null) {
            this.mNodeInfo.copyInto(node.getOrCreateNodeInfo());
        }
        if ((this.mPrivateFlags & 0x1000000000000L) != 0L) {
            node.background((ComparableDrawable)((Object)this.mObjectProps.get(22)));
        }
        if ((this.mPrivateFlags & 0x2000000000000L) != 0L) {
            node.testKey((String)this.mObjectProps.get(23));
        }
        if ((this.mPrivateFlags & 0x100000000000L) != 0L) {
            node.positionType((YogaPositionType)this.mObjectProps.get(20));
        }
        if ((this.mPrivateFlags & 0x200000000000L) != 0L) {
            Edges mPositions = (Edges)this.mObjectProps.get(21);
            length = YogaEdge.values().length;
            for (i = 0; i < length; ++i) {
                edge = YogaEdge.fromInt((int)i);
                value = mPositions.getRaw(edge);
                if (YogaConstants.isUndefined((float)value)) continue;
                node.positionPx(edge, (int)value);
            }
        }
        if ((this.mPrivateFlags & 0x400000000000L) != 0L) {
            node.widthPx(this.mIntProps.get(0));
        }
        if ((this.mPrivateFlags & 0x800000000000L) != 0L) {
            node.heightPx(this.mIntProps.get(1));
        }
        if ((this.mPrivateFlags & 1L) != 0L) {
            node.layoutDirection((YogaDirection)this.mObjectProps.get(6));
        }
        if ((this.mPrivateFlags & 0x40L) != 0L) {
            node.importantForAccessibility(this.mIntProps.get(2));
        }
        if ((this.mPrivateFlags & 0x80L) != 0L) {
            node.duplicateParentState(this.mDuplicateParentState);
        }
        if ((this.mPrivateFlags & 0x8000L) != 0L) {
            node.foreground((ComparableDrawable)((Object)this.mObjectProps.get(15)));
        }
        if ((this.mPrivateFlags & 0x1000000L) != 0L) {
            node.wrapInView();
        }
        if ((this.mPrivateFlags & 0x10000L) != 0L) {
            node.visibleHandler((EventHandler)this.mObjectProps.get(0));
        }
        if ((this.mPrivateFlags & 0x20000L) != 0L) {
            node.focusedHandler((EventHandler)this.mObjectProps.get(1));
        }
        if ((this.mPrivateFlags & 0x40000L) != 0L) {
            node.fullImpressionHandler((EventHandler)this.mObjectProps.get(3));
        }
        if ((this.mPrivateFlags & 0x80000L) != 0L) {
            node.invisibleHandler((EventHandler)this.mObjectProps.get(4));
        }
        if ((this.mPrivateFlags & 0x100000L) != 0L) {
            node.unfocusedHandler((EventHandler)this.mObjectProps.get(2));
        }
        if ((this.mPrivateFlags & 0x10000000000L) != 0L) {
            node.visibilityChangedHandler((EventHandler)this.mObjectProps.get(5));
        }
        if ((this.mPrivateFlags & 0x800000L) != 0L) {
            node.transitionKey((String)this.mObjectProps.get(16));
        }
        if ((this.mPrivateFlags & 0x20000000000L) != 0L) {
            node.transitionKeyType((Transition.TransitionKeyType)((Object)this.mObjectProps.get(17)));
        }
        if ((this.mPrivateFlags & 0x2000000L) != 0L) {
            node.visibleHeightRatio(this.mFloatProps.get(0));
        }
        if ((this.mPrivateFlags & 0x4000000L) != 0L) {
            node.visibleWidthRatio(this.mFloatProps.get(1));
        }
        if ((this.mPrivateFlags & 2L) != 0L) {
            node.alignSelf((YogaAlign)this.mObjectProps.get(7));
        }
        if ((this.mPrivateFlags & 0x400L) != 0L) {
            Edges mPositionPercents = (Edges)this.mObjectProps.get(13);
            length = YogaEdge.values().length;
            for (i = 0; i < length; ++i) {
                edge = YogaEdge.fromInt((int)i);
                value = mPositionPercents.getRaw(edge);
                if (YogaConstants.isUndefined((float)value)) continue;
                node.positionPercent(edge, value);
            }
        }
        if ((this.mPrivateFlags & 4L) != 0L) {
            node.flex(this.mFloatProps.get(2));
        }
        if ((this.mPrivateFlags & 8L) != 0L) {
            node.flexGrow(this.mFloatProps.get(3));
        }
        if ((this.mPrivateFlags & 0x10L) != 0L) {
            node.flexShrink(this.mFloatProps.get(4));
        }
        if ((this.mPrivateFlags & 0x20L) != 0L) {
            node.flexBasisPx(this.mIntProps.get(3));
        }
        if ((this.mPrivateFlags & 0x8000000L) != 0L) {
            node.flexBasisPercent(this.mFloatProps.get(5));
        }
        if ((this.mPrivateFlags & 0x80000000L) != 0L) {
            node.widthPercent(this.mFloatProps.get(6));
        }
        if ((this.mPrivateFlags & 0x800L) != 0L) {
            node.minWidthPx(this.mIntProps.get(4));
        }
        if ((this.mPrivateFlags & 0x100000000L) != 0L) {
            node.minWidthPercent(this.mFloatProps.get(7));
        }
        if ((this.mPrivateFlags & 0x1000L) != 0L) {
            node.maxWidthPx(this.mIntProps.get(5));
        }
        if ((this.mPrivateFlags & 0x200000000L) != 0L) {
            node.maxWidthPercent(this.mFloatProps.get(8));
        }
        if ((this.mPrivateFlags & 0x400000000L) != 0L) {
            node.heightPercent(this.mFloatProps.get(9));
        }
        if ((this.mPrivateFlags & 0x2000L) != 0L) {
            node.minHeightPx(this.mIntProps.get(6));
        }
        if ((this.mPrivateFlags & 0x800000000L) != 0L) {
            node.minHeightPercent(this.mFloatProps.get(10));
        }
        if ((this.mPrivateFlags & 0x4000L) != 0L) {
            node.maxHeightPx(this.mIntProps.get(7));
        }
        if ((this.mPrivateFlags & 0x1000000000L) != 0L) {
            node.maxHeightPercent(this.mFloatProps.get(11));
        }
        if ((this.mPrivateFlags & 0x400000L) != 0L) {
            node.aspectRatio(this.mFloatProps.get(12));
        }
        if ((this.mPrivateFlags & 0x80000000000L) != 0L) {
            node.isReferenceBaseline(this.mIsReferenceBaseline);
        }
        if ((this.mPrivateFlags & 0x100L) != 0L) {
            Edges mMargins = (Edges)this.mObjectProps.get(8);
            length = YogaEdge.values().length;
            for (i = 0; i < length; ++i) {
                edge = YogaEdge.fromInt((int)i);
                value = mMargins.getRaw(edge);
                if (YogaConstants.isUndefined((float)value)) continue;
                node.marginPx(edge, (int)value);
            }
        }
        if ((this.mPrivateFlags & 0x10000000L) != 0L) {
            Edges mMarginPercents = (Edges)this.mObjectProps.get(9);
            length = YogaEdge.values().length;
            for (i = 0; i < length; ++i) {
                edge = YogaEdge.fromInt((int)i);
                value = mMarginPercents.getRaw(edge);
                if (YogaConstants.isUndefined((float)value)) continue;
                node.marginPercent(edge, value);
            }
        }
        if ((this.mPrivateFlags & 0x20000000L) != 0L) {
            List mMarginAutos = (List)this.mObjectProps.get(10);
            for (YogaEdge edge2 : mMarginAutos) {
                node.marginAuto(edge2);
            }
        }
        if ((this.mPrivateFlags & 0x200L) != 0L) {
            Edges mPaddings = (Edges)this.mObjectProps.get(11);
            length = YogaEdge.values().length;
            for (int i2 = 0; i2 < length; ++i2) {
                edge = YogaEdge.fromInt((int)i2);
                value = mPaddings.getRaw(edge);
                if (YogaConstants.isUndefined((float)value)) continue;
                node.paddingPx(edge, (int)value);
            }
        }
        if ((this.mPrivateFlags & 0x40000000L) != 0L) {
            Edges mPaddingPercents = (Edges)this.mObjectProps.get(12);
            length = YogaEdge.values().length;
            for (int i3 = 0; i3 < length; ++i3) {
                edge = YogaEdge.fromInt((int)i3);
                value = mPaddingPercents.getRaw(edge);
                if (YogaConstants.isUndefined((float)value)) continue;
                node.paddingPercent(edge, value);
            }
        }
        if ((this.mPrivateFlags & 0x200000L) != 0L) {
            Edges mTouchExpansions = (Edges)this.mObjectProps.get(14);
            length = YogaEdge.values().length;
            for (int i4 = 0; i4 < length; ++i4) {
                edge = YogaEdge.fromInt((int)i4);
                value = mTouchExpansions.getRaw(edge);
                if (YogaConstants.isUndefined((float)value)) continue;
                node.touchExpansionPx(edge, (int)value);
            }
        }
        if ((this.mPrivateFlags & 0x2000000000L) != 0L) {
            node.border((Border)this.mObjectProps.get(18));
        }
        if ((this.mPrivateFlags & 0x4000000000L) != 0L) {
            node.stateListAnimator((StateListAnimator)this.mObjectProps.get(19));
        }
        if ((this.mPrivateFlags & 0x8000000000L) != 0L) {
            node.stateListAnimatorRes(this.mIntProps.get(10));
        }
        if ((this.mPrivateFlags & 0x40000000000L) != 0L) {
            node.useHeightAsBaseline(this.mUseHeightAsBaseline);
        }
    }

    SparseArray<Object> getOrCreateObjectProps() {
        if (this.mObjectProps == null) {
            this.mObjectProps = new SparseArray(2);
        }
        return this.mObjectProps;
    }

    SparseIntArray getOrCreateIntProps() {
        if (this.mIntProps == null) {
            this.mIntProps = new SparseIntArray(2);
        }
        return this.mIntProps;
    }

    SparseFloatArray getOrCreateFloatProps() {
        if (this.mFloatProps == null) {
            this.mFloatProps = new SparseFloatArray(2);
        }
        return this.mFloatProps;
    }
}

