/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import androidx.annotation.ArrayRes;
import androidx.annotation.AttrRes;
import androidx.annotation.BoolRes;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntegerRes;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.FastMath;
import com.facebook.litho.ResourceCache;

public class ResourceResolver {
    private Resources mResources;
    private Resources.Theme mTheme;
    private ResourceCache mResourceCache;
    private final int[] mAttrs = new int[1];

    public ResourceResolver(ComponentContext context) {
        this.init(context);
    }

    public void init(ComponentContext context) {
        this.mResources = context.getAndroidContext().getResources();
        this.mTheme = context.getAndroidContext().getTheme();
        this.mResourceCache = context.getResourceCache();
    }

    public int dipsToPixels(float dips) {
        float scale = this.mResources.getDisplayMetrics().density;
        return FastMath.round(dips * scale);
    }

    public int sipsToPixels(float dips) {
        float scale = this.mResources.getDisplayMetrics().scaledDensity;
        return FastMath.round(dips * scale);
    }

    @Nullable
    public String resolveStringRes(@StringRes int resId) {
        if (resId != 0) {
            String cached = (String)this.mResourceCache.get(resId);
            if (cached != null) {
                return cached;
            }
            String result = this.mResources.getString(resId);
            this.mResourceCache.put(resId, result);
            return result;
        }
        return null;
    }

    @Nullable
    public String resolveStringRes(@StringRes int resId, Object ... formatArgs) {
        return resId != 0 ? this.mResources.getString(resId, formatArgs) : null;
    }

    @Nullable
    public String[] resolveStringArrayRes(@ArrayRes int resId) {
        if (resId != 0) {
            String[] cached = (String[])this.mResourceCache.get(resId);
            if (cached != null) {
                return cached;
            }
            String[] result = this.mResources.getStringArray(resId);
            this.mResourceCache.put(resId, result);
            return result;
        }
        return null;
    }

    public int resolveIntRes(@IntegerRes int resId) {
        if (resId != 0) {
            Integer cached = (Integer)this.mResourceCache.get(resId);
            if (cached != null) {
                return cached;
            }
            int result = this.mResources.getInteger(resId);
            this.mResourceCache.put(resId, result);
            return result;
        }
        return 0;
    }

    @Nullable
    public final int[] resolveIntArrayRes(@ArrayRes int resId) {
        if (resId != 0) {
            int[] cached = (int[])this.mResourceCache.get(resId);
            if (cached != null) {
                return cached;
            }
            int[] result = this.mResources.getIntArray(resId);
            this.mResourceCache.put(resId, result);
            return result;
        }
        return null;
    }

    @Nullable
    public Integer[] resolveIntegerArrayRes(@ArrayRes int resId) {
        int[] resIds = this.resolveIntArrayRes(resId);
        if (resIds == null) {
            return null;
        }
        Integer[] result = new Integer[resIds.length];
        for (int i = 0; i < resIds.length; ++i) {
            result[i] = resIds[i];
        }
        return result;
    }

    public boolean resolveBoolRes(@BoolRes int resId) {
        if (resId != 0) {
            Boolean cached = (Boolean)this.mResourceCache.get(resId);
            if (cached != null) {
                return cached;
            }
            boolean result = this.mResources.getBoolean(resId);
            this.mResourceCache.put(resId, result);
            return result;
        }
        return false;
    }

    public int resolveColorRes(@ColorRes int resId) {
        if (resId != 0) {
            Integer cached = (Integer)this.mResourceCache.get(resId);
            if (cached != null) {
                return cached;
            }
            int result = this.mResources.getColor(resId);
            this.mResourceCache.put(resId, result);
            return result;
        }
        return 0;
    }

    public int resolveDimenSizeRes(@DimenRes int resId) {
        if (resId != 0) {
            Integer cached = (Integer)this.mResourceCache.get(resId);
            if (cached != null) {
                return cached;
            }
            int result = this.mResources.getDimensionPixelSize(resId);
            this.mResourceCache.put(resId, result);
            return result;
        }
        return 0;
    }

    public int resolveDimenOffsetRes(@DimenRes int resId) {
        if (resId != 0) {
            Integer cached = (Integer)this.mResourceCache.get(resId);
            if (cached != null) {
                return cached;
            }
            int result = this.mResources.getDimensionPixelOffset(resId);
            this.mResourceCache.put(resId, result);
            return result;
        }
        return 0;
    }

    public float resolveFloatRes(@DimenRes int resId) {
        if (resId != 0) {
            Float cached = (Float)this.mResourceCache.get(resId);
            if (cached != null) {
                return cached.floatValue();
            }
            float result = this.mResources.getDimension(resId);
            this.mResourceCache.put(resId, Float.valueOf(result));
            return result;
        }
        return 0.0f;
    }

    @Nullable
    public Drawable resolveDrawableRes(@DrawableRes int resId) {
        if (resId == 0) {
            return null;
        }
        return this.mResources.getDrawable(resId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolveStringAttr(@AttrRes int attrResId, @StringRes int defResId) {
        this.mAttrs[0] = attrResId;
        TypedArray a = this.mTheme.obtainStyledAttributes(this.mAttrs);
        try {
            String result = a.getString(0);
            if (result == null) {
                result = this.resolveStringRes(defResId);
            }
            String string = result;
            return string;
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String[] resolveStringArrayAttr(@AttrRes int attrResId, @ArrayRes int defResId) {
        this.mAttrs[0] = attrResId;
        TypedArray a = this.mTheme.obtainStyledAttributes(this.mAttrs);
        try {
            String[] stringArray = this.resolveStringArrayRes(a.getResourceId(0, defResId));
            return stringArray;
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int resolveIntAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
        this.mAttrs[0] = attrResId;
        TypedArray a = this.mTheme.obtainStyledAttributes(this.mAttrs);
        try {
            int n = a.getInt(0, this.resolveIntRes(defResId));
            return n;
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public int[] resolveIntArrayAttr(@AttrRes int attrResId, @ArrayRes int defResId) {
        this.mAttrs[0] = attrResId;
        TypedArray a = this.mTheme.obtainStyledAttributes(this.mAttrs);
        try {
            int[] nArray = this.resolveIntArrayRes(a.getResourceId(0, defResId));
            return nArray;
        }
        finally {
            a.recycle();
        }
    }

    @Nullable
    public Integer[] resolveIntegerArrayAttr(@AttrRes int attrResId, @ArrayRes int defResId) {
        int[] resIds = this.resolveIntArrayAttr(attrResId, defResId);
        if (resIds == null) {
            return null;
        }
        Integer[] result = new Integer[resIds.length];
        for (int i = 0; i < resIds.length; ++i) {
            result[i] = resIds[i];
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resolveBoolAttr(@AttrRes int attrResId, @BoolRes int defResId) {
        this.mAttrs[0] = attrResId;
        TypedArray a = this.mTheme.obtainStyledAttributes(this.mAttrs);
        try {
            boolean bl = a.getBoolean(0, this.resolveBoolRes(defResId));
            return bl;
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int resolveColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
        this.mAttrs[0] = attrResId;
        TypedArray a = this.mTheme.obtainStyledAttributes(this.mAttrs);
        try {
            int n = a.getColor(0, this.resolveColorRes(defResId));
            return n;
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int resolveDimenSizeAttr(@AttrRes int attrResId, @DimenRes int defResId) {
        this.mAttrs[0] = attrResId;
        TypedArray a = this.mTheme.obtainStyledAttributes(this.mAttrs);
        try {
            int n = a.getDimensionPixelSize(0, this.resolveDimenSizeRes(defResId));
            return n;
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int resolveDimenOffsetAttr(@AttrRes int attrResId, @DimenRes int defResId) {
        this.mAttrs[0] = attrResId;
        TypedArray a = this.mTheme.obtainStyledAttributes(this.mAttrs);
        try {
            int n = a.getDimensionPixelOffset(0, this.resolveDimenOffsetRes(defResId));
            return n;
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float resolveFloatAttr(@AttrRes int attrResId, @DimenRes int defResId) {
        this.mAttrs[0] = attrResId;
        TypedArray a = this.mTheme.obtainStyledAttributes(this.mAttrs);
        try {
            float f = a.getDimension(0, this.resolveFloatRes(defResId));
            return f;
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Drawable resolveDrawableAttr(@AttrRes int attrResId, @DrawableRes int defResId) {
        if (attrResId == 0) {
            return null;
        }
        this.mAttrs[0] = attrResId;
        TypedArray a = this.mTheme.obtainStyledAttributes(this.mAttrs);
        try {
            Drawable drawable = this.resolveDrawableRes(a.getResourceId(0, defResId));
            return drawable;
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int resolveResIdAttr(@AttrRes int attrResId, int defResId) {
        this.mAttrs[0] = attrResId;
        TypedArray a = this.mTheme.obtainStyledAttributes(this.mAttrs);
        try {
            int n = a.getResourceId(0, defResId);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    public final void release() {
        this.mResources = null;
        this.mTheme = null;
        this.mResourceCache = null;
    }
}

