/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.VisibleForTesting;
import com.facebook.litho.Component;
import com.facebook.litho.DisabledMountContentPool;
import com.facebook.litho.MountContentPool;
import com.facebook.litho.config.ComponentsConfiguration;

public class PoolBisectUtil {
    static MountContentPool getPoolForComponent(Component component) {
        if (ComponentsConfiguration.isPoolBisectEnabled && PoolBisectUtil.shouldDisablePool(component.getSimpleName())) {
            return new DisabledMountContentPool();
        }
        return component.onCreateMountContentPool();
    }

    @VisibleForTesting
    static boolean shouldDisablePool(String componentName) {
        if (!ComponentsConfiguration.isPoolBisectEnabled) {
            return false;
        }
        String start = ComponentsConfiguration.disablePoolsStart;
        String end = ComponentsConfiguration.disablePoolsEnd;
        return componentName.compareToIgnoreCase(start) >= 0 && componentName.compareToIgnoreCase(end) <= 0;
    }
}

