/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import javax.annotation.Nullable;

public class OutputUnitsAffinityGroup<T> {
    private final Object[] mContent = new Object[5];
    private short mSize = 0;

    public OutputUnitsAffinityGroup() {
    }

    public OutputUnitsAffinityGroup(OutputUnitsAffinityGroup<T> group) {
        int size = this.mContent.length;
        for (int index = 0; index < size; ++index) {
            this.mContent[index] = group.mContent[index];
        }
        this.mSize = group.mSize;
    }

    public void add(int type, T value) {
        if (value == null) {
            throw new IllegalArgumentException("value should not be null");
        }
        if (this.mContent[type] != null) {
            throw new RuntimeException("Already contains unit for type " + OutputUnitsAffinityGroup.typeToString(type));
        }
        if (this.mContent[3] != null || type == 3 && this.mSize > 0) {
            throw new RuntimeException("OutputUnitType.HOST unit should be the only member of an OutputUnitsAffinityGroup");
        }
        this.mContent[type] = value;
        this.mSize = (short)(this.mSize + 1);
    }

    public void replace(int type, T value) {
        if (value != null && this.mContent[type] != null) {
            this.mContent[type] = value;
        } else if (value != null && this.mContent[type] == null) {
            this.add(type, value);
        } else if (value == null && this.mContent[type] != null) {
            this.mContent[type] = null;
            this.mSize = (short)(this.mSize - 1);
        }
    }

    public T get(int type) {
        return (T)this.mContent[type];
    }

    public int size() {
        return this.mSize;
    }

    public boolean isEmpty() {
        return this.mSize == 0;
    }

    public int typeAt(int index) {
        if (index < 0 || index >= this.mSize) {
            throw new IndexOutOfBoundsException("index=" + index + ", size=" + this.mSize);
        }
        int i = 0;
        int j = 0;
        while (j <= index) {
            if (this.mContent[i] != null) {
                ++j;
            }
            ++i;
        }
        return i - 1;
    }

    public T getAt(int index) {
        return this.get(this.typeAt(index));
    }

    public T getMostSignificantUnit() {
        if (this.mContent[3] != null) {
            return this.get(3);
        }
        if (this.mContent[0] != null) {
            return this.get(0);
        }
        if (this.mContent[1] != null) {
            return this.get(1);
        }
        if (this.mContent[2] != null) {
            return this.get(2);
        }
        return this.get(4);
    }

    public void clean() {
        for (int i = 0; i < this.mContent.length; ++i) {
            this.mContent[i] = null;
        }
        this.mSize = 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutputUnitsAffinityGroup that = (OutputUnitsAffinityGroup)o;
        if (this.mSize != that.mSize) {
            return false;
        }
        for (int i = 0; i < this.mContent.length; ++i) {
            if (this.mContent[i] == that.mContent[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        for (int index = 0; index < this.size(); ++index) {
            int type = this.typeAt(index);
            T unit = this.getAt(index);
            sb.append("\n\t").append(OutputUnitsAffinityGroup.typeToString(type)).append(": ").append(unit.toString());
        }
        return sb.toString();
    }

    @Nullable
    private static String typeToString(int type) {
        switch (type) {
            case 0: {
                return "CONTENT";
            }
            case 1: {
                return "BACKGROUND";
            }
            case 2: {
                return "FOREGROUND";
            }
            case 3: {
                return "HOST";
            }
            case 4: {
                return "BORDER";
            }
        }
        return null;
    }
}

