/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.animation.AnimatorInflater;
import android.animation.StateListAnimator;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.collection.LongSparseArray;
import androidx.core.view.ViewCompat;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.litho.AnimationsDebug;
import com.facebook.litho.BoundsHelper;
import com.facebook.litho.ClickEvent;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentClickListener;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentFocusChangeListener;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.ComponentHostRecycleUtil;
import com.facebook.litho.ComponentHostUtils;
import com.facebook.litho.ComponentLongClickListener;
import com.facebook.litho.ComponentTouchListener;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.ComponentsReporter;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.DrawableComponent;
import com.facebook.litho.DynamicPropsManager;
import com.facebook.litho.EventDispatcherUtils;
import com.facebook.litho.EventHandler;
import com.facebook.litho.FocusChangedEvent;
import com.facebook.litho.FocusedVisibleEvent;
import com.facebook.litho.FullImpressionVisibleEvent;
import com.facebook.litho.HasLithoViewChildren;
import com.facebook.litho.InterceptTouchEvent;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LayoutStateOutputIdCalculator;
import com.facebook.litho.LithoView;
import com.facebook.litho.LogTreePopulator;
import com.facebook.litho.LongClickEvent;
import com.facebook.litho.MountItem;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.OutputUnitsAffinityGroup;
import com.facebook.litho.PerfEvent;
import com.facebook.litho.R;
import com.facebook.litho.TestItem;
import com.facebook.litho.TestOutput;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.TouchEvent;
import com.facebook.litho.Transition;
import com.facebook.litho.TransitionId;
import com.facebook.litho.TransitionManager;
import com.facebook.litho.TransitionUtils;
import com.facebook.litho.UnfocusedVisibleEvent;
import com.facebook.litho.ViewNodeInfo;
import com.facebook.litho.VisibilityChangedEvent;
import com.facebook.litho.VisibilityItem;
import com.facebook.litho.VisibilityOutput;
import com.facebook.litho.VisibleEvent;
import com.facebook.litho.animation.AnimatedProperties;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.drawable.ComparableDrawable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ThreadConfined(value="UI")
class MountState
implements TransitionManager.OnAnimationCompleteListener {
    static final long ROOT_HOST_ID = 0L;
    private static final double NS_IN_MS = 1000000.0;
    private static final BitSet sEmptyBitSet = new BitSet(0);
    private final LongSparseArray<MountItem> mIndexToItemMap;
    private final LongSparseArray<VisibilityItem> mVisibilityIdToItemMap;
    private final LongSparseArray<MountItem> mCanMountIncrementallyMountItems;
    private final Map<String, Deque<TestItem>> mTestItemMap;
    @Nullable
    private long[] mLayoutOutputsIds;
    private boolean mIsDirty;
    private boolean mNeedsRemount;
    private final LongSparseArray<ComponentHost> mHostsByMarker = new LongSparseArray();
    private static final Rect sTempRect = new Rect();
    private static final Rect sTempRect2 = new Rect();
    private final ComponentContext mContext;
    private final LithoView mLithoView;
    private final Rect mPreviousLocalVisibleRect = new Rect();
    private final PrepareMountStats mPrepareMountStats = new PrepareMountStats();
    private final MountStats mMountStats = new MountStats();
    private int mPreviousTopsIndex;
    private int mPreviousBottomsIndex;
    private int mLastMountedComponentTreeId = -1;
    private LayoutState mLastMountedLayoutState;
    private boolean mIsFirstMountOfComponentTree = false;
    private int mLastDisappearRangeStart = -1;
    private int mLastDisappearRangeEnd = -1;
    private final MountItem mRootHostMountItem;
    private TransitionManager mTransitionManager;
    private final HashSet<TransitionId> mAnimatingTransitionIds = new HashSet();
    private int[] mAnimationLockedIndices;
    private final Map<TransitionId, OutputUnitsAffinityGroup<MountItem>> mDisappearingMountItems = new LinkedHashMap<TransitionId, OutputUnitsAffinityGroup<MountItem>>();
    @Nullable
    private Transition mRootTransition;
    private boolean mTransitionsHasBeenCollected = false;
    private final Set<Long> mComponentIdsMountedInThisFrame = new HashSet<Long>();
    private final DynamicPropsManager mDynamicPropsManager = new DynamicPropsManager();

    public MountState(LithoView view) {
        this.mIndexToItemMap = new LongSparseArray();
        this.mVisibilityIdToItemMap = new LongSparseArray();
        this.mCanMountIncrementallyMountItems = new LongSparseArray();
        this.mContext = view.getComponentContext();
        this.mLithoView = view;
        this.mIsDirty = true;
        this.mTestItemMap = ComponentsConfiguration.isEndToEndTestRun ? new HashMap() : null;
        this.mRootHostMountItem = MountItem.createRootHostMountItem(this.mLithoView);
    }

    void setDirty() {
        ThreadUtils.assertMainThread();
        this.mIsDirty = true;
        this.mPreviousLocalVisibleRect.setEmpty();
    }

    boolean isDirty() {
        ThreadUtils.assertMainThread();
        return this.mIsDirty;
    }

    boolean needsRemount() {
        ThreadUtils.assertMainThread();
        return this.mNeedsRemount;
    }

    void setIsFirstMountOfComponentTree() {
        ThreadUtils.assertMainThread();
        this.mIsFirstMountOfComponentTree = true;
    }

    void mount(LayoutState layoutState, Rect localVisibleRect, boolean processVisibilityOutputs) {
        PerfEvent mountPerfEvent;
        ThreadUtils.assertMainThread();
        if (layoutState == null) {
            throw new IllegalStateException("Trying to mount a null layoutState");
        }
        ComponentTree componentTree = this.mLithoView.getComponentTree();
        boolean isIncrementalMountEnabled = localVisibleRect != null;
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            StringBuilder sectionName = new StringBuilder(isIncrementalMountEnabled ? "incrementalMount" : "mount").append("_").append(componentTree.getSimpleName());
            String logTag = componentTree.getContext().getLogTag();
            if (logTag != null) {
                sectionName.append("_").append(logTag);
            }
            ComponentsSystrace.beginSectionWithArgs(sectionName.toString()).arg("treeId", layoutState.getComponentTreeId()).flush();
        }
        ComponentsLogger logger = componentTree.getContext().getLogger();
        int componentTreeId = layoutState.getComponentTreeId();
        if (componentTreeId != this.mLastMountedComponentTreeId) {
            this.mLastMountedLayoutState = null;
        }
        PerfEvent perfEvent = mountPerfEvent = logger == null ? null : LogTreePopulator.populatePerfEventFromLogger(componentTree.getContext(), logger, logger.newPerformanceEvent(componentTree.getContext(), 6));
        if (this.mIsDirty) {
            this.updateTransitions(layoutState, componentTree);
            this.suppressInvalidationsOnHosts(true);
            if (mountPerfEvent != null) {
                mountPerfEvent.markerPoint("PREPARE_MOUNT_START");
            }
            this.prepareMount(layoutState, mountPerfEvent);
            if (mountPerfEvent != null) {
                mountPerfEvent.markerPoint("PREPARE_MOUNT_END");
            }
        }
        this.mMountStats.reset();
        if (mountPerfEvent != null && logger.isTracing(mountPerfEvent)) {
            this.mMountStats.enableLogging();
        }
        if (!isIncrementalMountEnabled || !this.performIncrementalMount(layoutState, localVisibleRect, processVisibilityOutputs)) {
            MountItem rootMountItem = (MountItem)this.mIndexToItemMap.get(0L);
            int size = layoutState.getMountableOutputCount();
            for (int i = 0; i < size; ++i) {
                boolean isMountable;
                MountItem currentMountItem;
                LayoutOutput layoutOutput = layoutState.getMountableOutputAt(i);
                Component component = layoutOutput.getComponent();
                if (isTracing) {
                    ComponentsSystrace.beginSection(component.getSimpleName());
                }
                boolean isMounted = (currentMountItem = this.getItemAt(i)) != null;
                boolean bl = isMountable = !isIncrementalMountEnabled || this.isMountedHostWithChildContent(currentMountItem) || Rect.intersects((Rect)localVisibleRect, (Rect)layoutOutput.getBounds()) || this.isAnimationLocked(i) || currentMountItem != null && currentMountItem == rootMountItem;
                if (isMountable && !isMounted) {
                    this.mountLayoutOutput(i, layoutOutput, layoutState);
                    if (this.isAnimationLocked(i) && isIncrementalMountEnabled && component.hasChildLithoViews()) {
                        View view = (View)this.getItemAt(i).getContent();
                        MountState.mountViewIncrementally(view, false);
                    }
                } else if (!isMountable && isMounted) {
                    this.unmountItem(i, this.mHostsByMarker);
                } else if (isMounted) {
                    if (this.mIsDirty) {
                        boolean useUpdateValueFromLayoutOutput = this.mLastMountedLayoutState != null && this.mLastMountedLayoutState.getId() == layoutState.getPreviousLayoutStateId();
                        long startTime = System.nanoTime();
                        TransitionId transitionId = currentMountItem.getTransitionId();
                        boolean itemUpdated = this.updateMountItemIfNeeded(layoutOutput, layoutState, currentMountItem, useUpdateValueFromLayoutOutput, componentTreeId, i);
                        if (itemUpdated) {
                            this.maybeRemoveAnimatingMountContent(transitionId);
                        }
                        if (this.mMountStats.isLoggingEnabled) {
                            if (itemUpdated) {
                                this.mMountStats.updatedNames.add(component.getSimpleName());
                                this.mMountStats.updatedTimes.add((double)(System.nanoTime() - startTime) / 1000000.0);
                                this.mMountStats.updatedCount++;
                            } else {
                                this.mMountStats.noOpCount++;
                            }
                        }
                    }
                    if (isIncrementalMountEnabled && component.hasChildLithoViews()) {
                        MountState.mountItemIncrementally(currentMountItem, processVisibilityOutputs);
                    }
                }
                if (!isTracing) continue;
                ComponentsSystrace.endSection();
            }
            if (isIncrementalMountEnabled) {
                this.setupPreviousMountableOutputData(layoutState, localVisibleRect);
            }
        }
        this.maybeUpdateAnimatingMountContent();
        if (this.shouldAnimateTransitions(layoutState) && this.hasTransitionsToAnimate()) {
            this.mTransitionManager.runTransitions();
        }
        if (processVisibilityOutputs) {
            ComponentsSystrace.beginSection("processVisibilityOutputs");
            this.processVisibilityOutputs(layoutState, localVisibleRect, mountPerfEvent);
            ComponentsSystrace.endSection();
        }
        this.mRootTransition = null;
        this.mTransitionsHasBeenCollected = false;
        boolean wasDirty = this.mIsDirty;
        this.mIsDirty = false;
        this.mNeedsRemount = false;
        this.mIsFirstMountOfComponentTree = false;
        if (localVisibleRect != null) {
            this.mPreviousLocalVisibleRect.set(localVisibleRect);
        }
        this.mLastMountedLayoutState = null;
        this.mLastMountedComponentTreeId = componentTreeId;
        this.mLastMountedLayoutState = layoutState;
        this.processTestOutputs(layoutState);
        this.suppressInvalidationsOnHosts(false);
        if (logger != null) {
            this.logMountPerfEvent(logger, mountPerfEvent, wasDirty);
        }
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
    }

    private void logMountPerfEvent(ComponentsLogger logger, @Nullable PerfEvent mountPerfEvent, boolean isDirty) {
        if (!this.mMountStats.isLoggingEnabled || mountPerfEvent == null) {
            logger.cancelPerfEvent(mountPerfEvent);
            return;
        }
        if (this.mMountStats.mountedCount == 0 || this.mMountStats.mountedNames.isEmpty()) {
            logger.cancelPerfEvent(mountPerfEvent);
            return;
        }
        mountPerfEvent.markerAnnotate("mounted_count", this.mMountStats.mountedCount);
        mountPerfEvent.markerAnnotate("mounted_content", this.mMountStats.mountedNames.toArray(new String[0]));
        mountPerfEvent.markerAnnotate("mounted_time_ms", this.mMountStats.mountTimes.toArray(new Double[0]));
        mountPerfEvent.markerAnnotate("unmounted_count", this.mMountStats.unmountedCount);
        mountPerfEvent.markerAnnotate("unmounted_content", this.mMountStats.unmountedNames.toArray(new String[0]));
        mountPerfEvent.markerAnnotate("unmounted_time_ms", this.mMountStats.unmountedTimes.toArray(new Double[0]));
        mountPerfEvent.markerAnnotate("mounted_extras", this.mMountStats.extras.toArray(new String[0]));
        mountPerfEvent.markerAnnotate("updated_count", this.mMountStats.updatedCount);
        mountPerfEvent.markerAnnotate("updated_content", this.mMountStats.updatedNames.toArray(new String[0]));
        mountPerfEvent.markerAnnotate("updated_time_ms", this.mMountStats.updatedTimes.toArray(new Double[0]));
        mountPerfEvent.markerAnnotate("visibility_handlers_total_time_ms", this.mMountStats.visibilityHandlersTotalTime);
        mountPerfEvent.markerAnnotate("visibility_handler", this.mMountStats.visibilityHandlerNames.toArray(new String[0]));
        mountPerfEvent.markerAnnotate("visibility_handler_time_ms", this.mMountStats.visibilityHandlerTimes.toArray(new Double[0]));
        mountPerfEvent.markerAnnotate("no_op_count", this.mMountStats.noOpCount);
        mountPerfEvent.markerAnnotate("is_dirty", isDirty);
        logger.logPerfEvent(mountPerfEvent);
    }

    private void maybeRemoveAnimatingMountContent(TransitionId transitionId) {
        if (this.mTransitionManager == null || transitionId == null) {
            return;
        }
        this.mTransitionManager.setMountContent(transitionId, null);
    }

    private void maybeRemoveAnimatingMountContent(TransitionId transitionId, int type) {
        if (this.mTransitionManager == null || transitionId == null) {
            return;
        }
        this.mTransitionManager.removeMountContent(transitionId, type);
    }

    private void maybeUpdateAnimatingMountContent() {
        if (this.mTransitionManager == null) {
            return;
        }
        LinkedHashMap<TransitionId, OutputUnitsAffinityGroup<Object>> animatingContent = new LinkedHashMap<TransitionId, OutputUnitsAffinityGroup<Object>>(this.mAnimatingTransitionIds.size());
        int size = this.mIndexToItemMap.size();
        for (int i = 0; i < size; ++i) {
            MountItem mountItem = (MountItem)this.mIndexToItemMap.valueAt(i);
            if (!mountItem.hasTransitionId()) continue;
            long layoutOutputId = this.mIndexToItemMap.keyAt(i);
            int type = LayoutStateOutputIdCalculator.getTypeFromId(layoutOutputId);
            OutputUnitsAffinityGroup<Object> group = (OutputUnitsAffinityGroup<Object>)animatingContent.get(mountItem.getTransitionId());
            if (group == null) {
                group = new OutputUnitsAffinityGroup<Object>();
                animatingContent.put(mountItem.getTransitionId(), group);
            }
            group.replace(type, mountItem.getContent());
        }
        for (TransitionId transitionId : animatingContent.keySet()) {
            this.mTransitionManager.setMountContent(transitionId, (OutputUnitsAffinityGroup)animatingContent.get(transitionId));
        }
        for (TransitionId transitionId : this.mDisappearingMountItems.keySet()) {
            OutputUnitsAffinityGroup<MountItem> mountItemsGroup = this.mDisappearingMountItems.get(transitionId);
            OutputUnitsAffinityGroup<Object> mountContentGroup = new OutputUnitsAffinityGroup<Object>();
            int sz = mountItemsGroup.size();
            for (int j = 0; j < sz; ++j) {
                int type = mountItemsGroup.typeAt(j);
                MountItem mountItem = mountItemsGroup.getAt(j);
                mountContentGroup.add(type, mountItem.getContent());
            }
            this.mTransitionManager.setMountContent(transitionId, mountContentGroup);
        }
    }

    void processVisibilityOutputs(LayoutState layoutState, Rect localVisibleRect, @Nullable PerfEvent mountPerfEvent) {
        ThreadUtils.assertMainThread();
        if (localVisibleRect == null) {
            return;
        }
        if (mountPerfEvent != null) {
            mountPerfEvent.markerPoint("VISIBILITY_HANDLERS_START");
        }
        boolean isDoingPerfLog = this.mMountStats.isLoggingEnabled;
        boolean isTracing = ComponentsSystrace.isTracing();
        long totalStartTime = isDoingPerfLog ? System.nanoTime() : 0L;
        int size = layoutState.getVisibilityOutputCount();
        for (int j = 0; j < size; ++j) {
            VisibilityOutput visibilityOutput = layoutState.getVisibilityOutputAt(j);
            if (isTracing) {
                String componentName = visibilityOutput.getComponent() != null ? visibilityOutput.getComponent().getSimpleName() : "Unknown";
                ComponentsSystrace.beginSection("visibilityHandlers:" + componentName);
            }
            long handlerStartTime = isDoingPerfLog ? System.nanoTime() : 0L;
            EventHandler<VisibleEvent> visibleHandler = visibilityOutput.getVisibleEventHandler();
            EventHandler<FocusedVisibleEvent> focusedHandler = visibilityOutput.getFocusedEventHandler();
            EventHandler<UnfocusedVisibleEvent> unfocusedHandler = visibilityOutput.getUnfocusedEventHandler();
            EventHandler<FullImpressionVisibleEvent> fullImpressionHandler = visibilityOutput.getFullImpressionEventHandler();
            EventHandler<InvisibleEvent> invisibleHandler = visibilityOutput.getInvisibleEventHandler();
            EventHandler<VisibilityChangedEvent> visibilityChangedHandler = visibilityOutput.getVisibilityChangedEventHandler();
            long visibilityOutputId = visibilityOutput.getId();
            Rect visibilityOutputBounds = visibilityOutput.getBounds();
            boolean boundsIntersect = sTempRect.setIntersect(visibilityOutputBounds, localVisibleRect);
            boolean isCurrentlyVisible = boundsIntersect && this.isInVisibleRange(visibilityOutput, visibilityOutputBounds, sTempRect);
            VisibilityItem visibilityItem = (VisibilityItem)this.mVisibilityIdToItemMap.get(visibilityOutputId);
            if (visibilityItem != null) {
                boolean hasGlobalKeyChanged;
                String previousGlobalKey = visibilityItem.getGlobalKey();
                String currentGlobalKey = visibilityOutput.getComponent() != null ? visibilityOutput.getComponent().getGlobalKey() : null;
                boolean bl = hasGlobalKeyChanged = previousGlobalKey != null && !previousGlobalKey.equals(currentGlobalKey);
                if (!hasGlobalKeyChanged) {
                    visibilityItem.setUnfocusedHandler(unfocusedHandler);
                    visibilityItem.setInvisibleHandler(invisibleHandler);
                }
                if (!isCurrentlyVisible || hasGlobalKeyChanged) {
                    if (visibilityItem.getInvisibleHandler() != null) {
                        EventDispatcherUtils.dispatchOnInvisible(visibilityItem.getInvisibleHandler());
                    }
                    if (visibilityChangedHandler != null) {
                        EventDispatcherUtils.dispatchOnVisibilityChanged(visibilityChangedHandler, 0, 0, 0.0f, 0.0f);
                    }
                    if (visibilityItem.isInFocusedRange()) {
                        visibilityItem.setFocusedRange(false);
                        if (visibilityItem.getUnfocusedHandler() != null) {
                            EventDispatcherUtils.dispatchOnUnfocused(visibilityItem.getUnfocusedHandler());
                        }
                    }
                    this.mVisibilityIdToItemMap.remove(visibilityOutputId);
                    visibilityItem = null;
                } else {
                    visibilityItem.setDoNotClearInThisPass(this.mIsDirty);
                }
            }
            if (isCurrentlyVisible) {
                if (visibilityItem == null) {
                    String globalKey = visibilityOutput.getComponent() != null ? visibilityOutput.getComponent().getGlobalKey() : null;
                    visibilityItem = new VisibilityItem(globalKey, invisibleHandler, unfocusedHandler, visibilityChangedHandler);
                    visibilityItem.setDoNotClearInThisPass(this.mIsDirty);
                    this.mVisibilityIdToItemMap.put(visibilityOutputId, (Object)visibilityItem);
                    if (visibleHandler != null) {
                        EventDispatcherUtils.dispatchOnVisible(visibleHandler);
                    }
                }
                if (focusedHandler != null || unfocusedHandler != null) {
                    if (this.isInFocusedRange(visibilityOutputBounds, sTempRect)) {
                        if (!visibilityItem.isInFocusedRange()) {
                            visibilityItem.setFocusedRange(true);
                            if (focusedHandler != null) {
                                EventDispatcherUtils.dispatchOnFocused(focusedHandler);
                            }
                        }
                    } else if (visibilityItem.isInFocusedRange()) {
                        visibilityItem.setFocusedRange(false);
                        if (unfocusedHandler != null) {
                            EventDispatcherUtils.dispatchOnUnfocused(unfocusedHandler);
                        }
                    }
                }
                if (fullImpressionHandler != null && !visibilityItem.isInFullImpressionRange()) {
                    visibilityItem.setVisibleEdges(visibilityOutputBounds, sTempRect);
                    if (visibilityItem.isInFullImpressionRange()) {
                        EventDispatcherUtils.dispatchOnFullImpression(fullImpressionHandler);
                    }
                }
                if (visibilityChangedHandler != null) {
                    int visibleWidth = MountState.sTempRect.right - MountState.sTempRect.left;
                    int visibleHeight = MountState.sTempRect.bottom - MountState.sTempRect.top;
                    EventDispatcherUtils.dispatchOnVisibilityChanged(visibilityChangedHandler, visibleWidth, visibleHeight, 100.0f * (float)visibleWidth / (float)visibilityOutputBounds.width(), 100.0f * (float)visibleHeight / (float)visibilityOutputBounds.height());
                }
            }
            if (isDoingPerfLog) {
                String componentName = visibilityOutput.getComponent() != null ? visibilityOutput.getComponent().getSimpleName() : "Unknown";
                this.mMountStats.visibilityHandlerTimes.add((double)(System.nanoTime() - handlerStartTime) / 1000000.0);
                this.mMountStats.visibilityHandlerNames.add(componentName);
            }
            if (!isTracing) continue;
            ComponentsSystrace.endSection();
        }
        if (this.mIsDirty) {
            this.clearVisibilityItems();
        }
        if (isDoingPerfLog) {
            this.mMountStats.visibilityHandlersTotalTime = (double)(System.nanoTime() - totalStartTime) / 1000000.0;
        }
        if (mountPerfEvent != null) {
            mountPerfEvent.markerPoint("VISIBILITY_HANDLERS_END");
        }
    }

    private void processTestOutputs(LayoutState layoutState) {
        if (this.mTestItemMap == null) {
            return;
        }
        this.mTestItemMap.clear();
        int size = layoutState.getTestOutputCount();
        for (int i = 0; i < size; ++i) {
            TestOutput testOutput = layoutState.getTestOutputAt(i);
            long hostMarker = testOutput.getHostMarker();
            long layoutOutputId = testOutput.getLayoutOutputId();
            MountItem mountItem = layoutOutputId == -1L ? null : (MountItem)this.mIndexToItemMap.get(layoutOutputId);
            TestItem testItem = new TestItem();
            testItem.setHost(hostMarker == -1L ? null : (ComponentHost)((Object)this.mHostsByMarker.get(hostMarker)));
            testItem.setBounds(testOutput.getBounds());
            testItem.setTestKey(testOutput.getTestKey());
            testItem.setContent(mountItem == null ? null : mountItem.getContent());
            LinkedList<TestItem> items = this.mTestItemMap.get(testOutput.getTestKey());
            LinkedList<TestItem> updatedItems = items == null ? new LinkedList<TestItem>() : items;
            updatedItems.add(testItem);
            this.mTestItemMap.put(testOutput.getTestKey(), updatedItems);
        }
    }

    private boolean isMountedHostWithChildContent(MountItem mountItem) {
        if (mountItem == null) {
            return false;
        }
        Object content = mountItem.getContent();
        if (!(content instanceof ComponentHost)) {
            return false;
        }
        ComponentHost host = (ComponentHost)((Object)content);
        return host.getMountItemCount() > 0;
    }

    private void setupPreviousMountableOutputData(LayoutState layoutState, Rect localVisibleRect) {
        int i;
        if (localVisibleRect.isEmpty()) {
            return;
        }
        ArrayList<LayoutOutput> layoutOutputTops = layoutState.getMountableOutputTops();
        ArrayList<LayoutOutput> layoutOutputBottoms = layoutState.getMountableOutputBottoms();
        int mountableOutputCount = layoutState.getMountableOutputCount();
        this.mPreviousTopsIndex = layoutState.getMountableOutputCount();
        for (i = 0; i < mountableOutputCount; ++i) {
            if (localVisibleRect.bottom > layoutOutputTops.get((int)i).getBounds().top) continue;
            this.mPreviousTopsIndex = i;
            break;
        }
        this.mPreviousBottomsIndex = layoutState.getMountableOutputCount();
        for (i = 0; i < mountableOutputCount; ++i) {
            if (localVisibleRect.top >= layoutOutputBottoms.get((int)i).getBounds().bottom) continue;
            this.mPreviousBottomsIndex = i;
            break;
        }
    }

    List<LithoView> getChildLithoViewsFromCurrentlyMountedItems() {
        ArrayList<LithoView> childLithoViews = new ArrayList<LithoView>();
        for (int i = 0; i < this.mIndexToItemMap.size(); ++i) {
            long layoutOutputId = this.mIndexToItemMap.keyAt(i);
            MountItem mountItem = (MountItem)this.mIndexToItemMap.get(layoutOutputId);
            if (mountItem == null || !(mountItem.getContent() instanceof HasLithoViewChildren)) continue;
            ((HasLithoViewChildren)mountItem.getContent()).obtainLithoViewChildren(childLithoViews);
        }
        return childLithoViews;
    }

    void clearVisibilityItems() {
        ThreadUtils.assertMainThread();
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("MountState.clearVisibilityItems");
        }
        for (int i = this.mVisibilityIdToItemMap.size() - 1; i >= 0; --i) {
            VisibilityItem visibilityItem = (VisibilityItem)this.mVisibilityIdToItemMap.valueAt(i);
            if (visibilityItem.doNotClearInThisPass()) {
                visibilityItem.setDoNotClearInThisPass(false);
                continue;
            }
            EventHandler<InvisibleEvent> invisibleHandler = visibilityItem.getInvisibleHandler();
            EventHandler<UnfocusedVisibleEvent> unfocusedHandler = visibilityItem.getUnfocusedHandler();
            EventHandler<VisibilityChangedEvent> visibilityChangedHandler = visibilityItem.getVisibilityChangedHandler();
            if (invisibleHandler != null) {
                EventDispatcherUtils.dispatchOnInvisible(invisibleHandler);
            }
            if (visibilityItem.isInFocusedRange()) {
                visibilityItem.setFocusedRange(false);
                if (unfocusedHandler != null) {
                    EventDispatcherUtils.dispatchOnUnfocused(unfocusedHandler);
                }
            }
            if (visibilityChangedHandler != null) {
                EventDispatcherUtils.dispatchOnVisibilityChanged(visibilityChangedHandler, 0, 0, 0.0f, 0.0f);
            }
            this.mVisibilityIdToItemMap.removeAt(i);
        }
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
    }

    private void registerHost(long id2, ComponentHost host) {
        host.suppressInvalidations(true);
        this.mHostsByMarker.put(id2, (Object)host);
    }

    private boolean isInVisibleRange(VisibilityOutput visibilityOutput, Rect bounds, Rect visibleBounds) {
        float heightRatio = visibilityOutput.getVisibleHeightRatio();
        float widthRatio = visibilityOutput.getVisibleWidthRatio();
        if (heightRatio == 0.0f && widthRatio == 0.0f) {
            return true;
        }
        return MountState.isInRatioRange(heightRatio, bounds.height(), visibleBounds.height()) && MountState.isInRatioRange(widthRatio, bounds.width(), visibleBounds.width());
    }

    private static boolean isInRatioRange(float ratio, int length, int visiblelength) {
        return (float)visiblelength >= ratio * (float)length;
    }

    private boolean isInFocusedRange(Rect componentBounds, Rect componentVisibleBounds) {
        View parent = (View)this.mLithoView.getParent();
        if (parent == null) {
            return false;
        }
        int halfViewportArea = parent.getWidth() * parent.getHeight() / 2;
        int totalComponentArea = MountState.computeRectArea(componentBounds);
        int visibleComponentArea = MountState.computeRectArea(componentVisibleBounds);
        return totalComponentArea >= halfViewportArea ? visibleComponentArea >= halfViewportArea : componentBounds.equals((Object)componentVisibleBounds);
    }

    private static int computeRectArea(Rect rect) {
        return rect.isEmpty() ? 0 : rect.width() * rect.height();
    }

    private void suppressInvalidationsOnHosts(boolean suppressInvalidations) {
        for (int i = this.mHostsByMarker.size() - 1; i >= 0; --i) {
            ((ComponentHost)((Object)this.mHostsByMarker.valueAt(i))).suppressInvalidations(suppressInvalidations);
        }
    }

    private boolean updateMountItemIfNeeded(LayoutOutput layoutOutput, LayoutState layoutState, MountItem currentMountItem, boolean useUpdateValueFromLayoutOutput, int componentTreeId, int index) {
        ComponentHost host;
        boolean shouldUpdateViewInfo;
        Component layoutOutputComponent = layoutOutput.getComponent();
        Component itemComponent = currentMountItem.getComponent();
        if (layoutOutputComponent == null) {
            throw new RuntimeException("Trying to update a MountItem with a null Component.");
        }
        boolean shouldUpdate = MountState.shouldUpdateMountItem(layoutOutput, currentMountItem, useUpdateValueFromLayoutOutput);
        boolean bl = shouldUpdateViewInfo = shouldUpdate || MountState.shouldUpdateViewInfo(layoutOutput, currentMountItem);
        if (shouldUpdate) {
            Component component;
            if (this.mLastMountedComponentTreeId != componentTreeId && Component.isHostSpec(component = currentMountItem.getComponent())) {
                ComponentHost componentHost = (ComponentHost)((Object)currentMountItem.getContent());
                this.removeDisappearingMountContentFromComponentHost(componentHost);
            }
            MountState.maybeUnsetViewAttributes(currentMountItem);
            host = currentMountItem.getHost();
            host.maybeUnregisterTouchExpansion(index, currentMountItem);
        } else if (shouldUpdateViewInfo) {
            MountState.maybeUnsetViewAttributes(currentMountItem);
            host = currentMountItem.getHost();
            host.maybeUnregisterTouchExpansion(index, currentMountItem);
        }
        if (currentMountItem.isBound()) {
            itemComponent.onUnbind(this.getContextForComponent(itemComponent), currentMountItem.getContent());
            currentMountItem.setIsBound(false);
        }
        currentMountItem.update(layoutOutput);
        if (shouldUpdate) {
            host = currentMountItem.getHost();
            host.maybeRegisterTouchExpansion(index, currentMountItem);
            this.updateMountedContent(currentMountItem, layoutOutput, itemComponent);
            MountState.setViewAttributes(currentMountItem);
        } else if (shouldUpdateViewInfo) {
            host = currentMountItem.getHost();
            host.maybeRegisterTouchExpansion(index, currentMountItem);
            MountState.setViewAttributes(currentMountItem);
        }
        Object currentContent = currentMountItem.getContent();
        this.bindComponentToContent(layoutOutputComponent, currentContent);
        currentMountItem.setIsBound(true);
        MountState.updateBoundsForMountedLayoutOutput(layoutOutput, layoutState, currentMountItem);
        ComponentHostUtils.maybeInvalidateAccessibilityState(currentMountItem);
        if (currentMountItem.getContent() instanceof Drawable) {
            ComponentHostUtils.maybeSetDrawableState((View)currentMountItem.getHost(), (Drawable)currentMountItem.getContent(), currentMountItem.getLayoutFlags(), currentMountItem.getNodeInfo());
        }
        return shouldUpdate;
    }

    private static boolean shouldUpdateViewInfo(LayoutOutput layoutOutput, MountItem currentMountItem) {
        ViewNodeInfo nextViewNodeInfo = layoutOutput.getViewNodeInfo();
        ViewNodeInfo currentViewNodeInfo = currentMountItem.getViewNodeInfo();
        if (currentViewNodeInfo == null && nextViewNodeInfo != null || currentViewNodeInfo != null && !currentViewNodeInfo.isEquivalentTo(nextViewNodeInfo)) {
            return true;
        }
        NodeInfo nextNodeInfo = layoutOutput.getNodeInfo();
        NodeInfo currentNodeInfo = currentMountItem.getNodeInfo();
        return currentNodeInfo == null && nextNodeInfo != null || currentNodeInfo != null && !currentNodeInfo.isEquivalentTo(nextNodeInfo);
    }

    private static boolean shouldUpdateMountItem(LayoutOutput layoutOutput, MountItem currentMountItem, boolean useUpdateValueFromLayoutOutput) {
        int updateState = layoutOutput.getUpdateState();
        Component currentComponent = currentMountItem.getComponent();
        Component nextComponent = layoutOutput.getComponent();
        if (layoutOutput.getOrientation() != currentMountItem.getOrientation()) {
            return true;
        }
        if (!MountState.sameSize(layoutOutput, currentMountItem) && nextComponent.isMountSizeDependent()) {
            return true;
        }
        if (useUpdateValueFromLayoutOutput) {
            if (updateState == 1) {
                return currentComponent instanceof DrawableComponent && nextComponent instanceof DrawableComponent && currentComponent.shouldComponentUpdate(currentComponent, nextComponent);
            }
            if (updateState == 2) {
                return true;
            }
        }
        if (!currentComponent.callsShouldUpdateOnMount()) {
            return true;
        }
        return currentComponent.shouldComponentUpdate(currentComponent, nextComponent);
    }

    private static boolean sameSize(LayoutOutput layoutOutput, MountItem item) {
        Rect layoutOutputBounds = layoutOutput.getBounds();
        Object mountedContent = item.getContent();
        return layoutOutputBounds.width() == MountState.getWidthForMountedContent(mountedContent) && layoutOutputBounds.height() == MountState.getHeightForMountedContent(mountedContent);
    }

    private static int getWidthForMountedContent(Object content) {
        return content instanceof Drawable ? ((Drawable)content).getBounds().width() : ((View)content).getWidth();
    }

    private static int getHeightForMountedContent(Object content) {
        return content instanceof Drawable ? ((Drawable)content).getBounds().height() : ((View)content).getHeight();
    }

    private static void updateBoundsForMountedLayoutOutput(LayoutOutput layoutOutput, LayoutState layoutState, MountItem item) {
        if (layoutOutput.getId() == 0L) {
            return;
        }
        MountState.getActualBounds(layoutOutput, layoutState, sTempRect);
        boolean forceTraversal = Component.isMountViewSpec(layoutOutput.getComponent()) && ((View)item.getContent()).isLayoutRequested();
        MountState.applyBoundsToMountContent(item.getContent(), MountState.sTempRect.left, MountState.sTempRect.top, MountState.sTempRect.right, MountState.sTempRect.bottom, forceTraversal);
    }

    private void prepareMount(LayoutState layoutState, @Nullable PerfEvent perfEvent) {
        List<Integer> disappearingItems = this.extractDisappearingItems(layoutState);
        PrepareMountStats stats = this.unmountOrMoveOldItems(layoutState, disappearingItems);
        if (perfEvent != null) {
            perfEvent.markerAnnotate("unmounted_count", stats.unmountedCount);
            perfEvent.markerAnnotate("moved_count", stats.movedCount);
            perfEvent.markerAnnotate("unchanged_count", stats.unchangedCount);
        }
        if (this.mHostsByMarker.get(0L) == null) {
            this.registerHost(0L, this.mLithoView);
            this.mIndexToItemMap.put(0L, (Object)this.mRootHostMountItem);
        }
        int outputCount = layoutState.getMountableOutputCount();
        if (this.mLayoutOutputsIds == null || outputCount != this.mLayoutOutputsIds.length) {
            this.mLayoutOutputsIds = new long[outputCount];
        }
        for (int i = 0; i < outputCount; ++i) {
            this.mLayoutOutputsIds[i] = layoutState.getMountableOutputAt(i).getId();
        }
    }

    private boolean isItemDisappearing(LayoutState layoutState, int index) {
        if (!this.shouldAnimateTransitions(layoutState) || !this.hasTransitionsToAnimate()) {
            return false;
        }
        if (this.mTransitionManager == null || this.mLastMountedLayoutState == null) {
            return false;
        }
        LayoutOutput layoutOutput = this.mLastMountedLayoutState.getMountableOutputAt(index);
        TransitionId transitionId = layoutOutput.getTransitionId();
        if (transitionId == null) {
            return false;
        }
        return this.mTransitionManager.isDisappearing(transitionId);
    }

    private List<Integer> extractDisappearingItems(LayoutState newLayoutState) {
        if (this.mLayoutOutputsIds == null) {
            return Collections.emptyList();
        }
        List<Integer> indices = null;
        int index = 0;
        while (index < this.mLayoutOutputsIds.length) {
            if (this.isItemDisappearing(newLayoutState, index)) {
                int lastDescendantIndex = this.findLastDescendantIndex(this.mLastMountedLayoutState, index);
                for (int j = index; j <= lastDescendantIndex; ++j) {
                    MountItem mountedItem = this.getItemAt(j);
                    if (mountedItem != null) continue;
                    LayoutOutput layoutOutput = this.mLastMountedLayoutState.getMountableOutputAt(j);
                    this.mountLayoutOutput(j, layoutOutput, this.mLastMountedLayoutState);
                }
                MountItem disappearingItem = this.getItemAt(index);
                this.remountComponentHostToRootIfNeeded(index);
                this.removeDisappearingItemMappings(index, lastDescendantIndex);
                this.startUnmountDisappearingItem(disappearingItem, index);
                if (indices == null) {
                    indices = new ArrayList<Integer>(2);
                }
                indices.add(index);
                indices.add(lastDescendantIndex);
                index = lastDescendantIndex + 1;
                continue;
            }
            ++index;
        }
        return indices != null ? indices : Collections.emptyList();
    }

    private void remountComponentHostToRootIfNeeded(int index) {
        int bottom;
        int right;
        ComponentHost rootHost = (ComponentHost)((Object)this.mHostsByMarker.get(0L));
        MountItem item = this.getItemAt(index);
        if (item.getHost() == rootHost) {
            return;
        }
        Object content = item.getContent();
        int left = 0;
        int top = 0;
        for (ComponentHost componentHost = item.getHost(); componentHost != rootHost; componentHost = (ComponentHost)componentHost.getParent()) {
            left += componentHost.getLeft();
            top += componentHost.getTop();
        }
        if (content instanceof View) {
            View view = (View)content;
            right = (left += view.getLeft()) + view.getWidth();
            bottom = (top += view.getTop()) + view.getHeight();
        } else {
            Rect bounds = ((Drawable)content).getBounds();
            right = (left += bounds.left) + bounds.width();
            bottom = (top += bounds.top) + bounds.height();
        }
        item.getHost().unmount(index, item);
        MountState.applyBoundsToMountContent(content, left, top, right, bottom, false);
        rootHost.mount(index, item, sTempRect);
        item.setHost(rootHost);
    }

    private void removeDisappearingItemMappings(int fromIndex, int toIndex) {
        this.mLastDisappearRangeStart = fromIndex;
        this.mLastDisappearRangeEnd = toIndex;
        for (int i = fromIndex; i <= toIndex; ++i) {
            MountItem item = this.getItemAt(i);
            this.mIndexToItemMap.remove(this.mLayoutOutputsIds[i]);
            if (item.getComponent() != null && item.getComponent().hasChildLithoViews()) {
                this.mCanMountIncrementallyMountItems.remove(this.mLayoutOutputsIds[i]);
            }
            if (!Component.isHostSpec(item.getComponent())) continue;
            this.mHostsByMarker.removeAt(this.mHostsByMarker.indexOfValue((Object)((ComponentHost)((Object)item.getContent()))));
        }
    }

    private void startUnmountDisappearingItem(MountItem item, int index) {
        TransitionId transitionId = item.getTransitionId();
        OutputUnitsAffinityGroup<MountItem> disappearingGroup = this.mDisappearingMountItems.get(transitionId);
        if (disappearingGroup == null) {
            disappearingGroup = new OutputUnitsAffinityGroup();
            this.mDisappearingMountItems.put(transitionId, disappearingGroup);
        }
        int type = LayoutStateOutputIdCalculator.getTypeFromId(this.mLayoutOutputsIds[index]);
        disappearingGroup.add(type, item);
        ComponentHost host = item.getHost();
        host.startUnmountDisappearingItem(index, item);
    }

    private PrepareMountStats unmountOrMoveOldItems(LayoutState newLayoutState, List<Integer> disappearingItems) {
        this.mPrepareMountStats.reset();
        if (this.mLayoutOutputsIds == null) {
            return this.mPrepareMountStats;
        }
        int disappearingItemsPointer = 0;
        for (int i = 0; i < this.mLayoutOutputsIds.length; ++i) {
            LayoutOutput newLayoutOutput = newLayoutState.getLayoutOutput(this.mLayoutOutputsIds[i]);
            int newPosition = newLayoutOutput == null ? -1 : newLayoutOutput.getIndex();
            MountItem oldItem = this.getItemAt(i);
            if (disappearingItems.size() > disappearingItemsPointer && disappearingItems.get(disappearingItemsPointer) == i) {
                i = disappearingItems.get(disappearingItemsPointer + 1);
                disappearingItemsPointer += 2;
                continue;
            }
            if (newPosition == -1) {
                this.unmountItem(i, this.mHostsByMarker);
                this.mPrepareMountStats.unmountedCount++;
                continue;
            }
            long newHostMarker = newLayoutOutput.getHostMarker();
            if (oldItem == null) {
                this.mPrepareMountStats.unmountedCount++;
                continue;
            }
            if (oldItem.getHost() != this.mHostsByMarker.get(newHostMarker)) {
                this.unmountItem(i, this.mHostsByMarker);
                this.mPrepareMountStats.unmountedCount++;
                continue;
            }
            if (newPosition != i) {
                oldItem.getHost().moveItem(oldItem, i, newPosition);
                this.mPrepareMountStats.movedCount++;
                continue;
            }
            this.mPrepareMountStats.unchangedCount++;
        }
        return this.mPrepareMountStats;
    }

    private void updateMountedContent(MountItem item, LayoutOutput layoutOutput, Component previousComponent) {
        Component newComponent = layoutOutput.getComponent();
        if (Component.isHostSpec(newComponent)) {
            return;
        }
        Object previousContent = item.getContent();
        previousComponent.unmount(this.getContextForComponent(previousComponent), previousContent);
        newComponent.mount(this.getContextForComponent(newComponent), previousContent);
    }

    private void mountLayoutOutput(int index, LayoutOutput layoutOutput, LayoutState layoutState) {
        Component component;
        long startTime = System.nanoTime();
        long hostMarker = layoutOutput.getHostMarker();
        ComponentHost host = (ComponentHost)((Object)this.mHostsByMarker.get(hostMarker));
        if (host == null) {
            int hostMountIndex = layoutState.getLayoutOutputPositionForId(hostMarker);
            LayoutOutput hostLayoutOutput = layoutState.getMountableOutputAt(hostMountIndex);
            this.mountLayoutOutput(hostMountIndex, hostLayoutOutput, layoutState);
            host = (ComponentHost)((Object)this.mHostsByMarker.get(hostMarker));
        }
        if ((component = layoutOutput.getComponent()) == null) {
            throw new RuntimeException("Trying to mount a LayoutOutput with a null Component.");
        }
        Object content = ComponentsPools.acquireMountContent(this.mContext.getAndroidContext(), component);
        ComponentContext context = this.getContextForComponent(component);
        component.mount(context, content);
        if (Component.isHostSpec(component)) {
            ComponentHost componentHost = (ComponentHost)((Object)content);
            componentHost.setParentHostMarker(hostMarker);
            this.registerHost(layoutOutput.getId(), componentHost);
        }
        MountItem item = this.mountContent(index, component, content, host, layoutOutput);
        this.bindComponentToContent(component, content);
        item.setIsBound(true);
        MountState.getActualBounds(layoutOutput, layoutState, sTempRect);
        MountState.applyBoundsToMountContent(item.getContent(), MountState.sTempRect.left, MountState.sTempRect.top, MountState.sTempRect.right, MountState.sTempRect.bottom, true);
        if (this.mMountStats.isLoggingEnabled) {
            this.mMountStats.mountTimes.add((double)(System.nanoTime() - startTime) / 1000000.0);
            this.mMountStats.mountedNames.add(component.getSimpleName());
            this.mMountStats.mountedCount++;
            this.mMountStats.extras.add(LogTreePopulator.getAnnotationBundleFromLogger(component, context.getLogger()));
        }
    }

    private MountItem mountContent(int index, Component component, Object content, ComponentHost host, LayoutOutput layoutOutput) {
        MountItem item = new MountItem(component, host, content, layoutOutput);
        this.mIndexToItemMap.put(this.mLayoutOutputsIds[index], (Object)item);
        if (component.hasChildLithoViews()) {
            this.mCanMountIncrementallyMountItems.put(this.mLayoutOutputsIds[index], (Object)item);
        }
        layoutOutput.getMountBounds(sTempRect);
        host.mount(index, item, sTempRect);
        MountState.setViewAttributes(item);
        return item;
    }

    private static void applyBoundsToMountContent(Object content, int left, int top, int right, int bottom, boolean force) {
        ThreadUtils.assertMainThread();
        if (content instanceof View) {
            BoundsHelper.applyBoundsToView((View)content, left, top, right, bottom, force);
        } else if (content instanceof Drawable) {
            ((Drawable)content).setBounds(left, top, right, bottom);
        } else {
            throw new IllegalStateException("Unsupported mounted content " + content);
        }
    }

    private static void getActualBounds(LayoutOutput layoutOutput, LayoutState layoutState, Rect outRect) {
        long actualHostMarker = layoutOutput.getHostMarker();
        layoutOutput.getMountBounds(outRect);
        long hostMarker = layoutOutput.getHostMarker();
        while (hostMarker != actualHostMarker) {
            LayoutOutput ancestor = layoutState.getLayoutOutput(hostMarker);
            ancestor.getMountBounds(sTempRect2);
            outRect.offset(MountState.sTempRect2.left, MountState.sTempRect2.top);
            hostMarker = ancestor.getHostMarker();
        }
    }

    private static void setViewAttributes(MountItem item) {
        Component component = item.getComponent();
        if (!Component.isMountViewSpec(component)) {
            return;
        }
        View view = (View)item.getContent();
        NodeInfo nodeInfo = item.getNodeInfo();
        if (nodeInfo != null) {
            MountState.setClickHandler(nodeInfo.getClickHandler(), view);
            MountState.setLongClickHandler(nodeInfo.getLongClickHandler(), view);
            MountState.setFocusChangeHandler(nodeInfo.getFocusChangeHandler(), view);
            MountState.setTouchHandler(nodeInfo.getTouchHandler(), view);
            MountState.setInterceptTouchHandler(nodeInfo.getInterceptTouchHandler(), view);
            MountState.setAccessibilityDelegate(view, nodeInfo);
            MountState.setViewTag(view, nodeInfo.getViewTag());
            MountState.setViewTags(view, nodeInfo.getViewTags());
            MountState.setShadowElevation(view, nodeInfo.getShadowElevation());
            MountState.setOutlineProvider(view, nodeInfo.getOutlineProvider());
            MountState.setClipToOutline(view, nodeInfo.getClipToOutline());
            MountState.setClipChildren(view, nodeInfo);
            MountState.setContentDescription(view, nodeInfo.getContentDescription());
            MountState.setFocusable(view, nodeInfo.getFocusState());
            MountState.setClickable(view, nodeInfo.getClickableState());
            MountState.setEnabled(view, nodeInfo.getEnabledState());
            MountState.setSelected(view, nodeInfo.getSelectedState());
            MountState.setScale(view, nodeInfo);
            MountState.setAlpha(view, nodeInfo);
            MountState.setRotation(view, nodeInfo);
            MountState.setRotationX(view, nodeInfo);
            MountState.setRotationY(view, nodeInfo);
        }
        MountState.setImportantForAccessibility(view, item.getImportantForAccessibility());
        ViewNodeInfo viewNodeInfo = item.getViewNodeInfo();
        if (viewNodeInfo != null) {
            MountState.setViewStateListAnimator(view, viewNodeInfo);
            if (!Component.isHostSpec(component)) {
                MountState.setViewBackground(view, viewNodeInfo);
                MountState.setViewPadding(view, viewNodeInfo);
                MountState.setViewForeground(view, viewNodeInfo);
                MountState.setViewLayoutDirection(view, viewNodeInfo);
            }
        }
    }

    private static void maybeUnsetViewAttributes(MountItem item) {
        Component component = item.getComponent();
        if (!Component.isMountViewSpec(component)) {
            return;
        }
        MountState.unsetViewAttributes(item, Component.isHostSpec(component));
    }

    private static void unsetViewAttributes(MountItem item, boolean isHostView) {
        View view = (View)item.getContent();
        NodeInfo nodeInfo = item.getNodeInfo();
        if (nodeInfo != null) {
            if (nodeInfo.getClickHandler() != null) {
                MountState.unsetClickHandler(view);
            }
            if (nodeInfo.getLongClickHandler() != null) {
                MountState.unsetLongClickHandler(view);
            }
            if (nodeInfo.getFocusChangeHandler() != null) {
                MountState.unsetFocusChangeHandler(view);
            }
            if (nodeInfo.getTouchHandler() != null) {
                MountState.unsetTouchHandler(view);
            }
            if (nodeInfo.getInterceptTouchHandler() != null) {
                MountState.unsetInterceptTouchEventHandler(view);
            }
            MountState.unsetViewTag(view);
            MountState.unsetViewTags(view, nodeInfo.getViewTags());
            MountState.unsetShadowElevation(view, nodeInfo.getShadowElevation());
            MountState.unsetOutlineProvider(view, nodeInfo.getOutlineProvider());
            MountState.unsetClipToOutline(view, nodeInfo.getClipToOutline());
            MountState.unsetClipChildren(view, nodeInfo.getClipChildren());
            if (!TextUtils.isEmpty((CharSequence)nodeInfo.getContentDescription())) {
                MountState.unsetContentDescription(view);
            }
            MountState.unsetScale(view, nodeInfo);
            MountState.unsetAlpha(view, nodeInfo);
            MountState.unsetRotation(view, nodeInfo);
            MountState.unsetRotationX(view, nodeInfo);
            MountState.unsetRotationY(view, nodeInfo);
        }
        view.setClickable(item.isViewClickable());
        view.setLongClickable(item.isViewLongClickable());
        MountState.unsetFocusable(view, item);
        MountState.unsetEnabled(view, item);
        MountState.unsetSelected(view, item);
        if (item.getImportantForAccessibility() != 0) {
            MountState.unsetImportantForAccessibility(view);
        }
        MountState.unsetAccessibilityDelegate(view);
        ViewNodeInfo viewNodeInfo = item.getViewNodeInfo();
        if (viewNodeInfo != null) {
            MountState.unsetViewStateListAnimator(view, viewNodeInfo);
            if (!isHostView) {
                MountState.unsetViewPadding(view, viewNodeInfo);
                MountState.unsetViewBackground(view, viewNodeInfo);
                MountState.unsetViewForeground(view, viewNodeInfo);
                MountState.unsetViewLayoutDirection(view);
            }
        }
    }

    private static void setAccessibilityDelegate(View view, NodeInfo nodeInfo) {
        if (!(view instanceof ComponentHost) && !nodeInfo.needsAccessibilityDelegate()) {
            return;
        }
        view.setTag(R.id.component_node_info, (Object)nodeInfo);
    }

    private static void unsetAccessibilityDelegate(View view) {
        if (!(view instanceof ComponentHost) && view.getTag(R.id.component_node_info) == null) {
            return;
        }
        view.setTag(R.id.component_node_info, null);
        if (!(view instanceof ComponentHost)) {
            ViewCompat.setAccessibilityDelegate((View)view, null);
        }
    }

    private static void setClickHandler(EventHandler<ClickEvent> clickHandler, View view) {
        if (clickHandler == null) {
            return;
        }
        ComponentClickListener listener = MountState.getComponentClickListener(view);
        if (listener == null) {
            listener = new ComponentClickListener();
            MountState.setComponentClickListener(view, listener);
        }
        listener.setEventHandler(clickHandler);
        view.setClickable(true);
    }

    private static void unsetClickHandler(View view) {
        ComponentClickListener listener = MountState.getComponentClickListener(view);
        if (listener != null) {
            listener.setEventHandler(null);
        }
    }

    static ComponentClickListener getComponentClickListener(View v) {
        if (v instanceof ComponentHost) {
            return ((ComponentHost)v).getComponentClickListener();
        }
        return (ComponentClickListener)v.getTag(R.id.component_click_listener);
    }

    static void setComponentClickListener(View v, ComponentClickListener listener) {
        if (v instanceof ComponentHost) {
            ((ComponentHost)v).setComponentClickListener(listener);
        } else {
            v.setOnClickListener((View.OnClickListener)listener);
            v.setTag(R.id.component_click_listener, (Object)listener);
        }
    }

    private static void setLongClickHandler(EventHandler<LongClickEvent> longClickHandler, View view) {
        if (longClickHandler != null) {
            ComponentLongClickListener listener = MountState.getComponentLongClickListener(view);
            if (listener == null) {
                listener = new ComponentLongClickListener();
                MountState.setComponentLongClickListener(view, listener);
            }
            listener.setEventHandler(longClickHandler);
            view.setLongClickable(true);
        }
    }

    private static void unsetLongClickHandler(View view) {
        ComponentLongClickListener listener = MountState.getComponentLongClickListener(view);
        if (listener != null) {
            listener.setEventHandler(null);
        }
    }

    static ComponentLongClickListener getComponentLongClickListener(View v) {
        if (v instanceof ComponentHost) {
            return ((ComponentHost)v).getComponentLongClickListener();
        }
        return (ComponentLongClickListener)v.getTag(R.id.component_long_click_listener);
    }

    static void setComponentLongClickListener(View v, ComponentLongClickListener listener) {
        if (v instanceof ComponentHost) {
            ((ComponentHost)v).setComponentLongClickListener(listener);
        } else {
            v.setOnLongClickListener((View.OnLongClickListener)listener);
            v.setTag(R.id.component_long_click_listener, (Object)listener);
        }
    }

    private static void setFocusChangeHandler(EventHandler<FocusChangedEvent> focusChangeHandler, View view) {
        if (focusChangeHandler == null) {
            return;
        }
        ComponentFocusChangeListener listener = MountState.getComponentFocusChangeListener(view);
        if (listener == null) {
            listener = new ComponentFocusChangeListener();
            MountState.setComponentFocusChangeListener(view, listener);
        }
        listener.setEventHandler(focusChangeHandler);
    }

    private static void unsetFocusChangeHandler(View view) {
        ComponentFocusChangeListener listener = MountState.getComponentFocusChangeListener(view);
        if (listener != null) {
            listener.setEventHandler(null);
        }
    }

    static ComponentFocusChangeListener getComponentFocusChangeListener(View v) {
        if (v instanceof ComponentHost) {
            return ((ComponentHost)v).getComponentFocusChangeListener();
        }
        return (ComponentFocusChangeListener)v.getTag(R.id.component_focus_change_listener);
    }

    static void setComponentFocusChangeListener(View v, ComponentFocusChangeListener listener) {
        if (v instanceof ComponentHost) {
            ((ComponentHost)v).setComponentFocusChangeListener(listener);
        } else {
            v.setOnFocusChangeListener((View.OnFocusChangeListener)listener);
            v.setTag(R.id.component_focus_change_listener, (Object)listener);
        }
    }

    private static void setTouchHandler(EventHandler<TouchEvent> touchHandler, View view) {
        if (touchHandler != null) {
            ComponentTouchListener listener = MountState.getComponentTouchListener(view);
            if (listener == null) {
                listener = new ComponentTouchListener();
                MountState.setComponentTouchListener(view, listener);
            }
            listener.setEventHandler(touchHandler);
        }
    }

    private static void unsetTouchHandler(View view) {
        ComponentTouchListener listener = MountState.getComponentTouchListener(view);
        if (listener != null) {
            listener.setEventHandler(null);
        }
    }

    private static void setInterceptTouchHandler(EventHandler<InterceptTouchEvent> interceptTouchHandler, View view) {
        if (interceptTouchHandler == null) {
            return;
        }
        if (view instanceof ComponentHost) {
            ((ComponentHost)view).setInterceptTouchEventHandler(interceptTouchHandler);
        }
    }

    private static void unsetInterceptTouchEventHandler(View view) {
        if (view instanceof ComponentHost) {
            ((ComponentHost)view).setInterceptTouchEventHandler(null);
        }
    }

    static ComponentTouchListener getComponentTouchListener(View v) {
        if (v instanceof ComponentHost) {
            return ((ComponentHost)v).getComponentTouchListener();
        }
        return (ComponentTouchListener)v.getTag(R.id.component_touch_listener);
    }

    static void setComponentTouchListener(View v, ComponentTouchListener listener) {
        if (v instanceof ComponentHost) {
            ((ComponentHost)v).setComponentTouchListener(listener);
        } else {
            v.setOnTouchListener((View.OnTouchListener)listener);
            v.setTag(R.id.component_touch_listener, (Object)listener);
        }
    }

    private static void setViewTag(View view, Object viewTag) {
        if (view instanceof ComponentHost) {
            ComponentHost host = (ComponentHost)view;
            host.setViewTag(viewTag);
        } else {
            view.setTag(viewTag);
        }
    }

    private static void setViewTags(View view, SparseArray<Object> viewTags) {
        if (viewTags == null) {
            return;
        }
        if (view instanceof ComponentHost) {
            ComponentHost host = (ComponentHost)view;
            host.setViewTags(viewTags);
        } else {
            int size = viewTags.size();
            for (int i = 0; i < size; ++i) {
                view.setTag(viewTags.keyAt(i), viewTags.valueAt(i));
            }
        }
    }

    private static void unsetViewTag(View view) {
        if (view instanceof ComponentHost) {
            ComponentHost host = (ComponentHost)view;
            host.setViewTag(null);
        } else {
            view.setTag(null);
        }
    }

    private static void unsetViewTags(View view, SparseArray<Object> viewTags) {
        if (view instanceof ComponentHost) {
            ComponentHost host = (ComponentHost)view;
            host.setViewTags(null);
        } else if (viewTags != null) {
            int size = viewTags.size();
            for (int i = 0; i < size; ++i) {
                view.setTag(viewTags.keyAt(i), null);
            }
        }
    }

    private static void setShadowElevation(View view, float shadowElevation) {
        if (shadowElevation != 0.0f) {
            ViewCompat.setElevation((View)view, (float)shadowElevation);
        }
    }

    private static void unsetShadowElevation(View view, float shadowElevation) {
        if (shadowElevation != 0.0f) {
            ViewCompat.setElevation((View)view, (float)0.0f);
        }
    }

    private static void setOutlineProvider(View view, ViewOutlineProvider outlineProvider) {
        if (outlineProvider != null && Build.VERSION.SDK_INT >= 21) {
            view.setOutlineProvider(outlineProvider);
        }
    }

    private static void unsetOutlineProvider(View view, ViewOutlineProvider outlineProvider) {
        if (outlineProvider != null && Build.VERSION.SDK_INT >= 21) {
            view.setOutlineProvider(ViewOutlineProvider.BACKGROUND);
        }
    }

    private static void setClipToOutline(View view, boolean clipToOutline) {
        if (clipToOutline && Build.VERSION.SDK_INT >= 21) {
            view.setClipToOutline(clipToOutline);
        }
    }

    private static void unsetClipToOutline(View view, boolean clipToOutline) {
        if (clipToOutline && Build.VERSION.SDK_INT >= 21) {
            view.setClipToOutline(false);
        }
    }

    private static void setClipChildren(View view, NodeInfo nodeInfo) {
        if (nodeInfo.isClipChildrenSet() && view instanceof ViewGroup) {
            ((ViewGroup)view).setClipChildren(nodeInfo.getClipChildren());
        }
    }

    private static void unsetClipChildren(View view, boolean clipChildren) {
        if (!clipChildren && view instanceof ViewGroup) {
            ((ViewGroup)view).setClipChildren(true);
        }
    }

    private static void setContentDescription(View view, CharSequence contentDescription) {
        if (TextUtils.isEmpty((CharSequence)contentDescription)) {
            return;
        }
        view.setContentDescription(contentDescription);
    }

    private static void unsetContentDescription(View view) {
        view.setContentDescription(null);
    }

    private static void setImportantForAccessibility(View view, int importantForAccessibility) {
        if (importantForAccessibility == 0) {
            return;
        }
        ViewCompat.setImportantForAccessibility((View)view, (int)importantForAccessibility);
    }

    private static void unsetImportantForAccessibility(View view) {
        ViewCompat.setImportantForAccessibility((View)view, (int)0);
    }

    private static void setFocusable(View view, int focusState) {
        if (focusState == 1) {
            view.setFocusable(true);
        } else if (focusState == 2) {
            view.setFocusable(false);
        }
    }

    private static void unsetFocusable(View view, MountItem mountItem) {
        view.setFocusable(mountItem.isViewFocusable());
    }

    private static void setClickable(View view, int clickableState) {
        if (clickableState == 1) {
            view.setClickable(true);
        } else if (clickableState == 2) {
            view.setClickable(false);
        }
    }

    private static void setEnabled(View view, int enabledState) {
        if (enabledState == 1) {
            view.setEnabled(true);
        } else if (enabledState == 2) {
            view.setEnabled(false);
        }
    }

    private static void unsetEnabled(View view, MountItem mountItem) {
        view.setEnabled(mountItem.isViewEnabled());
    }

    private static void setSelected(View view, int selectedState) {
        if (selectedState == 1) {
            view.setSelected(true);
        } else if (selectedState == 2) {
            view.setSelected(false);
        }
    }

    private static void unsetSelected(View view, MountItem mountItem) {
        view.setSelected(mountItem.isViewSelected());
    }

    private static void setScale(View view, NodeInfo nodeInfo) {
        if (Build.VERSION.SDK_INT >= 11 && nodeInfo.isScaleSet()) {
            float scale = nodeInfo.getScale();
            view.setScaleX(scale);
            view.setScaleY(scale);
        }
    }

    private static void unsetScale(View view, NodeInfo nodeInfo) {
        if (Build.VERSION.SDK_INT >= 11 && nodeInfo.isScaleSet()) {
            if (view.getScaleX() != 1.0f) {
                view.setScaleX(1.0f);
            }
            if (view.getScaleY() != 1.0f) {
                view.setScaleY(1.0f);
            }
        }
    }

    private static void setAlpha(View view, NodeInfo nodeInfo) {
        if (Build.VERSION.SDK_INT >= 11 && nodeInfo.isAlphaSet()) {
            view.setAlpha(nodeInfo.getAlpha());
        }
    }

    private static void unsetAlpha(View view, NodeInfo nodeInfo) {
        if (Build.VERSION.SDK_INT >= 11 && nodeInfo.isAlphaSet() && view.getAlpha() != 1.0f) {
            view.setAlpha(1.0f);
        }
    }

    private static void setRotation(View view, NodeInfo nodeInfo) {
        if (Build.VERSION.SDK_INT >= 11 && nodeInfo.isRotationSet()) {
            view.setRotation(nodeInfo.getRotation());
        }
    }

    private static void unsetRotation(View view, NodeInfo nodeInfo) {
        if (Build.VERSION.SDK_INT >= 11 && nodeInfo.isRotationSet() && view.getRotation() != 0.0f) {
            view.setRotation(0.0f);
        }
    }

    private static void setRotationX(View view, NodeInfo nodeInfo) {
        if (Build.VERSION.SDK_INT >= 11 && nodeInfo.isRotationXSet()) {
            view.setRotationX(nodeInfo.getRotationX());
        }
    }

    private static void unsetRotationX(View view, NodeInfo nodeInfo) {
        if (Build.VERSION.SDK_INT >= 11 && nodeInfo.isRotationXSet() && view.getRotationX() != 0.0f) {
            view.setRotationX(0.0f);
        }
    }

    private static void setRotationY(View view, NodeInfo nodeInfo) {
        if (Build.VERSION.SDK_INT >= 11 && nodeInfo.isRotationYSet()) {
            view.setRotationY(nodeInfo.getRotationY());
        }
    }

    private static void unsetRotationY(View view, NodeInfo nodeInfo) {
        if (Build.VERSION.SDK_INT >= 11 && nodeInfo.isRotationYSet() && view.getRotationY() != 0.0f) {
            view.setRotationY(0.0f);
        }
    }

    private static void setViewPadding(View view, ViewNodeInfo viewNodeInfo) {
        if (!viewNodeInfo.hasPadding()) {
            return;
        }
        view.setPadding(viewNodeInfo.getPaddingLeft(), viewNodeInfo.getPaddingTop(), viewNodeInfo.getPaddingRight(), viewNodeInfo.getPaddingBottom());
    }

    private static void unsetViewPadding(View view, ViewNodeInfo viewNodeInfo) {
        if (!viewNodeInfo.hasPadding()) {
            return;
        }
        view.setPadding(0, 0, 0, 0);
    }

    private static void setViewBackground(View view, ViewNodeInfo viewNodeInfo) {
        ComparableDrawable background = viewNodeInfo.getBackground();
        if (background != null) {
            MountState.setBackgroundCompat(view, background);
        }
    }

    private static void unsetViewBackground(View view, ViewNodeInfo viewNodeInfo) {
        ComparableDrawable background = viewNodeInfo.getBackground();
        if (background != null) {
            MountState.setBackgroundCompat(view, null);
        }
    }

    private static void setBackgroundCompat(View view, Drawable drawable) {
        if (Build.VERSION.SDK_INT < 16) {
            view.setBackgroundDrawable(drawable);
        } else {
            view.setBackground(drawable);
        }
    }

    private static void setViewForeground(View view, ViewNodeInfo viewNodeInfo) {
        ComparableDrawable foreground = viewNodeInfo.getForeground();
        if (foreground != null) {
            if (Build.VERSION.SDK_INT < 23) {
                throw new IllegalStateException("MountState has a ViewNodeInfo with foreground however the current Android version doesn't support foreground on Views");
            }
            view.setForeground((Drawable)foreground);
        }
    }

    private static void unsetViewForeground(View view, ViewNodeInfo viewNodeInfo) {
        ComparableDrawable foreground = viewNodeInfo.getForeground();
        if (foreground != null) {
            if (Build.VERSION.SDK_INT < 23) {
                throw new IllegalStateException("MountState has a ViewNodeInfo with foreground however the current Android version doesn't support foreground on Views");
            }
            view.setForeground(null);
        }
    }

    private static void setViewLayoutDirection(View view, ViewNodeInfo viewNodeInfo) {
        int viewLayoutDirection;
        if (Build.VERSION.SDK_INT < 17) {
            return;
        }
        switch (viewNodeInfo.getLayoutDirection()) {
            case LTR: {
                viewLayoutDirection = 0;
                break;
            }
            case RTL: {
                viewLayoutDirection = 1;
                break;
            }
            default: {
                viewLayoutDirection = 2;
            }
        }
        view.setLayoutDirection(viewLayoutDirection);
    }

    private static void unsetViewLayoutDirection(View view) {
        if (Build.VERSION.SDK_INT < 17) {
            return;
        }
        view.setLayoutDirection(2);
    }

    private static void setViewStateListAnimator(View view, ViewNodeInfo viewNodeInfo) {
        StateListAnimator stateListAnimator = viewNodeInfo.getStateListAnimator();
        int stateListAnimatorRes = viewNodeInfo.getStateListAnimatorRes();
        if (stateListAnimator == null && stateListAnimatorRes == 0) {
            return;
        }
        if (Build.VERSION.SDK_INT < 21) {
            throw new IllegalStateException("MountState has a ViewNodeInfo with stateListAnimator, however the current Android version doesn't support stateListAnimator on Views");
        }
        if (stateListAnimator == null) {
            stateListAnimator = AnimatorInflater.loadStateListAnimator((Context)view.getContext(), (int)stateListAnimatorRes);
        }
        view.setStateListAnimator(stateListAnimator);
    }

    private static void unsetViewStateListAnimator(View view, ViewNodeInfo viewNodeInfo) {
        if (viewNodeInfo.getStateListAnimator() == null && viewNodeInfo.getStateListAnimatorRes() == 0) {
            return;
        }
        if (Build.VERSION.SDK_INT < 21) {
            throw new IllegalStateException("MountState has a ViewNodeInfo with stateListAnimator, however the current Android version doesn't support stateListAnimator on Views");
        }
        view.setStateListAnimator(null);
    }

    private static void mountItemIncrementally(MountItem item, boolean processVisibilityOutputs) {
        Component component = item.getComponent();
        if (!Component.isMountViewSpec(component)) {
            return;
        }
        View view = (View)item.getContent();
        MountState.mountViewIncrementally(view, processVisibilityOutputs);
    }

    private static void mountViewIncrementally(View view, boolean processVisibilityOutputs) {
        ThreadUtils.assertMainThread();
        if (view instanceof LithoView) {
            LithoView lithoView = (LithoView)view;
            if (lithoView.isIncrementalMountEnabled()) {
                if (!processVisibilityOutputs) {
                    lithoView.performIncrementalMount(new Rect(0, 0, view.getWidth(), view.getHeight()), false);
                } else {
                    lithoView.performIncrementalMount();
                }
            }
        } else if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View childView = viewGroup.getChildAt(i);
                MountState.mountViewIncrementally(childView, processVisibilityOutputs);
            }
        }
    }

    private void unmountDisappearingItemChild(ComponentContext context, MountItem item) {
        int index;
        ComponentHost host;
        this.maybeRemoveAnimatingMountContent(item.getTransitionId());
        Object content = item.getContent();
        if (content instanceof ComponentHost) {
            host = (ComponentHost)((Object)content);
            for (int i = host.getMountItemCount() - 1; i >= 0; --i) {
                MountItem mountItem = host.getMountItemAt(i);
                this.unmountDisappearingItemChild(context, mountItem);
            }
            if (host.getMountItemCount() > 0) {
                throw new IllegalStateException("Recursively unmounting items from a ComponentHost, left some items behind maybe because not tracked by its MountState");
            }
        }
        host = item.getHost();
        host.unmount(item);
        MountState.maybeUnsetViewAttributes(item);
        this.unbindAndUnmountLifecycle(item);
        if (item.getComponent().hasChildLithoViews() && (index = this.mCanMountIncrementallyMountItems.indexOfValue((Object)item)) > 0) {
            this.mCanMountIncrementallyMountItems.removeAt(index);
        }
        this.assertNoDanglingMountContent(item);
        item.releaseMountContent(context.getAndroidContext());
    }

    private void assertNoDanglingMountContent(MountItem item) {
        int index = this.mIndexToItemMap.indexOfValue((Object)item);
        if (index > -1) {
            long id2 = this.mIndexToItemMap.keyAt(index);
            int layoutOutputIndex = -1;
            for (int i = 0; i < this.mLayoutOutputsIds.length; ++i) {
                if (id2 != this.mLayoutOutputsIds[i]) continue;
                layoutOutputIndex = i;
                break;
            }
            throw new RuntimeException("Got dangling mount content during animation: index=" + layoutOutputIndex + ", mapIndex=" + index + ", id=" + id2 + ", disappearRange=[" + this.mLastDisappearRangeStart + "," + this.mLastDisappearRangeEnd + "], contentType=" + item.getContent().getClass() + ", component=" + (item.getComponent() != null ? item.getComponent().getSimpleName() : null) + ", transitionId=" + item.getTransitionId() + ", host=" + (Object)((Object)item.getHost()) + ", isRootHost=" + (this.mHostsByMarker.get(0L) == item.getHost()));
        }
    }

    void unmountAllItems() {
        ThreadUtils.assertMainThread();
        if (this.mLayoutOutputsIds == null) {
            return;
        }
        for (int i = this.mLayoutOutputsIds.length - 1; i >= 0; --i) {
            this.unmountItem(i, this.mHostsByMarker);
        }
        this.mPreviousLocalVisibleRect.setEmpty();
        this.mNeedsRemount = true;
    }

    private void unmountItem(int index, LongSparseArray<ComponentHost> hostsByMarker) {
        String rootComponentName;
        int i;
        ComponentHost host;
        MountItem item = this.getItemAt(index);
        long startTime = System.nanoTime();
        if (item == null) {
            return;
        }
        if (this.mLayoutOutputsIds[index] == 0L) {
            MountState.unsetViewAttributes(item, true);
            return;
        }
        Object content = item.getContent();
        if (content instanceof ComponentHost && !(content instanceof LithoView)) {
            host = (ComponentHost)((Object)content);
            block0: for (i = host.getMountItemCount() - 1; i >= 0; --i) {
                MountItem mountItem = host.getMountItemAt(i);
                long layoutOutputId = this.mIndexToItemMap.keyAt(this.mIndexToItemMap.indexOfValue((Object)mountItem));
                for (int mountIndex = this.mLayoutOutputsIds.length - 1; mountIndex >= 0; --mountIndex) {
                    if (this.mLayoutOutputsIds[mountIndex] != layoutOutputId) continue;
                    this.unmountItem(mountIndex, hostsByMarker);
                    continue block0;
                }
            }
            if (host.getMountItemCount() > 0) {
                throw new IllegalStateException("Recursively unmounting items from a ComponentHost, left some items behind maybe because not tracked by its MountState");
            }
        }
        if (content instanceof HasLithoViewChildren) {
            ArrayList<LithoView> lithoViews = new ArrayList<LithoView>();
            ((HasLithoViewChildren)content).obtainLithoViewChildren(lithoViews);
            for (i = lithoViews.size() - 1; i >= 0; --i) {
                LithoView lithoView = lithoViews.get(i);
                lithoView.unmountAllItems();
            }
        }
        host = item.getHost();
        host.unmount(index, item);
        MountState.maybeUnsetViewAttributes(item);
        Component component = item.getComponent();
        if (Component.isHostSpec(component)) {
            ComponentHost componentHost = (ComponentHost)((Object)content);
            hostsByMarker.removeAt(hostsByMarker.indexOfValue((Object)componentHost));
            this.removeDisappearingMountContentFromComponentHost(componentHost);
        }
        this.unbindAndUnmountLifecycle(item);
        long layoutOutputId = this.mLayoutOutputsIds[index];
        this.mIndexToItemMap.remove(layoutOutputId);
        if (item.hasTransitionId()) {
            int type = LayoutStateOutputIdCalculator.getTypeFromId(layoutOutputId);
            this.maybeRemoveAnimatingMountContent(item.getTransitionId(), type);
        }
        if (component.hasChildLithoViews()) {
            this.mCanMountIncrementallyMountItems.delete(this.mLayoutOutputsIds[index]);
        }
        String string = rootComponentName = this.mLastMountedLayoutState == null ? "null_layout" : this.mLastMountedLayoutState.mRootComponentName;
        if (!Component.isHostSpec(component) || !ComponentHostRecycleUtil.shouldSkipRecyclingComponentHost(index, rootComponentName)) {
            item.releaseMountContent(this.mContext.getAndroidContext());
        }
        if (this.mMountStats.isLoggingEnabled) {
            this.mMountStats.unmountedTimes.add((double)(System.nanoTime() - startTime) / 1000000.0);
            this.mMountStats.unmountedNames.add(component.getSimpleName());
            this.mMountStats.unmountedCount++;
        }
    }

    private void unbindAndUnmountLifecycle(MountItem item) {
        Component component = item.getComponent();
        Object content = item.getContent();
        ComponentContext context = this.getContextForComponent(component);
        if (item.isBound()) {
            component.onUnbind(context, content);
            item.setIsBound(false);
        }
        component.unmount(context, content);
    }

    private void endUnmountDisappearingItem(OutputUnitsAffinityGroup<MountItem> group) {
        this.maybeRemoveAnimatingMountContent(group.getMostSignificantUnit().getTransitionId());
        int size = group.size();
        for (int i = 0; i < size; ++i) {
            int index;
            MountItem item = group.getAt(i);
            if (group.typeAt(i) == 3) {
                ComponentHost content = (ComponentHost)((Object)item.getContent());
                for (int j = content.getMountItemCount() - 1; j >= 0; --j) {
                    MountItem mountItem = content.getMountItemAt(j);
                    this.unmountDisappearingItemChild(this.mContext, mountItem);
                }
                if (content.getMountItemCount() > 0) {
                    throw new IllegalStateException("Recursively unmounting items from a ComponentHost, left some items behind maybe because not tracked by its MountState");
                }
            }
            ComponentHost host = item.getHost();
            host.unmountDisappearingItem(item);
            MountState.maybeUnsetViewAttributes(item);
            this.unbindAndUnmountLifecycle(item);
            if (item.getComponent().hasChildLithoViews() && (index = this.mCanMountIncrementallyMountItems.indexOfValue((Object)item)) > 0) {
                this.mCanMountIncrementallyMountItems.removeAt(index);
            }
            this.assertNoDanglingMountContent(item);
            item.releaseMountContent(this.mContext.getAndroidContext());
        }
    }

    int getItemCount() {
        ThreadUtils.assertMainThread();
        return this.mLayoutOutputsIds == null ? 0 : this.mLayoutOutputsIds.length;
    }

    MountItem getItemAt(int i) {
        ThreadUtils.assertMainThread();
        return (MountItem)this.mIndexToItemMap.get(this.mLayoutOutputsIds[i]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTransitions(LayoutState layoutState, ComponentTree componentTree) {
        if (!this.mIsDirty) {
            throw new RuntimeException("Should only process transitions on dirty mounts");
        }
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            String logTag = componentTree.getContext().getLogTag();
            if (logTag == null) {
                ComponentsSystrace.beginSection("MountState.updateTransitions");
            } else {
                ComponentsSystrace.beginSection("MountState.updateTransitions:" + logTag);
            }
        }
        try {
            int componentTreeId = layoutState.getComponentTreeId();
            if (this.mLastMountedComponentTreeId != componentTreeId) {
                this.resetAnimationState();
                if (!this.mIsFirstMountOfComponentTree) {
                    return;
                }
            }
            if (!this.mDisappearingMountItems.isEmpty()) {
                this.updateDisappearingMountItems(layoutState);
            }
            if (this.shouldAnimateTransitions(layoutState)) {
                this.collectAllTransitions(layoutState, componentTree);
                if (this.hasTransitionsToAnimate()) {
                    this.createNewTransitions(layoutState, this.mRootTransition);
                }
            }
            this.mAnimationLockedIndices = null;
            if (!this.mAnimatingTransitionIds.isEmpty()) {
                this.regenerateAnimationLockedIndices(layoutState);
            }
        }
        finally {
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
        }
    }

    private void resetAnimationState() {
        if (this.mTransitionManager == null) {
            return;
        }
        for (OutputUnitsAffinityGroup<MountItem> group : this.mDisappearingMountItems.values()) {
            this.endUnmountDisappearingItem(group);
        }
        this.mDisappearingMountItems.clear();
        this.mAnimatingTransitionIds.clear();
        this.mTransitionManager.reset();
        this.mAnimationLockedIndices = null;
    }

    private void updateDisappearingMountItems(LayoutState newLayoutState) {
        Map<TransitionId, OutputUnitsAffinityGroup<LayoutOutput>> nextMountedTransitionIds = newLayoutState.getTransitionIdMapping();
        for (TransitionId transitionId : nextMountedTransitionIds.keySet()) {
            OutputUnitsAffinityGroup<MountItem> disappearingItem = this.mDisappearingMountItems.remove(transitionId);
            if (disappearingItem == null) continue;
            this.endUnmountDisappearingItem(disappearingItem);
        }
    }

    private void createNewTransitions(LayoutState newLayoutState, Transition rootTransition) {
        this.prepareTransitionManager();
        this.mTransitionManager.setupTransitions(this.mLastMountedLayoutState, newLayoutState, rootTransition);
        Map<TransitionId, OutputUnitsAffinityGroup<LayoutOutput>> nextTransitionIds = newLayoutState.getTransitionIdMapping();
        for (TransitionId transitionId : nextTransitionIds.keySet()) {
            if (!this.mTransitionManager.isAnimating(transitionId)) continue;
            this.mAnimatingTransitionIds.add(transitionId);
        }
    }

    private void regenerateAnimationLockedIndices(LayoutState newLayoutState) {
        Map<TransitionId, OutputUnitsAffinityGroup<LayoutOutput>> transitionMapping = newLayoutState.getTransitionIdMapping();
        if (transitionMapping != null) {
            for (TransitionId transitionId : transitionMapping.keySet()) {
                if (!this.mAnimatingTransitionIds.contains(transitionId)) continue;
                if (this.mAnimationLockedIndices == null) {
                    this.mAnimationLockedIndices = new int[newLayoutState.getMountableOutputCount()];
                }
                OutputUnitsAffinityGroup<LayoutOutput> group = transitionMapping.get(transitionId);
                int sz = group.size();
                for (int j = 0; j < sz; ++j) {
                    LayoutOutput layoutOutput = group.getAt(j);
                    int position = newLayoutState.getLayoutOutputPositionForId(layoutOutput.getId());
                    this.updateAnimationLockCount(newLayoutState, position, true);
                }
            }
        } else {
            this.mAnimationLockedIndices = null;
        }
        if (AnimationsDebug.ENABLED) {
            AnimationsDebug.debugPrintAnimationLockedIndices(newLayoutState, this.mAnimationLockedIndices);
        }
    }

    private int findLastDescendantIndex(LayoutState layoutState, int index) {
        LayoutOutput host = layoutState.getMountableOutputAt(index);
        long hostId = host.getId();
        int size = layoutState.getMountableOutputCount();
        for (int i = index + 1; i < size; ++i) {
            LayoutOutput layoutOutput = layoutState.getMountableOutputAt(i);
            long curentHostId = layoutOutput.getHostMarker();
            while (curentHostId != hostId) {
                if (curentHostId == 0L) {
                    return i - 1;
                }
                int parentIndex = layoutState.getLayoutOutputPositionForId(curentHostId);
                LayoutOutput parent = layoutState.getMountableOutputAt(parentIndex);
                curentHostId = parent.getHostMarker();
            }
        }
        return layoutState.getMountableOutputCount() - 1;
    }

    private void updateAnimationLockCount(LayoutState layoutState, int index, boolean increment) {
        int lastDescendantIndex = this.findLastDescendantIndex(layoutState, index);
        for (int i = index; i <= lastDescendantIndex; ++i) {
            if (increment) {
                int n = i;
                this.mAnimationLockedIndices[n] = this.mAnimationLockedIndices[n] + 1;
                continue;
            }
            int n = i;
            this.mAnimationLockedIndices[n] = this.mAnimationLockedIndices[n] - 1;
            if (this.mAnimationLockedIndices[n] >= 0) continue;
            ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.FATAL, "Decremented animation lock count below 0!");
            this.mAnimationLockedIndices[i] = 0;
        }
        long hostId = layoutState.getMountableOutputAt(index).getHostMarker();
        while (hostId != 0L) {
            int hostIndex = layoutState.getLayoutOutputPositionForId(hostId);
            if (increment) {
                int n = hostIndex;
                this.mAnimationLockedIndices[n] = this.mAnimationLockedIndices[n] + 1;
            } else {
                int n = hostIndex;
                this.mAnimationLockedIndices[n] = this.mAnimationLockedIndices[n] - 1;
                if (this.mAnimationLockedIndices[n] < 0) {
                    ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.FATAL, "Decremented animation lock count below 0!");
                    this.mAnimationLockedIndices[hostIndex] = 0;
                }
            }
            hostId = layoutState.getMountableOutputAt(hostIndex).getHostMarker();
        }
    }

    private boolean shouldAnimateTransitions(LayoutState newLayoutState) {
        return this.mIsDirty && (this.mLastMountedComponentTreeId == newLayoutState.getComponentTreeId() || this.mIsFirstMountOfComponentTree);
    }

    private boolean hasTransitionsToAnimate() {
        return this.mRootTransition != null;
    }

    @Override
    public void onAnimationComplete(TransitionId transitionId) {
        OutputUnitsAffinityGroup<MountItem> disappearingGroup = this.mDisappearingMountItems.remove(transitionId);
        if (disappearingGroup != null) {
            this.endUnmountDisappearingItem(disappearingGroup);
        } else {
            int i;
            OutputUnitsAffinityGroup<LayoutOutput> layoutOutputGroup;
            if (!this.mAnimatingTransitionIds.remove(transitionId) && AnimationsDebug.ENABLED) {
                Log.e((String)"LithoAnimationDebug", (String)("Ending animation for id " + transitionId + " but it wasn't recorded as animating!"));
            }
            if ((layoutOutputGroup = this.mLastMountedLayoutState.getLayoutOutputsForTransitionId(transitionId)) == null) {
                return;
            }
            int size = layoutOutputGroup.size();
            for (i = 0; i < size; ++i) {
                LayoutOutput layoutOutput = layoutOutputGroup.getAt(i);
                int position = layoutOutput.getIndex();
                this.updateAnimationLockCount(this.mLastMountedLayoutState, position, false);
            }
            if (ComponentsConfiguration.isDebugModeEnabled && this.mAnimatingTransitionIds.isEmpty()) {
                size = this.mAnimationLockedIndices.length;
                for (i = 0; i < size; ++i) {
                    if (this.mAnimationLockedIndices[i] == 0) continue;
                    throw new RuntimeException("No running animations but index " + i + " is still animation locked!");
                }
            }
        }
    }

    void unbind() {
        ThreadUtils.assertMainThread();
        if (this.mLayoutOutputsIds == null) {
            return;
        }
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("MountState.unbind");
        }
        int size = this.mLayoutOutputsIds.length;
        for (int i = 0; i < size; ++i) {
            MountItem mountItem = this.getItemAt(i);
            if (mountItem == null || !mountItem.isBound()) continue;
            this.unbindComponentFromContent(mountItem.getComponent(), mountItem.getContent());
            mountItem.setIsBound(false);
        }
        this.clearVisibilityItems();
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
    }

    void detach() {
        ThreadUtils.assertMainThread();
        this.unbind();
    }

    void rebind() {
        ThreadUtils.assertMainThread();
        if (this.mLayoutOutputsIds == null) {
            return;
        }
        int size = this.mLayoutOutputsIds.length;
        for (int i = 0; i < size; ++i) {
            MountItem mountItem = this.getItemAt(i);
            if (mountItem == null || mountItem.isBound()) continue;
            Component component = mountItem.getComponent();
            Object content = mountItem.getContent();
            this.bindComponentToContent(component, content);
            mountItem.setIsBound(true);
            if (!(content instanceof View) || content instanceof ComponentHost || !((View)content).isLayoutRequested()) continue;
            View view = (View)content;
            MountState.applyBoundsToMountContent(view, view.getLeft(), view.getTop(), view.getRight(), view.getBottom(), true);
        }
    }

    private boolean isAnimationLocked(int index) {
        if (this.mAnimationLockedIndices == null) {
            return false;
        }
        return this.mAnimationLockedIndices[index] > 0;
    }

    private boolean performIncrementalMount(LayoutState layoutState, Rect localVisibleRect, boolean processVisibilityOutputs) {
        int height;
        int layoutOutputIndex;
        if (this.mPreviousLocalVisibleRect.isEmpty()) {
            return false;
        }
        if (localVisibleRect.left != this.mPreviousLocalVisibleRect.left || localVisibleRect.right != this.mPreviousLocalVisibleRect.right) {
            return false;
        }
        ArrayList<LayoutOutput> layoutOutputTops = layoutState.getMountableOutputTops();
        ArrayList<LayoutOutput> layoutOutputBottoms = layoutState.getMountableOutputBottoms();
        int count = layoutState.getMountableOutputCount();
        if (localVisibleRect.top > 0 || this.mPreviousLocalVisibleRect.top > 0) {
            while (this.mPreviousBottomsIndex < count && localVisibleRect.top >= layoutOutputBottoms.get((int)this.mPreviousBottomsIndex).getBounds().bottom) {
                long id2 = layoutOutputBottoms.get(this.mPreviousBottomsIndex).getId();
                layoutOutputIndex = layoutState.getLayoutOutputPositionForId(id2);
                if (!this.isAnimationLocked(layoutOutputIndex)) {
                    this.unmountItem(layoutOutputIndex, this.mHostsByMarker);
                }
                ++this.mPreviousBottomsIndex;
            }
            while (this.mPreviousBottomsIndex > 0 && localVisibleRect.top < layoutOutputBottoms.get((int)(this.mPreviousBottomsIndex - 1)).getBounds().bottom) {
                --this.mPreviousBottomsIndex;
                LayoutOutput layoutOutput = layoutOutputBottoms.get(this.mPreviousBottomsIndex);
                int layoutOutputIndex2 = layoutState.getLayoutOutputPositionForId(layoutOutput.getId());
                if (this.getItemAt(layoutOutputIndex2) != null) continue;
                this.mountLayoutOutput(layoutState.getLayoutOutputPositionForId(layoutOutput.getId()), layoutOutput, layoutState);
                this.mComponentIdsMountedInThisFrame.add(layoutOutput.getId());
            }
        }
        if (localVisibleRect.bottom < (height = this.mLithoView.getHeight()) || this.mPreviousLocalVisibleRect.bottom < height) {
            while (this.mPreviousTopsIndex < count && localVisibleRect.bottom > layoutOutputTops.get((int)this.mPreviousTopsIndex).getBounds().top) {
                LayoutOutput layoutOutput = layoutOutputTops.get(this.mPreviousTopsIndex);
                layoutOutputIndex = layoutState.getLayoutOutputPositionForId(layoutOutput.getId());
                if (this.getItemAt(layoutOutputIndex) == null) {
                    this.mountLayoutOutput(layoutState.getLayoutOutputPositionForId(layoutOutput.getId()), layoutOutput, layoutState);
                    this.mComponentIdsMountedInThisFrame.add(layoutOutput.getId());
                }
                ++this.mPreviousTopsIndex;
            }
            while (this.mPreviousTopsIndex > 0 && localVisibleRect.bottom <= layoutOutputTops.get((int)(this.mPreviousTopsIndex - 1)).getBounds().top) {
                --this.mPreviousTopsIndex;
                long id3 = layoutOutputTops.get(this.mPreviousTopsIndex).getId();
                int layoutOutputIndex3 = layoutState.getLayoutOutputPositionForId(id3);
                if (this.isAnimationLocked(layoutOutputIndex3)) continue;
                this.unmountItem(layoutOutputIndex3, this.mHostsByMarker);
            }
        }
        int size = this.mCanMountIncrementallyMountItems.size();
        for (int i = 0; i < size; ++i) {
            int layoutOutputPosition;
            MountItem mountItem = (MountItem)this.mCanMountIncrementallyMountItems.valueAt(i);
            long layoutOutputId = this.mCanMountIncrementallyMountItems.keyAt(i);
            if (this.mComponentIdsMountedInThisFrame.contains(layoutOutputId) || (layoutOutputPosition = layoutState.getLayoutOutputPositionForId(layoutOutputId)) == -1) continue;
            MountState.mountItemIncrementally(mountItem, processVisibilityOutputs);
        }
        this.mComponentIdsMountedInThisFrame.clear();
        return true;
    }

    private void prepareTransitionManager() {
        if (this.mTransitionManager == null) {
            this.mTransitionManager = new TransitionManager(this, this);
        }
    }

    private void removeDisappearingMountContentFromComponentHost(ComponentHost componentHost) {
        if (componentHost.hasDisappearingItems()) {
            List<TransitionId> ids = componentHost.getDisappearingItemTransitionIds();
            int size = ids.size();
            for (int i = 0; i < size; ++i) {
                this.mTransitionManager.setMountContent(ids.get(i), null);
            }
        }
    }

    void collectAllTransitions(LayoutState layoutState, ComponentTree componentTree) {
        ThreadUtils.assertMainThread();
        if (this.mTransitionsHasBeenCollected) {
            return;
        }
        ArrayList<Transition> allTransitions = new ArrayList<Transition>();
        if (layoutState.getTransitions() != null) {
            allTransitions.addAll(layoutState.getTransitions());
        }
        componentTree.applyPreviousRenderData(layoutState);
        MountState.collectMountTimeTransitions(layoutState, allTransitions);
        componentTree.consumeStateUpdateTransitions(allTransitions, layoutState.mRootComponentName);
        Transition.RootBoundsTransition rootWidthTransition = new Transition.RootBoundsTransition();
        Transition.RootBoundsTransition rootHeightTransition = new Transition.RootBoundsTransition();
        TransitionId rootTransitionId = layoutState.getRootTransitionId();
        if (rootTransitionId != null) {
            int size = allTransitions.size();
            for (int i = 0; i < size; ++i) {
                Transition transition = allTransitions.get(i);
                if (transition == null) {
                    throw new IllegalStateException("NULL_TRANSITION when collecting root bounds anim. Root: " + layoutState.mRootComponentName + ", root TransitionId: " + rootTransitionId);
                }
                TransitionUtils.collectRootBoundsTransitions(rootTransitionId, transition, AnimatedProperties.WIDTH, rootWidthTransition);
                TransitionUtils.collectRootBoundsTransitions(rootTransitionId, transition, AnimatedProperties.HEIGHT, rootHeightTransition);
            }
        }
        rootWidthTransition = rootWidthTransition.hasTransition ? rootWidthTransition : null;
        rootHeightTransition = rootHeightTransition.hasTransition ? rootHeightTransition : null;
        componentTree.setRootWidthAnimation(rootWidthTransition);
        componentTree.setRootHeightAnimation(rootHeightTransition);
        this.mRootTransition = TransitionManager.getRootTransition(allTransitions);
        this.mTransitionsHasBeenCollected = true;
    }

    @Nullable
    private static void collectMountTimeTransitions(LayoutState layoutState, List<Transition> outList) {
        List<Component> componentsNeedingPreviousRenderData = layoutState.getComponentsNeedingPreviousRenderData();
        if (componentsNeedingPreviousRenderData == null) {
            return;
        }
        int size = componentsNeedingPreviousRenderData.size();
        for (int i = 0; i < size; ++i) {
            Component component = componentsNeedingPreviousRenderData.get(i);
            Transition transition = component.createTransition(component.getScopedContext());
            if (transition == null) continue;
            TransitionUtils.addTransitions(transition, outList, layoutState.mRootComponentName);
        }
    }

    @VisibleForTesting(otherwise=2)
    Deque<TestItem> findTestItems(String testKey) {
        if (this.mTestItemMap == null) {
            throw new UnsupportedOperationException("Trying to access TestItems while ComponentsConfiguration.isEndToEndTestRun is false.");
        }
        LinkedList items = this.mTestItemMap.get(testKey);
        return items == null ? new LinkedList() : items;
    }

    private ComponentContext getContextForComponent(Component component) {
        ComponentContext c = component.getScopedContext();
        return c == null ? this.mContext : c;
    }

    private void bindComponentToContent(Component component, Object content) {
        component.bind(this.getContextForComponent(component), content);
        this.mDynamicPropsManager.onBindComponentToContent(component, content);
    }

    private void unbindComponentFromContent(Component component, Object content) {
        this.mDynamicPropsManager.onUnbindComponent(component);
        component.unbind(this.getContextForComponent(component), content);
    }

    private static class MountStats {
        private List<String> mountedNames;
        private List<String> unmountedNames;
        private List<String> updatedNames;
        private List<String> visibilityHandlerNames;
        private List<String> extras;
        private List<Double> mountTimes;
        private List<Double> unmountedTimes;
        private List<Double> updatedTimes;
        private List<Double> visibilityHandlerTimes;
        private int mountedCount;
        private int unmountedCount;
        private int updatedCount;
        private int noOpCount;
        private double visibilityHandlersTotalTime;
        private boolean isLoggingEnabled;
        private boolean isInitialized;

        private MountStats() {
        }

        private void enableLogging() {
            this.isLoggingEnabled = true;
            if (!this.isInitialized) {
                this.isInitialized = true;
                this.mountedNames = new ArrayList<String>();
                this.unmountedNames = new ArrayList<String>();
                this.updatedNames = new ArrayList<String>();
                this.visibilityHandlerNames = new ArrayList<String>();
                this.extras = new ArrayList<String>();
                this.mountTimes = new ArrayList<Double>();
                this.unmountedTimes = new ArrayList<Double>();
                this.updatedTimes = new ArrayList<Double>();
                this.visibilityHandlerTimes = new ArrayList<Double>();
            }
        }

        private void reset() {
            this.mountedCount = 0;
            this.unmountedCount = 0;
            this.updatedCount = 0;
            this.noOpCount = 0;
            this.visibilityHandlersTotalTime = 0.0;
            if (this.isInitialized) {
                this.mountedNames.clear();
                this.unmountedNames.clear();
                this.updatedNames.clear();
                this.visibilityHandlerNames.clear();
                this.extras.clear();
                this.mountTimes.clear();
                this.unmountedTimes.clear();
                this.updatedTimes.clear();
                this.visibilityHandlerTimes.clear();
            }
            this.isLoggingEnabled = false;
        }
    }

    private static class PrepareMountStats {
        private int unmountedCount = 0;
        private int movedCount = 0;
        private int unchangedCount = 0;

        private PrepareMountStats() {
        }

        private void reset() {
            this.unchangedCount = 0;
            this.movedCount = 0;
            this.unmountedCount = 0;
        }
    }
}

