/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.view.View;
import androidx.annotation.Nullable;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.HostComponent;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.LithoView;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.TransitionId;
import com.facebook.litho.ViewNodeInfo;
import com.facebook.yoga.YogaDirection;

class MountItem {
    static final int LAYOUT_FLAG_DUPLICATE_PARENT_STATE = 1;
    static final int LAYOUT_FLAG_DISABLE_TOUCHABLE = 2;
    static final int LAYOUT_FLAG_MATCH_HOST_BOUNDS = 4;
    private static final int FLAG_VIEW_CLICKABLE = 1;
    private static final int FLAG_VIEW_LONG_CLICKABLE = 2;
    private static final int FLAG_VIEW_FOCUSABLE = 4;
    private static final int FLAG_VIEW_ENABLED = 8;
    private static final int FLAG_VIEW_SELECTED = 16;
    private final Object mContent;
    private NodeInfo mNodeInfo;
    private ViewNodeInfo mViewNodeInfo;
    private Component mComponent;
    private ComponentHost mHost;
    private boolean mIsBound;
    private int mImportantForAccessibility = 0;
    @Nullable
    private TransitionId mTransitionId;
    private int mOrientation;
    private boolean mIsReleased;
    private int mLayoutFlags;
    private int mMountViewFlags;

    static MountItem createRootHostMountItem(LithoView lithoView) {
        ViewNodeInfo viewNodeInfo = new ViewNodeInfo();
        viewNodeInfo.setLayoutDirection(YogaDirection.INHERIT);
        MountItem item = new MountItem(HostComponent.create(), lithoView, (Object)lithoView, null, viewNodeInfo, 0, 0, lithoView.getContext().getResources().getConfiguration().orientation, null);
        return item;
    }

    MountItem(Component component, ComponentHost host, Object content, LayoutOutput layoutOutput) {
        this(component, host, content, layoutOutput.getNodeInfo(), layoutOutput.getViewNodeInfo(), layoutOutput.getFlags(), layoutOutput.getImportantForAccessibility(), layoutOutput.getOrientation(), layoutOutput.getTransitionId());
    }

    MountItem(Component component, ComponentHost host, Object content, NodeInfo nodeInfo, ViewNodeInfo viewNodeInfo, int layoutFlags, int importantForAccessibility, int orientation, TransitionId transitionId) {
        if (component == null) {
            throw new RuntimeException("Calling init() on a MountItem with a null Component!");
        }
        this.mComponent = component;
        this.mContent = content;
        this.mHost = host;
        this.mLayoutFlags = layoutFlags;
        this.mImportantForAccessibility = importantForAccessibility;
        this.mOrientation = orientation;
        this.mTransitionId = transitionId;
        if (nodeInfo != null) {
            this.mNodeInfo = nodeInfo;
        }
        if (viewNodeInfo != null) {
            this.mViewNodeInfo = viewNodeInfo;
        }
        if (this.mContent instanceof View) {
            View view = (View)this.mContent;
            if (view.isClickable()) {
                this.mMountViewFlags |= 1;
            }
            if (view.isLongClickable()) {
                this.mMountViewFlags |= 2;
            }
            if (view.isFocusable()) {
                this.mMountViewFlags |= 4;
            }
            if (view.isEnabled()) {
                this.mMountViewFlags |= 8;
            }
            if (view.isSelected()) {
                this.mMountViewFlags |= 0x10;
            }
        }
    }

    void update(LayoutOutput layoutOutput) {
        this.mComponent = layoutOutput.getComponent();
        if (this.mComponent == null) {
            throw new RuntimeException("Trying to update a MountItem with a null Component!");
        }
        this.mLayoutFlags = layoutOutput.getFlags();
        this.mImportantForAccessibility = layoutOutput.getImportantForAccessibility();
        this.mOrientation = layoutOutput.getOrientation();
        this.mTransitionId = layoutOutput.getTransitionId();
        this.mNodeInfo = null;
        this.mViewNodeInfo = null;
        if (layoutOutput.getNodeInfo() != null) {
            this.mNodeInfo = layoutOutput.getNodeInfo();
        }
        if (layoutOutput.getViewNodeInfo() != null) {
            this.mViewNodeInfo = layoutOutput.getViewNodeInfo();
        }
    }

    @Nullable
    Component getComponent() {
        return this.mComponent;
    }

    void setHost(ComponentHost host) {
        this.mHost = host;
    }

    ComponentHost getHost() {
        return this.mHost;
    }

    Object getContent() {
        return this.mContent;
    }

    int getLayoutFlags() {
        return this.mLayoutFlags;
    }

    int getImportantForAccessibility() {
        return this.mImportantForAccessibility;
    }

    int getOrientation() {
        return this.mOrientation;
    }

    NodeInfo getNodeInfo() {
        return this.mNodeInfo;
    }

    ViewNodeInfo getViewNodeInfo() {
        return this.mViewNodeInfo;
    }

    @Nullable
    TransitionId getTransitionId() {
        return this.mTransitionId;
    }

    boolean hasTransitionId() {
        return this.mTransitionId != null;
    }

    boolean isAccessible() {
        if (this.mComponent == null) {
            return false;
        }
        if (this.mImportantForAccessibility == 2) {
            return false;
        }
        return this.mNodeInfo != null && this.mNodeInfo.needsAccessibilityDelegate() || this.mComponent.implementsAccessibility();
    }

    void releaseMountContent(Context context) {
        if (this.mIsReleased) {
            throw new RuntimeException("Releasing released mount content!");
        }
        ComponentsPools.release(context, this.mComponent, this.mContent);
        this.mIsReleased = true;
    }

    static boolean isDuplicateParentState(int flags) {
        return (flags & 1) == 1;
    }

    static boolean isTouchableDisabled(int flags) {
        return (flags & 2) == 2;
    }

    boolean isViewClickable() {
        return (this.mMountViewFlags & 1) == 1;
    }

    boolean isViewLongClickable() {
        return (this.mMountViewFlags & 2) == 2;
    }

    boolean isViewFocusable() {
        return (this.mMountViewFlags & 4) == 4;
    }

    boolean isViewEnabled() {
        return (this.mMountViewFlags & 8) == 8;
    }

    boolean isViewSelected() {
        return (this.mMountViewFlags & 0x10) == 16;
    }

    boolean isBound() {
        return this.mIsBound;
    }

    void setIsBound(boolean bound) {
        this.mIsBound = bound;
    }
}

