/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import com.facebook.litho.DrawableMatrix;
import com.facebook.litho.Touchable;
import javax.annotation.Nullable;

public class MatrixDrawable<T extends Drawable>
extends Drawable
implements Drawable.Callback,
Touchable {
    public static final int UNSET = -1;
    private T mDrawable;
    private DrawableMatrix mMatrix;
    private boolean mShouldClipRect;
    private int mWidth;
    private int mHeight;

    public void mount(T drawable, DrawableMatrix matrix) {
        if (this.mDrawable == drawable) {
            return;
        }
        if (this.mDrawable != null) {
            this.setDrawableVisibilitySafe(false, false);
            this.mDrawable.setCallback(null);
        }
        this.mDrawable = drawable;
        if (this.mDrawable != null) {
            this.setDrawableVisibilitySafe(this.isVisible(), false);
            this.mDrawable.setCallback((Drawable.Callback)this);
        }
        this.mMatrix = matrix;
        this.mShouldClipRect = this.mMatrix != null && this.mMatrix.shouldClipRect() || Build.VERSION.SDK_INT < 11 && this.mDrawable instanceof ColorDrawable || this.mDrawable instanceof InsetDrawable;
        this.invalidateSelf();
    }

    public void mount(T drawable) {
        this.mount(drawable, null);
    }

    public void bind(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.setInnerDrawableBounds(this.mWidth, this.mHeight);
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
    }

    public void setBounds(Rect bounds) {
        super.setBounds(bounds);
    }

    private void setInnerDrawableBounds(int width, int height) {
        if (this.mDrawable == null) {
            return;
        }
        this.mDrawable.setBounds(0, 0, width, height);
    }

    public void unmount() {
        if (this.mDrawable != null) {
            this.setDrawableVisibilitySafe(false, false);
            this.mDrawable.setCallback(null);
        }
        this.mDrawable = null;
        this.mMatrix = null;
        this.mShouldClipRect = false;
        this.mHeight = 0;
        this.mWidth = 0;
    }

    public T getMountedDrawable() {
        return this.mDrawable;
    }

    private void setDrawableVisibilitySafe(boolean visible, boolean restart) {
        if (this.mDrawable != null && this.mDrawable.isVisible() != visible) {
            try {
                this.mDrawable.setVisible(visible, restart);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void draw(Canvas canvas) {
        if (this.mDrawable == null) {
            return;
        }
        Rect bounds = this.getBounds();
        int saveCount = canvas.save();
        canvas.translate((float)bounds.left, (float)bounds.top);
        if (this.mShouldClipRect) {
            canvas.clipRect(0, 0, bounds.width(), bounds.height());
        }
        if (this.mMatrix != null) {
            canvas.concat((Matrix)this.mMatrix);
        }
        this.mDrawable.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    public void setChangingConfigurations(int configs) {
        if (this.mDrawable == null) {
            return;
        }
        this.mDrawable.setChangingConfigurations(configs);
    }

    public int getChangingConfigurations() {
        return this.mDrawable == null ? -1 : this.mDrawable.getChangingConfigurations();
    }

    public void setDither(boolean dither) {
        if (this.mDrawable == null) {
            return;
        }
        this.mDrawable.setDither(dither);
    }

    public void setFilterBitmap(boolean filter) {
        if (this.mDrawable == null) {
            return;
        }
        this.mDrawable.setFilterBitmap(filter);
    }

    public void setAlpha(int alpha) {
        if (this.mDrawable == null) {
            return;
        }
        this.mDrawable.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        if (this.mDrawable == null) {
            return;
        }
        this.mDrawable.setColorFilter(cf);
    }

    public boolean isStateful() {
        return this.mDrawable != null && this.mDrawable.isStateful();
    }

    public boolean setState(int[] stateSet) {
        return this.mDrawable != null && this.mDrawable.setState(stateSet);
    }

    @Nullable
    public int[] getState() {
        return this.mDrawable == null ? null : this.mDrawable.getState();
    }

    @Nullable
    public Drawable getCurrent() {
        return this.mDrawable == null ? null : this.mDrawable.getCurrent();
    }

    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        this.setDrawableVisibilitySafe(visible, restart);
        return changed;
    }

    public int getOpacity() {
        return this.mDrawable == null ? -1 : this.mDrawable.getOpacity();
    }

    @Nullable
    public Region getTransparentRegion() {
        return this.mDrawable == null ? null : this.mDrawable.getTransparentRegion();
    }

    public int getIntrinsicWidth() {
        return this.mDrawable == null ? -1 : this.mDrawable.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.mDrawable == null ? -1 : this.mDrawable.getIntrinsicHeight();
    }

    public int getMinimumWidth() {
        return this.mDrawable == null ? -1 : this.mDrawable.getMinimumWidth();
    }

    public int getMinimumHeight() {
        return this.mDrawable == null ? -1 : this.mDrawable.getMinimumHeight();
    }

    public boolean getPadding(Rect padding) {
        return this.mDrawable != null && this.mDrawable.getPadding(padding);
    }

    protected boolean onLevelChange(int level) {
        return this.mDrawable != null && this.mDrawable.setLevel(level);
    }

    public void invalidateDrawable(Drawable who) {
        this.invalidateSelf();
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        this.unscheduleSelf(what);
    }

    @Override
    @TargetApi(value=21)
    public boolean onTouchEvent(MotionEvent event, View host) {
        Rect bounds = this.getBounds();
        int x = (int)event.getX() - bounds.left;
        int y = (int)event.getY() - bounds.top;
        this.mDrawable.setHotspot((float)x, (float)y);
        return false;
    }

    @Override
    public boolean shouldHandleTouchEvent(MotionEvent event) {
        return Build.VERSION.SDK_INT >= 21 && this.mDrawable != null && this.mDrawable instanceof RippleDrawable && event.getActionMasked() == 0 && this.getBounds().contains((int)event.getX(), (int)event.getY());
    }
}

