/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.PerfEvent;
import com.facebook.litho.TreeProps;
import java.util.Map;
import javax.annotation.CheckReturnValue;

public final class LogTreePopulator {
    private LogTreePopulator() {
    }

    @CheckReturnValue
    @Nullable
    public static PerfEvent populatePerfEventFromLogger(ComponentContext c, ComponentsLogger logger, @Nullable PerfEvent perfEvent) {
        if (perfEvent == null) {
            return null;
        }
        String logTag = c.getLogTag();
        if (logTag == null) {
            logger.cancelPerfEvent(perfEvent);
            return null;
        }
        perfEvent.markerAnnotate("log_tag", logTag);
        TreeProps treeProps = c.getTreeProps();
        if (treeProps == null) {
            return perfEvent;
        }
        Map<String, String> extraAnnotations = logger.getExtraAnnotations(treeProps);
        if (extraAnnotations == null) {
            return perfEvent;
        }
        for (Map.Entry<String, String> e : extraAnnotations.entrySet()) {
            perfEvent.markerAnnotate(e.getKey(), e.getValue());
        }
        return perfEvent;
    }

    @Nullable
    public static String getAnnotationBundleFromLogger(Component component, ComponentsLogger logger) {
        ComponentContext scopedContext = component.getScopedContext();
        if (scopedContext == null) {
            return null;
        }
        TreeProps treeProps = scopedContext.getTreeProps();
        if (treeProps == null) {
            return null;
        }
        Map<String, String> extraAnnotations = logger.getExtraAnnotations(treeProps);
        if (extraAnnotations == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(extraAnnotations.size() * 16);
        for (Map.Entry<String, String> entry : extraAnnotations.entrySet()) {
            sb.append(entry.getKey());
            sb.append(':');
            sb.append(entry.getValue());
            sb.append(':');
        }
        return sb.toString();
    }
}

