/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.text.TextUtils;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.widget.NestedScrollView;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.DebugComponent;
import com.facebook.litho.DebugComponentDescriptionHelper;
import com.facebook.litho.InternalNode;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LithoView;
import com.facebook.litho.TestItem;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.proguard.annotations.DoNotStrip;
import java.util.Deque;

@DoNotStrip
public class LithoViewTestHelper {
    @DoNotStrip
    @Nullable
    public static TestItem findTestItem(LithoView lithoView, String testKey) {
        Deque<TestItem> items = lithoView.findTestItems(testKey);
        return items.isEmpty() ? null : items.getLast();
    }

    @DoNotStrip
    @NonNull
    public static Deque<TestItem> findTestItems(LithoView lithoView, String testKey) {
        return lithoView.findTestItems(testKey);
    }

    @DoNotStrip
    public static String viewToString(LithoView view) {
        return LithoViewTestHelper.viewToString(view, false);
    }

    @DoNotStrip
    public static String viewToString(LithoView view, boolean embedded) {
        DebugComponent root = DebugComponent.getRootInstance(view);
        if (root == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int left = view.getLeft();
        int top = view.getTop();
        if (view.getParent() instanceof NestedScrollView) {
            NestedScrollView scrollingParentView = (NestedScrollView)view.getParent();
            left -= scrollingParentView.computeHorizontalScrollOffset();
            top -= scrollingParentView.computeVerticalScrollOffset();
        }
        DebugComponentDescriptionHelper.addViewDescription(left, top, root, sb, embedded);
        int depth = embedded ? LithoViewTestHelper.getLithoViewDepthInAndroid(view) : 0;
        LithoViewTestHelper.viewToString(root, sb, embedded, depth);
        return sb.toString();
    }

    private static void viewToString(DebugComponent component, StringBuilder sb, boolean embedded, int depth) {
        for (DebugComponent child : component.getChildComponents()) {
            int nextDepth = depth;
            if (!ComponentsConfiguration.isEndToEndTestRun || child.isLayoutNode()) {
                LithoViewTestHelper.writeNewLineWithIndentByDepth(sb, nextDepth);
                DebugComponentDescriptionHelper.addViewDescription(0, 0, child, sb, embedded);
                ++nextDepth;
            }
            LithoViewTestHelper.viewToString(child, sb, embedded, nextDepth);
        }
    }

    private static int getLithoViewDepthInAndroid(LithoView view) {
        int depth = 2;
        for (ViewParent parent = view.getParent(); parent != null; parent = parent.getParent()) {
            ++depth;
        }
        return depth;
    }

    private static void writeNewLineWithIndentByDepth(StringBuilder sb, int depth) {
        sb.append("\n");
        for (int i = 0; i <= depth; ++i) {
            sb.append("  ");
        }
    }

    public static String toDebugString(@Nullable LithoView lithoView) {
        if (lithoView == null) {
            return "";
        }
        String debugString = LithoViewTestHelper.viewToString(lithoView, true);
        return TextUtils.isEmpty((CharSequence)debugString) ? LithoViewTestHelper.viewBoundsToString(lithoView) : debugString;
    }

    private static String viewBoundsToString(LithoView lithoView) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(lithoView.getLeft());
        sb.append(",");
        sb.append(lithoView.getTop());
        sb.append("-");
        sb.append(lithoView.getRight());
        sb.append(",");
        sb.append(lithoView.getBottom());
        sb.append(")");
        return sb.toString();
    }

    @ThreadConfined(value="UI")
    @Nullable
    public static InternalNodeRef getRootLayoutRef(LithoView view) {
        ComponentTree componentTree = view.getComponentTree();
        LayoutState mainThreadLayoutState = componentTree != null ? componentTree.getMainThreadLayoutState() : null;
        return mainThreadLayoutState != null ? new InternalNodeRef(mainThreadLayoutState.getLayoutRoot()) : null;
    }

    @ThreadConfined(value="UI")
    public static void setRootLayoutRef(LithoView view, InternalNodeRef rootLayoutNode) {
        LayoutState mainThreadLayoutState;
        ComponentTree componentTree = view.getComponentTree();
        LayoutState layoutState = mainThreadLayoutState = componentTree != null ? componentTree.getMainThreadLayoutState() : null;
        if (mainThreadLayoutState != null) {
            mainThreadLayoutState.mLayoutRoot = rootLayoutNode.mInternalNodeRef;
        }
    }

    public static final class InternalNodeRef {
        private final InternalNode mInternalNodeRef;

        private InternalNodeRef(InternalNode node) {
            this.mInternalNodeRef = node;
        }
    }
}

