/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityManager;
import androidx.annotation.VisibleForTesting;
import androidx.core.view.accessibility.AccessibilityManagerCompat;
import com.facebook.litho.AccessibilityUtils;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.ComponentLogParams;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.DoubleMeasureFixUtil;
import com.facebook.litho.EventDispatcherUtils;
import com.facebook.litho.FocusedVisibleEvent;
import com.facebook.litho.FullImpressionVisibleEvent;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LithoViewTestHelper;
import com.facebook.litho.MountState;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.TestItem;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.UnfocusedVisibleEvent;
import com.facebook.litho.VisibilityOutput;
import com.facebook.litho.VisibleEvent;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.proguard.annotations.DoNotStrip;
import java.lang.ref.WeakReference;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class LithoView
extends ComponentHost {
    public static final String ZERO_HEIGHT_LOG = "LithoView:0-height";
    public static final String SET_ALREADY_ATTACHED_COMPONENT_TREE = "LithoView:SetAlreadyAttachedComponentTree";
    @Nullable
    private ComponentTree mComponentTree;
    private final MountState mMountState;
    private final ComponentContext mComponentContext;
    private boolean mIsAttached;
    private final Rect mPreviousMountVisibleRectBounds = new Rect();
    private boolean mForceLayout;
    private boolean mSuppressMeasureComponentTree;
    private boolean mIsMeasuring = false;
    private boolean mHasNewComponentTree = false;
    private int mAnimatedWidth = -1;
    private int mAnimatedHeight = -1;
    private OnDirtyMountListener mOnDirtyMountListener = null;
    @Nullable
    private OnPostDrawListener mOnPostDrawListener = null;
    private final AccessibilityManager mAccessibilityManager;
    private final AccessibilityStateChangeListener mAccessibilityStateChangeListener = new AccessibilityStateChangeListener(this);
    private static final int[] sLayoutSize = new int[2];
    private ComponentTree mTemporaryDetachedComponent;
    private int mTransientStateCount;
    private boolean mDoMeasureInLayout;
    @Nullable
    private Map<String, ComponentLogParams> mInvalidStateLogParams;
    @Nullable
    private String mPreviousComponentSimpleName;
    @Nullable
    private String mNullComponentCause;

    public static LithoView create(Context context, Component component) {
        return LithoView.create(new ComponentContext(context), component);
    }

    public static LithoView create(ComponentContext context, Component component) {
        LithoView lithoView = new LithoView(context);
        lithoView.setComponentTree(ComponentTree.create(context, component).build());
        return lithoView;
    }

    public LithoView(Context context) {
        this(context, null);
    }

    public LithoView(Context context, AttributeSet attrs) {
        this(new ComponentContext(context), attrs);
    }

    public LithoView(ComponentContext context) {
        this(context, null);
    }

    public LithoView(ComponentContext context, AttributeSet attrs) {
        super(context, attrs);
        this.mComponentContext = context;
        this.mMountState = new MountState(this);
        this.mAccessibilityManager = (AccessibilityManager)context.getAndroidContext().getSystemService("accessibility");
    }

    private static void performLayoutOnChildrenIfNecessary(ComponentHost host) {
        int count = host.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = host.getChildAt(i);
            if (child.isLayoutRequested()) {
                child.measure(View.MeasureSpec.makeMeasureSpec((int)child.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)child.getHeight(), (int)0x40000000));
                child.layout(child.getLeft(), child.getTop(), child.getRight(), child.getBottom());
            }
            if (!(child instanceof ComponentHost)) continue;
            LithoView.performLayoutOnChildrenIfNecessary((ComponentHost)child);
        }
    }

    protected void forceRelayout() {
        this.mForceLayout = true;
        this.requestLayout();
    }

    public void startTemporaryDetach() {
        this.mTemporaryDetachedComponent = this.mComponentTree;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.onAttach();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.onDetach();
    }

    public void onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        this.onDetach();
    }

    public void onFinishTemporaryDetach() {
        super.onFinishTemporaryDetach();
        this.onAttach();
    }

    private void onAttach() {
        if (!this.mIsAttached) {
            this.mIsAttached = true;
            if (this.mComponentTree != null) {
                this.mComponentTree.attach();
            }
            this.refreshAccessibilityDelegatesIfNeeded(AccessibilityUtils.isAccessibilityEnabled(this.getContext()));
            AccessibilityManagerCompat.addAccessibilityStateChangeListener((AccessibilityManager)this.mAccessibilityManager, (AccessibilityManagerCompat.AccessibilityStateChangeListener)this.mAccessibilityStateChangeListener);
        }
    }

    private void onDetach() {
        if (this.mIsAttached) {
            this.mIsAttached = false;
            this.mMountState.detach();
            if (this.mComponentTree != null) {
                this.mComponentTree.detach();
            }
            AccessibilityManagerCompat.removeAccessibilityStateChangeListener((AccessibilityManager)this.mAccessibilityManager, (AccessibilityManagerCompat.AccessibilityStateChangeListener)this.mAccessibilityStateChangeListener);
            this.mSuppressMeasureComponentTree = false;
        }
    }

    public void suppressMeasureComponentTree(boolean suppress) {
        this.mSuppressMeasureComponentTree = suppress;
    }

    public void setAnimatedWidth(int width) {
        this.mAnimatedWidth = width;
        this.requestLayout();
    }

    public void setAnimatedHeight(int height) {
        this.mAnimatedHeight = height;
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean canAnimateRootBounds;
        widthMeasureSpec = DoubleMeasureFixUtil.correctWidthSpecForAndroidDoubleMeasureBug(this.getResources(), this.getContext().getPackageManager(), widthMeasureSpec);
        boolean animating = this.mAnimatedWidth != -1 || this.mAnimatedHeight != -1;
        int upToDateWidth = this.mAnimatedWidth != -1 ? this.mAnimatedWidth : this.getWidth();
        int upToDateHeight = this.mAnimatedHeight != -1 ? this.mAnimatedHeight : this.getHeight();
        this.mAnimatedWidth = -1;
        this.mAnimatedHeight = -1;
        if (animating && !this.isMountStateDirty()) {
            this.setMeasuredDimension(upToDateWidth, upToDateHeight);
            return;
        }
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams instanceof LayoutManagerOverrideParams) {
            int overrideHeightSpec;
            LayoutManagerOverrideParams layoutManagerOverrideParams = (LayoutManagerOverrideParams)layoutParams;
            int overrideWidthSpec = layoutManagerOverrideParams.getWidthMeasureSpec();
            if (overrideWidthSpec != -1) {
                widthMeasureSpec = overrideWidthSpec;
            }
            if ((overrideHeightSpec = layoutManagerOverrideParams.getHeightMeasureSpec()) != -1) {
                heightMeasureSpec = overrideHeightSpec;
            }
        }
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mTemporaryDetachedComponent != null && this.mComponentTree == null) {
            this.setComponentTree(this.mTemporaryDetachedComponent);
            this.mTemporaryDetachedComponent = null;
        }
        if (!this.mForceLayout && SizeSpec.getMode(widthMeasureSpec) == 0x40000000 && SizeSpec.getMode(heightMeasureSpec) == 0x40000000) {
            this.mDoMeasureInLayout = true;
            this.setMeasuredDimension(width, height);
            return;
        }
        this.mIsMeasuring = true;
        if (this.mComponentTree != null && !this.mSuppressMeasureComponentTree) {
            boolean forceRelayout = this.mForceLayout;
            this.mForceLayout = false;
            this.mComponentTree.measure(widthMeasureSpec, heightMeasureSpec, sLayoutSize, forceRelayout);
            width = sLayoutSize[0];
            height = sLayoutSize[1];
            this.mDoMeasureInLayout = false;
        }
        if (height == 0) {
            this.maybeLogInvalidZeroHeight();
        }
        boolean bl = canAnimateRootBounds = !this.mSuppressMeasureComponentTree && this.mComponentTree != null && (!this.mHasNewComponentTree || !this.mComponentTree.hasMounted());
        if (canAnimateRootBounds) {
            int initialAnimatedHeight;
            this.mComponentTree.maybeCollectTransitions();
            int initialAnimatedWidth = this.mComponentTree.getInitialAnimatedLithoViewWidth(upToDateWidth, this.mHasNewComponentTree);
            if (initialAnimatedWidth != -1) {
                width = initialAnimatedWidth;
            }
            if ((initialAnimatedHeight = this.mComponentTree.getInitialAnimatedLithoViewHeight(upToDateHeight, this.mHasNewComponentTree)) != -1) {
                height = initialAnimatedHeight;
            }
        }
        this.setMeasuredDimension(width, height);
        this.mHasNewComponentTree = false;
        this.mIsMeasuring = false;
    }

    @Override
    protected void performLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.mComponentTree != null) {
            boolean wasMountTriggered;
            if (this.mComponentTree.isReleased()) {
                throw new IllegalStateException("Trying to layout a LithoView holding onto a released ComponentTree");
            }
            if (this.mDoMeasureInLayout || this.mComponentTree.getMainThreadLayoutState() == null) {
                this.mComponentTree.measure(View.MeasureSpec.makeMeasureSpec((int)(right - left), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(bottom - top), (int)0x40000000), sLayoutSize, false);
                this.mHasNewComponentTree = false;
                this.mDoMeasureInLayout = false;
            }
            if (!(wasMountTriggered = this.mComponentTree.layout()) && this.isIncrementalMountEnabled()) {
                this.performIncrementalMount();
            }
            if (!wasMountTriggered || this.shouldAlwaysLayoutChildren()) {
                LithoView.performLayoutOnChildrenIfNecessary(this);
            }
        }
    }

    protected boolean shouldAlwaysLayoutChildren() {
        return false;
    }

    public ComponentContext getComponentContext() {
        return this.mComponentContext;
    }

    @Override
    protected boolean shouldRequestLayout() {
        if (this.mComponentTree != null && this.mComponentTree.isMounting()) {
            return false;
        }
        return super.shouldRequestLayout();
    }

    void assertNotInMeasure() {
        if (this.mIsMeasuring) {
            throw new RuntimeException("Cannot update ComponentTree while in the middle of measure");
        }
    }

    @Nullable
    public ComponentTree getComponentTree() {
        return this.mComponentTree;
    }

    public void setOnDirtyMountListener(OnDirtyMountListener onDirtyMountListener) {
        this.mOnDirtyMountListener = onDirtyMountListener;
    }

    public void setOnPostDrawListener(@Nullable OnPostDrawListener onPostDrawListener) {
        this.mOnPostDrawListener = onPostDrawListener;
    }

    void onDirtyMountComplete() {
        if (this.mOnDirtyMountListener != null) {
            this.mOnDirtyMountListener.onDirtyMount(this);
        }
    }

    public void setComponentTree(@Nullable ComponentTree componentTree) {
        ThreadUtils.assertMainThread();
        this.assertNotInMeasure();
        this.mTemporaryDetachedComponent = null;
        if (this.mComponentTree == componentTree) {
            if (this.mIsAttached) {
                this.rebind();
            }
            return;
        }
        this.mHasNewComponentTree = this.mComponentTree == null || componentTree == null || this.mComponentTree.mId != componentTree.mId;
        this.setMountStateDirty();
        if (this.mComponentTree != null) {
            if (ComponentsConfiguration.unmountAllWhenComponentTreeSetToNull && componentTree == null) {
                this.unmountAllItems();
            }
            if (this.mInvalidStateLogParams != null) {
                this.mPreviousComponentSimpleName = this.mComponentTree.getSimpleName();
            }
            if (componentTree != null && componentTree.getLithoView() != null && this.mInvalidStateLogParams != null && this.mInvalidStateLogParams.containsKey(SET_ALREADY_ATTACHED_COMPONENT_TREE)) {
                this.logSetAlreadyAttachedComponentTree(this.mComponentTree, componentTree, this.mInvalidStateLogParams.get(SET_ALREADY_ATTACHED_COMPONENT_TREE));
            }
            if (this.mIsAttached) {
                this.mComponentTree.detach();
            }
            this.mComponentTree.clearLithoView();
        }
        this.mComponentTree = componentTree;
        if (this.mComponentTree != null) {
            if (this.mComponentTree.isReleased()) {
                throw new IllegalStateException("Setting a released ComponentTree to a LithoView, released component was: " + this.mComponentTree.getReleasedComponent());
            }
            this.mComponentTree.setLithoView(this);
            if (this.mIsAttached) {
                this.mComponentTree.attach();
            } else {
                this.requestLayout();
            }
        }
        this.mNullComponentCause = this.mComponentTree == null ? "set_CT" : null;
    }

    public void setComponent(Component component) {
        if (this.mComponentTree == null) {
            this.setComponentTree(ComponentTree.create(this.getComponentContext(), component).build());
        } else {
            this.mComponentTree.setRoot(component);
        }
    }

    public void setComponentAsync(Component component) {
        if (this.mComponentTree == null) {
            this.setComponentTree(ComponentTree.create(this.getComponentContext(), component).build());
        } else {
            this.mComponentTree.setRootAsync(component);
        }
    }

    public void rebind() {
        this.mMountState.rebind();
    }

    public void unbind() {
        this.mMountState.unbind();
    }

    void clearComponentTree() {
        ThreadUtils.assertMainThread();
        if (this.mIsAttached) {
            throw new IllegalStateException("Trying to clear the ComponentTree while attached.");
        }
        this.mComponentTree = null;
        this.mNullComponentCause = "clear_CT";
    }

    public void setVisibilityHint(boolean isVisible) {
        ThreadUtils.assertMainThread();
        if (this.mComponentTree == null || !this.mComponentTree.isIncrementalMountEnabled()) {
            return;
        }
        if (isVisible) {
            if (this.getLocalVisibleRect(new Rect())) {
                this.mComponentTree.processVisibilityOutputs();
                this.recursivelySetVisibleHint(true);
            }
        } else {
            this.recursivelySetVisibleHint(false);
            this.mMountState.clearVisibilityItems();
        }
    }

    private void recursivelySetVisibleHint(boolean isVisible) {
        List<LithoView> childLithoViews = this.mMountState.getChildLithoViewsFromCurrentlyMountedItems();
        for (int i = childLithoViews.size() - 1; i >= 0; --i) {
            LithoView lithoView = childLithoViews.get(i);
            lithoView.setVisibilityHint(isVisible);
        }
    }

    public void setHasTransientState(boolean hasTransientState) {
        if (hasTransientState) {
            if (this.mTransientStateCount == 0 && this.mComponentTree != null && this.mComponentTree.isIncrementalMountEnabled()) {
                this.performIncrementalMount(new Rect(0, 0, this.getWidth(), this.getHeight()), false);
            }
            ++this.mTransientStateCount;
        } else {
            --this.mTransientStateCount;
            if (this.mTransientStateCount == 0 && this.mComponentTree != null && this.mComponentTree.isIncrementalMountEnabled()) {
                this.performIncrementalMount();
            }
            if (this.mTransientStateCount < 0) {
                this.mTransientStateCount = 0;
            }
        }
        super.setHasTransientState(hasTransientState);
    }

    public void offsetTopAndBottom(int offset) {
        super.offsetTopAndBottom(offset);
        this.maybePerformIncrementalMountOnView();
    }

    public void offsetLeftAndRight(int offset) {
        super.offsetLeftAndRight(offset);
        this.maybePerformIncrementalMountOnView();
    }

    public void setTranslationX(float translationX) {
        if (translationX == this.getTranslationX()) {
            return;
        }
        super.setTranslationX(translationX);
        this.maybePerformIncrementalMountOnView();
    }

    public void setTranslationY(float translationY) {
        if (translationY == this.getTranslationY()) {
            return;
        }
        super.setTranslationY(translationY);
        this.maybePerformIncrementalMountOnView();
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mOnPostDrawListener != null) {
            this.mOnPostDrawListener.onPostDraw();
        }
    }

    private void maybePerformIncrementalMountOnView() {
        if (this.mComponentTree == null || !this.mComponentTree.isIncrementalMountEnabled() || !(this.getParent() instanceof View)) {
            return;
        }
        int parentWidth = ((View)this.getParent()).getWidth();
        int parentHeight = ((View)this.getParent()).getHeight();
        int translationX = (int)this.getTranslationX();
        int translationY = (int)this.getTranslationY();
        int top = this.getTop() + translationY;
        int bottom = this.getBottom() + translationY;
        int left = this.getLeft() + translationX;
        int right = this.getRight() + translationX;
        if (left >= 0 && top >= 0 && right <= parentWidth && bottom <= parentHeight && this.mPreviousMountVisibleRectBounds.width() == this.getWidth() && this.mPreviousMountVisibleRectBounds.height() == this.getHeight()) {
            return;
        }
        Rect rect = new Rect();
        if (!this.getLocalVisibleRect(rect)) {
            return;
        }
        this.performIncrementalMount(rect, true);
    }

    private boolean checkMainThreadLayoutStateForIncrementalMount() {
        if (this.mComponentTree.getMainThreadLayoutState() != null) {
            return true;
        }
        if (!this.isLayoutRequested()) {
            throw new RuntimeException("Trying to incrementally mount a component with a null main thread LayoutState on a LithoView that hasn't requested layout!");
        }
        return false;
    }

    public void performIncrementalMount(Rect visibleRect, boolean processVisibilityOutputs) {
        if (this.mComponentTree == null || !this.checkMainThreadLayoutStateForIncrementalMount()) {
            return;
        }
        if (!this.mComponentTree.isIncrementalMountEnabled()) {
            throw new IllegalStateException("To perform incremental mounting, you need first to enable it when creating the ComponentTree.");
        }
        this.mComponentTree.mountComponent(visibleRect, processVisibilityOutputs);
    }

    public void performIncrementalMount() {
        if (this.mComponentTree == null || this.mComponentTree.getMainThreadLayoutState() == null) {
            return;
        }
        if (!this.mComponentTree.isIncrementalMountEnabled()) {
            throw new IllegalStateException("To perform incremental mounting, you need first to enable it when creating the ComponentTree.");
        }
        this.mComponentTree.incrementalMountComponent();
    }

    public boolean isIncrementalMountEnabled() {
        return this.mComponentTree != null && this.mComponentTree.isIncrementalMountEnabled();
    }

    public void release() {
        ThreadUtils.assertMainThread();
        if (this.mComponentTree != null) {
            this.mComponentTree.release();
            this.mComponentTree = null;
            this.mNullComponentCause = "release_CT";
        }
    }

    void mount(LayoutState layoutState, Rect currentVisibleArea, boolean processVisibilityOutputs) {
        if (this.mTransientStateCount > 0 && this.mComponentTree != null && this.mComponentTree.isIncrementalMountEnabled()) {
            if (!this.mMountState.isDirty()) {
                return;
            }
            currentVisibleArea = new Rect(0, 0, this.getWidth(), this.getHeight());
            processVisibilityOutputs = false;
        }
        if (currentVisibleArea == null) {
            this.mPreviousMountVisibleRectBounds.setEmpty();
        } else {
            this.mPreviousMountVisibleRectBounds.set(currentVisibleArea);
        }
        this.mMountState.mount(layoutState, currentVisibleArea, processVisibilityOutputs);
    }

    @Deprecated
    public void dispatchVisibilityEvent(Class<?> visibilityEventType) {
        LayoutState layoutState;
        if (this.isIncrementalMountEnabled()) {
            throw new IllegalStateException("dispatchVisibilityEvent - Can't manually trigger visibility events when incremental mount is enabled");
        }
        LayoutState layoutState2 = layoutState = this.mComponentTree == null ? null : this.mComponentTree.getMainThreadLayoutState();
        if (layoutState != null && visibilityEventType != null) {
            for (int i = 0; i < layoutState.getVisibilityOutputCount(); ++i) {
                this.dispatchVisibilityEvent(layoutState.getVisibilityOutputAt(i), visibilityEventType);
            }
            List<LithoView> childViews = this.mMountState.getChildLithoViewsFromCurrentlyMountedItems();
            for (LithoView lithoView : childViews) {
                lithoView.dispatchVisibilityEvent(visibilityEventType);
            }
        }
    }

    private void dispatchVisibilityEvent(VisibilityOutput visibilityOutput, Class<?> visibilityEventType) {
        if (visibilityEventType == VisibleEvent.class) {
            if (visibilityOutput.getVisibleEventHandler() != null) {
                EventDispatcherUtils.dispatchOnVisible(visibilityOutput.getVisibleEventHandler());
            }
        } else if (visibilityEventType == InvisibleEvent.class) {
            if (visibilityOutput.getInvisibleEventHandler() != null) {
                EventDispatcherUtils.dispatchOnInvisible(visibilityOutput.getInvisibleEventHandler());
            }
        } else if (visibilityEventType == FocusedVisibleEvent.class) {
            if (visibilityOutput.getFocusedEventHandler() != null) {
                EventDispatcherUtils.dispatchOnFocused(visibilityOutput.getFocusedEventHandler());
            }
        } else if (visibilityEventType == UnfocusedVisibleEvent.class) {
            if (visibilityOutput.getUnfocusedEventHandler() != null) {
                EventDispatcherUtils.dispatchOnUnfocused(visibilityOutput.getUnfocusedEventHandler());
            }
        } else if (visibilityEventType == FullImpressionVisibleEvent.class && visibilityOutput.getFullImpressionEventHandler() != null) {
            EventDispatcherUtils.dispatchOnFullImpression(visibilityOutput.getFullImpressionEventHandler());
        }
    }

    void processVisibilityOutputs(LayoutState layoutState, Rect currentVisibleArea) {
        this.mMountState.processVisibilityOutputs(layoutState, currentVisibleArea, null);
    }

    public void unmountAllItems() {
        this.mMountState.unmountAllItems();
        this.mPreviousMountVisibleRectBounds.setEmpty();
    }

    public Rect getPreviousMountBounds() {
        return this.mPreviousMountVisibleRectBounds;
    }

    void setMountStateDirty() {
        this.mMountState.setDirty();
        this.mPreviousMountVisibleRectBounds.setEmpty();
    }

    boolean isMountStateDirty() {
        return this.mMountState.isDirty();
    }

    boolean mountStateNeedsRemount() {
        return this.mMountState.needsRemount();
    }

    MountState getMountState() {
        return this.mMountState;
    }

    public void setInvalidStateLogParamsList(@Nullable List<ComponentLogParams> logParamsList) {
        if (logParamsList == null) {
            this.mInvalidStateLogParams = null;
        } else {
            this.mInvalidStateLogParams = new HashMap<String, ComponentLogParams>();
            int size = logParamsList.size();
            for (int i = 0; i < size; ++i) {
                ComponentLogParams logParams = logParamsList.get(i);
                this.mInvalidStateLogParams.put(logParams.logType, logParams);
            }
        }
    }

    private void maybeLogInvalidZeroHeight() {
        boolean isViewBeingRemovedInPreLayoutOfPredictiveAnim;
        ComponentLogParams logParams;
        ComponentsLogger logger = this.getComponentContext().getLogger();
        if (logger == null) {
            return;
        }
        if (this.mComponentTree != null && this.mComponentTree.getMainThreadLayoutState() != null && this.mComponentTree.getMainThreadLayoutState().mLayoutRoot == null) {
            return;
        }
        ComponentLogParams componentLogParams = logParams = this.mInvalidStateLogParams == null ? null : this.mInvalidStateLogParams.get(ZERO_HEIGHT_LOG);
        if (logParams == null) {
            return;
        }
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        boolean bl = isViewBeingRemovedInPreLayoutOfPredictiveAnim = layoutParams instanceof LayoutManagerOverrideParams && ((LayoutManagerOverrideParams)layoutParams).hasValidAdapterPosition();
        if (isViewBeingRemovedInPreLayoutOfPredictiveAnim) {
            return;
        }
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append(logParams.logProductId);
        messageBuilder.append("-");
        messageBuilder.append(ZERO_HEIGHT_LOG);
        messageBuilder.append(", current=");
        messageBuilder.append(this.mComponentTree == null ? "null_" + this.mNullComponentCause : this.mComponentTree.getSimpleName());
        messageBuilder.append(", previous=");
        messageBuilder.append(this.mPreviousComponentSimpleName);
        messageBuilder.append(", view=");
        messageBuilder.append(LithoViewTestHelper.toDebugString(this));
        LithoView.logError(logger, messageBuilder.toString(), logParams);
    }

    private void logSetAlreadyAttachedComponentTree(ComponentTree currentComponentTree, ComponentTree newComponentTree, ComponentLogParams logParams) {
        ComponentsLogger logger = this.getComponentContext().getLogger();
        if (logger == null) {
            return;
        }
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append(logParams.logProductId);
        messageBuilder.append("-");
        messageBuilder.append(SET_ALREADY_ATTACHED_COMPONENT_TREE);
        messageBuilder.append(", currentView=");
        messageBuilder.append(LithoViewTestHelper.toDebugString(currentComponentTree.getLithoView()));
        messageBuilder.append(", newComponent.LV=");
        messageBuilder.append(LithoViewTestHelper.toDebugString(newComponentTree.getLithoView()));
        messageBuilder.append(", currentComponent=");
        messageBuilder.append(currentComponentTree.getSimpleName());
        messageBuilder.append(", newComponent=");
        messageBuilder.append(newComponentTree.getSimpleName());
        LithoView.logError(logger, messageBuilder.toString(), logParams);
    }

    private static void logError(ComponentsLogger logger, String message, ComponentLogParams logParams) {
        ComponentsLogger.LogLevel logLevel = logParams.failHarder ? ComponentsLogger.LogLevel.FATAL : ComponentsLogger.LogLevel.ERROR;
        logger.emitMessage(logLevel, message, logParams.samplingFrequency);
    }

    @DoNotStrip
    @VisibleForTesting(otherwise=2)
    Deque<TestItem> findTestItems(String testKey) {
        return this.mMountState.findTestItems(testKey);
    }

    public void rerenderForAccessibility(boolean enabled) {
        this.refreshAccessibilityDelegatesIfNeeded(enabled);
        this.forceRelayout();
    }

    public String toString() {
        return LithoViewTestHelper.viewToString(this, true);
    }

    public static interface LayoutManagerOverrideParams {
        public static final int UNINITIALIZED = -1;

        public int getWidthMeasureSpec();

        public int getHeightMeasureSpec();

        public boolean hasValidAdapterPosition();
    }

    private static class AccessibilityStateChangeListener
    extends AccessibilityManagerCompat.AccessibilityStateChangeListenerCompat {
        private final WeakReference<LithoView> mLithoView;

        private AccessibilityStateChangeListener(LithoView lithoView) {
            this.mLithoView = new WeakReference<LithoView>(lithoView);
        }

        public void onAccessibilityStateChanged(boolean enabled) {
            AccessibilityUtils.invalidateCachedIsAccessibilityEnabled();
            LithoView lithoView = (LithoView)((Object)this.mLithoView.get());
            if (lithoView == null) {
                return;
            }
            lithoView.rerenderForAccessibility(enabled);
        }
    }

    public static interface OnPostDrawListener {
        public void onPostDraw();
    }

    public static interface OnDirtyMountListener {
        public void onDirtyMount(LithoView var1);
    }
}

