/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.config.DeviceInfoUtils;
import com.facebook.litho.config.LayoutThreadPoolConfiguration;

public class LayoutThreadPoolConfigurationImpl
implements LayoutThreadPoolConfiguration {
    private int mCorePoolSize;
    private int mMaxPoolSize;
    private int mThreadPriority;

    public LayoutThreadPoolConfigurationImpl(int corePoolSize, int maxPoolSize, int threadPriority) {
        this.mCorePoolSize = corePoolSize;
        this.mMaxPoolSize = maxPoolSize;
        this.mThreadPriority = threadPriority;
    }

    @Override
    public int getCorePoolSize() {
        return this.mCorePoolSize;
    }

    @Override
    public int getMaxPoolSize() {
        return this.mMaxPoolSize;
    }

    @Override
    public int getThreadPriority() {
        return this.mThreadPriority;
    }

    public static class Builder {
        private boolean hasFixedSizePool;
        private int corePoolSize = 1;
        private int maxPoolSize = 1;
        private double corePoolSizeMultiplier = 1.0;
        private int corePoolSizeIncrement = 0;
        private double maxPoolSizeMultiplier = 1.0;
        private int maxPoolSizeIncrement = 0;
        private int threadPriority = 5;
        private ComponentsLogger logger;

        public Builder hasFixedSizePool(boolean hasFixedSizePool) {
            this.hasFixedSizePool = hasFixedSizePool;
            return this;
        }

        public Builder fixedSizePoolConfiguration(int corePoolSize, int maxPoolSize) {
            this.corePoolSize = corePoolSize;
            this.maxPoolSize = maxPoolSize;
            return this;
        }

        public Builder coreDependentPoolConfiguration(double corePoolSizeMultiplier, int corePoolSizeIncrement, double maxPoolSizeMultiplier, int maxPoolSizeIncrement) {
            this.corePoolSizeMultiplier = corePoolSizeMultiplier;
            this.corePoolSizeIncrement = corePoolSizeIncrement;
            this.maxPoolSizeMultiplier = maxPoolSizeMultiplier;
            this.maxPoolSizeIncrement = maxPoolSizeIncrement;
            return this;
        }

        public Builder threadPriority(int threadPriority) {
            this.threadPriority = threadPriority;
            return this;
        }

        public Builder logger(ComponentsLogger logger) {
            this.logger = logger;
            return this;
        }

        public LayoutThreadPoolConfigurationImpl build() {
            if (this.hasFixedSizePool) {
                return new LayoutThreadPoolConfigurationImpl(this.corePoolSize, this.maxPoolSize, this.threadPriority);
            }
            int numProcessors = DeviceInfoUtils.getNumberOfCPUCores();
            if (numProcessors == -1 || numProcessors == 0) {
                numProcessors = 1;
                if (this.logger != null) {
                    this.logger.emitMessage(ComponentsLogger.LogLevel.WARNING, "Could not read number of cores from device");
                }
            }
            int procDepCorePoolSize = (int)Math.ceil((double)numProcessors * this.corePoolSizeMultiplier + (double)this.corePoolSizeIncrement);
            int procDepMaxPoolSize = (int)Math.ceil((double)numProcessors * this.maxPoolSizeMultiplier + (double)this.maxPoolSizeIncrement);
            if (procDepCorePoolSize == 0) {
                procDepCorePoolSize = 1;
            }
            if (procDepMaxPoolSize < procDepCorePoolSize) {
                procDepMaxPoolSize = procDepCorePoolSize;
            }
            return new LayoutThreadPoolConfigurationImpl(procDepCorePoolSize, procDepMaxPoolSize, this.threadPriority);
        }
    }
}

