/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.os.Looper;
import android.os.Process;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class LayoutThreadFactory
implements ThreadFactory {
    private static final AtomicInteger threadPoolId = new AtomicInteger(1);
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final int mThreadPriority;
    private final int mThreadPoolId;

    public LayoutThreadFactory(int threadPriority) {
        this.mThreadPriority = threadPriority;
        this.mThreadPoolId = threadPoolId.getAndIncrement();
    }

    @Override
    public Thread newThread(final Runnable r) {
        Runnable wrapperRunnable = new Runnable(){

            @Override
            public void run() {
                if (Looper.myLooper() == null) {
                    Looper.prepare();
                }
                try {
                    Process.setThreadPriority((int)LayoutThreadFactory.this.mThreadPriority);
                }
                catch (SecurityException e) {
                    Process.setThreadPriority((int)(LayoutThreadFactory.this.mThreadPriority + 1));
                }
                r.run();
            }
        };
        Thread thread = new Thread(wrapperRunnable, "ComponentLayoutThread" + this.mThreadPoolId + "-" + this.threadNumber.getAndIncrement());
        thread.setPriority(10);
        return thread;
    }
}

