/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.graphics.Rect;
import android.os.Build;
import android.text.TextUtils;
import android.view.accessibility.AccessibilityManager;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.collection.LongSparseArray;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.AccessibilityUtils;
import com.facebook.litho.Border;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentUtils;
import com.facebook.litho.ComponentsChainException;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.ComponentsPools;
import com.facebook.litho.ComponentsReporter;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.ContextUtils;
import com.facebook.litho.DebugComponent;
import com.facebook.litho.DebugOverlayDrawable;
import com.facebook.litho.DiffNode;
import com.facebook.litho.DrawableComponent;
import com.facebook.litho.EventHandler;
import com.facebook.litho.FocusedVisibleEvent;
import com.facebook.litho.FullImpressionVisibleEvent;
import com.facebook.litho.HostComponent;
import com.facebook.litho.InternalNode;
import com.facebook.litho.InternalNodeUtils;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.LayoutStateOutputIdCalculator;
import com.facebook.litho.LogTreePopulator;
import com.facebook.litho.MeasureComparisonUtils;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.OutputUnitsAffinityGroup;
import com.facebook.litho.PerfEvent;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.StateHandler;
import com.facebook.litho.TestOutput;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.Transition;
import com.facebook.litho.TransitionId;
import com.facebook.litho.TransitionUtils;
import com.facebook.litho.UnfocusedVisibleEvent;
import com.facebook.litho.ViewNodeInfo;
import com.facebook.litho.VisibilityChangedEvent;
import com.facebook.litho.VisibilityOutput;
import com.facebook.litho.VisibleEvent;
import com.facebook.litho.WorkingRangeContainer;
import com.facebook.litho.WorkingRangeStatusHandler;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.drawable.BorderColorDrawable;
import com.facebook.litho.drawable.ComparableDrawable;
import com.facebook.yoga.YogaConstants;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaEdge;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckReturnValue;

class LayoutState {
    static final Comparator<LayoutOutput> sTopsComparator = new Comparator<LayoutOutput>(){

        @Override
        public int compare(LayoutOutput lhs, LayoutOutput rhs) {
            int lhsTop = lhs.getBounds().top;
            int rhsTop = rhs.getBounds().top;
            return lhsTop == rhsTop ? lhs.getIndex() - rhs.getIndex() : lhsTop - rhsTop;
        }
    };
    static final Comparator<LayoutOutput> sBottomsComparator = new Comparator<LayoutOutput>(){

        @Override
        public int compare(LayoutOutput lhs, LayoutOutput rhs) {
            int lhsBottom = lhs.getBounds().bottom;
            int rhsBottom = rhs.getBounds().bottom;
            return lhsBottom == rhsBottom ? rhs.getIndex() - lhs.getIndex() : lhsBottom - rhsBottom;
        }
    };
    private static final AtomicInteger sIdGenerator = new AtomicInteger(1);
    private static final int NO_PREVIOUS_LAYOUT_STATE_ID = -1;
    private final Map<String, Rect> mComponentKeyToBounds = new HashMap<String, Rect>();
    private final List<Component> mComponents = new ArrayList<Component>();
    private final ComponentContext mContext;
    private Component mComponent;
    private int mWidthSpec;
    private int mHeightSpec;
    private final List<LayoutOutput> mMountableOutputs = new ArrayList<LayoutOutput>(8);
    private final List<VisibilityOutput> mVisibilityOutputs = new ArrayList<VisibilityOutput>(8);
    private final LongSparseArray<Integer> mOutputsIdToPositionMap = new LongSparseArray(8);
    private final ArrayList<LayoutOutput> mMountableOutputTops = new ArrayList();
    private final ArrayList<LayoutOutput> mMountableOutputBottoms = new ArrayList();
    @Nullable
    private LayoutStateOutputIdCalculator mLayoutStateOutputIdCalculator;
    private final List<TestOutput> mTestOutputs;
    @Nullable
    InternalNode mLayoutRoot;
    @Nullable
    TransitionId mRootTransitionId;
    @Nullable
    String mRootComponentName;
    private DiffNode mDiffTreeRoot;
    private int mWidth;
    private int mHeight;
    private int mCurrentX;
    private int mCurrentY;
    private int mCurrentLevel = 0;
    private long mCurrentHostMarker = -1L;
    private int mCurrentHostOutputPosition = -1;
    private boolean mShouldDuplicateParentState = true;
    private int mParentEnabledState = 0;
    private boolean mShouldGenerateDiffTree = false;
    private int mComponentTreeId = -1;
    private final int mId;
    private int mPreviousLayoutStateId = -1;
    private AccessibilityManager mAccessibilityManager;
    private boolean mAccessibilityEnabled = false;
    private StateHandler mStateHandler;
    private boolean mClipChildren = true;
    private List<Component> mComponentsNeedingPreviousRenderData;
    @Nullable
    private TransitionId mCurrentTransitionId;
    @Nullable
    private OutputUnitsAffinityGroup<LayoutOutput> mCurrentLayoutOutputAffinityGroup;
    private final Map<TransitionId, OutputUnitsAffinityGroup<LayoutOutput>> mTransitionIdMapping = new LinkedHashMap<TransitionId, OutputUnitsAffinityGroup<LayoutOutput>>();
    private final Set<TransitionId> mDuplicatedTransitionIds = new HashSet<TransitionId>();
    private List<Transition> mTransitions;
    private final int mOrientation;
    private volatile boolean mIsPartialLayoutState;
    private static final Object debugLock = new Object();
    @Nullable
    private static Map<Integer, List<Boolean>> layoutCalculationsOnMainThread;
    @Nullable
    WorkingRangeContainer mWorkingRangeContainer;
    @Nullable
    private Map<String, Component> mAttachableContainer;

    LayoutState(ComponentContext context) {
        this.mContext = context;
        this.mId = sIdGenerator.getAndIncrement();
        this.mStateHandler = this.mContext.getStateHandler();
        this.mTestOutputs = ComponentsConfiguration.isEndToEndTestRun ? new ArrayList(8) : null;
        this.mOrientation = context.getResources().getConfiguration().orientation;
    }

    @VisibleForTesting
    Component getRootComponent() {
        return this.mComponent;
    }

    boolean isPartialLayoutState() {
        return this.mIsPartialLayoutState;
    }

    @Nullable
    private static LayoutOutput createGenericLayoutOutput(InternalNode node, LayoutState layoutState, boolean hasHostView) {
        Component component = node.getTailComponent();
        if (component == null || component.getMountType() == ComponentLifecycle.MountType.NONE) {
            return null;
        }
        long hostMarker = layoutState.mCurrentHostMarker;
        return LayoutState.createLayoutOutput(component, hostMarker, layoutState, node, true, node.getImportantForAccessibility(), layoutState.mShouldDuplicateParentState, hasHostView);
    }

    private static LayoutOutput createHostLayoutOutput(LayoutState layoutState, InternalNode node) {
        long hostMarker;
        LayoutOutput hostOutput;
        ViewNodeInfo viewNodeInfo;
        HostComponent hostComponent = HostComponent.create();
        Component tailComponent = node.getTailComponent();
        if (tailComponent != null) {
            hostComponent.setCommonDynamicProps(tailComponent.getCommonDynamicProps());
        }
        if ((viewNodeInfo = (hostOutput = LayoutState.createLayoutOutput(hostComponent, hostMarker = layoutState.isLayoutRoot(node) ? 0L : layoutState.mCurrentHostMarker, layoutState, node, false, node.getImportantForAccessibility(), node.isDuplicateParentStateEnabled(), false)).getViewNodeInfo()) != null) {
            if (node.hasStateListAnimatorResSet()) {
                viewNodeInfo.setStateListAnimatorRes(node.getStateListAnimatorRes());
            } else {
                viewNodeInfo.setStateListAnimator(node.getStateListAnimator());
            }
        }
        return hostOutput;
    }

    private static LayoutOutput createDrawableLayoutOutput(Component component, LayoutState layoutState, InternalNode node, boolean hasHostView) {
        long hostMarker = layoutState.mCurrentHostMarker;
        return LayoutState.createLayoutOutput(component, hostMarker, layoutState, node, false, 2, layoutState.mShouldDuplicateParentState, hasHostView);
    }

    private static LayoutOutput createLayoutOutput(Component component, long hostMarker, LayoutState layoutState, InternalNode node, boolean useNodePadding, int importantForAccessibility, boolean duplicateParentState, boolean hasHostView) {
        TransitionId transitionId;
        ViewNodeInfo layoutOutputViewNodeInfo;
        NodeInfo layoutOutputNodeInfo;
        int hostTranslationY;
        int hostTranslationX;
        boolean isMountViewSpec = Component.isMountViewSpec(component);
        if (layoutState.mCurrentHostOutputPosition >= 0) {
            LayoutOutput hostOutput = layoutState.mMountableOutputs.get(layoutState.mCurrentHostOutputPosition);
            Rect hostBounds = hostOutput.getBounds();
            hostTranslationX = hostBounds.left;
            hostTranslationY = hostBounds.top;
        } else {
            hostTranslationX = 0;
            hostTranslationY = 0;
        }
        int flags = 0;
        int l = layoutState.mCurrentX + node.getX();
        int t = layoutState.mCurrentY + node.getY();
        int r = l + node.getWidth();
        int b = t + node.getHeight();
        int paddingLeft = useNodePadding ? node.getPaddingLeft() : 0;
        int paddingTop = useNodePadding ? node.getPaddingTop() : 0;
        int paddingRight = useNodePadding ? node.getPaddingRight() : 0;
        int paddingBottom = useNodePadding ? node.getPaddingBottom() : 0;
        NodeInfo nodeInfo = node.getNodeInfo();
        if (isMountViewSpec) {
            layoutOutputNodeInfo = nodeInfo;
            ViewNodeInfo viewNodeInfo = new ViewNodeInfo();
            if (useNodePadding && node.isPaddingSet()) {
                viewNodeInfo.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
            }
            viewNodeInfo.setLayoutDirection(node.getResolvedLayoutDirection());
            viewNodeInfo.setExpandedTouchBounds(node, l - hostTranslationX, t - hostTranslationY, r - hostTranslationX, b - hostTranslationY);
            layoutOutputViewNodeInfo = viewNodeInfo;
        } else {
            l += paddingLeft;
            t += paddingTop;
            r -= paddingRight;
            b -= paddingBottom;
            if (nodeInfo != null && nodeInfo.getEnabledState() == 2) {
                flags |= 2;
            }
            layoutOutputNodeInfo = null;
            layoutOutputViewNodeInfo = null;
        }
        Rect bounds = new Rect(l, t, r, b);
        if (duplicateParentState) {
            flags |= 1;
        }
        if (hasHostView) {
            flags |= 4;
            transitionId = null;
        } else {
            transitionId = layoutState.mCurrentTransitionId;
        }
        return new LayoutOutput(layoutOutputNodeInfo, layoutOutputViewNodeInfo, component, bounds, hostTranslationX, hostTranslationY, flags, hostMarker, importantForAccessibility, layoutState.mOrientation, transitionId);
    }

    private static VisibilityOutput createVisibilityOutput(InternalNode node, LayoutState layoutState) {
        int l = layoutState.mCurrentX + node.getX();
        int t = layoutState.mCurrentY + node.getY();
        int r = l + node.getWidth();
        int b = t + node.getHeight();
        EventHandler<VisibleEvent> visibleHandler = node.getVisibleHandler();
        EventHandler<FocusedVisibleEvent> focusedHandler = node.getFocusedHandler();
        EventHandler<UnfocusedVisibleEvent> unfocusedHandler = node.getUnfocusedHandler();
        EventHandler<FullImpressionVisibleEvent> fullImpressionHandler = node.getFullImpressionHandler();
        EventHandler<InvisibleEvent> invisibleHandler = node.getInvisibleHandler();
        EventHandler<VisibilityChangedEvent> visibleRectChangedEventHandler = node.getVisibilityChangedHandler();
        VisibilityOutput visibilityOutput = new VisibilityOutput();
        visibilityOutput.setComponent(node.getTailComponent());
        visibilityOutput.setBounds(l, t, r, b);
        visibilityOutput.setVisibleHeightRatio(node.getVisibleHeightRatio());
        visibilityOutput.setVisibleWidthRatio(node.getVisibleWidthRatio());
        visibilityOutput.setVisibleEventHandler(visibleHandler);
        visibilityOutput.setFocusedEventHandler(focusedHandler);
        visibilityOutput.setUnfocusedEventHandler(unfocusedHandler);
        visibilityOutput.setFullImpressionEventHandler(fullImpressionHandler);
        visibilityOutput.setInvisibleEventHandler(invisibleHandler);
        visibilityOutput.setVisibilityChangedEventHandler(visibleRectChangedEventHandler);
        return visibilityOutput;
    }

    private static TestOutput createTestOutput(InternalNode node, LayoutState layoutState, LayoutOutput layoutOutput) {
        int l = layoutState.mCurrentX + node.getX();
        int t = layoutState.mCurrentY + node.getY();
        int r = l + node.getWidth();
        int b = t + node.getHeight();
        TestOutput output = new TestOutput();
        output.setTestKey(node.getTestKey());
        output.setBounds(l, t, r, b);
        output.setHostMarker(layoutState.mCurrentHostMarker);
        if (layoutOutput != null) {
            output.setLayoutOutputId(layoutOutput.getId());
        }
        return output;
    }

    private static boolean isLayoutDirectionRTL(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (Build.VERSION.SDK_INT >= 17 && (applicationInfo.flags & 0x400000) != 0) {
            int layoutDirection = LayoutState.getLayoutDirection(context);
            return layoutDirection == 1;
        }
        return false;
    }

    @TargetApi(value=17)
    private static int getLayoutDirection(Context context) {
        return context.getResources().getConfiguration().getLayoutDirection();
    }

    private static boolean hasViewContent(InternalNode node, LayoutState layoutState) {
        Component component = node.getTailComponent();
        NodeInfo nodeInfo = node.getNodeInfo();
        boolean implementsAccessibility = nodeInfo != null && nodeInfo.needsAccessibilityDelegate() || component != null && component.implementsAccessibility();
        int importantForAccessibility = node.getImportantForAccessibility();
        boolean hasAccessibilityContent = layoutState.mAccessibilityEnabled && importantForAccessibility != 2 && (implementsAccessibility || nodeInfo != null && !TextUtils.isEmpty((CharSequence)nodeInfo.getContentDescription()) || importantForAccessibility != 0);
        boolean hasFocusChangeHandler = nodeInfo != null && nodeInfo.hasFocusChangeHandler();
        boolean hasEnabledTouchEventHandlers = nodeInfo != null && nodeInfo.hasTouchEventHandlers() && nodeInfo.getEnabledState() != 2;
        boolean hasViewTag = nodeInfo != null && nodeInfo.getViewTag() != null;
        boolean hasViewTags = nodeInfo != null && nodeInfo.getViewTags() != null;
        boolean hasShadowElevation = nodeInfo != null && nodeInfo.getShadowElevation() != 0.0f;
        boolean hasOutlineProvider = nodeInfo != null && nodeInfo.getOutlineProvider() != null;
        boolean hasClipToOutline = nodeInfo != null && nodeInfo.getClipToOutline();
        boolean isFocusableSetTrue = nodeInfo != null && nodeInfo.getFocusState() == 1;
        boolean isClickableSetTrue = nodeInfo != null && nodeInfo.getClickableState() == 1;
        boolean hasClipChildrenSet = nodeInfo != null && nodeInfo.isClipChildrenSet();
        return hasFocusChangeHandler || hasEnabledTouchEventHandlers || hasViewTag || hasViewTags || hasShadowElevation || hasOutlineProvider || hasClipToOutline || hasClipChildrenSet || hasAccessibilityContent || isFocusableSetTrue || isClickableSetTrue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectResults(ComponentContext parentContext, InternalNode node, LayoutState layoutState, DiffNode parentDiffNode) {
        ArrayList<WorkingRangeContainer.Registration> registrations;
        ComparableDrawable foreground;
        int size;
        Context scopedAndroidContext;
        ComparableDrawable background;
        DiffNode diffNode;
        boolean isCachedOutputUpdated;
        if (node.hasNewLayout()) {
            node.markLayoutSeen();
        }
        Component component = node.getTailComponent();
        boolean isTracing = ComponentsSystrace.isTracing();
        if (node.isNestedTreeHolder()) {
            if (isTracing) {
                ComponentsSystrace.beginSectionWithArgs("resolveNestedTree:" + node.getSimpleName()).arg("widthSpec", "EXACTLY " + node.getWidth()).arg("heightSpec", "EXACTLY " + node.getHeight()).arg("rootComponentId", node.getTailComponent().getId()).flush();
            }
            InternalNode nestedTree = LayoutState.resolveNestedTree(parentContext.isNestedTreeResolutionExperimentEnabled() ? parentContext : node.getContext(), node, SizeSpec.makeSizeSpec(node.getWidth(), 0x40000000), SizeSpec.makeSizeSpec(node.getHeight(), 0x40000000));
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
            if (nestedTree == ComponentContext.NULL_LAYOUT) {
                return;
            }
            layoutState.mCurrentX += node.getX();
            layoutState.mCurrentY += node.getY();
            LayoutState.collectResults(parentContext, nestedTree, layoutState, parentDiffNode);
            layoutState.mCurrentX -= node.getX();
            layoutState.mCurrentY -= node.getY();
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
            return;
        }
        if (node.getImportantForAccessibility() == 8) {
            node.importantForAccessibility(1);
            int size2 = node.getChildCount();
            for (int i = 0; i < size2; ++i) {
                node.getChildAt(i).importantForAccessibility(4);
            }
        }
        boolean shouldGenerateDiffTree = layoutState.mShouldGenerateDiffTree;
        DiffNode currentDiffNode = node.getDiffNode();
        boolean shouldUseCachedOutputs = Component.isMountSpec(component) && currentDiffNode != null;
        boolean bl = isCachedOutputUpdated = shouldUseCachedOutputs && node.areCachedMeasuresValid();
        if (shouldGenerateDiffTree) {
            diffNode = LayoutState.createDiffNode(node, parentDiffNode);
            if (parentDiffNode == null) {
                layoutState.mDiffTreeRoot = diffNode;
            }
        } else {
            diffNode = null;
        }
        if (layoutState.mParentEnabledState == 2) {
            node.getOrCreateNodeInfo().setEnabled(false);
        }
        boolean needsHostView = LayoutState.needsHostView(node, layoutState);
        long currentHostMarker = layoutState.mCurrentHostMarker;
        int currentHostOutputPosition = layoutState.mCurrentHostOutputPosition;
        TransitionId currentTransitionId = layoutState.mCurrentTransitionId;
        OutputUnitsAffinityGroup<LayoutOutput> currentLayoutOutputAffinityGroup = layoutState.mCurrentLayoutOutputAffinityGroup;
        layoutState.mCurrentTransitionId = LayoutState.getTransitionIdForNode(node);
        OutputUnitsAffinityGroup outputUnitsAffinityGroup = layoutState.mCurrentLayoutOutputAffinityGroup = layoutState.mCurrentTransitionId != null ? new OutputUnitsAffinityGroup() : null;
        if (needsHostView) {
            int hostLayoutPosition = LayoutState.addHostLayoutOutput(node, layoutState, diffNode);
            LayoutState.addCurrentAffinityGroupToTransitionMapping(layoutState);
            ++layoutState.mCurrentLevel;
            layoutState.mCurrentHostMarker = layoutState.mMountableOutputs.get(hostLayoutPosition).getId();
            layoutState.mCurrentHostOutputPosition = hostLayoutPosition;
        }
        boolean shouldDuplicateParentState = layoutState.mShouldDuplicateParentState;
        layoutState.mShouldDuplicateParentState = needsHostView || shouldDuplicateParentState && node.isDuplicateParentStateEnabled();
        LayoutOutput layoutOutput = LayoutState.createGenericLayoutOutput(node, layoutState, needsHostView);
        if (layoutOutput != null) {
            long previousId = shouldUseCachedOutputs ? currentDiffNode.getContent().getId() : -1L;
            layoutState.calculateAndSetLayoutOutputIdAndUpdateState(layoutOutput, layoutState.mCurrentLevel, 0, previousId, isCachedOutputUpdated);
        }
        if ((background = node.getBackground()) != null) {
            if (layoutOutput != null && layoutOutput.getViewNodeInfo() != null) {
                layoutOutput.getViewNodeInfo().setBackground(background);
            } else {
                LayoutOutput convertBackground = currentDiffNode != null ? currentDiffNode.getBackground() : null;
                LayoutOutput backgroundOutput = LayoutState.addDrawableComponent(node, layoutState, convertBackground, background, 1, needsHostView);
                if (diffNode != null) {
                    diffNode.setBackground(backgroundOutput);
                }
            }
        }
        if (Component.isMountSpec(component)) {
            if (isTracing) {
                ComponentsSystrace.beginSection("onBoundsDefined:" + node.getSimpleName());
            }
            component.onBoundsDefined(layoutState.mContext, node);
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
            LayoutState.addMountableOutput(layoutState, layoutOutput);
            LayoutState.addLayoutOutputIdToPositionsMap(layoutState.mOutputsIdToPositionMap, layoutOutput, layoutState.mMountableOutputs.size() - 1);
            LayoutState.maybeAddLayoutOutputToAffinityGroup(layoutState.mCurrentLayoutOutputAffinityGroup, 0, layoutOutput);
            if (diffNode != null) {
                diffNode.setContent(layoutOutput);
            }
        }
        if (TransitionUtils.areTransitionsEnabled(scopedAndroidContext = component == null || component.getScopedContext() == null ? null : component.getScopedContext().getAndroidContext())) {
            ArrayList<Component> componentsNeedingPreviousRenderData;
            ArrayList<Transition> transitions = node.getTransitions();
            if (transitions != null) {
                size = transitions.size();
                for (int i = 0; i < size; ++i) {
                    Transition transition = transitions.get(i);
                    if (layoutState.mTransitions == null) {
                        layoutState.mTransitions = new ArrayList<Transition>();
                    }
                    TransitionUtils.addTransitions(transition, layoutState.mTransitions, layoutState.mRootComponentName);
                }
            }
            if ((componentsNeedingPreviousRenderData = node.getComponentsNeedingPreviousRenderData()) != null) {
                if (layoutState.mComponentsNeedingPreviousRenderData == null) {
                    layoutState.mComponentsNeedingPreviousRenderData = new ArrayList<Component>();
                }
                layoutState.mComponentsNeedingPreviousRenderData.addAll(componentsNeedingPreviousRenderData);
            }
        }
        layoutState.mCurrentX += node.getX();
        layoutState.mCurrentY += node.getY();
        int parentEnabledState = layoutState.mParentEnabledState;
        layoutState.mParentEnabledState = node.getNodeInfo() != null ? node.getNodeInfo().getEnabledState() : 0;
        size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            LayoutState.collectResults(node.getContext(), node.getChildAt(i), layoutState, diffNode);
        }
        layoutState.mParentEnabledState = parentEnabledState;
        layoutState.mCurrentX -= node.getX();
        layoutState.mCurrentY -= node.getY();
        if (node.shouldDrawBorders()) {
            LayoutOutput convertBorder = currentDiffNode != null ? currentDiffNode.getBorder() : null;
            LayoutOutput borderOutput = LayoutState.addDrawableComponent(node, layoutState, convertBorder, LayoutState.getBorderColorDrawable(node), 4, needsHostView);
            if (diffNode != null) {
                diffNode.setBorder(borderOutput);
            }
        }
        if ((foreground = node.getForeground()) != null) {
            if (layoutOutput != null && layoutOutput.getViewNodeInfo() != null && Build.VERSION.SDK_INT >= 23) {
                layoutOutput.getViewNodeInfo().setForeground(foreground);
            } else {
                LayoutOutput convertForeground = currentDiffNode != null ? currentDiffNode.getForeground() : null;
                LayoutOutput foregroundOutput = LayoutState.addDrawableComponent(node, layoutState, convertForeground, foreground, 2, needsHostView);
                if (diffNode != null) {
                    diffNode.setForeground(foregroundOutput);
                }
            }
        }
        if (node.hasVisibilityHandlers()) {
            VisibilityOutput visibilityOutput = LayoutState.createVisibilityOutput(node, layoutState);
            long previousId = shouldUseCachedOutputs && currentDiffNode.getVisibilityOutput() != null ? currentDiffNode.getVisibilityOutput().getId() : -1L;
            layoutState.calculateAndSetVisibilityOutputId(visibilityOutput, layoutState.mCurrentLevel, previousId);
            layoutState.mVisibilityOutputs.add(visibilityOutput);
            if (diffNode != null) {
                diffNode.setVisibilityOutput(visibilityOutput);
            }
        }
        if (layoutState.mTestOutputs != null && !TextUtils.isEmpty((CharSequence)node.getTestKey())) {
            TestOutput testOutput = LayoutState.createTestOutput(node, layoutState, layoutOutput);
            layoutState.mTestOutputs.add(testOutput);
        }
        if ((registrations = node.getWorkingRangeRegistrations()) != null && !registrations.isEmpty()) {
            if (layoutState.mWorkingRangeContainer == null) {
                layoutState.mWorkingRangeContainer = new WorkingRangeContainer();
            }
            for (WorkingRangeContainer.Registration registration : registrations) {
                layoutState.mWorkingRangeContainer.registerWorkingRange(registration.mName, registration.mWorkingRange, registration.mComponent);
            }
        }
        if (component != null) {
            Rect rect = new Rect();
            if (layoutOutput != null) {
                rect.set(layoutOutput.getBounds());
            } else {
                rect.left = layoutState.mCurrentX + node.getX();
                rect.top = layoutState.mCurrentY + node.getY();
                rect.right = rect.left + node.getWidth();
                rect.bottom = rect.top + node.getHeight();
            }
            for (Component delegate : node.getComponents()) {
                Rect copyRect = new Rect();
                copyRect.set(rect);
                if (delegate.getScopedContext() != null && delegate.getScopedContext().getComponentTree() != null) {
                    layoutState.mComponents.add(delegate);
                    if (delegate.hasAttachDetachCallback()) {
                        if (layoutState.mAttachableContainer == null) {
                            layoutState.mAttachableContainer = new HashMap<String, Component>();
                        }
                        layoutState.mAttachableContainer.put(delegate.getGlobalKey(), delegate);
                    }
                }
                if (delegate.getGlobalKey() == null) continue;
                layoutState.mComponentKeyToBounds.put(delegate.getGlobalKey(), copyRect);
            }
        }
        if (ComponentsConfiguration.enableLithoViewDebugOverlay) {
            if (layoutState.isLayoutRoot(node)) {
                ArrayList<Boolean> mainThreadCalculations;
                int n = layoutState.getComponentTreeId();
                Object object = debugLock;
                synchronized (object) {
                    List<Boolean> calculationsOnMainThread;
                    if (layoutCalculationsOnMainThread == null) {
                        layoutCalculationsOnMainThread = new HashMap<Integer, List<Boolean>>();
                    }
                    if ((calculationsOnMainThread = layoutCalculationsOnMainThread.get(n)) == null) {
                        calculationsOnMainThread = new ArrayList<Boolean>();
                    }
                    calculationsOnMainThread.add(ThreadUtils.isMainThread());
                    layoutCalculationsOnMainThread.put(n, calculationsOnMainThread);
                    mainThreadCalculations = new ArrayList<Boolean>(calculationsOnMainThread);
                }
                LayoutState.addDrawableComponent(node, layoutState, null, new DebugOverlayDrawable(mainThreadCalculations), 2, needsHostView);
            }
        } else if (layoutCalculationsOnMainThread != null) {
            Object object = debugLock;
            synchronized (object) {
                layoutCalculationsOnMainThread = null;
            }
        }
        if (layoutState.mCurrentHostMarker != currentHostMarker) {
            layoutState.mCurrentHostMarker = currentHostMarker;
            layoutState.mCurrentHostOutputPosition = currentHostOutputPosition;
            --layoutState.mCurrentLevel;
        }
        layoutState.mShouldDuplicateParentState = shouldDuplicateParentState;
        LayoutState.addCurrentAffinityGroupToTransitionMapping(layoutState);
        layoutState.mCurrentTransitionId = currentTransitionId;
        layoutState.mCurrentLayoutOutputAffinityGroup = currentLayoutOutputAffinityGroup;
    }

    Map<String, Rect> getComponentKeyToBounds() {
        return this.mComponentKeyToBounds;
    }

    List<Component> getComponents() {
        return this.mComponents;
    }

    void clearComponents() {
        this.mComponents.clear();
    }

    @Nullable
    Map<String, Component> consumeAttachables() {
        Map<String, Component> tmp = this.mAttachableContainer;
        this.mAttachableContainer = null;
        return tmp;
    }

    private static void calculateAndSetHostOutputIdAndUpdateState(InternalNode node, LayoutOutput hostOutput, LayoutState layoutState) {
        if (layoutState.isLayoutRoot(node)) {
            hostOutput.setId(0L);
            hostOutput.setUpdateState(2);
        } else {
            layoutState.calculateAndSetLayoutOutputIdAndUpdateState(hostOutput, layoutState.mCurrentLevel, 3, -1L, false);
        }
    }

    private static LayoutOutput addDrawableComponent(InternalNode node, LayoutState layoutState, @Nullable LayoutOutput recycle, ComparableDrawable drawable, int type, boolean matchHostBoundsTransitions) {
        DrawableComponent drawableComponent = DrawableComponent.create(drawable);
        drawableComponent.setScopedContext(ComponentContext.withComponentScope(node.getContext(), drawableComponent));
        boolean isOutputUpdated = recycle != null ? !drawableComponent.shouldComponentUpdate(recycle.getComponent(), drawableComponent) : false;
        long previousId = recycle != null ? recycle.getId() : -1L;
        LayoutOutput output = LayoutState.addDrawableLayoutOutput(drawableComponent, layoutState, node, type, previousId, isOutputUpdated, matchHostBoundsTransitions);
        LayoutState.maybeAddLayoutOutputToAffinityGroup(layoutState.mCurrentLayoutOutputAffinityGroup, type, output);
        return output;
    }

    private static ComparableDrawable getBorderColorDrawable(InternalNode node) {
        if (!node.shouldDrawBorders()) {
            throw new RuntimeException("This node does not support drawing border color");
        }
        boolean isRtl = node.recursivelyResolveLayoutDirection() == YogaDirection.RTL;
        float[] borderRadius = node.getBorderRadius();
        int[] borderColors = node.getBorderColors();
        YogaEdge leftEdge = isRtl ? YogaEdge.RIGHT : YogaEdge.LEFT;
        YogaEdge rightEdge = isRtl ? YogaEdge.LEFT : YogaEdge.RIGHT;
        return new BorderColorDrawable.Builder().pathEffect(node.getBorderPathEffect()).borderLeftColor(Border.getEdgeColor(borderColors, leftEdge)).borderTopColor(Border.getEdgeColor(borderColors, YogaEdge.TOP)).borderRightColor(Border.getEdgeColor(borderColors, rightEdge)).borderBottomColor(Border.getEdgeColor(borderColors, YogaEdge.BOTTOM)).borderLeftWidth(node.getLayoutBorder(leftEdge)).borderTopWidth(node.getLayoutBorder(YogaEdge.TOP)).borderRightWidth(node.getLayoutBorder(rightEdge)).borderBottomWidth(node.getLayoutBorder(YogaEdge.BOTTOM)).borderRadius(borderRadius).build();
    }

    private static void addLayoutOutputIdToPositionsMap(LongSparseArray outputsIdToPositionMap, LayoutOutput layoutOutput, int position) {
        if (outputsIdToPositionMap != null) {
            outputsIdToPositionMap.put(layoutOutput.getId(), (Object)position);
        }
    }

    private static void maybeAddLayoutOutputToAffinityGroup(OutputUnitsAffinityGroup<LayoutOutput> group, int outputType, LayoutOutput layoutOutput) {
        if (group != null) {
            group.add(outputType, layoutOutput);
        }
    }

    private static void addCurrentAffinityGroupToTransitionMapping(LayoutState layoutState) {
        OutputUnitsAffinityGroup<LayoutOutput> group = layoutState.mCurrentLayoutOutputAffinityGroup;
        if (group == null || group.isEmpty()) {
            return;
        }
        TransitionId transitionId = layoutState.mCurrentTransitionId;
        if (transitionId == null) {
            return;
        }
        if (transitionId.mType == 3) {
            if (!layoutState.mDuplicatedTransitionIds.contains(transitionId) && layoutState.mTransitionIdMapping.put(transitionId, group) != null) {
                layoutState.mTransitionIdMapping.remove(transitionId);
                layoutState.mDuplicatedTransitionIds.add(transitionId);
            }
        } else if (layoutState.mTransitionIdMapping.put(transitionId, group) != null) {
            ComponentsReporter.emitMessage(ComponentsReporter.LogLevel.FATAL, "The transitionId '" + transitionId + "' is defined multiple times in the same layout. TransitionIDs must be unique.\nTree:\n" + ComponentUtils.treeToString(layoutState.mLayoutRoot));
        }
        layoutState.mCurrentLayoutOutputAffinityGroup = null;
        layoutState.mCurrentTransitionId = null;
    }

    private static LayoutOutput addDrawableLayoutOutput(Component drawableComponent, LayoutState layoutState, InternalNode node, int outputType, long previousId, boolean isCachedOutputUpdated, boolean matchHostBoundsTransitions) {
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("onBoundsDefined:" + node.getSimpleName());
        }
        drawableComponent.onBoundsDefined(layoutState.mContext, node);
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
        LayoutOutput drawableLayoutOutput = LayoutState.createDrawableLayoutOutput(drawableComponent, layoutState, node, matchHostBoundsTransitions);
        layoutState.calculateAndSetLayoutOutputIdAndUpdateState(drawableLayoutOutput, layoutState.mCurrentLevel, outputType, previousId, isCachedOutputUpdated);
        LayoutState.addMountableOutput(layoutState, drawableLayoutOutput);
        LayoutState.addLayoutOutputIdToPositionsMap(layoutState.mOutputsIdToPositionMap, drawableLayoutOutput, layoutState.mMountableOutputs.size() - 1);
        return drawableLayoutOutput;
    }

    private static int addHostLayoutOutput(InternalNode node, LayoutState layoutState, DiffNode diffNode) {
        Component component = node.getTailComponent();
        if (Component.isMountViewSpec(component) && !layoutState.isLayoutRoot(node)) {
            throw new IllegalArgumentException("We shouldn't insert a host as a parent of a View");
        }
        LayoutOutput hostLayoutOutput = LayoutState.createHostLayoutOutput(layoutState, node);
        LayoutState.addMountableOutput(layoutState, hostLayoutOutput);
        int hostOutputPosition = layoutState.mMountableOutputs.size() - 1;
        if (diffNode != null) {
            diffNode.setHost(hostLayoutOutput);
        }
        LayoutState.calculateAndSetHostOutputIdAndUpdateState(node, hostLayoutOutput, layoutState);
        LayoutState.addLayoutOutputIdToPositionsMap(layoutState.mOutputsIdToPositionMap, hostLayoutOutput, hostOutputPosition);
        LayoutState.maybeAddLayoutOutputToAffinityGroup(layoutState.mCurrentLayoutOutputAffinityGroup, 3, hostLayoutOutput);
        return hostOutputPosition;
    }

    static LayoutState calculate(ComponentContext c, Component component, int componentTreeId, int widthSpec, int heightSpec, int source) {
        return LayoutState.calculate(c, component, componentTreeId, widthSpec, heightSpec, false, null, source, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LayoutState calculate(ComponentContext c, Component component, int componentTreeId, int widthSpec, int heightSpec, boolean shouldGenerateDiffTree, @Nullable LayoutState currentLayoutState, int source, @Nullable String extraAttribution) {
        LayoutState layoutState;
        ComponentsLogger logger = c.getLogger();
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            if (extraAttribution != null) {
                ComponentsSystrace.beginSection("extra:" + extraAttribution);
            }
            ComponentsSystrace.beginSectionWithArgs("LayoutState.calculate_" + component.getSimpleName() + "_" + LayoutState.sourceToString(source)).arg("treeId", componentTreeId).arg("rootId", component.getId()).arg("widthSpec", SizeSpec.toString(widthSpec)).arg("heightSpec", SizeSpec.toString(heightSpec)).flush();
        }
        DiffNode diffTreeRoot = currentLayoutState != null ? currentLayoutState.mDiffTreeRoot : null;
        try {
            InternalNode root;
            PerfEvent logLayoutState;
            PerfEvent perfEvent = logLayoutState = logger != null ? LogTreePopulator.populatePerfEventFromLogger(c, logger, logger.newPerformanceEvent(c, 16)) : null;
            if (logLayoutState != null) {
                logLayoutState.markerAnnotate("component", component.getSimpleName());
                logLayoutState.markerAnnotate("calculate_layout_state_source", LayoutState.sourceToString(source));
                logLayoutState.markerAnnotate("tree_diff_enabled", diffTreeRoot != null);
            }
            component.markLayoutStarted();
            layoutState = new LayoutState(c);
            layoutState.mShouldGenerateDiffTree = shouldGenerateDiffTree;
            layoutState.mComponentTreeId = componentTreeId;
            layoutState.mPreviousLayoutStateId = currentLayoutState != null ? currentLayoutState.mId : -1;
            layoutState.mAccessibilityManager = (AccessibilityManager)c.getAndroidContext().getSystemService("accessibility");
            layoutState.mAccessibilityEnabled = AccessibilityUtils.isAccessibilityEnabled(layoutState.mAccessibilityManager);
            layoutState.mComponent = component;
            layoutState.mWidthSpec = widthSpec;
            layoutState.mHeightSpec = heightSpec;
            layoutState.mRootComponentName = component.getSimpleName();
            InternalNode layoutCreatedInWillRender = component.consumeLayoutCreatedInWillRender();
            boolean isReconcilable = LayoutState.isReconcilable(c, component, currentLayoutState);
            layoutState.mLayoutRoot = root = layoutCreatedInWillRender == null ? LayoutState.createAndMeasureTreeForComponent(c, component, widthSpec, heightSpec, null, isReconcilable ? currentLayoutState.mLayoutRoot : null, diffTreeRoot, logLayoutState) : layoutCreatedInWillRender;
            layoutState.mRootTransitionId = LayoutState.getTransitionIdForNode(root);
            if (c.wasLayoutInterrupted()) {
                layoutState.mIsPartialLayoutState = true;
                LayoutState layoutState2 = layoutState;
                return layoutState2;
            }
            if (logLayoutState != null) {
                logLayoutState.markerPoint("start_collect_results");
            }
            LayoutState.setSizeAfterMeasureAndCollectResults(c, layoutState);
            if (logLayoutState != null) {
                logLayoutState.markerPoint("end_collect_results");
                logger.logPerfEvent(logLayoutState);
            }
        }
        finally {
            if (isTracing) {
                ComponentsSystrace.endSection();
                if (extraAttribution != null) {
                    ComponentsSystrace.endSection();
                }
            }
        }
        return layoutState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LayoutState resumeCalculate(ComponentContext c, int source, @Nullable String extraAttribution, LayoutState layoutState) {
        if (!layoutState.mIsPartialLayoutState) {
            throw new IllegalStateException("Can not resume a finished LayoutState calculation");
        }
        Component component = layoutState.mComponent;
        int componentTreeId = layoutState.mComponentTreeId;
        int widthSpec = layoutState.mWidthSpec;
        int heightSpec = layoutState.mHeightSpec;
        ComponentsLogger logger = c.getLogger();
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            if (extraAttribution != null) {
                ComponentsSystrace.beginSection("extra:" + extraAttribution);
            }
            ComponentsSystrace.beginSectionWithArgs("LayoutState.resumeCalculate_" + component.getSimpleName() + "_" + LayoutState.sourceToString(source)).arg("treeId", componentTreeId).arg("rootId", component.getId()).arg("widthSpec", SizeSpec.toString(widthSpec)).arg("heightSpec", SizeSpec.toString(heightSpec)).flush();
        }
        try {
            PerfEvent logLayoutState;
            PerfEvent perfEvent = logLayoutState = logger != null ? LogTreePopulator.populatePerfEventFromLogger(c, logger, logger.newPerformanceEvent(c, 19)) : null;
            if (logLayoutState != null) {
                logLayoutState.markerAnnotate("component", component.getSimpleName());
                logLayoutState.markerAnnotate("calculate_layout_state_source", LayoutState.sourceToString(source));
            }
            LayoutState.resumeCreateAndMeasureTreeForComponent(c, component, widthSpec, heightSpec, null, layoutState.mLayoutRoot, layoutState.mDiffTreeRoot, logLayoutState);
            layoutState.mIsPartialLayoutState = false;
            LayoutState.setSizeAfterMeasureAndCollectResults(c, layoutState);
            if (logLayoutState != null) {
                logger.logPerfEvent(logLayoutState);
            }
        }
        finally {
            if (isTracing) {
                ComponentsSystrace.endSection();
                if (extraAttribution != null) {
                    ComponentsSystrace.endSection();
                }
            }
        }
        return layoutState;
    }

    private static void setSizeAfterMeasureAndCollectResults(ComponentContext c, LayoutState layoutState) {
        boolean isTracing = ComponentsSystrace.isTracing();
        int widthSpec = layoutState.mWidthSpec;
        int heightSpec = layoutState.mHeightSpec;
        InternalNode root = layoutState.mLayoutRoot;
        switch (SizeSpec.getMode(widthSpec)) {
            case 0x40000000: {
                layoutState.mWidth = SizeSpec.getSize(widthSpec);
                break;
            }
            case -2147483648: {
                layoutState.mWidth = Math.min(root.getWidth(), SizeSpec.getSize(widthSpec));
                break;
            }
            case 0: {
                layoutState.mWidth = root.getWidth();
            }
        }
        switch (SizeSpec.getMode(heightSpec)) {
            case 0x40000000: {
                layoutState.mHeight = SizeSpec.getSize(heightSpec);
                break;
            }
            case -2147483648: {
                layoutState.mHeight = Math.min(root.getHeight(), SizeSpec.getSize(heightSpec));
                break;
            }
            case 0: {
                layoutState.mHeight = root.getHeight();
            }
        }
        layoutState.clearLayoutStateOutputIdCalculator();
        layoutState.mCurrentHostMarker = -1L;
        if (root == ComponentContext.NULL_LAYOUT) {
            return;
        }
        if (isTracing) {
            ComponentsSystrace.beginSection("collectResults");
        }
        LayoutState.collectResults(c, root, layoutState, null);
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
        if (isTracing) {
            ComponentsSystrace.beginSection("sortMountableOutputs");
        }
        Collections.sort(layoutState.mMountableOutputTops, sTopsComparator);
        Collections.sort(layoutState.mMountableOutputBottoms, sBottomsComparator);
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
        if (!(c.isReconciliationEnabled() || ComponentsConfiguration.isDebugModeEnabled || ComponentsConfiguration.isEndToEndTestRun || layoutState.mLayoutRoot == null)) {
            layoutState.mLayoutRoot = null;
        }
    }

    private static boolean isReconcilable(ComponentContext c, Component nextRootComponent, @Nullable LayoutState currentLayoutState) {
        if (currentLayoutState == null || currentLayoutState.mLayoutRoot == null || !c.isReconciliationEnabled()) {
            return false;
        }
        StateHandler stateHandler = c.getStateHandler();
        if (stateHandler == null || !stateHandler.hasPendingUpdates()) {
            return false;
        }
        Component previous = currentLayoutState.mComponent;
        if (!LayoutState.isSameComponentType(previous, nextRootComponent)) {
            return false;
        }
        return nextRootComponent.isEquivalentTo(previous);
    }

    private static String sourceToString(int source) {
        switch (source) {
            case 0: {
                return "setRoot";
            }
            case 2: {
                return "setSizeSpec";
            }
            case 4: {
                return "updateStateSync";
            }
            case 1: {
                return "setRootAsync";
            }
            case 3: {
                return "setSizeSpecAsync";
            }
            case 5: {
                return "updateStateAsync";
            }
            case 6: {
                return "measure";
            }
            case -2: {
                return "test";
            }
            case -1: {
                return "none";
            }
        }
        throw new RuntimeException("Unknown calculate layout source: " + source);
    }

    @ThreadSafe(enableChecks=false)
    void preAllocateMountContent(boolean shouldPreallocatePerMountSpec) {
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("preAllocateMountContent:" + this.mComponent.getSimpleName());
        }
        if (this.mMountableOutputs != null && !this.mMountableOutputs.isEmpty()) {
            int size = this.mMountableOutputs.size();
            for (int i = 0; i < size; ++i) {
                Component component = this.mMountableOutputs.get(i).getComponent();
                if (shouldPreallocatePerMountSpec && !component.canPreallocate() || !Component.isMountViewSpec(component)) continue;
                if (isTracing) {
                    ComponentsSystrace.beginSection("preAllocateMountContent:" + component.getSimpleName());
                }
                ComponentsPools.maybePreallocateContent(this.mContext.getAndroidContext(), component);
                if (!isTracing) continue;
                ComponentsSystrace.endSection();
            }
        }
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
    }

    boolean isActivityValid() {
        return ContextUtils.getValidActivityForContext(this.mContext.getAndroidContext()) != null;
    }

    private void clearLayoutStateOutputIdCalculator() {
        if (this.mLayoutStateOutputIdCalculator != null) {
            this.mLayoutStateOutputIdCalculator.clear();
        }
    }

    private void calculateAndSetLayoutOutputIdAndUpdateState(LayoutOutput layoutOutput, int level, int type, long previousId, boolean isCachedOutputUpdated) {
        if (this.mLayoutStateOutputIdCalculator == null) {
            this.mLayoutStateOutputIdCalculator = new LayoutStateOutputIdCalculator();
        }
        this.mLayoutStateOutputIdCalculator.calculateAndSetLayoutOutputIdAndUpdateState(layoutOutput, level, type, previousId, isCachedOutputUpdated);
    }

    private void calculateAndSetVisibilityOutputId(VisibilityOutput visibilityOutput, int level, long previousId) {
        if (this.mLayoutStateOutputIdCalculator == null) {
            this.mLayoutStateOutputIdCalculator = new LayoutStateOutputIdCalculator();
        }
        this.mLayoutStateOutputIdCalculator.calculateAndSetVisibilityOutputId(visibilityOutput, level, previousId);
    }

    @VisibleForTesting
    static InternalNode createTree(Component component, ComponentContext context, @Nullable InternalNode current) {
        if (current != null) {
            return current.reconcile(context, component);
        }
        return component.createLayout(context, true);
    }

    @VisibleForTesting
    static void measureTree(InternalNode root, int widthSpec, int heightSpec, DiffNode previousDiffTreeRoot) {
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("measureTree:" + root.getSimpleName());
        }
        if (YogaConstants.isUndefined((float)root.getStyleWidth())) {
            root.setStyleWidthFromSpec(widthSpec);
        }
        if (YogaConstants.isUndefined((float)root.getStyleHeight())) {
            root.setStyleHeightFromSpec(heightSpec);
        }
        if (previousDiffTreeRoot != null) {
            ComponentsSystrace.beginSection("applyDiffNode");
            LayoutState.applyDiffNodeToUnchangedNodes(root, previousDiffTreeRoot);
            ComponentsSystrace.endSection();
        }
        root.calculateLayout(SizeSpec.getMode(widthSpec) == 0 ? Float.NaN : (float)SizeSpec.getSize(widthSpec), SizeSpec.getMode(heightSpec) == 0 ? Float.NaN : (float)SizeSpec.getSize(heightSpec));
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
    }

    static InternalNode resolveNestedTree(ComponentContext context, InternalNode holder, int widthSpec, int heightSpec) {
        InternalNode resolvedLayout;
        InternalNode nestedTree;
        Component component = holder.getTailComponent();
        InternalNode layoutFromWillRender = component.consumeLayoutCreatedInWillRender();
        InternalNode internalNode = nestedTree = layoutFromWillRender == null ? holder.getNestedTree() : layoutFromWillRender;
        if (nestedTree == null || !LayoutState.hasCompatibleSizeSpec(nestedTree.getLastWidthSpec(), nestedTree.getLastHeightSpec(), widthSpec, heightSpec, nestedTree.getLastMeasuredWidth(), nestedTree.getLastMeasuredHeight())) {
            InternalNode cachedLayout = LayoutState.consumeCachedLayout(component, holder, widthSpec, heightSpec);
            if (cachedLayout != null) {
                resolvedLayout = cachedLayout;
            } else {
                Component root = holder.getTailComponent();
                if (context.isNestedTreeResolutionExperimentEnabled() && root != null) {
                    Component copy = root.makeShallowCopy();
                    copy.setGlobalKey(root.getGlobalKey());
                    holder.setRootComponent(copy);
                }
                if (nestedTree != null && component.canUsePreviousLayout(context)) {
                    LayoutState.remeasureTree(nestedTree, widthSpec, heightSpec);
                    resolvedLayout = nestedTree;
                } else {
                    resolvedLayout = LayoutState.createAndMeasureTreeForComponent(context, component, widthSpec, heightSpec, holder, null, holder.getDiffNode(), null);
                }
                resolvedLayout.setLastWidthSpec(widthSpec);
                resolvedLayout.setLastHeightSpec(heightSpec);
                resolvedLayout.setLastMeasuredHeight(resolvedLayout.getHeight());
                resolvedLayout.setLastMeasuredWidth(resolvedLayout.getWidth());
            }
            holder.setNestedTree(resolvedLayout);
        } else {
            resolvedLayout = nestedTree;
        }
        resolvedLayout.assertContextSpecificStyleNotSet();
        return resolvedLayout;
    }

    @VisibleForTesting
    static void remeasureTree(InternalNode layout, int widthSpec, int heightSpec) {
        if (layout == ComponentContext.NULL_LAYOUT) {
            return;
        }
        layout.resetResolvedLayoutProperties();
        LayoutState.measureTree(layout, widthSpec, heightSpec, layout.getDiffNode());
    }

    static InternalNode createAndMeasureTreeForComponent(ComponentContext c, Component component, int widthSpec, int heightSpec) {
        return LayoutState.createAndMeasureTreeForComponent(c, component, widthSpec, heightSpec, null, null, null, null);
    }

    @VisibleForTesting
    static InternalNode createAndMeasureTreeForComponent(ComponentContext c, Component component, int widthSpec, int heightSpec, @Nullable InternalNode nestedTreeHolder, @Nullable InternalNode current, @Nullable DiffNode diffTreeRoot, @Nullable PerfEvent layoutStatePerfEvent) {
        boolean hasNestedTreeHolder;
        if (layoutStatePerfEvent != null) {
            layoutStatePerfEvent.markerPoint("start_create_layout");
        }
        component.updateInternalChildState(c);
        if (ComponentsConfiguration.isDebugModeEnabled) {
            DebugComponent.applyOverrides(c, component);
        }
        c = component.getScopedContext();
        boolean isTest = "robolectric".equals(Build.FINGERPRINT);
        if (!isTest) {
            c = c.makeNewCopy();
        }
        boolean bl = hasNestedTreeHolder = nestedTreeHolder != null;
        if (hasNestedTreeHolder) {
            c.setTreeProps(nestedTreeHolder.getPendingTreeProps());
        }
        int previousWidthSpec = c.getWidthSpec();
        int previousHeightSpec = c.getHeightSpec();
        c.setWidthSpec(widthSpec);
        c.setHeightSpec(heightSpec);
        InternalNode root = LayoutState.createTree(component, c, current);
        c.setTreeProps(null);
        c.setWidthSpec(previousWidthSpec);
        c.setHeightSpec(previousHeightSpec);
        if (layoutStatePerfEvent != null) {
            layoutStatePerfEvent.markerPoint("end_create_layout");
        }
        if (root == ComponentContext.NULL_LAYOUT || c.wasLayoutInterrupted()) {
            return root;
        }
        if (hasNestedTreeHolder && Component.isLayoutSpecWithSizeSpec(component)) {
            nestedTreeHolder.copyInto(root);
            diffTreeRoot = nestedTreeHolder.getDiffNode();
        } else if (root.getStyleDirection() == YogaDirection.INHERIT && LayoutState.isLayoutDirectionRTL(c.getAndroidContext())) {
            root.layoutDirection(YogaDirection.RTL);
        }
        if (layoutStatePerfEvent != null) {
            layoutStatePerfEvent.markerPoint("start_measure");
        }
        LayoutState.measureTree(root, widthSpec, heightSpec, diffTreeRoot);
        if (layoutStatePerfEvent != null) {
            layoutStatePerfEvent.markerPoint("end_measure");
        }
        return root;
    }

    private static InternalNode resumeCreateAndMeasureTreeForComponent(ComponentContext c, Component component, int widthSpec, int heightSpec, @Nullable InternalNode nestedTreeHolder, InternalNode root, @Nullable DiffNode diffTreeRoot, @Nullable PerfEvent logLayoutState) {
        LayoutState.resumeCreateTree(c, root);
        if (root == ComponentContext.NULL_LAYOUT) {
            return root;
        }
        if (nestedTreeHolder != null && Component.isLayoutSpecWithSizeSpec(component)) {
            nestedTreeHolder.copyInto(root);
            diffTreeRoot = nestedTreeHolder.getDiffNode();
        } else if (root.getStyleDirection() == YogaDirection.INHERIT && LayoutState.isLayoutDirectionRTL(c.getAndroidContext())) {
            root.layoutDirection(YogaDirection.RTL);
        }
        if (logLayoutState != null) {
            logLayoutState.markerPoint("start_measure");
        }
        LayoutState.measureTree(root, widthSpec, heightSpec, diffTreeRoot);
        if (logLayoutState != null) {
            logLayoutState.markerPoint("end_measure");
        }
        return root;
    }

    private static void resumeCreateTree(ComponentContext c, InternalNode root) {
        int i;
        int size;
        List<Component> unresolved = root.getUnresolvedComponents();
        if (unresolved != null) {
            size = unresolved.size();
            for (i = 0; i < size; ++i) {
                root.child(unresolved.get(i));
            }
            root.getUnresolvedComponents().clear();
        }
        size = root.getChildCount();
        for (i = 0; i < size; ++i) {
            LayoutState.resumeCreateTree(c, root.getChildAt(i));
        }
    }

    @Nullable
    static InternalNode consumeCachedLayout(Component component, InternalNode holder, int widthSpec, int heightSpec) {
        InternalNode cachedLayout = component.getCachedLayout();
        if (cachedLayout != null) {
            component.clearCachedLayout();
            boolean hasValidDirection = InternalNodeUtils.hasValidLayoutDirectionInNestedTree(holder, cachedLayout);
            boolean hasCompatibleSizeSpec = LayoutState.hasCompatibleSizeSpec(cachedLayout.getLastWidthSpec(), cachedLayout.getLastHeightSpec(), widthSpec, heightSpec, cachedLayout.getLastMeasuredWidth(), cachedLayout.getLastMeasuredHeight());
            if (hasValidDirection && hasCompatibleSizeSpec) {
                return cachedLayout;
            }
        }
        return null;
    }

    static DiffNode createDiffNode(InternalNode node, DiffNode parent) {
        DiffNode diffNode = new DiffNode();
        diffNode.setLastWidthSpec(node.getLastWidthSpec());
        diffNode.setLastHeightSpec(node.getLastHeightSpec());
        diffNode.setLastMeasuredWidth(node.getLastMeasuredWidth());
        diffNode.setLastMeasuredHeight(node.getLastMeasuredHeight());
        diffNode.setComponent(node.getTailComponent());
        if (parent != null) {
            parent.addChild(diffNode);
        }
        return diffNode;
    }

    boolean isCompatibleSpec(int widthSpec, int heightSpec) {
        boolean widthIsCompatible = MeasureComparisonUtils.isMeasureSpecCompatible(this.mWidthSpec, widthSpec, this.mWidth);
        boolean heightIsCompatible = MeasureComparisonUtils.isMeasureSpecCompatible(this.mHeightSpec, heightSpec, this.mHeight);
        return widthIsCompatible && heightIsCompatible;
    }

    boolean isCompatibleAccessibility() {
        return AccessibilityUtils.isAccessibilityEnabled(this.mAccessibilityManager) == this.mAccessibilityEnabled;
    }

    static void applyDiffNodeToUnchangedNodes(InternalNode layoutNode, DiffNode diffNode) {
        try {
            boolean isTreeRoot;
            boolean bl = isTreeRoot = layoutNode.getParent() == null;
            if (Component.isLayoutSpecWithSizeSpec(layoutNode.getTailComponent()) && !isTreeRoot) {
                layoutNode.setDiffNode(diffNode);
                return;
            }
            if (!LayoutState.hostIsCompatible(layoutNode, diffNode)) {
                return;
            }
            layoutNode.setDiffNode(diffNode);
            int layoutCount = layoutNode.getChildCount();
            int diffCount = diffNode.getChildCount();
            if (layoutCount != 0 && diffCount != 0) {
                for (int i = 0; i < layoutCount && i < diffCount; ++i) {
                    LayoutState.applyDiffNodeToUnchangedNodes(layoutNode.getChildAt(i), diffNode.getChildAt(i));
                }
            } else if (!LayoutState.shouldComponentUpdate(layoutNode, diffNode)) {
                LayoutState.applyDiffNodeToLayoutNode(layoutNode, diffNode);
            }
        }
        catch (Throwable t) {
            Component c = layoutNode.getTailComponent();
            if (c != null) {
                throw new ComponentsChainException(c, t);
            }
            throw t;
        }
    }

    private static void applyDiffNodeToLayoutNode(InternalNode layoutNode, DiffNode diffNode) {
        Component component = layoutNode.getTailComponent();
        if (component != null) {
            component.copyInterStageImpl(diffNode.getComponent());
        }
        layoutNode.setCachedMeasuresValid(true);
    }

    private static boolean hostIsCompatible(InternalNode node, DiffNode diffNode) {
        if (diffNode == null) {
            return false;
        }
        return LayoutState.isSameComponentType(node.getTailComponent(), diffNode.getComponent());
    }

    private static boolean isSameComponentType(Component a, Component b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.getClass().equals(b.getClass());
    }

    private static boolean shouldComponentUpdate(InternalNode layoutNode, DiffNode diffNode) {
        if (diffNode == null) {
            return true;
        }
        Component component = layoutNode.getTailComponent();
        if (component != null) {
            return component.shouldComponentUpdate(component, diffNode.getComponent());
        }
        return true;
    }

    boolean isCompatibleComponentAndSpec(int componentId, int widthSpec, int heightSpec) {
        return this.mComponent.getId() == componentId && this.isCompatibleSpec(widthSpec, heightSpec);
    }

    boolean isCompatibleSize(int width, int height) {
        return this.mWidth == width && this.mHeight == height;
    }

    boolean isForComponentId(int componentId) {
        return this.mComponent.getId() == componentId;
    }

    int getMountableOutputCount() {
        return this.mMountableOutputs.size();
    }

    LayoutOutput getMountableOutputAt(int index) {
        return this.mMountableOutputs.get(index);
    }

    ArrayList<LayoutOutput> getMountableOutputTops() {
        return this.mMountableOutputTops;
    }

    ArrayList<LayoutOutput> getMountableOutputBottoms() {
        return this.mMountableOutputBottoms;
    }

    int getVisibilityOutputCount() {
        return this.mVisibilityOutputs.size();
    }

    VisibilityOutput getVisibilityOutputAt(int index) {
        return this.mVisibilityOutputs.get(index);
    }

    int getTestOutputCount() {
        return this.mTestOutputs == null ? 0 : this.mTestOutputs.size();
    }

    @Nullable
    TestOutput getTestOutputAt(int index) {
        return this.mTestOutputs == null ? null : this.mTestOutputs.get(index);
    }

    public DiffNode getDiffTree() {
        return this.mDiffTreeRoot;
    }

    int getWidth() {
        return this.mWidth;
    }

    int getHeight() {
        return this.mHeight;
    }

    int getComponentTreeId() {
        return this.mComponentTreeId;
    }

    int getId() {
        return this.mId;
    }

    int getPreviousLayoutStateId() {
        return this.mPreviousLayoutStateId;
    }

    @CheckReturnValue
    StateHandler consumeStateHandler() {
        StateHandler stateHandler = this.mStateHandler;
        this.mStateHandler = null;
        return stateHandler;
    }

    InternalNode getLayoutRoot() {
        return this.mLayoutRoot;
    }

    private boolean isLayoutRoot(InternalNode node) {
        return this.mLayoutRoot.isNestedTreeHolder() ? node == this.mLayoutRoot.getNestedTree() : node == this.mLayoutRoot;
    }

    public static boolean hasCompatibleSizeSpec(int oldWidthSpec, int oldHeightSpec, int newWidthSpec, int newHeightSpec, float oldMeasuredWidth, float oldMeasuredHeight) {
        boolean widthIsCompatible = MeasureComparisonUtils.isMeasureSpecCompatible(oldWidthSpec, newWidthSpec, (int)oldMeasuredWidth);
        boolean heightIsCompatible = MeasureComparisonUtils.isMeasureSpecCompatible(oldHeightSpec, newHeightSpec, (int)oldMeasuredHeight);
        return widthIsCompatible && heightIsCompatible;
    }

    private static boolean needsHostView(InternalNode node, LayoutState layoutState) {
        if (layoutState.isLayoutRoot(node)) {
            return true;
        }
        Component component = node.getTailComponent();
        if (Component.isMountViewSpec(component)) {
            return false;
        }
        if (node.isForceViewWrapping()) {
            return true;
        }
        if (LayoutState.hasViewContent(node, layoutState)) {
            return true;
        }
        if (component != null && component.hasCommonDynamicProps()) {
            return true;
        }
        return LayoutState.needsHostViewForTransition(node);
    }

    private static boolean needsHostViewForTransition(InternalNode node) {
        return !TextUtils.isEmpty((CharSequence)node.getTransitionKey()) && !Component.isMountViewSpec(node.getTailComponent());
    }

    int getLayoutOutputPositionForId(long layoutOutputId) {
        return (Integer)this.mOutputsIdToPositionMap.get(layoutOutputId, (Object)-1);
    }

    @Nullable
    LayoutOutput getLayoutOutput(long layoutOutputId) {
        int position = this.getLayoutOutputPositionForId(layoutOutputId);
        return position < 0 ? null : this.getMountableOutputAt(position);
    }

    @Nullable
    List<Transition> getTransitions() {
        return this.mTransitions;
    }

    Map<TransitionId, OutputUnitsAffinityGroup<LayoutOutput>> getTransitionIdMapping() {
        return this.mTransitionIdMapping;
    }

    @Nullable
    OutputUnitsAffinityGroup<LayoutOutput> getLayoutOutputsForTransitionId(TransitionId transitionId) {
        return this.mTransitionIdMapping.get(transitionId);
    }

    private static void addMountableOutput(LayoutState layoutState, LayoutOutput layoutOutput) {
        layoutOutput.setIndex(layoutState.mMountableOutputs.size());
        layoutState.mMountableOutputs.add(layoutOutput);
        layoutState.mMountableOutputTops.add(layoutOutput);
        layoutState.mMountableOutputBottoms.add(layoutOutput);
    }

    @Nullable
    List<Component> getComponentsNeedingPreviousRenderData() {
        return this.mComponentsNeedingPreviousRenderData;
    }

    @Nullable
    TransitionId getRootTransitionId() {
        return this.mRootTransitionId;
    }

    void checkWorkingRangeAndDispatch(int position, int firstVisibleIndex, int lastVisibleIndex, int firstFullyVisibleIndex, int lastFullyVisibleIndex, WorkingRangeStatusHandler stateHandler) {
        if (this.mWorkingRangeContainer == null) {
            return;
        }
        this.mWorkingRangeContainer.checkWorkingRangeAndDispatch(position, firstVisibleIndex, lastVisibleIndex, firstFullyVisibleIndex, lastFullyVisibleIndex, stateHandler);
    }

    void dispatchOnExitRangeIfNeeded(WorkingRangeStatusHandler stateHandler) {
        if (this.mWorkingRangeContainer == null) {
            return;
        }
        this.mWorkingRangeContainer.dispatchOnExitedRangeIfNeeded(stateHandler);
    }

    @Nullable
    private static TransitionId getTransitionIdForNode(InternalNode node) {
        String reference;
        int type;
        Component component = node.getTailComponent();
        String extraData = null;
        if (node.hasTransitionKey()) {
            Transition.TransitionKeyType transitionKeyType = node.getTransitionKeyType();
            if (transitionKeyType == Transition.TransitionKeyType.GLOBAL) {
                type = 1;
            } else if (transitionKeyType == Transition.TransitionKeyType.LOCAL) {
                type = 2;
                extraData = component != null ? component.getOwnerGlobalKey() : null;
            } else {
                throw new RuntimeException("Unhandled transition key type " + (Object)((Object)transitionKeyType));
            }
            reference = node.getTransitionKey();
        } else {
            type = 3;
            reference = component != null ? component.getGlobalKey() : null;
        }
        return reference != null ? new TransitionId(type, reference, extraData) : null;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CalculateLayoutSource {
        public static final int TEST = -2;
        public static final int NONE = -1;
        public static final int SET_ROOT_SYNC = 0;
        public static final int SET_ROOT_ASYNC = 1;
        public static final int SET_SIZE_SPEC_SYNC = 2;
        public static final int SET_SIZE_SPEC_ASYNC = 3;
        public static final int UPDATE_STATE_SYNC = 4;
        public static final int UPDATE_STATE_ASYNC = 5;
        public static final int MEASURE = 6;
    }
}

