/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import androidx.annotation.Nullable;
import com.facebook.litho.AnimatableItem;
import com.facebook.litho.Component;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.TransitionId;
import com.facebook.litho.ViewNodeInfo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

class LayoutOutput
implements Cloneable,
AnimatableItem {
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_UPDATED = 1;
    public static final int STATE_DIRTY = 2;
    @Nullable
    private final NodeInfo mNodeInfo;
    @Nullable
    private final ViewNodeInfo mViewNodeInfo;
    private final Component mComponent;
    private final Rect mBounds;
    private final int mHostTranslationX;
    private final int mHostTranslationY;
    private final int mFlags;
    private final int mImportantForAccessibility;
    private final int mOrientation;
    @Nullable
    private final TransitionId mTransitionId;
    private final long mHostMarker;
    private int mIndex;
    private long mId;
    private int mUpdateState = 0;

    public LayoutOutput(@Nullable NodeInfo nodeInfo, @Nullable ViewNodeInfo viewNodeInfo, Component component, Rect bounds, int hostTranslationX, int hostTranslationY, int flags, long hostMarker, int importantForAccessibility, int orientation, @Nullable TransitionId transitionId) {
        if (component == null) {
            throw new RuntimeException("Trying to set a null Component on a LayoutOutput!");
        }
        this.mNodeInfo = nodeInfo;
        this.mViewNodeInfo = viewNodeInfo;
        this.mComponent = component;
        this.mBounds = bounds;
        this.mHostTranslationX = hostTranslationX;
        this.mHostTranslationY = hostTranslationY;
        this.mFlags = flags;
        this.mHostMarker = hostMarker;
        this.mImportantForAccessibility = importantForAccessibility;
        this.mOrientation = orientation;
        this.mTransitionId = transitionId;
    }

    Component getComponent() {
        return this.mComponent;
    }

    void getMountBounds(Rect outRect) {
        outRect.left = this.mBounds.left - this.mHostTranslationX;
        outRect.top = this.mBounds.top - this.mHostTranslationY;
        outRect.right = this.mBounds.right - this.mHostTranslationX;
        outRect.bottom = this.mBounds.bottom - this.mHostTranslationY;
    }

    @Override
    public Rect getBounds() {
        return this.mBounds;
    }

    @Override
    public float getScale() {
        return this.mNodeInfo != null ? this.mNodeInfo.getScale() : 1.0f;
    }

    @Override
    public float getAlpha() {
        return this.mNodeInfo != null ? this.mNodeInfo.getAlpha() : 1.0f;
    }

    @Override
    public float getRotation() {
        return this.mNodeInfo != null ? this.mNodeInfo.getRotation() : 0.0f;
    }

    @Override
    public float getRotationX() {
        return this.mNodeInfo != null ? this.mNodeInfo.getRotationX() : 0.0f;
    }

    @Override
    public float getRotationY() {
        return this.mNodeInfo != null ? this.mNodeInfo.getRotationY() : 0.0f;
    }

    @Override
    public boolean isScaleSet() {
        return this.mNodeInfo != null && this.mNodeInfo.isScaleSet();
    }

    @Override
    public boolean isAlphaSet() {
        return this.mNodeInfo != null && this.mNodeInfo.isAlphaSet();
    }

    @Override
    public boolean isRotationSet() {
        return this.mNodeInfo != null && this.mNodeInfo.isRotationSet();
    }

    @Override
    public boolean isRotationXSet() {
        return this.mNodeInfo != null && this.mNodeInfo.isRotationXSet();
    }

    @Override
    public boolean isRotationYSet() {
        return this.mNodeInfo != null && this.mNodeInfo.isRotationYSet();
    }

    int getFlags() {
        return this.mFlags;
    }

    long getHostMarker() {
        return this.mHostMarker;
    }

    long getId() {
        return this.mId;
    }

    void setId(long id2) {
        this.mId = id2;
    }

    int getIndex() {
        return this.mIndex;
    }

    void setIndex(int index) {
        this.mIndex = index;
    }

    NodeInfo getNodeInfo() {
        return this.mNodeInfo;
    }

    public void setUpdateState(int state) {
        this.mUpdateState = state;
    }

    public int getUpdateState() {
        return this.mUpdateState;
    }

    public int getImportantForAccessibility() {
        return this.mImportantForAccessibility;
    }

    int getOrientation() {
        return this.mOrientation;
    }

    @Nullable
    ViewNodeInfo getViewNodeInfo() {
        return this.mViewNodeInfo;
    }

    @Nullable
    public TransitionId getTransitionId() {
        return this.mTransitionId;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UpdateState {
    }
}

