/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentsLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class KeyHandler {
    private static final String STACK_TRACE_NO_SPEC_MESSAGE = "Unable to determine root of duplicate key in a *Spec.java file.";
    private static final String STACK_TRACE_SPEC_MESSAGE = "Please look at the following spec hierarchy and make sure all sibling children components of the same type have unique keys:\n";
    @Nullable
    private final ComponentsLogger mLogger;
    private final Set<String> mKnownGlobalKeys = new HashSet<String>();

    public KeyHandler(@Nullable ComponentsLogger logger) {
        this.mLogger = logger;
    }

    public void registerKey(Component component) {
        this.checkIsDuplicateKey(component);
        this.mKnownGlobalKeys.add(component.getGlobalKey());
    }

    public boolean hasKey(String key) {
        return this.mKnownGlobalKeys.contains(key);
    }

    private void checkIsDuplicateKey(Component component) {
        if (this.mKnownGlobalKeys.contains(component.getGlobalKey())) {
            String errorMessage;
            String message = "Found another " + component.getSimpleName() + " Component with the same key: " + component.getKey();
            String string = errorMessage = this.mLogger == null ? message : this.getDuplicateKeyMessage();
            if (component.hasState()) {
                throw new RuntimeException(message + "\n" + errorMessage);
            }
            if (this.mLogger != null) {
                this.mLogger.emitMessage(ComponentsLogger.LogLevel.ERROR, message + "\n" + errorMessage);
            }
        }
    }

    private String getDuplicateKeyMessage() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        ArrayList<String> specHierarchy = new ArrayList<String>();
        for (StackTraceElement stackElement : stackTrace) {
            boolean hasJustBeenAdded;
            String fileName = stackElement.getFileName();
            if (fileName == null) continue;
            boolean bl = hasJustBeenAdded = !specHierarchy.isEmpty() && ((String)specHierarchy.get(specHierarchy.size() - 1)).equals(fileName);
            if (!this.hasMatch(fileName) || this.mLogger.getKeyCollisionStackTraceBlacklist().contains(fileName) || hasJustBeenAdded) continue;
            specHierarchy.add(fileName);
        }
        if (specHierarchy.isEmpty()) {
            return STACK_TRACE_NO_SPEC_MESSAGE;
        }
        return KeyHandler.format(specHierarchy);
    }

    private static String format(List<String> specHierarchy) {
        Collections.reverse(specHierarchy);
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append(STACK_TRACE_SPEC_MESSAGE);
        int tabLevel = 1;
        for (String spec : specHierarchy) {
            for (int i = 0; i < tabLevel; ++i) {
                messageBuilder.append("\t");
            }
            ++tabLevel;
            messageBuilder.append(spec);
            messageBuilder.append("\n");
        }
        return messageBuilder.toString();
    }

    private boolean hasMatch(String filename) {
        for (String query : this.mLogger.getKeyCollisionStackTraceKeywords()) {
            if (!filename.contains(query)) continue;
            return true;
        }
        return false;
    }
}

