/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import com.facebook.litho.ComponentTree;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

public final class HotswapManager {
    @GuardedBy(value="this")
    @Nullable
    private static ClassLoader sSpecClassLoader;
    @GuardedBy(value="this")
    private static final Set<ComponentTree> sComponentTrees;

    public static synchronized void init(ClassLoader classLoader) {
        sSpecClassLoader = classLoader;
    }

    @Nullable
    public static synchronized ClassLoader getClassLoader() {
        throw new RuntimeException("Hotswap ClassLoader should only be accessed in debug mode.");
    }

    static synchronized void addComponentTree(ComponentTree componentTree) {
        sComponentTrees.add(componentTree);
    }

    public static synchronized void onHotswap() {
        for (ComponentTree componentTree : sComponentTrees) {
            componentTree.forceMainThreadLayout();
        }
    }

    static {
        sComponentTrees = Collections.newSetFromMap(new WeakHashMap());
    }
}

