/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.os.Build;
import android.util.SparseArray;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.DisabledMountContentPool;
import com.facebook.litho.DynamicValue;
import com.facebook.litho.MountContentPool;
import com.facebook.litho.config.ComponentsConfiguration;
import javax.annotation.Nullable;

class HostComponent
extends Component {
    @Nullable
    private SparseArray<DynamicValue<?>> mCommonDynamicProps;

    protected HostComponent() {
        super("HostComponent");
    }

    @Override
    protected MountContentPool onCreateMountContentPool() {
        if (ComponentsConfiguration.disableComponentHostPool) {
            return new DisabledMountContentPool();
        }
        return super.onCreateMountContentPool();
    }

    @Override
    protected Object onCreateMountContent(Context c) {
        return new ComponentHost(c);
    }

    @Override
    protected void onMount(ComponentContext c, Object convertContent) {
        ComponentHost host = (ComponentHost)((Object)convertContent);
        if (Build.VERSION.SDK_INT >= 11) {
            host.setAlpha(1.0f);
        }
    }

    @Override
    protected void onUnmount(ComponentContext c, Object mountedContent) {
        ComponentHost host = (ComponentHost)((Object)mountedContent);
        if (host.isPressed()) {
            host.setPressed(false);
        }
    }

    @Override
    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.VIEW;
    }

    static HostComponent create() {
        return new HostComponent();
    }

    @Override
    public boolean isEquivalentTo(Component other) {
        return this == other;
    }

    @Override
    protected int poolSize() {
        return 45;
    }

    @Override
    protected boolean shouldUpdate(Component previous, Component next) {
        return true;
    }

    @Override
    @Nullable
    SparseArray<DynamicValue<?>> getCommonDynamicProps() {
        return this.mCommonDynamicProps;
    }

    @Override
    boolean hasCommonDynamicProps() {
        return this.mCommonDynamicProps != null;
    }

    void setCommonDynamicProps(SparseArray<DynamicValue<?>> commonDynamicProps) {
        this.mCommonDynamicProps = commonDynamicProps;
    }
}

