/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.VisibleForTesting;
import androidx.collection.SparseArrayCompat;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.EventHandler;
import com.facebook.litho.HasEventDispatcher;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@ThreadSafe
public class EventHandlersController {
    private final Map<String, EventHandlersWrapper> mEventHandlers = new HashMap<String, EventHandlersWrapper>();

    public synchronized void bindEventHandlers(ComponentContext c, HasEventDispatcher dispatcher, String globalKey) {
        if (globalKey == null) {
            return;
        }
        EventHandlersWrapper eventHandlers = this.mEventHandlers.get(globalKey);
        if (eventHandlers == null) {
            return;
        }
        eventHandlers.mUsedInCurrentTree = true;
        eventHandlers.bindToDispatcher(c, dispatcher);
    }

    public synchronized void clearUnusedEventHandlers() {
        Iterator<String> iterator = this.mEventHandlers.keySet().iterator();
        while (iterator.hasNext()) {
            EventHandlersWrapper eventHandlersWrapper = this.mEventHandlers.get(iterator.next());
            if (eventHandlersWrapper == null || !eventHandlersWrapper.mUsedInCurrentTree) {
                iterator.remove();
                continue;
            }
            eventHandlersWrapper.mUsedInCurrentTree = false;
        }
    }

    public synchronized void recordEventHandler(String globalKey, EventHandler eventHandler) {
        if (globalKey == null) {
            return;
        }
        EventHandlersWrapper eventHandlers = this.mEventHandlers.get(globalKey);
        if (eventHandlers == null) {
            eventHandlers = new EventHandlersWrapper();
            this.mEventHandlers.put(globalKey, eventHandlers);
        }
        eventHandlers.addEventHandler(eventHandler);
    }

    @VisibleForTesting
    public synchronized Map<String, EventHandlersWrapper> getEventHandlers() {
        return this.mEventHandlers;
    }

    @VisibleForTesting
    public static class EventHandlersWrapper {
        private final SparseArrayCompat<EventHandler> mEventHandlers = new SparseArrayCompat();
        boolean mUsedInCurrentTree;

        void addEventHandler(EventHandler eventHandler) {
            this.mEventHandlers.put(eventHandler.id, (Object)eventHandler);
        }

        void bindToDispatcher(ComponentContext c, HasEventDispatcher dispatcher) {
            int size = this.mEventHandlers.size();
            for (int i = 0; i < size; ++i) {
                EventHandler eventHandler = (EventHandler)this.mEventHandlers.valueAt(i);
                eventHandler.mHasEventDispatcher = dispatcher;
                if (eventHandler.params == null) continue;
                eventHandler.params[0] = c;
            }
        }

        @VisibleForTesting
        public SparseArrayCompat<EventHandler> getEventHandlers() {
            return this.mEventHandlers;
        }
    }
}

