/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.yoga.YogaConstants;
import com.facebook.yoga.YogaEdge;
import java.util.Arrays;

public class Edges {
    public static final int EDGES_LENGTH = YogaEdge.values().length;
    private static final byte UNDEFINED_INDEX = 15;
    private static final byte INDEX_MASK = 15;
    private static final float DEFAULT_VALUE = 0.0f;
    private static final int ALIASES_MASK = 4095;
    private static final int ALIASES_RIGHT_SHIFT = 24;
    private static final int ALL_INTVALUT = YogaEdge.ALL.intValue();
    private static final int HORIZONTAL_INTVALUE = YogaEdge.HORIZONTAL.intValue();
    private static final int VERTICAL_INTVALUT = YogaEdge.VERTICAL.intValue();
    private long mEdgesToValuesIndex = -1L;
    private float[] mValues;
    private boolean mHasAliasesSet;

    public boolean set(YogaEdge yogaEdge, float value) {
        int edgeIntValue = yogaEdge.intValue();
        if (!Edges.floatsEqual(this.getRaw(edgeIntValue), value)) {
            byte edgeIndex = this.getIndex(edgeIntValue);
            if (YogaConstants.isUndefined((float)value)) {
                this.mEdgesToValuesIndex |= 15L << edgeIntValue * 4;
                this.mValues[edgeIndex] = Float.NaN;
            } else if (edgeIndex == 15) {
                byte newIndex = this.getFirstAvailableIndex();
                if (newIndex >= EDGES_LENGTH) {
                    throw new IllegalStateException("The newIndex for the array cannot be bigger than the amount of Yoga Edges.");
                }
                this.mEdgesToValuesIndex &= 15L << edgeIntValue * 4 ^ 0xFFFFFFFFFFFFFFFFL;
                this.mEdgesToValuesIndex |= (long)newIndex << edgeIntValue * 4;
                this.mValues[newIndex] = value;
            } else {
                this.mValues[edgeIndex] = value;
            }
            this.mHasAliasesSet = (~((int)(this.mEdgesToValuesIndex >> 24)) & 0xFFF) != 0;
            return true;
        }
        return false;
    }

    public float get(YogaEdge edge) {
        float defaultValue;
        float f = defaultValue = edge == YogaEdge.START || edge == YogaEdge.END ? Float.NaN : 0.0f;
        if (this.mEdgesToValuesIndex == -1L) {
            return defaultValue;
        }
        byte edgeIndex = this.getIndex(edge.intValue());
        if (edgeIndex != 15) {
            return this.mValues[edgeIndex];
        }
        if (this.mHasAliasesSet) {
            int secondTypeEdgeValue = edge == YogaEdge.TOP || edge == YogaEdge.BOTTOM ? VERTICAL_INTVALUT : HORIZONTAL_INTVALUE;
            byte secondTypeEdgeIndex = this.getIndex(secondTypeEdgeValue);
            if (secondTypeEdgeIndex != 15) {
                return this.mValues[secondTypeEdgeIndex];
            }
            if (this.getIndex(ALL_INTVALUT) != 15) {
                return this.mValues[this.getIndex(ALL_INTVALUT)];
            }
        }
        return defaultValue;
    }

    public float getRaw(YogaEdge edge) {
        byte edgeIndex = this.getIndex(edge.intValue());
        if (edgeIndex == 15) {
            return Float.NaN;
        }
        return this.mValues[edgeIndex];
    }

    public float getRaw(int edgeEnumValue) {
        byte edgeIndex = this.getIndex(edgeEnumValue);
        if (edgeIndex == 15) {
            return Float.NaN;
        }
        return this.mValues[edgeIndex];
    }

    private byte getIndex(int edgeEnumValue) {
        return (byte)(this.mEdgesToValuesIndex >> edgeEnumValue * 4 & 0xFL);
    }

    private byte getFirstAvailableIndex() {
        if (this.mValues == null) {
            this.mValues = new float[]{Float.NaN, Float.NaN};
            return 0;
        }
        for (int i = 0; i < this.mValues.length; ++i) {
            if (!YogaConstants.isUndefined((float)this.mValues[i])) continue;
            return (byte)i;
        }
        float[] oldValues = this.mValues;
        this.mValues = new float[Math.min(oldValues.length * 2, EDGES_LENGTH)];
        System.arraycopy(oldValues, 0, this.mValues, 0, oldValues.length);
        Arrays.fill(this.mValues, oldValues.length, this.mValues.length, Float.NaN);
        return (byte)oldValues.length;
    }

    private static boolean floatsEqual(float f1, float f2) {
        if (Float.isNaN(f1) || Float.isNaN(f2)) {
            return Float.isNaN(f1) && Float.isNaN(f2);
        }
        return Math.abs(f2 - f1) < 1.0E-5f;
    }
}

