/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import java.util.HashSet;
import java.util.Set;

public class DynamicValue<T> {
    private T mValue;
    private final Set<OnValueChangeListener<T>> mListeners = new HashSet<OnValueChangeListener<T>>();

    public DynamicValue(T mValue) {
        this.mValue = mValue;
    }

    public void set(T value) {
        if (this.mValue == value || this.mValue != null && this.mValue.equals(value)) {
            return;
        }
        this.mValue = value;
        for (OnValueChangeListener<T> listener : this.mListeners) {
            listener.onValueChange(this);
        }
    }

    T get() {
        return this.mValue;
    }

    void attachListener(OnValueChangeListener<T> listener) {
        this.mListeners.add(listener);
    }

    void detach(OnValueChangeListener<T> listener) {
        this.mListeners.remove(listener);
    }

    static interface OnValueChangeListener<T> {
        public void onValueChange(DynamicValue<T> var1);
    }
}

