/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.graphics.drawable.Drawable;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.MatrixDrawable;
import com.facebook.litho.drawable.ComparableDrawable;

class DrawableComponent<T extends Drawable>
extends Component {
    ComparableDrawable mDrawable;
    int mDrawableWidth;
    int mDrawableHeight;

    private DrawableComponent(ComparableDrawable drawable) {
        super("DrawableComponent");
        this.mDrawable = drawable;
    }

    @Override
    protected void onBoundsDefined(ComponentContext c, ComponentLayout layout) {
        this.setDrawableWidth(layout.getWidth());
        this.setDrawableHeight(layout.getHeight());
    }

    @Override
    protected Object onCreateMountContent(Context c) {
        return new MatrixDrawable();
    }

    @Override
    protected void onMount(ComponentContext context, Object content) {
        MatrixDrawable drawable = (MatrixDrawable)content;
        drawable.mount(this.getDrawable());
    }

    @Override
    protected void onBind(ComponentContext c, Object mountedContent) {
        MatrixDrawable mountedDrawable = (MatrixDrawable)mountedContent;
        mountedDrawable.bind(this.getDrawableWidth(), this.getDrawableHeight());
    }

    @Override
    protected void onUnmount(ComponentContext context, Object mountedContent) {
        MatrixDrawable matrixDrawable = (MatrixDrawable)mountedContent;
        matrixDrawable.unmount();
    }

    @Override
    protected boolean isPureRender() {
        return true;
    }

    @Override
    public ComponentLifecycle.MountType getMountType() {
        return ComponentLifecycle.MountType.DRAWABLE;
    }

    public static DrawableComponent create(ComparableDrawable drawable) {
        return new DrawableComponent(drawable);
    }

    @Override
    protected boolean shouldUpdate(Component previous, Component next) {
        ComparableDrawable nextDrawable;
        ComparableDrawable previousDrawable = ((DrawableComponent)previous).getDrawable();
        return !previousDrawable.isEquivalentTo(nextDrawable = ((DrawableComponent)next).getDrawable());
    }

    private ComparableDrawable getDrawable() {
        return this.mDrawable;
    }

    @Override
    public boolean isEquivalentTo(Component o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DrawableComponent drawableComponent = (DrawableComponent)o;
        return ((Object)((Object)this.mDrawable)).equals((Object)drawableComponent.mDrawable);
    }

    private void setDrawableWidth(int drawableWidth) {
        this.mDrawableWidth = drawableWidth;
    }

    private int getDrawableWidth() {
        return this.mDrawableWidth;
    }

    private void setDrawableHeight(int drawableHeight) {
        this.mDrawableHeight = drawableHeight;
    }

    private int getDrawableHeight() {
        return this.mDrawableHeight;
    }
}

