/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import com.facebook.litho.SizeSpec;

public class DoubleMeasureFixUtil {
    private static final String SYSTEM_FEATURE = "org.chromium.arc.device_management";

    public static int correctWidthSpecForAndroidDoubleMeasureBug(Resources resources, PackageManager packageManager, int widthSpec) {
        int calculatedScreenWidthPx;
        float screenDensity;
        float screenWidthDp;
        int mode = SizeSpec.getMode(widthSpec);
        if (mode == 0) {
            return widthSpec;
        }
        boolean isChromebook = packageManager.hasSystemFeature(SYSTEM_FEATURE);
        Configuration configuration = resources.getConfiguration();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        int screenWidthPx = isChromebook ? (int)(screenWidthDp * screenDensity + 0.5f) : displayMetrics.widthPixels;
        if (screenWidthPx != (calculatedScreenWidthPx = (int)((screenDensity = displayMetrics.density) * (screenWidthDp = (float)configuration.screenWidthDp) + 0.5f)) && calculatedScreenWidthPx == SizeSpec.getSize(widthSpec)) {
            return SizeSpec.makeSizeSpec(screenWidthPx, mode);
        }
        return widthSpec;
    }
}

